/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.flags.Flag;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.LaunchCompatibilityChecker;
import com.android.tools.idea.run.LaunchCompatibilityCheckerImpl;
import com.android.tools.idea.run.LaunchableAndroidDevice;
import com.android.tools.idea.run.deployment.ConnectedDevice;
import com.android.tools.idea.run.deployment.ConnectedDevicesTask;
import com.android.tools.idea.run.deployment.DdmlibAndroidDebugBridge;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.Key;
import com.android.tools.idea.run.deployment.KeyToConnectionTimeMap;
import com.android.tools.idea.run.deployment.NameGetter;
import com.android.tools.idea.run.deployment.PhysicalDevice;
import com.android.tools.idea.run.deployment.VirtualDevice;
import com.android.tools.idea.run.deployment.VirtualDevicesTask;
import com.android.tools.idea.run.deployment.Worker;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Streams;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.File;
import java.nio.file.FileSystems;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AsyncDevicesGetter
implements Disposable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final BooleanSupplier mySelectDeviceSnapshotComboBoxSnapshotsEnabled;
    @NotNull
    private final Worker<Collection<VirtualDevice>> myVirtualDevicesWorker;
    @NotNull
    private final Worker<List<ConnectedDevice>> myConnectedDevicesWorker;
    @NotNull
    private final KeyToConnectionTimeMap myMap;
    @NotNull
    private final Function<ConnectedDevice, String> myGetName;
    @Nullable
    private LaunchCompatibilityChecker myChecker;

    private AsyncDevicesGetter(@NotNull Project project) {
        if (project == null) {
            AsyncDevicesGetter.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.mySelectDeviceSnapshotComboBoxSnapshotsEnabled = () -> ((Flag)StudioFlags.SELECT_DEVICE_SNAPSHOT_COMBO_BOX_SNAPSHOTS_ENABLED).get();
        this.myVirtualDevicesWorker = new Worker();
        this.myConnectedDevicesWorker = new Worker();
        this.myMap = new KeyToConnectionTimeMap();
        this.myGetName = new NameGetter(this);
    }

    @NonInjectable
    @VisibleForTesting
    AsyncDevicesGetter(@NotNull Project project, @NotNull BooleanSupplier selectDeviceSnapshotComboBoxSnapshotsEnabled, @NotNull KeyToConnectionTimeMap map2, @NotNull Function<ConnectedDevice, String> getName) {
        if (project == null) {
            AsyncDevicesGetter.$$$reportNull$$$0(1);
        }
        if (selectDeviceSnapshotComboBoxSnapshotsEnabled == null) {
            AsyncDevicesGetter.$$$reportNull$$$0(2);
        }
        if (map2 == null) {
            AsyncDevicesGetter.$$$reportNull$$$0(3);
        }
        if (getName == null) {
            AsyncDevicesGetter.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.mySelectDeviceSnapshotComboBoxSnapshotsEnabled = selectDeviceSnapshotComboBoxSnapshotsEnabled;
        this.myVirtualDevicesWorker = new Worker();
        this.myConnectedDevicesWorker = new Worker();
        this.myMap = map2;
        this.myGetName = getName;
    }

    public void dispose() {
    }

    @NotNull
    static AsyncDevicesGetter getInstance(@NotNull Project project) {
        if (project == null) {
            AsyncDevicesGetter.$$$reportNull$$$0(5);
        }
        AsyncDevicesGetter asyncDevicesGetter = (AsyncDevicesGetter)project.getService(AsyncDevicesGetter.class);
        if (asyncDevicesGetter == null) {
            AsyncDevicesGetter.$$$reportNull$$$0(6);
        }
        return asyncDevicesGetter;
    }

    @NotNull
    Optional<List<Device>> get() {
        this.initChecker(RunManager.getInstance((Project)this.myProject).getSelectedConfiguration(), AndroidFacet::getInstance);
        File adb = AndroidSdkUtils.getAdb(this.myProject);
        if (adb == null) {
            Logger.getInstance(AsyncDevicesGetter.class).info("adb not found");
            Optional<List<Device>> optional2 = Optional.empty();
            if (optional2 == null) {
                AsyncDevicesGetter.$$$reportNull$$$0(7);
            }
            return optional2;
        }
        DdmlibAndroidDebugBridge bridge = new DdmlibAndroidDebugBridge(adb);
        if (!bridge.isConnected()) {
            Logger.getInstance(AsyncDevicesGetter.class).info("ADB is not connected");
            Optional<List<Device>> optional3 = Optional.empty();
            if (optional3 == null) {
                AsyncDevicesGetter.$$$reportNull$$$0(8);
            }
            return optional3;
        }
        VirtualDevicesTask virtualDevicesTask = new VirtualDevicesTask.Builder().setExecutorService(AppExecutorUtil.getAppExecutorService()).setGetAvds(() -> AvdManagerConnection.getDefaultAvdManagerConnection().getAvds(false)).setSelectDeviceSnapshotComboBoxSnapshotsEnabled(this.mySelectDeviceSnapshotComboBoxSnapshotsEnabled).setFileSystem(FileSystems.getDefault()).setNewLaunchableAndroidDevice(LaunchableAndroidDevice::new).setChecker(this.myChecker).build();
        Optional<Collection<VirtualDevice>> virtualDevices = this.myVirtualDevicesWorker.perform(virtualDevicesTask);
        Optional<List<ConnectedDevice>> connectedDevices = this.myConnectedDevicesWorker.perform(new ConnectedDevicesTask(bridge, this.myChecker));
        if (!virtualDevices.isPresent() || !connectedDevices.isPresent()) {
            Optional<List<Device>> optional4 = Optional.empty();
            if (optional4 == null) {
                AsyncDevicesGetter.$$$reportNull$$$0(9);
            }
            return optional4;
        }
        Optional<List<Device>> optional5 = Optional.of(this.getImpl(virtualDevices.get(), (Collection<ConnectedDevice>)connectedDevices.get()));
        if (optional5 == null) {
            AsyncDevicesGetter.$$$reportNull$$$0(10);
        }
        return optional5;
    }

    @NotNull
    @VisibleForTesting
    List<Device> getImpl(@NotNull Collection<VirtualDevice> virtualDevices, @NotNull Collection<ConnectedDevice> connectedDevices) {
        if (virtualDevices == null) {
            AsyncDevicesGetter.$$$reportNull$$$0(11);
        }
        if (connectedDevices == null) {
            AsyncDevicesGetter.$$$reportNull$$$0(12);
        }
        Stream deviceStream = Streams.concat((Stream[])new Stream[]{this.connectedVirtualDeviceStream(connectedDevices, virtualDevices), this.physicalDeviceStream(connectedDevices), AsyncDevicesGetter.disconnectedVirtualDeviceStream(virtualDevices, connectedDevices)});
        List<Device> devices2 = deviceStream.collect(Collectors.toList());
        Collection keys = devices2.stream().filter(Device::isConnected).map(Device::getKey).collect(Collectors.toList());
        this.myMap.retainAll(keys);
        List<Device> list = devices2;
        if (list == null) {
            AsyncDevicesGetter.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    private Stream<VirtualDevice> connectedVirtualDeviceStream(@NotNull Collection<ConnectedDevice> connectedDevices, @NotNull Collection<VirtualDevice> virtualDevices) {
        if (connectedDevices == null) {
            AsyncDevicesGetter.$$$reportNull$$$0(14);
        }
        if (virtualDevices == null) {
            AsyncDevicesGetter.$$$reportNull$$$0(15);
        }
        Stream<VirtualDevice> stream = connectedDevices.stream().filter(ConnectedDevice::isVirtualDevice).map(device -> VirtualDevice.newConnectedDevice(device, this.myMap, AsyncDevicesGetter.findFirst(virtualDevices, device.getKey()).orElse(null)));
        if (stream == null) {
            AsyncDevicesGetter.$$$reportNull$$$0(16);
        }
        return stream;
    }

    @NotNull
    private static @NotNull Optional<@NotNull VirtualDevice> findFirst(@NotNull @NotNull Collection<@NotNull VirtualDevice> devices2, @NotNull Key key) {
        if (devices2 == null) {
            AsyncDevicesGetter.$$$reportNull$$$0(17);
        }
        if (key == null) {
            AsyncDevicesGetter.$$$reportNull$$$0(18);
        }
        Optional<VirtualDevice> optional2 = devices2.stream().filter(device -> device.matches(key)).findFirst();
        if (optional2 == null) {
            AsyncDevicesGetter.$$$reportNull$$$0(19);
        }
        return optional2;
    }

    @NotNull
    private Stream<PhysicalDevice> physicalDeviceStream(@NotNull Collection<ConnectedDevice> connectedDevices) {
        if (connectedDevices == null) {
            AsyncDevicesGetter.$$$reportNull$$$0(20);
        }
        Stream<PhysicalDevice> stream = connectedDevices.stream().filter(ConnectedDevice::isPhysicalDevice).map(device -> PhysicalDevice.newDevice(device, this.myGetName, this.myMap));
        if (stream == null) {
            AsyncDevicesGetter.$$$reportNull$$$0(21);
        }
        return stream;
    }

    @NotNull
    private static Stream<VirtualDevice> disconnectedVirtualDeviceStream(@NotNull Collection<VirtualDevice> virtualDevices, @NotNull Collection<ConnectedDevice> connectedDevices) {
        if (virtualDevices == null) {
            AsyncDevicesGetter.$$$reportNull$$$0(22);
        }
        if (connectedDevices == null) {
            AsyncDevicesGetter.$$$reportNull$$$0(23);
        }
        Collection connectedVirtualDeviceKeys = connectedDevices.stream().filter(ConnectedDevice::isVirtualDevice).map(Device::getKey).collect(Collectors.toSet());
        Stream<VirtualDevice> stream = virtualDevices.stream().filter(device -> !device.hasKeyContainedBy(connectedVirtualDeviceKeys));
        if (stream == null) {
            AsyncDevicesGetter.$$$reportNull$$$0(24);
        }
        return stream;
    }

    @VisibleForTesting
    void initChecker(@Nullable RunnerAndConfigurationSettings configurationAndSettings, @NotNull Function<Module, AndroidFacet> facetGetter) {
        if (facetGetter == null) {
            AsyncDevicesGetter.$$$reportNull$$$0(25);
        }
        if (configurationAndSettings == null) {
            this.myChecker = null;
            return;
        }
        RunConfiguration configuration = configurationAndSettings.getConfiguration();
        if (!(configuration instanceof ModuleBasedConfiguration)) {
            this.myChecker = null;
            return;
        }
        Module module2 = ((ModuleBasedConfiguration)configuration).getConfigurationModule().getModule();
        if (module2 == null) {
            this.myChecker = null;
            return;
        }
        AndroidFacet facet2 = facetGetter.apply(module2);
        if (facet2 == null || Disposer.isDisposed((Disposable)facet2)) {
            this.myChecker = null;
            return;
        }
        if (DumbService.isDumb((Project)this.myProject)) {
            this.myChecker = null;
            return;
        }
        this.myChecker = LaunchCompatibilityCheckerImpl.create(facet2, null, null);
    }

    @VisibleForTesting
    Object getChecker() {
        return this.myChecker;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 21: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 21: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectDeviceSnapshotComboBoxSnapshotsEnabled";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getName";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/deployment/AsyncDevicesGetter";
                break;
            }
            case 11: 
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualDevices";
                break;
            }
            case 12: 
            case 14: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectedDevices";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "devices";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetGetter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/deployment/AsyncDevicesGetter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getImpl";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "connectedVirtualDeviceStream";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findFirst";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "physicalDeviceStream";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "disconnectedVirtualDeviceStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 21: 
            case 24: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getImpl";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "connectedVirtualDeviceStream";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findFirst";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "physicalDeviceStream";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "disconnectedVirtualDeviceStream";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "initChecker";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 21: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

