/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.activity;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.model.ActivitiesAndAliases;
import com.android.tools.idea.model.AndroidManifestIndex;
import com.android.tools.idea.model.AndroidManifestIndexQueryUtils;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.run.activity.ActivityLocator;
import com.android.tools.idea.run.activity.ActivityLocatorUtils;
import com.android.tools.idea.run.activity.DefaultActivityLocator;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.Function;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;

public class SpecificActivityLocator
extends ActivityLocator {
    @NotNull
    private final AndroidFacet myFacet;
    @Nullable
    private final String myActivityName;
    @NotNull
    private final GlobalSearchScope mySearchScope;

    public SpecificActivityLocator(@NotNull AndroidFacet facet2, @Nullable String activityName, @NotNull GlobalSearchScope searchScope) {
        if (facet2 == null) {
            SpecificActivityLocator.$$$reportNull$$$0(0);
        }
        if (searchScope == null) {
            SpecificActivityLocator.$$$reportNull$$$0(1);
        }
        this.myFacet = facet2;
        this.myActivityName = activityName;
        this.mySearchScope = searchScope;
    }

    public SpecificActivityLocator(@NotNull AndroidFacet facet2, @Nullable String activityName) {
        if (facet2 == null) {
            SpecificActivityLocator.$$$reportNull$$$0(2);
        }
        this(facet2, activityName, GlobalSearchScope.projectScope((Project)facet2.getModule().getProject()));
    }

    @Override
    @NotNull
    public String getQualifiedActivityName(@NotNull IDevice device) {
        if (device == null) {
            SpecificActivityLocator.$$$reportNull$$$0(3);
        }
        assert (this.myActivityName != null);
        String string = this.myActivityName;
        if (string == null) {
            SpecificActivityLocator.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public void validate() throws ActivityLocator.ActivityLocatorException {
        if (this.myActivityName == null || this.myActivityName.isEmpty()) {
            throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("activity.class.not.specified.error", new Object[0]));
        }
        if (SpecificActivityLocator.doesPackageContainMavenProperty(this.myFacet)) {
            return;
        }
        Module module2 = this.myFacet.getModule();
        Project project = module2.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiClass activityClass = facade.findClass("android.app.Activity", ProjectScope.getAllScope((Project)project));
        if (activityClass == null) {
            throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("cant.find.activity.class.error", new Object[0]));
        }
        PsiClass specifiedActivityClass = JavaExecutionUtil.findMainClass((Project)project, (String)this.myActivityName, (GlobalSearchScope)this.mySearchScope);
        if (AndroidManifestIndex.indexEnabled().booleanValue()) {
            this.validateBasedOnManifestIndex(activityClass, specifiedActivityClass);
            return;
        }
        this.validateBasedOnMergedManifestSnapshot(activityClass, specifiedActivityClass);
    }

    private void validateBasedOnManifestIndex(@NotNull PsiClass activityClass, @Nullable PsiClass specifiedActivityClass) throws ActivityLocator.ActivityLocatorException {
        if (activityClass == null) {
            SpecificActivityLocator.$$$reportNull$$$0(5);
        }
        if (DumbService.isDumb((Project)this.myFacet.getModule().getProject())) {
            return;
        }
        ActivitiesAndAliases activityWrappers = AndroidManifestIndexQueryUtils.queryActivitiesFromManifestIndex(this.myFacet);
        this.validateHelper(activityClass, specifiedActivityClass, (Function<String, DefaultActivityLocator.ActivityWrapper>)((Function)activityWrappers::findActivityByName), (Function<String, DefaultActivityLocator.ActivityWrapper>)((Function)activityWrappers::findAliasByName));
    }

    private void validateBasedOnMergedManifestSnapshot(@NotNull PsiClass activityClass, @Nullable PsiClass specifiedActivityClass) throws ActivityLocator.ActivityLocatorException {
        boolean onEdt;
        MergedManifestSnapshot manifest;
        if (activityClass == null) {
            SpecificActivityLocator.$$$reportNull$$$0(6);
        }
        if ((manifest = SpecificActivityLocator.getMergedManifest(this.myFacet, onEdt = ApplicationManager.getApplication().isDispatchThread() && !ApplicationManager.getApplication().isUnitTestMode())) == null) {
            return;
        }
        this.validateHelper(activityClass, specifiedActivityClass, (Function<String, DefaultActivityLocator.ActivityWrapper>)((Function)name -> {
            Element element2 = manifest.findActivity((String)name);
            if (element2 == null) {
                return null;
            }
            return DefaultActivityLocator.ActivityWrapper.get(element2);
        }), (Function<String, DefaultActivityLocator.ActivityWrapper>)((Function)name -> {
            Element element2 = manifest.findActivityAlias((String)name);
            if (element2 == null) {
                return null;
            }
            return DefaultActivityLocator.ActivityWrapper.get(element2);
        }));
    }

    private void validateHelper(@NotNull PsiClass activityClass, @Nullable PsiClass specifiedActivityClass, Function<String, DefaultActivityLocator.ActivityWrapper> getActivity, Function<String, DefaultActivityLocator.ActivityWrapper> getAlias) throws ActivityLocator.ActivityLocatorException {
        DefaultActivityLocator.ActivityWrapper specifiedActivity;
        if (activityClass == null) {
            SpecificActivityLocator.$$$reportNull$$$0(7);
        }
        if (specifiedActivityClass == null || !specifiedActivityClass.isInheritor(activityClass, true)) {
            specifiedActivity = (DefaultActivityLocator.ActivityWrapper)getAlias.fun((Object)this.myActivityName);
            if (specifiedActivity == null) {
                throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("not.activity.subclass.error", this.myActivityName));
            }
        } else {
            String qualifiedActivityName = ActivityLocatorUtils.getQualifiedActivityName(specifiedActivityClass);
            specifiedActivity = (DefaultActivityLocator.ActivityWrapper)getActivity.fun((Object)qualifiedActivityName);
            if (specifiedActivity == null) {
                throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("activity.not.declared.in.manifest", specifiedActivityClass.getName()));
            }
        }
        if (!specifiedActivity.isLogicallyExported()) {
            throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("specific.activity.not.launchable.error", new Object[0]));
        }
    }

    private static boolean doesPackageContainMavenProperty(@NotNull AndroidFacet facet2) {
        Manifest manifest;
        if (facet2 == null) {
            SpecificActivityLocator.$$$reportNull$$$0(8);
        }
        if ((manifest = Manifest.getMainManifest(facet2)) == null) {
            return false;
        }
        String aPackage = manifest.getPackage().getStringValue();
        return aPackage != null && aPackage.contains("${");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/activity/SpecificActivityLocator";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activityClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/activity/SpecificActivityLocator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedActivityName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedActivityName";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validateBasedOnManifestIndex";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validateBasedOnMergedManifestSnapshot";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "validateHelper";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doesPackageContainMavenProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

