/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.activity;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.ApkFileUnit;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.activity.ActivityLocator;
import com.android.tools.idea.run.activity.DefaultActivityLocator;
import com.android.tools.idea.run.activity.manifest.IntentFilter;
import com.android.tools.idea.run.activity.manifest.ManifestActivityInfo;
import com.android.tools.idea.run.activity.manifest.NodeActivity;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class DefaultApkActivityLocator
extends ActivityLocator {
    private static final Logger LOG = Logger.getInstance(DefaultApkActivityLocator.class);
    private final ApkProvider myApkProvider;

    public DefaultApkActivityLocator(@NotNull ApkProvider apkProvider) {
        if (apkProvider == null) {
            DefaultApkActivityLocator.$$$reportNull$$$0(0);
        }
        this.myApkProvider = apkProvider;
    }

    @Override
    public void validate() throws ActivityLocator.ActivityLocatorException {
    }

    @Override
    @NotNull
    public String getQualifiedActivityName(@NotNull IDevice device) throws ActivityLocator.ActivityLocatorException {
        Collection<ApkInfo> apks;
        if (device == null) {
            DefaultApkActivityLocator.$$$reportNull$$$0(1);
        }
        try {
            apks = this.myApkProvider.getApks(device);
        }
        catch (Exception e) {
            throw new ActivityLocator.ActivityLocatorException("Unable to list apks", e);
        }
        if (apks.isEmpty()) {
            throw new ActivityLocator.ActivityLocatorException("No APKs provided. Unable to extract default activity");
        }
        String defaultActivity = DefaultApkActivityLocator.computeDefaultActivityFromApks(apks);
        if (defaultActivity == null) {
            throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("default.activity.not.found.error", new Object[0]));
        }
        String string = defaultActivity;
        if (string == null) {
            DefaultApkActivityLocator.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static String computeDefaultActivityFromApks(@NotNull Collection<ApkInfo> apks) {
        if (apks == null) {
            DefaultApkActivityLocator.$$$reportNull$$$0(3);
        }
        if (apks.size() != 1) {
            StringBuilder errorMessage = new StringBuilder("Unable to extract Default Activity\n");
            errorMessage.append("Received projects:\n");
            for (ApkInfo apkInfo : apks) {
                errorMessage.append("  " + apkInfo.getApplicationId() + " containing :\n" + apkInfo.getFiles());
                for (ApkFileUnit fileUnit : apkInfo.getFiles()) {
                    errorMessage.append("    " + fileUnit.getApkFile());
                }
            }
            throw new IllegalStateException(errorMessage.toString());
        }
        ArrayList<NodeActivity> activities = new ArrayList<NodeActivity>();
        ApkInfo apkInfo = apks.iterator().next();
        for (ApkFileUnit apkFileUnit : apkInfo.getFiles()) {
            File file2 = apkFileUnit.getApkFile();
            String ext = file2.getName().toLowerCase(Locale.US);
            if (!ext.endsWith(".apk")) continue;
            try (ZipFile zipFile = new ZipFile(file2);){
                ZipEntry manifestEntry = zipFile.getEntry("AndroidManifest.xml");
                if (manifestEntry == null) continue;
                InputStream input = zipFile.getInputStream(manifestEntry);
                try {
                    ManifestActivityInfo manifest = ManifestActivityInfo.parseBinaryFromStream(input);
                    activities.addAll(manifest.activities());
                }
                finally {
                    if (input == null) continue;
                    input.close();
                }
            }
            catch (Exception e) {
                LOG.warn("Unable to parse '" + file2.getName() + "' for default activity", (Throwable)e);
            }
        }
        String defaultActivityName = DefaultActivityLocator.computeDefaultActivity(activities);
        if (defaultActivityName == null) {
            StringBuilder errorMessage = new StringBuilder("Unable to find Default Activity in:\n");
            DefaultApkActivityLocator.printActivities(activities, errorMessage);
            LOG.info(errorMessage.toString());
        }
        return defaultActivityName;
    }

    private static void printActivities(List<NodeActivity> activities, StringBuilder message2) {
        for (NodeActivity activity : activities) {
            message2.append("  " + activity.getQualifiedName() + ":\n");
            for (IntentFilter intent : activity.getIntentFilters()) {
                for (String action2 : intent.getActions()) {
                    message2.append("    " + action2 + "\n");
                }
                for (String category : intent.getCategories()) {
                    message2.append("    " + category + "\n");
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apkProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/activity/DefaultApkActivityLocator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/activity/DefaultApkActivityLocator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedActivityName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedActivityName";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeDefaultActivityFromApks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

