/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.AndroidProcessHandler;
import com.android.tools.idea.run.AppDeploymentListener;
import com.android.tools.idea.run.ApplicationTerminator;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.LaunchInfo;
import com.android.tools.idea.run.tasks.DebugConnectorTask;
import com.android.tools.idea.run.tasks.LaunchContext;
import com.android.tools.idea.run.tasks.LaunchResult;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.tasks.LaunchTasksProvider;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.run.util.LaunchUtils;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.android.tools.idea.run.util.SwapInfo;
import com.android.tools.idea.stats.RunStats;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.wireless.android.sdk.stats.LaunchTaskDetail;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaunchTaskRunner
extends Task.Backgroundable {
    @NotNull
    private final String myConfigName;
    @NotNull
    private final String myApplicationId;
    @Nullable
    private final String myExecutionTargetName;
    @NotNull
    private final LaunchInfo myLaunchInfo;
    @NotNull
    private final ProcessHandler myProcessHandler;
    @NotNull
    private final DeviceFutures myDeviceFutures;
    @NotNull
    private final LaunchTasksProvider myLaunchTasksProvider;
    @NotNull
    private final RunStats myStats;
    @NotNull
    private final BiConsumer<String, HyperlinkInfo> myConsoleConsumer;
    @NotNull
    private final List<Runnable> myOnFinished;
    @Nullable
    private String myError;
    @Nullable
    private NotificationListener myErrorNotificationListener;

    public LaunchTaskRunner(@NotNull Project project, @NotNull String configName, @NotNull String applicationId2, @Nullable String executionTargetName, @NotNull LaunchInfo launchInfo, @NotNull ProcessHandler processHandler, @NotNull DeviceFutures deviceFutures, @NotNull LaunchTasksProvider launchTasksProvider, @NotNull RunStats stats, @NotNull BiConsumer<String, HyperlinkInfo> consoleConsumer) {
        if (project == null) {
            LaunchTaskRunner.$$$reportNull$$$0(0);
        }
        if (configName == null) {
            LaunchTaskRunner.$$$reportNull$$$0(1);
        }
        if (applicationId2 == null) {
            LaunchTaskRunner.$$$reportNull$$$0(2);
        }
        if (launchInfo == null) {
            LaunchTaskRunner.$$$reportNull$$$0(3);
        }
        if (processHandler == null) {
            LaunchTaskRunner.$$$reportNull$$$0(4);
        }
        if (deviceFutures == null) {
            LaunchTaskRunner.$$$reportNull$$$0(5);
        }
        if (launchTasksProvider == null) {
            LaunchTaskRunner.$$$reportNull$$$0(6);
        }
        if (stats == null) {
            LaunchTaskRunner.$$$reportNull$$$0(7);
        }
        if (consoleConsumer == null) {
            LaunchTaskRunner.$$$reportNull$$$0(8);
        }
        super(project, "Launching " + configName);
        this.myConfigName = configName;
        this.myApplicationId = applicationId2;
        this.myExecutionTargetName = executionTargetName;
        this.myLaunchInfo = launchInfo;
        this.myProcessHandler = processHandler;
        this.myDeviceFutures = deviceFutures;
        this.myLaunchTasksProvider = launchTasksProvider;
        this.myStats = stats;
        this.myConsoleConsumer = consoleConsumer;
        this.myOnFinished = new ArrayList<Runnable>();
    }

    /*
     * Exception decompiling
     */
    public void run(@NotNull ProgressIndicator indicator) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ListenableFuture<Boolean> runLaunchTaskAsync(@NotNull List<LaunchTask> launchTasks, @NotNull ProgressIndicator indicator, @NotNull LaunchContext launchContext, boolean destroyProcessOnCancellation, @NotNull AtomicInteger completedStepsCount, int totalScheduledStepsCount) {
        if (launchTasks == null) {
            LaunchTaskRunner.$$$reportNull$$$0(10);
        }
        if (indicator == null) {
            LaunchTaskRunner.$$$reportNull$$$0(11);
        }
        if (launchContext == null) {
            LaunchTaskRunner.$$$reportNull$$$0(12);
        }
        if (completedStepsCount == null) {
            LaunchTaskRunner.$$$reportNull$$$0(13);
        }
        return MoreExecutors.listeningDecorator((ExecutorService)MoreExecutors.newDirectExecutorService()).submit(() -> {
            indicator.setFraction((double)(completedStepsCount.floatValue() / (float)totalScheduledStepsCount));
            IDevice device = launchContext.getDevice();
            LaunchStatus launchStatus = launchContext.getLaunchStatus();
            String groupId = "LaunchTaskRunner for " + launchContext.getExecutor().getId();
            NotificationGroup notificationGroup = NotificationGroup.findRegisteredGroup((String)groupId);
            if (notificationGroup == null) {
                notificationGroup = NotificationGroup.toolWindowGroup((String)groupId, (String)launchContext.getExecutor().getId());
            }
            for (LaunchTask task2 : launchTasks) {
                if (!LaunchTaskRunner.checkIfLaunchIsAliveAndTerminateIfCancelIsRequested(indicator, launchStatus, destroyProcessOnCancellation)) {
                    return false;
                }
                if (!task2.shouldRun(launchContext)) continue;
                LaunchTaskDetail.Builder details = this.myStats.beginLaunchTask(task2);
                indicator.setText(task2.getDescription());
                LaunchResult result2 = task2.run(launchContext);
                this.myOnFinished.addAll(result2.onFinishedCallbacks());
                boolean success2 = result2.getSuccess();
                this.myStats.endLaunchTask(task2, details, success2);
                if (!success2) {
                    this.myErrorNotificationListener = result2.getNotificationListener();
                    this.myError = result2.getError();
                    launchStatus.terminateLaunch(result2.getConsoleError(), !this.isSwap());
                    if (result2.getConsoleHyperlinkInfo() != null) {
                        this.myConsoleConsumer.accept(result2.getConsoleHyperlinkText() + "\n", result2.getConsoleHyperlinkInfo());
                    }
                    notificationGroup.createNotification("Error", result2.getError(), NotificationType.ERROR).setListener(this.myErrorNotificationListener).setImportant(true).notify(this.myProject);
                    RunContentManager.getInstance((Project)this.myProject).toFrontRunContent(this.myLaunchInfo.executor, this.myProcessHandler);
                    this.myStats.setErrorId(result2.getErrorId());
                    return false;
                }
                ((AppDeploymentListener)this.myProject.getMessageBus().syncPublisher(AppDeploymentListener.TOPIC)).appDeployedToDevice(device, this.myProject);
                indicator.setFraction((double)(completedStepsCount.floatValue() / (float)totalScheduledStepsCount));
            }
            String launchType = this.myLaunchTasksProvider.getLaunchTypeDisplayName();
            notificationGroup.createNotification("", launchType + " succeeded", NotificationType.INFORMATION).setImportant(false).notify(this.myProject);
            return true;
        });
    }

    private void printLaunchTaskStartedMessage(ConsolePrinter consolePrinter) {
        StringBuilder launchString = new StringBuilder("\n");
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd HH:mm:ss");
        launchString.append(dateFormat.format(new Date())).append(": ");
        launchString.append(this.getLaunchVerb()).append(" ");
        launchString.append("'").append(this.myConfigName).append("'");
        if (!StringUtil.isEmpty((String)this.myExecutionTargetName)) {
            launchString.append(" on ");
            launchString.append(this.myExecutionTargetName);
        }
        launchString.append(".");
        consolePrinter.stdout(launchString.toString());
    }

    public void onSuccess() {
        if (this.myError == null) {
            this.myStats.success();
        } else {
            this.myStats.fail();
            LaunchUtils.showNotification(this.myProject, this.myLaunchInfo.executor, this.myConfigName, this.myError, NotificationType.ERROR, this.myErrorNotificationListener);
        }
    }

    public void onFinished() {
        super.onFinished();
        for (Runnable runnable2 : this.myOnFinished) {
            ApplicationManager.getApplication().invokeLater(runnable2);
        }
    }

    @Nullable
    private IDevice waitForDevice(@NotNull ListenableFuture<IDevice> deviceFuture, @NotNull ProgressIndicator indicator, @NotNull LaunchStatus launchStatus, boolean destroyProcess) {
        if (deviceFuture == null) {
            LaunchTaskRunner.$$$reportNull$$$0(14);
        }
        if (indicator == null) {
            LaunchTaskRunner.$$$reportNull$$$0(15);
        }
        if (launchStatus == null) {
            LaunchTaskRunner.$$$reportNull$$$0(16);
        }
        this.myStats.beginWaitForDevice();
        IDevice device = null;
        while (LaunchTaskRunner.checkIfLaunchIsAliveAndTerminateIfCancelIsRequested(indicator, launchStatus, destroyProcess)) {
            try {
                device = (IDevice)deviceFuture.get(1L, TimeUnit.SECONDS);
                break;
            }
            catch (TimeoutException timeoutException) {
            }
            catch (InterruptedException e) {
                launchStatus.terminateLaunch("Interrupted while waiting for device", destroyProcess);
                break;
            }
            catch (ExecutionException e) {
                launchStatus.terminateLaunch("Error while waiting for device: " + e.getCause().getMessage(), destroyProcess);
                break;
            }
        }
        this.myStats.endWaitForDevice(device);
        return device;
    }

    private static boolean checkIfLaunchIsAliveAndTerminateIfCancelIsRequested(@NotNull ProgressIndicator indicator, @NotNull LaunchStatus launchStatus, boolean destroyProcess) {
        if (indicator == null) {
            LaunchTaskRunner.$$$reportNull$$$0(17);
        }
        if (launchStatus == null) {
            LaunchTaskRunner.$$$reportNull$$$0(18);
        }
        if (launchStatus.isLaunchTerminated()) {
            return false;
        }
        if (indicator.isCanceled()) {
            launchStatus.terminateLaunch("User cancelled launch", destroyProcess);
            return false;
        }
        return true;
    }

    private static int getTotalDuration(@NotNull List<LaunchTask> launchTasks, @Nullable DebugConnectorTask debugSessionTask) {
        if (launchTasks == null) {
            LaunchTaskRunner.$$$reportNull$$$0(19);
        }
        int total = 0;
        for (LaunchTask task2 : launchTasks) {
            total += task2.getDuration();
        }
        if (debugSessionTask != null) {
            total += debugSessionTask.getDuration();
        }
        return total;
    }

    private boolean isSwap() {
        return this.myLaunchInfo.env.getUserData(SwapInfo.SWAP_INFO_KEY) != null;
    }

    @NotNull
    private String getLaunchVerb() {
        SwapInfo swapInfo = (SwapInfo)this.myLaunchInfo.env.getUserData(SwapInfo.SWAP_INFO_KEY);
        if (swapInfo != null) {
            if (swapInfo.getType() == SwapInfo.SwapType.APPLY_CHANGES) {
                return "Applying changes to";
            }
            if (swapInfo.getType() == SwapInfo.SwapType.APPLY_CODE_CHANGES) {
                return "Applying code changes to";
            }
        }
        return "Launching";
    }

    private static /* synthetic */ int lambda$run$4(DebugConnectorTask debugSessionTask, List launchTasks) {
        return LaunchTaskRunner.getTotalDuration(launchTasks, debugSessionTask);
    }

    private static /* synthetic */ void lambda$run$3() {
    }

    private /* synthetic */ ListenableFuture lambda$run$2(ProcessHandlerLaunchStatus launchStatus, IDevice device) {
        return MoreExecutors.listeningDecorator((ExecutorService)AppExecutorUtil.getAppExecutorService()).submit(() -> {
            ApplicationTerminator terminator = new ApplicationTerminator(device, this.myApplicationId);
            if (!terminator.killApp(launchStatus)) {
                throw new CancellationException("Could not terminate running app " + this.myApplicationId);
            }
            if (device.isOnline()) {
                ((AndroidProcessHandler)this.myProcessHandler).addTargetDevice(device);
            }
        });
    }

    private /* synthetic */ IDevice lambda$run$0(ProgressIndicator indicator, ProcessHandlerLaunchStatus launchStatus, boolean destroyProcessOnCancellation, ListenableFuture deviceFuture) {
        return this.waitForDevice((ListenableFuture<IDevice>)deviceFuture, indicator, launchStatus, destroyProcessOnCancellation);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceFutures";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchTasksProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stats";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleConsumer";
                break;
            }
            case 9: 
            case 11: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchTasks";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchContext";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completedStepsCount";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceFuture";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchStatus";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/run/LaunchTaskRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "runLaunchTaskAsync";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "waitForDevice";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "checkIfLaunchIsAliveAndTerminateIfCancelIsRequested";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "getTotalDuration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

