/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.builder.model.InstantAppProjectBuildOutput;
import com.android.builder.model.InstantAppVariantBuildOutput;
import com.android.builder.model.ProjectBuildOutput;
import com.android.builder.model.TestVariantBuildOutput;
import com.android.builder.model.VariantBuildOutput;
import com.android.ddmlib.IDevice;
import com.android.ide.common.build.GenericBuiltArtifacts;
import com.android.ide.common.build.GenericBuiltArtifactsLoader;
import com.android.ide.common.gradle.model.IdeAndroidArtifact;
import com.android.ide.common.gradle.model.IdeAndroidArtifactOutput;
import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.ide.common.gradle.model.IdeTestedTargetVariant;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.ide.common.gradle.model.impl.ModelCache;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.apk.analyzer.AaptInvoker;
import com.android.tools.apk.analyzer.AndroidApplicationInfo;
import com.android.tools.apk.analyzer.ArchiveContext;
import com.android.tools.apk.analyzer.Archives;
import com.android.tools.idea.apk.viewer.ApkParser;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.run.PostBuildModel;
import com.android.tools.idea.gradle.run.PostBuildModelProvider;
import com.android.tools.idea.gradle.util.DynamicAppUtils;
import com.android.tools.idea.gradle.util.GradleBuildOutputUtil;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.OutputType;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.projectsystem.AndroidProjectSettingsService;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.run.ApkFileUnit;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.BestOutputFinder;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class GradleApkProvider
implements ApkProvider {
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final ApplicationIdProvider myApplicationIdProvider;
    @NotNull
    private final PostBuildModelProvider myOutputModelProvider;
    @NotNull
    private final BestOutputFinder myBestOutputFinder;
    private final boolean myTest;
    private Function<AndroidVersion, OutputKind> myOutputKindProvider;
    public static final Key<PostBuildModel> POST_BUILD_MODEL = Key.create((String)"com.android.tools.idea.post_build_model");

    public GradleApkProvider(@NotNull AndroidFacet facet2, @NotNull ApplicationIdProvider applicationIdProvider, @NotNull PostBuildModelProvider outputModelProvider, boolean test, @NotNull Function<AndroidVersion, OutputKind> outputKindProvider) {
        if (facet2 == null) {
            GradleApkProvider.$$$reportNull$$$0(0);
        }
        if (applicationIdProvider == null) {
            GradleApkProvider.$$$reportNull$$$0(1);
        }
        if (outputModelProvider == null) {
            GradleApkProvider.$$$reportNull$$$0(2);
        }
        if (outputKindProvider == null) {
            GradleApkProvider.$$$reportNull$$$0(3);
        }
        this(facet2, applicationIdProvider, outputModelProvider, new BestOutputFinder(), test, outputKindProvider);
    }

    @VisibleForTesting
    public GradleApkProvider(@NotNull AndroidFacet facet2, @NotNull ApplicationIdProvider applicationIdProvider, boolean test) {
        if (facet2 == null) {
            GradleApkProvider.$$$reportNull$$$0(4);
        }
        if (applicationIdProvider == null) {
            GradleApkProvider.$$$reportNull$$$0(5);
        }
        this(facet2, applicationIdProvider, () -> null, test, version2 -> OutputKind.Default);
    }

    @VisibleForTesting
    public GradleApkProvider(@NotNull AndroidFacet facet2, @NotNull ApplicationIdProvider applicationIdProvider, @NotNull PostBuildModelProvider outputModelProvider, boolean test) {
        if (facet2 == null) {
            GradleApkProvider.$$$reportNull$$$0(6);
        }
        if (applicationIdProvider == null) {
            GradleApkProvider.$$$reportNull$$$0(7);
        }
        if (outputModelProvider == null) {
            GradleApkProvider.$$$reportNull$$$0(8);
        }
        this(facet2, applicationIdProvider, outputModelProvider, new BestOutputFinder(), test, version2 -> OutputKind.Default);
    }

    @VisibleForTesting
    GradleApkProvider(@NotNull AndroidFacet facet2, @NotNull ApplicationIdProvider applicationIdProvider, @NotNull PostBuildModelProvider outputModelProvider, @NotNull BestOutputFinder bestOutputFinder, boolean test, Function<AndroidVersion, OutputKind> outputKindProvider) {
        if (facet2 == null) {
            GradleApkProvider.$$$reportNull$$$0(9);
        }
        if (applicationIdProvider == null) {
            GradleApkProvider.$$$reportNull$$$0(10);
        }
        if (outputModelProvider == null) {
            GradleApkProvider.$$$reportNull$$$0(11);
        }
        if (bestOutputFinder == null) {
            GradleApkProvider.$$$reportNull$$$0(12);
        }
        this.myFacet = facet2;
        this.myApplicationIdProvider = applicationIdProvider;
        this.myOutputModelProvider = outputModelProvider;
        this.myBestOutputFinder = bestOutputFinder;
        this.myTest = test;
        this.myOutputKindProvider = outputKindProvider;
    }

    @TestOnly
    OutputKind getOutputKind(@Nullable AndroidVersion targetDevicesMinVersion) {
        return this.myOutputKindProvider.apply(targetDevicesMinVersion);
    }

    @TestOnly
    boolean isTest() {
        return this.myTest;
    }

    @Override
    @NotNull
    public Collection<ApkInfo> getApks(@NotNull IDevice device) throws ApkProvisionException {
        if (device == null) {
            GradleApkProvider.$$$reportNull$$$0(13);
        }
        List<ApkInfo> list = this.getApks(device.getAbis(), device.getVersion());
        if (list == null) {
            GradleApkProvider.$$$reportNull$$$0(14);
        }
        return list;
    }

    @VisibleForTesting
    @NotNull
    public List<ApkInfo> getApks(List<String> deviceAbis, AndroidVersion deviceVersion) throws ApkProvisionException {
        AndroidModuleModel androidModel = AndroidModuleModel.get(this.myFacet);
        if (androidModel == null) {
            GradleApkProvider.getLogger().warn("Android model is null. Sync might have failed");
            List<ApkInfo> list = Collections.emptyList();
            if (list == null) {
                GradleApkProvider.$$$reportNull$$$0(15);
            }
            return list;
        }
        IdeVariant selectedVariant = androidModel.getSelectedVariant();
        ArrayList<ApkInfo> apkList = new ArrayList<ApkInfo>();
        int projectType = androidModel.getAndroidProject().getProjectType();
        if (projectType == 0 || projectType == 4 || projectType == 2 || projectType == 6) {
            String pkgName;
            String string = pkgName = projectType == 2 ? this.myApplicationIdProvider.getTestPackageName() : this.myApplicationIdProvider.getPackageName();
            if (pkgName == null) {
                GradleApkProvider.getLogger().warn("Package name is null. Sync might have failed");
                List<ApkInfo> list = Collections.emptyList();
                if (list == null) {
                    GradleApkProvider.$$$reportNull$$$0(16);
                }
                return list;
            }
            switch (this.myOutputKindProvider.apply(deviceVersion)) {
                case Default: {
                    ArrayList<ApkFileUnit> apkFileList = new ArrayList<ApkFileUnit>();
                    apkFileList.add(new ApkFileUnit(androidModel.getModuleName(), this.getApk(selectedVariant, deviceAbis, deviceVersion, this.myFacet, false)));
                    apkFileList.addAll(this.collectDependentFeaturesApks(androidModel, deviceAbis, deviceVersion));
                    apkList.add(new ApkInfo(apkFileList, pkgName));
                    break;
                }
                case AppBundleOutputModel: {
                    ApkInfo apkInfo;
                    Module baseAppModule = this.myFacet.getModule();
                    if (projectType == 6) {
                        baseAppModule = DynamicAppUtils.getBaseFeature(this.myFacet.getModule());
                    }
                    if (baseAppModule == null || (apkInfo = DynamicAppUtils.collectAppBundleOutput(baseAppModule, this.myOutputModelProvider, pkgName)) == null) break;
                    apkList.add(apkInfo);
                }
            }
        }
        apkList.addAll(GradleApkProvider.getAdditionalApks(selectedVariant.getMainArtifact()));
        if (this.myTest) {
            if (projectType == 2) {
                if (androidModel.getFeatures().isTestedTargetVariantsSupported()) {
                    apkList.addAll(0, this.getTargetedApks(selectedVariant, deviceAbis, deviceVersion));
                }
            } else {
                IdeAndroidArtifact testArtifactInfo = androidModel.getSelectedVariant().getAndroidTestArtifact();
                if (testArtifactInfo != null) {
                    File testApk = this.getApk(androidModel.getSelectedVariant(), deviceAbis, deviceVersion, this.myFacet, true);
                    String testPackageName = this.myApplicationIdProvider.getTestPackageName();
                    assert (testPackageName != null);
                    apkList.add(new ApkInfo(testApk, testPackageName));
                    apkList.addAll(GradleApkProvider.getAdditionalApks(testArtifactInfo));
                }
            }
        }
        ArrayList<ApkInfo> arrayList = apkList;
        if (arrayList == null) {
            GradleApkProvider.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @NotNull
    private List<ApkFileUnit> collectDependentFeaturesApks(@NotNull AndroidModuleModel androidModel, @NotNull List<String> deviceAbis, @NotNull AndroidVersion deviceVersion) {
        if (androidModel == null) {
            GradleApkProvider.$$$reportNull$$$0(18);
        }
        if (deviceAbis == null) {
            GradleApkProvider.$$$reportNull$$$0(19);
        }
        if (deviceVersion == null) {
            GradleApkProvider.$$$reportNull$$$0(20);
        }
        IdeAndroidProject project = androidModel.getAndroidProject();
        List<ApkFileUnit> list = DynamicAppUtils.getDependentFeatureModulesForBase(this.myFacet.getModule().getProject(), project).stream().map(module2 -> {
            AndroidFacet featureFacet = AndroidFacet.getInstance((Module)module2);
            if (featureFacet == null) {
                return null;
            }
            AndroidModuleModel androidFeatureModel = AndroidModuleModel.get(featureFacet);
            if (androidFeatureModel == null) {
                return null;
            }
            IdeVariant selectedVariant = androidFeatureModel.getSelectedVariant();
            try {
                File apk = this.getApk(selectedVariant, deviceAbis, deviceVersion, featureFacet, false);
                return new ApkFileUnit(androidFeatureModel.getModuleName(), apk);
            }
            catch (ApkProvisionException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (list == null) {
            GradleApkProvider.$$$reportNull$$$0(21);
        }
        return list;
    }

    @NotNull
    private static List<ApkInfo> getAdditionalApks(@NotNull IdeAndroidArtifact testArtifactInfo) {
        if (testArtifactInfo == null) {
            GradleApkProvider.$$$reportNull$$$0(22);
        }
        ArrayList<ApkInfo> result2 = new ArrayList<ApkInfo>();
        for (File fileApk : testArtifactInfo.getAdditionalRuntimeApks()) {
            try {
                String packageId = GradleApkProvider.getPackageId(fileApk);
                result2.add(new ApkInfo(fileApk, packageId));
            }
            catch (ApkProvisionException e) {
                GradleApkProvider.getLogger().error("Failed to get the package name from the given file. Therefore, we are not be able to install it. Please install it manually: " + fileApk.getName() + " error: " + e.getMessage(), (Throwable)e);
            }
        }
        ArrayList<ApkInfo> arrayList = result2;
        if (arrayList == null) {
            GradleApkProvider.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    private static Path getPathToAapt() {
        AndroidSdkHandler handler2 = AndroidSdks.getInstance().tryToChooseSdkHandler();
        return AaptInvoker.getPathToAapt((AndroidSdkHandler)handler2, (ILogger)new LogWrapper(GradleApkProvider.class));
    }

    private static String getPackageId(@NotNull File fileApk) throws ApkProvisionException {
        String string;
        block10: {
            if (fileApk == null) {
                GradleApkProvider.$$$reportNull$$$0(24);
            }
            ArchiveContext archiveContext = Archives.open((Path)fileApk.toPath());
            try {
                AndroidApplicationInfo applicationInfo = ApkParser.getAppInfo(GradleApkProvider.getPathToAapt(), archiveContext.getArchive());
                if (applicationInfo == AndroidApplicationInfo.UNKNOWN) {
                    throw new ApkProvisionException("Could not determine manifest package for apk: " + fileApk.getName());
                }
                string = applicationInfo.packageId;
                if (archiveContext == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (archiveContext != null) {
                        try {
                            archiveContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ApkProvisionException("Could not determine manifest package for apk: " + fileApk.getName(), e.getCause());
                }
            }
            archiveContext.close();
        }
        return string;
    }

    @VisibleForTesting
    @NotNull
    File getApk(@NotNull IdeVariant variant2, @NotNull List<String> deviceAbis, @NotNull AndroidVersion deviceVersion, @NotNull AndroidFacet facet2, boolean fromTestArtifact) throws ApkProvisionException {
        if (variant2 == null) {
            GradleApkProvider.$$$reportNull$$$0(25);
        }
        if (deviceAbis == null) {
            GradleApkProvider.$$$reportNull$$$0(26);
        }
        if (deviceVersion == null) {
            GradleApkProvider.$$$reportNull$$$0(27);
        }
        if (facet2 == null) {
            GradleApkProvider.$$$reportNull$$$0(28);
        }
        AndroidModuleModel androidModel = AndroidModuleModel.get(facet2);
        assert (androidModel != null);
        if (androidModel.getFeatures().isBuildOutputFileSupported()) {
            return this.getApkFromBuildOutputFile(androidModel, deviceAbis, fromTestArtifact);
        }
        if (androidModel.getFeatures().isPostBuildSyncSupported()) {
            File file2 = this.getApkFromPostBuildSync(variant2, deviceAbis, deviceVersion, facet2, fromTestArtifact);
            if (file2 == null) {
                GradleApkProvider.$$$reportNull$$$0(29);
            }
            return file2;
        }
        File file3 = this.getApkFromPreBuildSync(variant2, deviceAbis, fromTestArtifact);
        if (file3 == null) {
            GradleApkProvider.$$$reportNull$$$0(30);
        }
        return file3;
    }

    @NotNull
    private File getApkFromBuildOutputFile(@NotNull AndroidModuleModel androidModel, @NotNull List<String> deviceAbis, boolean fromTestArtifact) throws ApkProvisionException {
        IdeVariant variant2;
        String outputFile;
        if (androidModel == null) {
            GradleApkProvider.$$$reportNull$$$0(31);
        }
        if (deviceAbis == null) {
            GradleApkProvider.$$$reportNull$$$0(32);
        }
        if ((outputFile = GradleBuildOutputUtil.getOutputListingFile(androidModel, (variant2 = androidModel.getSelectedVariant()).getName(), OutputType.Apk, fromTestArtifact)) == null) {
            throw new ApkProvisionException("Cannot get output listing file name from the build model");
        }
        GenericBuiltArtifacts builtArtifacts = GenericBuiltArtifactsLoader.loadFromFile((File)new File(outputFile), (ILogger)new LogWrapper(GradleApkProvider.getLogger()));
        if (builtArtifacts == null) {
            throw new ApkProvisionException(String.format("Error loading build artifacts from: %s", outputFile));
        }
        File file2 = this.myBestOutputFinder.findBestOutput(variant2, deviceAbis, builtArtifacts);
        if (file2 == null) {
            GradleApkProvider.$$$reportNull$$$0(33);
        }
        return file2;
    }

    @NotNull
    @VisibleForTesting
    File getApkFromPreBuildSync(@NotNull IdeVariant variant2, @NotNull List<String> deviceAbis, boolean fromTestArtifact) throws ApkProvisionException {
        IdeAndroidArtifact artifact;
        if (variant2 == null) {
            GradleApkProvider.$$$reportNull$$$0(34);
        }
        if (deviceAbis == null) {
            GradleApkProvider.$$$reportNull$$$0(35);
        }
        IdeAndroidArtifact ideAndroidArtifact = artifact = fromTestArtifact ? variant2.getAndroidTestArtifact() : variant2.getMainArtifact();
        assert (artifact != null);
        ArrayList<IdeAndroidArtifactOutput> outputs = new ArrayList<IdeAndroidArtifactOutput>(artifact.getOutputs());
        File file2 = this.myBestOutputFinder.findBestOutput(variant2, deviceAbis, outputs);
        if (file2 == null) {
            GradleApkProvider.$$$reportNull$$$0(36);
        }
        return file2;
    }

    @NotNull
    @VisibleForTesting
    File getApkFromPostBuildSync(@NotNull IdeVariant variant2, @NotNull List<String> deviceAbis, @NotNull AndroidVersion deviceVersion, @NotNull AndroidFacet facet2, boolean fromTestArtifact) throws ApkProvisionException {
        if (variant2 == null) {
            GradleApkProvider.$$$reportNull$$$0(37);
        }
        if (deviceAbis == null) {
            GradleApkProvider.$$$reportNull$$$0(38);
        }
        if (deviceVersion == null) {
            GradleApkProvider.$$$reportNull$$$0(39);
        }
        if (facet2 == null) {
            GradleApkProvider.$$$reportNull$$$0(40);
        }
        ArrayList<IdeAndroidArtifactOutput> outputs = new ArrayList<IdeAndroidArtifactOutput>();
        PostBuildModel outputModels = this.myOutputModelProvider.getPostBuildModel();
        if (outputModels == null) {
            File file2 = this.getApkFromPreBuildSync(variant2, deviceAbis, fromTestArtifact);
            if (file2 == null) {
                GradleApkProvider.$$$reportNull$$$0(41);
            }
            return file2;
        }
        ModelCache modelCache = ModelCache.create();
        if (((AndroidFacetConfiguration)facet2.getConfiguration()).getProjectType() == 4) {
            InstantAppProjectBuildOutput outputModel = outputModels.findInstantAppProjectBuildOutput(facet2);
            if (outputModel == null) {
                throw new ApkProvisionException("Couldn't get post build model for Instant Apps. Please, make sure to use plugin 3.0.0-alpha10 or later.");
            }
            for (InstantAppVariantBuildOutput instantAppVariantBuildOutput : outputModel.getInstantAppVariantsBuildOutput()) {
                if (!instantAppVariantBuildOutput.getName().equals(variant2.getName())) continue;
                outputs.add((IdeAndroidArtifactOutput)modelCache.androidArtifactOutputFrom(instantAppVariantBuildOutput.getOutput()));
            }
        } else {
            ProjectBuildOutput outputModel = outputModels.findProjectBuildOutput(facet2);
            if (outputModel == null) {
                File file3 = this.getApkFromPreBuildSync(variant2, deviceAbis, fromTestArtifact);
                if (file3 == null) {
                    GradleApkProvider.$$$reportNull$$$0(42);
                }
                return file3;
            }
            for (VariantBuildOutput variantBuildOutput : outputModel.getVariantsBuildOutput()) {
                if (!variantBuildOutput.getName().equals(variant2.getName())) continue;
                if (fromTestArtifact) {
                    for (TestVariantBuildOutput testVariantBuildOutput : variantBuildOutput.getTestingVariants()) {
                        if (!testVariantBuildOutput.getType().equals(TestVariantBuildOutput.ANDROID_TEST)) continue;
                        int apiWithSplitApk = AndroidVersion.ALLOW_SPLIT_APK_INSTALLATION.getApiLevel();
                        if (((AndroidFacetConfiguration)facet2.getConfiguration()).getProjectType() == 6 && !deviceVersion.isGreaterOrEqualThan(apiWithSplitApk)) {
                            throw new ApkProvisionException("Running Instrumented Tests for Dynamic Features is currently not supported on API < 21.");
                        }
                        outputs.addAll(ContainerUtil.map((Collection)testVariantBuildOutput.getOutputs(), arg_0 -> ((ModelCache)modelCache).androidArtifactOutputFrom(arg_0)));
                    }
                    continue;
                }
                outputs.addAll(ContainerUtil.map((Collection)variantBuildOutput.getOutputs(), arg_0 -> ((ModelCache)modelCache).androidArtifactOutputFrom(arg_0)));
            }
        }
        File file4 = outputs.isEmpty() ? this.getApkFromPreBuildSync(variant2, deviceAbis, fromTestArtifact) : this.myBestOutputFinder.findBestOutput(variant2, deviceAbis, outputs);
        if (file4 == null) {
            GradleApkProvider.$$$reportNull$$$0(43);
        }
        return file4;
    }

    @NotNull
    private List<ApkInfo> getTargetedApks(@NotNull IdeVariant selectedVariant, @NotNull List<String> deviceAbis, @NotNull AndroidVersion deviceVersion) throws ApkProvisionException {
        if (selectedVariant == null) {
            GradleApkProvider.$$$reportNull$$$0(44);
        }
        if (deviceAbis == null) {
            GradleApkProvider.$$$reportNull$$$0(45);
        }
        if (deviceVersion == null) {
            GradleApkProvider.$$$reportNull$$$0(46);
        }
        ArrayList<ApkInfo> targetedApks = new ArrayList<ApkInfo>();
        for (IdeTestedTargetVariant testedVariant : selectedVariant.getTestedTargetVariants()) {
            String targetGradlePath = testedVariant.getTargetProjectPath();
            Module targetModule = (Module)ApplicationManager.getApplication().runReadAction(() -> {
                Project project = this.myFacet.getModule().getProject();
                return GradleUtil.findModuleByGradlePath(project, targetGradlePath);
            });
            if (targetModule == null) {
                GradleApkProvider.getLogger().warn(String.format("Module not found for gradle path %s. Please install tested apk manually.", targetGradlePath));
                continue;
            }
            AndroidFacet targetFacet = AndroidFacet.getInstance((Module)targetModule);
            if (targetFacet == null) {
                GradleApkProvider.getLogger().warn("Android facet for tested module is null. Please install tested apk manually.");
                continue;
            }
            AndroidModuleModel targetAndroidModel = AndroidModuleModel.get(targetModule);
            if (targetAndroidModel == null) {
                GradleApkProvider.getLogger().warn("Android model for tested module is null. Sync might have failed.");
                continue;
            }
            IdeVariant targetVariant = targetAndroidModel.findVariantByName(testedVariant.getTargetVariant());
            if (targetVariant == null) {
                GradleApkProvider.getLogger().warn("Tested variant not found. Sync might have failed.");
                continue;
            }
            File targetApk = this.getApk(targetVariant, deviceAbis, deviceVersion, targetFacet, false);
            String applicationId2 = targetVariant.getMergedFlavor().getApplicationId();
            if (applicationId2 == null) {
                applicationId2 = targetAndroidModel.getApplicationId();
            }
            targetedApks.add(new ApkInfo(targetApk, applicationId2));
        }
        ArrayList<ApkInfo> arrayList = targetedApks;
        if (arrayList == null) {
            GradleApkProvider.$$$reportNull$$$0(47);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<ValidationError> validate() {
        AndroidModuleModel androidModuleModel = AndroidModuleModel.get(this.myFacet);
        if (androidModuleModel == null) {
            Runnable requestProjectSync = () -> ProjectSystemUtil.getSyncManager(this.myFacet.getModule().getProject()).syncProject(ProjectSystemSyncManager.SyncReason.USER_REQUEST);
            ImmutableList immutableList = ImmutableList.of((Object)ValidationError.fatal("The project has not yet been synced with Gradle configuration", requestProjectSync));
            if (immutableList == null) {
                GradleApkProvider.$$$reportNull$$$0(48);
            }
            return immutableList;
        }
        Object targetDevicesMinVersion = null;
        if (androidModuleModel.getAndroidProject().getProjectType() == 4 || this.myOutputKindProvider.apply((AndroidVersion)targetDevicesMinVersion) == OutputKind.AppBundleOutputModel || androidModuleModel.getMainArtifact().isSigned()) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                GradleApkProvider.$$$reportNull$$$0(49);
            }
            return immutableList;
        }
        File outputFile = GradleUtil.getOutputFile(androidModuleModel);
        String outputFileName = outputFile == null ? "Unknown output" : outputFile.getName();
        String message2 = AndroidBundle.message("run.error.apk.not.signed", outputFileName, androidModuleModel.getSelectedVariant().getDisplayName());
        Runnable quickFix = () -> {
            Module module2 = this.myFacet.getModule();
            ProjectSettingsService service = ProjectSettingsService.getInstance((Project)module2.getProject());
            if (service instanceof AndroidProjectSettingsService) {
                ((AndroidProjectSettingsService)service).openSigningConfiguration(module2);
            } else {
                service.openModuleSettings(module2);
            }
        };
        ImmutableList immutableList = ImmutableList.of((Object)ValidationError.fatal(message2, quickFix));
        if (immutableList == null) {
            GradleApkProvider.$$$reportNull$$$0(50);
        }
        return immutableList;
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger2 = Logger.getInstance(GradleApkProvider.class);
        if (logger2 == null) {
            GradleApkProvider.$$$reportNull$$$0(51);
        }
        return logger2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 29: 
            case 30: 
            case 33: 
            case 36: 
            case 41: 
            case 42: 
            case 43: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 29: 
            case 30: 
            case 33: 
            case 36: 
            case 41: 
            case 42: 
            case 43: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationIdProvider";
                break;
            }
            case 2: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputModelProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputKindProvider";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bestOutputFinder";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 29: 
            case 30: 
            case 33: 
            case 36: 
            case 41: 
            case 42: 
            case 43: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/GradleApkProvider";
                break;
            }
            case 18: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
            case 19: 
            case 26: 
            case 32: 
            case 35: 
            case 38: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceAbis";
                break;
            }
            case 20: 
            case 27: 
            case 39: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceVersion";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testArtifactInfo";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileApk";
                break;
            }
            case 25: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedVariant";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/GradleApkProvider";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getApks";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "collectDependentFeaturesApks";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalApks";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getApk";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getApkFromBuildOutputFile";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getApkFromPreBuildSync";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getApkFromPostBuildSync";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetedApks";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "validate";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getApks";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 29: 
            case 30: 
            case 33: 
            case 36: 
            case 41: 
            case 42: 
            case 43: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "collectDependentFeaturesApks";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalApks";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getPackageId";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getApk";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getApkFromBuildOutputFile";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getApkFromPreBuildSync";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getApkFromPostBuildSync";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getTargetedApks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 29: 
            case 30: 
            case 33: 
            case 36: 
            case 41: 
            case 42: 
            case 43: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum OutputKind {
        Default,
        AppBundleOutputModel;

    }
}

