/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.avdmanager.AvdManagerUtils;
import com.android.tools.idea.ddms.DeviceNameProperties;
import com.android.tools.idea.ddms.DeviceNamePropertiesFetcher;
import com.android.tools.idea.ddms.DeviceRenderer;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.run.ConnectedAndroidDevice;
import com.android.tools.idea.run.DeviceChooserListener;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.run.LaunchCompatibilityCheckerImpl;
import com.google.common.base.Predicate;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.table.JBTable;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import gnu.trove.TIntArrayList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceChooser
implements Disposable,
AndroidDebugBridge.IDebugBridgeChangeListener,
AndroidDebugBridge.IDeviceChangeListener {
    private static final int UPDATE_DELAY_MILLIS = 250;
    private static final String[] COLUMN_TITLES = new String[]{"Device", "State", "Compatible", "Serial Number"};
    private static final int DEVICE_NAME_COLUMN_INDEX = 0;
    private static final int DEVICE_STATE_COLUMN_INDEX = 1;
    private static final int COMPATIBILITY_COLUMN_INDEX = 2;
    private static final int SERIAL_COLUMN_INDEX = 3;
    public static final IDevice[] EMPTY_DEVICE_ARRAY = new IDevice[0];
    private final List<DeviceChooserListener> myListeners;
    private final MergingUpdateQueue myUpdateQueue;
    private volatile boolean myProcessSelectionFlag;
    private final JComponent myPanel;
    private final JBTable myDeviceTable;
    private final Predicate<IDevice> myFilter;
    private final ListenableFuture<AndroidVersion> myMinSdkVersion;
    private final AndroidFacet myFacet;
    private final IAndroidTarget myProjectTarget;
    private final Set<String> mySupportedAbis;
    private int[] mySelectedRows;
    private final AtomicBoolean myDevicesDetected;

    public DeviceChooser(boolean multipleSelection, final @NotNull Action okAction, @NotNull AndroidFacet facet2, @NotNull IAndroidTarget projectTarget, @Nullable Predicate<IDevice> filter2) {
        if (okAction == null) {
            DeviceChooser.$$$reportNull$$$0(0);
        }
        if (facet2 == null) {
            DeviceChooser.$$$reportNull$$$0(1);
        }
        if (projectTarget == null) {
            DeviceChooser.$$$reportNull$$$0(2);
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProcessSelectionFlag = true;
        this.myDevicesDetected = new AtomicBoolean();
        this.myFacet = facet2;
        this.myFilter = filter2;
        this.myMinSdkVersion = AndroidModuleInfo.getInstance(facet2).getRuntimeMinSdkVersion();
        this.myProjectTarget = projectTarget;
        AndroidModuleModel androidModuleModel = AndroidModuleModel.get(facet2);
        this.mySupportedAbis = androidModuleModel != null ? androidModuleModel.getSelectedVariant().getMainArtifact().getAbiFilters() : Collections.emptySet();
        this.myDeviceTable = new JBTable();
        this.myPanel = ScrollPaneFactory.createScrollPane((Component)this.myDeviceTable);
        this.myPanel.setPreferredSize((Dimension)JBUI.size((int)550, (int)220));
        MyDeviceTableModel tableModel2 = new MyDeviceTableModel(EMPTY_DEVICE_ARRAY);
        this.myDeviceTable.setModel((TableModel)tableModel2);
        this.myDeviceTable.setSelectionMode(multipleSelection ? 2 : 0);
        this.myDeviceTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (DeviceChooser.this.myProcessSelectionFlag) {
                    DeviceChooser.this.fireSelectedDevicesChanged();
                }
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (DeviceChooser.this.myDeviceTable.isEnabled() && okAction.isEnabled()) {
                    okAction.actionPerformed(null);
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/run/DeviceChooser$2", "onDoubleClick"));
            }
        }.installOn((Component)this.myDeviceTable);
        this.myDeviceTable.setDefaultRenderer(LaunchCompatibility.class, (TableCellRenderer)((Object)new LaunchCompatibilityRenderer()));
        this.myDeviceTable.setDefaultRenderer(IDevice.class, (TableCellRenderer)((Object)new DeviceRenderer.DeviceNameRenderer(AvdManagerUtils.getAvdManagerSilently(facet2), new DeviceNamePropertiesFetcher(this, new FutureCallback<DeviceNameProperties>(){

            public void onSuccess(@Nullable DeviceNameProperties result2) {
                DeviceChooser.this.updateTable();
            }

            public void onFailure(@NotNull Throwable t) {
                if (t == null) {
                    3.$$$reportNull$$$0(0);
                }
                Logger.getInstance(DeviceChooser.class).warn("Error retrieving device name properties", t);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/run/DeviceChooser$3", "onFailure"));
            }
        }))));
        this.myDeviceTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && okAction.isEnabled()) {
                    okAction.actionPerformed(null);
                }
            }
        });
        this.myDeviceTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int i2;
                if (e.getButton() == 3 && (i2 = DeviceChooser.this.myDeviceTable.rowAtPoint(e.getPoint())) >= 0) {
                    Object serial = DeviceChooser.this.myDeviceTable.getValueAt(i2, 3);
                    final String serialString = serial.toString();
                    JBPopupMenu popupMenu2 = new JBPopupMenu();
                    AbstractAction action2 = new AbstractAction("Copy Serial Number"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(serialString));
                        }
                    };
                    popupMenu2.add((Action)action2);
                    popupMenu2.show(e.getComponent(), e.getX(), e.getY());
                }
                super.mouseReleased(e);
            }
        });
        DeviceChooser.setColumnWidth(this.myDeviceTable, 0, "Samsung Galaxy Nexus Android 4.1 (API 17)");
        DeviceChooser.setColumnWidth(this.myDeviceTable, 1, "offline");
        DeviceChooser.setColumnWidth(this.myDeviceTable, 2, "Compatible");
        DeviceChooser.setColumnWidth(this.myDeviceTable, 3, "123456");
        this.myDeviceTable.setAutoCreateColumnsFromModel(false);
        this.myDeviceTable.setAutoCreateRowSorter(true);
        this.myUpdateQueue = new MergingUpdateQueue("android.device.chooser", 250, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        this.myMinSdkVersion.addListener(() -> tableModel2.fireTableDataChanged(), arg_0 -> ((Application)ApplicationManager.getApplication()).invokeLater(arg_0));
    }

    private static void setColumnWidth(JBTable deviceTable, int columnIndex, String sampleText) {
        int width = DeviceChooser.getWidth(deviceTable, sampleText);
        deviceTable.getColumnModel().getColumn(columnIndex).setPreferredWidth(width);
    }

    private static int getWidth(JBTable deviceTable, String sampleText) {
        FontMetrics metrics = deviceTable.getFontMetrics(deviceTable.getFont());
        return metrics.stringWidth(sampleText);
    }

    public void init(@Nullable String[] selectedSerials) {
        this.updateTable();
        if (selectedSerials != null) {
            this.resetSelection(selectedSerials);
        }
    }

    private void resetSelection(@NotNull String[] selectedSerials) {
        if (selectedSerials == null) {
            DeviceChooser.$$$reportNull$$$0(3);
        }
        MyDeviceTableModel model2 = (MyDeviceTableModel)this.myDeviceTable.getModel();
        HashSet selectedSerialsSet = new HashSet();
        Collections.addAll(selectedSerialsSet, selectedSerials);
        IDevice[] myDevices = model2.myDevices;
        ListSelectionModel selectionModel = this.myDeviceTable.getSelectionModel();
        boolean cleared = false;
        int n = myDevices.length;
        for (int i2 = 0; i2 < n; ++i2) {
            String serialNumber = myDevices[i2].getSerialNumber();
            if (!selectedSerialsSet.contains(serialNumber)) continue;
            if (!cleared) {
                selectionModel.clearSelection();
                cleared = true;
            }
            selectionModel.addSelectionInterval(i2, i2);
        }
    }

    private void updateTable() {
        IDevice[] devices2 = this.getFilteredDevices();
        if (devices2.length > 1) {
            Arrays.sort(devices2, new Comparator<IDevice>(){

                @Override
                public int compare(IDevice device1, IDevice device2) {
                    int apiLevel1 = this.safeGetApiLevel(device1);
                    int apiLevel2 = this.safeGetApiLevel(device2);
                    return apiLevel2 - apiLevel1;
                }

                private int safeGetApiLevel(IDevice device) {
                    try {
                        String s = device.getProperty("ro.build.version.sdk");
                        return StringUtil.isNotEmpty((String)s) ? Integer.parseInt(s) : 0;
                    }
                    catch (Exception e) {
                        return 0;
                    }
                }
            });
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            this.myDevicesDetected.set(devices2.length > 0);
            this.refreshTable(devices2);
        });
    }

    private void refreshTable(IDevice[] devices2) {
        Object[] selectedDevices = this.getSelectedDevices(false);
        TIntArrayList selectedRows = new TIntArrayList();
        for (int i2 = 0; i2 < devices2.length; ++i2) {
            if (ArrayUtil.indexOf((Object[])selectedDevices, (Object)devices2[i2]) < 0) continue;
            selectedRows.add(i2);
        }
        this.myProcessSelectionFlag = false;
        this.myDeviceTable.setModel((TableModel)new MyDeviceTableModel(devices2));
        if (selectedRows.isEmpty() && devices2.length > 0) {
            this.myDeviceTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        for (int selectedRow : selectedRows.toNativeArray()) {
            if (selectedRow >= devices2.length) continue;
            this.myDeviceTable.getSelectionModel().addSelectionInterval(selectedRow, selectedRow);
        }
        this.fireSelectedDevicesChanged();
        this.myProcessSelectionFlag = true;
    }

    public boolean hasDevices() {
        return this.myDevicesDetected.get();
    }

    public JComponent getPreferredFocusComponent() {
        return this.myDeviceTable;
    }

    @Nullable
    public JComponent getPanel() {
        return this.myPanel;
    }

    @Nullable
    public ValidationInfo doValidate() {
        Object message2;
        if (!this.myDeviceTable.isEnabled()) {
            return null;
        }
        int[] rows = this.mySelectedRows != null ? this.mySelectedRows : this.myDeviceTable.getSelectedRows();
        boolean hasIncompatible = false;
        boolean hasCompatible = false;
        for (int row : rows) {
            if (!this.isRowCompatible(row)) {
                hasIncompatible = true;
                continue;
            }
            hasCompatible = true;
        }
        if (!hasIncompatible) {
            return null;
        }
        if (hasCompatible) {
            message2 = "At least one of the selected devices is incompatible. Will only install on compatible devices.";
        } else {
            String devicesAre = rows.length > 1 ? "devices are" : "device is";
            message2 = "The selected " + devicesAre + " incompatible.";
        }
        return new ValidationInfo((String)message2);
    }

    @NotNull
    public IDevice[] getSelectedDevices() {
        return this.getSelectedDevices(true);
    }

    @NotNull
    private IDevice[] getSelectedDevices(boolean onlyCompatible) {
        int[] rows = this.mySelectedRows != null ? this.mySelectedRows : this.myDeviceTable.getSelectedRows();
        ArrayList<IDevice> result2 = new ArrayList<IDevice>();
        block0: for (int row : rows) {
            IDevice[] devices2;
            if (row < 0 || onlyCompatible && !this.isRowCompatible(row)) continue;
            Object serial = this.myDeviceTable.getValueAt(row, 3);
            for (IDevice device : devices2 = this.getFilteredDevices()) {
                if (!device.getSerialNumber().equals(serial.toString())) continue;
                result2.add(device);
                continue block0;
            }
        }
        IDevice[] iDeviceArray = result2.toArray(new IDevice[0]);
        if (iDeviceArray == null) {
            DeviceChooser.$$$reportNull$$$0(4);
        }
        return iDeviceArray;
    }

    @NotNull
    private IDevice[] getFilteredDevices() {
        AndroidDebugBridge bridge = AndroidDebugBridge.getBridge();
        if (bridge == null || !bridge.isConnected()) {
            if (EMPTY_DEVICE_ARRAY == null) {
                DeviceChooser.$$$reportNull$$$0(5);
            }
            return EMPTY_DEVICE_ARRAY;
        }
        ArrayList<IDevice> filteredDevices = new ArrayList<IDevice>();
        for (IDevice device : bridge.getDevices()) {
            if (this.myFilter != null && !this.myFilter.apply((Object)device)) continue;
            filteredDevices.add(device);
        }
        IDevice[] iDeviceArray = filteredDevices.toArray(new IDevice[0]);
        if (iDeviceArray == null) {
            DeviceChooser.$$$reportNull$$$0(6);
        }
        return iDeviceArray;
    }

    private boolean isRowCompatible(int row) {
        Object compatibility = this.myDeviceTable.getValueAt(row, 2);
        return compatibility instanceof LaunchCompatibility && ((LaunchCompatibility)compatibility).isCompatible() != ThreeState.NO;
    }

    public void finish() {
        this.mySelectedRows = this.myDeviceTable.getSelectedRows();
    }

    public void dispose() {
        AndroidDebugBridge.removeDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    public void setEnabled(boolean enabled) {
        this.myDeviceTable.setEnabled(enabled);
    }

    @NotNull
    private static String getDeviceState(@NotNull IDevice device) {
        IDevice.DeviceState state;
        if (device == null) {
            DeviceChooser.$$$reportNull$$$0(7);
        }
        return (state = device.getState()) != null ? StringUtil.capitalize((String)StringUtil.toLowerCase((String)state.name())) : "";
    }

    private void fireSelectedDevicesChanged() {
        for (DeviceChooserListener listener2 : this.myListeners) {
            listener2.selectedDevicesChanged();
        }
    }

    public void addListener(@NotNull DeviceChooserListener listener2) {
        if (listener2 == null) {
            DeviceChooser.$$$reportNull$$$0(8);
        }
        this.myListeners.add(listener2);
    }

    public void bridgeChanged(AndroidDebugBridge bridge) {
        this.postUpdate();
    }

    public void deviceConnected(@NotNull IDevice device) {
        if (device == null) {
            DeviceChooser.$$$reportNull$$$0(9);
        }
        this.postUpdate();
    }

    public void deviceDisconnected(@NotNull IDevice device) {
        if (device == null) {
            DeviceChooser.$$$reportNull$$$0(10);
        }
        this.postUpdate();
    }

    public void deviceChanged(@NotNull IDevice device, int changeMask) {
        if (device == null) {
            DeviceChooser.$$$reportNull$$$0(11);
        }
        this.postUpdate();
    }

    private void postUpdate() {
        this.myUpdateQueue.queue(new Update("updateTable"){

            public void run() {
                DeviceChooser.this.updateTable();
            }

            public boolean canEat(Update update2) {
                return true;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "okAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectTarget";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedSerials";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/DeviceChooser";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/DeviceChooser";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDevices";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredDevices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resetSelection";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDeviceState";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "deviceConnected";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deviceDisconnected";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "deviceChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LaunchCompatibilityRenderer
    extends ColoredTableCellRenderer {
        private LaunchCompatibilityRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JTable table2, Object value2, boolean selected, boolean hasFocus, int row, int column) {
            if (table2 == null) {
                LaunchCompatibilityRenderer.$$$reportNull$$$0(0);
            }
            if (!(value2 instanceof LaunchCompatibility)) {
                return;
            }
            LaunchCompatibility compatibility = (LaunchCompatibility)value2;
            ThreeState compatible = compatibility.isCompatible();
            if (compatible == ThreeState.YES) {
                this.append("Yes");
            } else {
                if (compatible == ThreeState.NO) {
                    this.append("No", SimpleTextAttributes.ERROR_ATTRIBUTES);
                } else {
                    this.append("Maybe");
                }
                String reason = compatibility.getReason();
                if (reason != null) {
                    this.append(", ");
                    this.append(reason);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/android/tools/idea/run/DeviceChooser$LaunchCompatibilityRenderer", "customizeCellRenderer"));
        }
    }

    private class MyDeviceTableModel
    extends AbstractTableModel {
        private final IDevice[] myDevices;

        public MyDeviceTableModel(IDevice[] devices2) {
            this.myDevices = devices2;
        }

        @Override
        public String getColumnName(int column) {
            return COLUMN_TITLES[column];
        }

        @Override
        public int getRowCount() {
            return this.myDevices.length;
        }

        @Override
        public int getColumnCount() {
            return COLUMN_TITLES.length;
        }

        @Override
        @Nullable
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex >= this.myDevices.length) {
                return null;
            }
            IDevice device = this.myDevices[rowIndex];
            switch (columnIndex) {
                case 0: {
                    return device;
                }
                case 3: {
                    return device.getSerialNumber();
                }
                case 1: {
                    return DeviceChooser.getDeviceState(device);
                }
                case 2: {
                    ConnectedAndroidDevice connectedDevice = new ConnectedAndroidDevice(device, null);
                    try {
                        return DeviceChooser.this.myMinSdkVersion.isDone() ? connectedDevice.canRun((AndroidVersion)DeviceChooser.this.myMinSdkVersion.get(), DeviceChooser.this.myProjectTarget, DeviceChooser.this.myFacet, (Function<AndroidFacet, EnumSet<IDevice.HardwareFeature>>)((Function)LaunchCompatibilityCheckerImpl::getRequiredHardwareFeatures), DeviceChooser.this.mySupportedAbis) : Boolean.valueOf(false);
                    }
                    catch (InterruptedException | ExecutionException e) {
                        return false;
                    }
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 2) {
                return LaunchCompatibility.class;
            }
            if (columnIndex == 0) {
                return IDevice.class;
            }
            return String.class;
        }
    }
}

