/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.annotations.Trace;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.DeploymentApplicationService;
import com.android.tools.idea.run.util.LaunchStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class ApplicationTerminator
implements AndroidDebugBridge.IDeviceChangeListener {
    @NotNull
    private final IDevice myIDevice;
    @NotNull
    private final String myApplicationId;
    @NotNull
    private final List<Client> myClientsToWaitFor;
    @NotNull
    private final CountDownLatch myProcessKilledLatch;

    public ApplicationTerminator(@NotNull IDevice iDevice, @NotNull String applicationId2) {
        if (iDevice == null) {
            ApplicationTerminator.$$$reportNull$$$0(0);
        }
        if (applicationId2 == null) {
            ApplicationTerminator.$$$reportNull$$$0(1);
        }
        this.myClientsToWaitFor = Collections.synchronizedList(new ArrayList());
        this.myProcessKilledLatch = new CountDownLatch(1);
        this.myIDevice = iDevice;
        this.myApplicationId = applicationId2;
    }

    @Trace
    public boolean killApp(@NotNull LaunchStatus launchStatus) {
        if (launchStatus == null) {
            ApplicationTerminator.$$$reportNull$$$0(2);
        }
        this.myIDevice.forceStop(this.myApplicationId);
        this.myClientsToWaitFor.addAll(DeploymentApplicationService.getInstance().findClient(this.myIDevice, this.myApplicationId));
        if (!this.myIDevice.isOnline() || this.myClientsToWaitFor.isEmpty()) {
            this.myProcessKilledLatch.countDown();
        } else {
            AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
            this.checkDone();
        }
        try {
            if (!this.myProcessKilledLatch.await(10L, TimeUnit.SECONDS)) {
                launchStatus.terminateLaunch(String.format("%s is already running.", this.myApplicationId), true);
                return false;
            }
        }
        catch (InterruptedException ignored) {
            launchStatus.terminateLaunch(String.format("%s is already running.", this.myApplicationId), true);
            return false;
        }
        return true;
    }

    public void deviceConnected(@NotNull IDevice device) {
        if (device == null) {
            ApplicationTerminator.$$$reportNull$$$0(3);
        }
    }

    public void deviceDisconnected(@NotNull IDevice device) {
        if (device == null) {
            ApplicationTerminator.$$$reportNull$$$0(4);
        }
        if (device == this.myIDevice) {
            this.myProcessKilledLatch.countDown();
            AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        }
    }

    public void deviceChanged(@NotNull IDevice changedDevice, int changeMask) {
        if (changedDevice == null) {
            ApplicationTerminator.$$$reportNull$$$0(5);
        }
        if (changedDevice != this.myIDevice || (changeMask & 2) == 0) {
            this.checkDone();
            return;
        }
        this.myClientsToWaitFor.retainAll(Arrays.asList(changedDevice.getClients()));
        this.checkDone();
    }

    private void checkDone() {
        if (this.myClientsToWaitFor.isEmpty()) {
            this.myProcessKilledLatch.countDown();
            AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iDevice";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchStatus";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedDevice";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/run/ApplicationTerminator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "killApp";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "deviceConnected";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "deviceDisconnected";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "deviceChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

