/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.deploy.DeploymentConfiguration;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.util.DynamicAppUtils;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.run.AndroidLaunchTaskContributor;
import com.android.tools.idea.run.AndroidRunConfiguration;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.android.tools.idea.run.editor.AndroidDebuggerContext;
import com.android.tools.idea.run.editor.DeepLinkLaunch;
import com.android.tools.idea.run.tasks.AppLaunchTask;
import com.android.tools.idea.run.tasks.ApplyChangesTask;
import com.android.tools.idea.run.tasks.ApplyCodeChangesTask;
import com.android.tools.idea.run.tasks.ClearLogcatTask;
import com.android.tools.idea.run.tasks.DebugConnectorTask;
import com.android.tools.idea.run.tasks.DeployTask;
import com.android.tools.idea.run.tasks.DismissKeyguardTask;
import com.android.tools.idea.run.tasks.KillAndRestartAppLaunchTask;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.tasks.LaunchTasksProvider;
import com.android.tools.idea.run.tasks.RunInstantAppTask;
import com.android.tools.idea.run.tasks.ShowLogcatTask;
import com.android.tools.idea.run.tasks.UninstallIotLauncherAppsTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.run.util.SwapInfo;
import com.android.tools.idea.stats.RunStats;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLaunchTasksProvider
implements LaunchTasksProvider {
    private final Logger myLogger;
    private final AndroidRunConfigurationBase myRunConfig;
    private final ExecutionEnvironment myEnv;
    private final AndroidFacet myFacet;
    private final ApplicationIdProvider myApplicationIdProvider;
    private final ApkProvider myApkProvider;
    private final LaunchOptions myLaunchOptions;
    private final Project myProject;

    public AndroidLaunchTasksProvider(@NotNull AndroidRunConfigurationBase runConfig, @NotNull ExecutionEnvironment env, @NotNull AndroidFacet facet2, @NotNull ApplicationIdProvider applicationIdProvider, @NotNull ApkProvider apkProvider, @NotNull LaunchOptions launchOptions) {
        if (runConfig == null) {
            AndroidLaunchTasksProvider.$$$reportNull$$$0(0);
        }
        if (env == null) {
            AndroidLaunchTasksProvider.$$$reportNull$$$0(1);
        }
        if (facet2 == null) {
            AndroidLaunchTasksProvider.$$$reportNull$$$0(2);
        }
        if (applicationIdProvider == null) {
            AndroidLaunchTasksProvider.$$$reportNull$$$0(3);
        }
        if (apkProvider == null) {
            AndroidLaunchTasksProvider.$$$reportNull$$$0(4);
        }
        if (launchOptions == null) {
            AndroidLaunchTasksProvider.$$$reportNull$$$0(5);
        }
        this.myLogger = Logger.getInstance(AndroidLaunchTasksProvider.class);
        this.myRunConfig = runConfig;
        this.myEnv = env;
        this.myProject = facet2.getModule().getProject();
        this.myFacet = facet2;
        this.myApplicationIdProvider = applicationIdProvider;
        this.myApkProvider = apkProvider;
        this.myLaunchOptions = launchOptions;
    }

    @Override
    @NotNull
    public List<LaunchTask> getTasks(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter consolePrinter) {
        String packageName;
        if (device == null) {
            AndroidLaunchTasksProvider.$$$reportNull$$$0(6);
        }
        if (launchStatus == null) {
            AndroidLaunchTasksProvider.$$$reportNull$$$0(7);
        }
        if (consolePrinter == null) {
            AndroidLaunchTasksProvider.$$$reportNull$$$0(8);
        }
        ArrayList<LaunchTask> launchTasks = new ArrayList<LaunchTask>();
        if (this.myLaunchOptions.isClearLogcatBeforeStart()) {
            launchTasks.add(new ClearLogcatTask(this.myProject));
        }
        launchTasks.add(new DismissKeyguardTask());
        boolean useApplyChanges = this.shouldApplyChanges() || this.shouldApplyCodeChanges();
        boolean terminateLaunchOnError = !useApplyChanges && !this.shouldDeployAsInstant();
        try {
            AppLaunchTask appLaunchTask;
            packageName = this.myApplicationIdProvider.getPackageName();
            launchTasks.addAll(this.getDeployTasks(device, packageName));
            StringBuilder amStartOptions = new StringBuilder();
            for (AndroidLaunchTaskContributor taskContributor : (AndroidLaunchTaskContributor[])AndroidLaunchTaskContributor.EP_NAME.getExtensions()) {
                String amOptions = taskContributor.getAmStartOptions(this.myFacet.getModule(), packageName, this.myLaunchOptions, device);
                amStartOptions.append(amStartOptions.length() == 0 ? "" : " ").append(amOptions);
                LaunchTask task2 = taskContributor.getTask(this.myFacet.getModule(), packageName, this.myLaunchOptions);
                if (task2 == null) continue;
                launchTasks.add(task2);
            }
            if (!this.shouldDeployAsInstant() && (appLaunchTask = this.myRunConfig.getApplicationLaunchTask(this.myApplicationIdProvider, this.myFacet, amStartOptions.toString(), this.myLaunchOptions.isDebug(), launchStatus, this.myApkProvider, consolePrinter, device)) != null) {
                launchTasks.add(new KillAndRestartAppLaunchTask(packageName));
                launchTasks.add(appLaunchTask);
            }
        }
        catch (ApkProvisionException e) {
            if (useApplyChanges) {
                this.myLogger.error((Throwable)e);
            } else {
                this.myLogger.warn((Throwable)e);
            }
            launchStatus.terminateLaunch("Unable to determine application id: " + e, terminateLaunchOnError);
            List<LaunchTask> list = Collections.emptyList();
            if (list == null) {
                AndroidLaunchTasksProvider.$$$reportNull$$$0(9);
            }
            return list;
        }
        catch (IllegalStateException e) {
            this.myLogger.error((Throwable)e);
            launchStatus.terminateLaunch(e.getMessage(), terminateLaunchOnError);
            List<LaunchTask> list = Collections.emptyList();
            if (list == null) {
                AndroidLaunchTasksProvider.$$$reportNull$$$0(10);
            }
            return list;
        }
        if (!this.myLaunchOptions.isDebug() && this.myLaunchOptions.isOpenLogcatAutomatically()) {
            launchTasks.add(new ShowLogcatTask(this.myProject, packageName));
        }
        ArrayList<LaunchTask> arrayList = launchTasks;
        if (arrayList == null) {
            AndroidLaunchTasksProvider.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    @VisibleForTesting
    List<LaunchTask> getDeployTasks(@NotNull IDevice device, @NotNull String packageName) throws ApkProvisionException {
        if (device == null) {
            AndroidLaunchTasksProvider.$$$reportNull$$$0(12);
        }
        if (packageName == null) {
            AndroidLaunchTasksProvider.$$$reportNull$$$0(13);
        }
        if (!this.myLaunchOptions.isDeploy()) {
            List<LaunchTask> list = Collections.emptyList();
            if (list == null) {
                AndroidLaunchTasksProvider.$$$reportNull$$$0(14);
            }
            return list;
        }
        ArrayList<LaunchTask> tasks = new ArrayList<LaunchTask>();
        if (((Boolean)StudioFlags.UNINSTALL_LAUNCHER_APPS_ENABLED.get()).booleanValue() && device.supportsFeature(IDevice.HardwareFeature.EMBEDDED)) {
            tasks.add(new UninstallIotLauncherAppsTask(this.myProject, packageName));
        }
        List<String> disabledFeatures = this.myLaunchOptions.getDisabledDynamicFeatures();
        ImmutableMap.Builder packages = ImmutableMap.builder();
        for (ApkInfo apkInfo : this.myApkProvider.getApks(device)) {
            packages.put((Object)apkInfo.getApplicationId(), AndroidLaunchTasksProvider.getFilteredFeatures(apkInfo, disabledFeatures));
        }
        Computable installPathProvider = () -> EmbeddedDistributionPaths.getInstance().findEmbeddedInstaller();
        switch (this.getDeployType()) {
            case RUN_INSTANT_APP: {
                AndroidRunConfiguration runConfig = (AndroidRunConfiguration)this.myRunConfig;
                DeepLinkLaunch.State state = (DeepLinkLaunch.State)runConfig.getLaunchOptionState("launch_deep_link");
                assert (state != null);
                tasks.add(new RunInstantAppTask(this.myApkProvider.getApks(device), state.DEEP_LINK, disabledFeatures));
                break;
            }
            case APPLY_CHANGES: {
                tasks.add(new ApplyChangesTask(this.myProject, (Map<String, List<File>>)packages.build(), this.isApplyChangesFallbackToRun(), this.myLaunchOptions.getAlwaysInstallWithPm(), (Computable<String>)installPathProvider));
                break;
            }
            case APPLY_CODE_CHANGES: {
                tasks.add(new ApplyCodeChangesTask(this.myProject, (Map<String, List<File>>)packages.build(), this.isApplyCodeChangesFallbackToRun(), this.myLaunchOptions.getAlwaysInstallWithPm(), (Computable<String>)installPathProvider));
                break;
            }
            case DEPLOY: {
                tasks.add(new DeployTask(this.myProject, (Map<String, List<File>>)packages.build(), this.myLaunchOptions.getPmInstallOptions(device), this.myLaunchOptions.getInstallOnAllUsers(), this.myLaunchOptions.getAlwaysInstallWithPm(), (Computable<String>)installPathProvider));
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled Deploy Type");
            }
        }
        ImmutableList immutableList = ImmutableList.copyOf(tasks);
        if (immutableList == null) {
            AndroidLaunchTasksProvider.$$$reportNull$$$0(15);
        }
        return immutableList;
    }

    @Override
    public String getLaunchTypeDisplayName() {
        return this.getDeployType().asDisplayName();
    }

    private boolean isApplyCodeChangesFallbackToRun() {
        return DeploymentConfiguration.getInstance().APPLY_CODE_CHANGES_FALLBACK_TO_RUN;
    }

    private boolean isApplyChangesFallbackToRun() {
        return DeploymentConfiguration.getInstance().APPLY_CHANGES_FALLBACK_TO_RUN;
    }

    @Override
    public void fillStats(RunStats stats) {
        stats.setApplyChangesFallbackToRun(this.isApplyChangesFallbackToRun());
        stats.setApplyCodeChangesFallbackToRun(this.isApplyCodeChangesFallbackToRun());
    }

    @NotNull
    private static List<File> getFilteredFeatures(ApkInfo apkInfo, List<String> disabledFeatures) {
        if (apkInfo.getFiles().size() > 1) {
            List<File> list = apkInfo.getFiles().stream().filter(feature -> DynamicAppUtils.isFeatureEnabled(disabledFeatures, feature)).map(file2 -> file2.getApkFile()).collect(Collectors.toList());
            if (list == null) {
                AndroidLaunchTasksProvider.$$$reportNull$$$0(16);
            }
            return list;
        }
        ImmutableList immutableList = ImmutableList.of((Object)apkInfo.getFile());
        if (immutableList == null) {
            AndroidLaunchTasksProvider.$$$reportNull$$$0(17);
        }
        return immutableList;
    }

    @Override
    @Nullable
    public DebugConnectorTask getConnectDebuggerTask(@NotNull LaunchStatus launchStatus, @Nullable AndroidVersion version2) {
        if (launchStatus == null) {
            AndroidLaunchTasksProvider.$$$reportNull$$$0(18);
        }
        if (!this.myLaunchOptions.isDebug()) {
            return null;
        }
        Logger logger2 = Logger.getInstance(AndroidLaunchTasksProvider.class);
        HashSet<String> packageIds = new HashSet<String>();
        String packageName = null;
        try {
            packageName = this.myApplicationIdProvider.getPackageName();
            packageIds.add(packageName);
        }
        catch (ApkProvisionException e) {
            logger2.error((Throwable)e);
        }
        try {
            String testPackageName = this.myApplicationIdProvider.getTestPackageName();
            if (testPackageName != null) {
                packageIds.add(testPackageName);
            }
        }
        catch (ApkProvisionException e) {
            logger2.warn("Unable to obtain test package name, will not connect debugger if tests don't instantiate main application");
        }
        AndroidDebuggerContext androidDebuggerContext = this.myRunConfig.getAndroidDebuggerContext();
        AndroidDebugger debugger = androidDebuggerContext.getAndroidDebugger();
        if (debugger == null) {
            logger2.warn("Unable to determine debugger to use for this launch");
            return null;
        }
        logger2.info("Using debugger: " + debugger.getId());
        Object androidDebuggerState = androidDebuggerContext.getAndroidDebuggerState();
        if (androidDebuggerState != null) {
            return debugger.getConnectDebuggerTask(this.myEnv, version2, packageIds, this.myFacet, androidDebuggerState, this.myRunConfig.getType().getId(), packageName);
        }
        return null;
    }

    private boolean shouldDeployAsInstant() {
        return ((AndroidFacetConfiguration)this.myFacet.getConfiguration()).getProjectType() == 4 || this.myLaunchOptions.isDeployAsInstant();
    }

    private boolean shouldApplyChanges() {
        SwapInfo swapInfo = (SwapInfo)this.myEnv.getUserData(SwapInfo.SWAP_INFO_KEY);
        return swapInfo != null && swapInfo.getType() == SwapInfo.SwapType.APPLY_CHANGES;
    }

    private boolean shouldApplyCodeChanges() {
        SwapInfo swapInfo = (SwapInfo)this.myEnv.getUserData(SwapInfo.SWAP_INFO_KEY);
        return swapInfo != null && swapInfo.getType() == SwapInfo.SwapType.APPLY_CODE_CHANGES;
    }

    private DeployType getDeployType() {
        if (this.shouldDeployAsInstant()) {
            return DeployType.RUN_INSTANT_APP;
        }
        if (this.shouldApplyChanges()) {
            return DeployType.APPLY_CHANGES;
        }
        if (this.shouldApplyCodeChanges()) {
            return DeployType.APPLY_CODE_CHANGES;
        }
        return DeployType.DEPLOY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfig";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationIdProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apkProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchOptions";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchStatus";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consolePrinter";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/AndroidLaunchTasksProvider";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/AndroidLaunchTasksProvider";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTasks";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeployTasks";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredFeatures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTasks";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDeployTasks";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getConnectDebuggerTask";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum DeployType {
        RUN_INSTANT_APP{

            @Override
            public String asDisplayName() {
                return "Instant App Launch";
            }
        }
        ,
        APPLY_CHANGES{

            @Override
            public String asDisplayName() {
                return "Apply Changes";
            }
        }
        ,
        APPLY_CODE_CHANGES{

            @Override
            public String asDisplayName() {
                return "Apply Code Changes";
            }
        }
        ,
        DEPLOY{

            @Override
            public String asDisplayName() {
                return "Launch";
            }
        };


        public abstract String asDisplayName();
    }
}

