/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.room.migrations.update;

import com.android.tools.idea.room.migrations.json.DatabaseBundle;
import com.android.tools.idea.room.migrations.json.DatabaseViewBundle;
import com.android.tools.idea.room.migrations.json.EntityBundle;
import com.android.tools.idea.room.migrations.json.ForeignKeyBundle;
import com.android.tools.idea.room.migrations.json.FtsEntityBundle;
import com.android.tools.idea.room.migrations.update.EntityUpdate;
import com.android.tools.idea.room.migrations.update.SchemaDiffUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class DatabaseUpdate {
    private Map<String, EntityBundle> newEntities;
    private Map<String, EntityBundle> deletedEntities;
    private Map<String, EntityUpdate> modifiedEntities;
    private Set<String> tablesToForeignKeyCheck;
    private Map<String, String> renamedEntities;
    private List<DatabaseViewBundle> deletedViews;
    private List<DatabaseViewBundle> newOrModifiedViews;
    private int currentVersion;
    private int previousVersion;

    public DatabaseUpdate(@NotNull DatabaseBundle oldDatabase, @NotNull DatabaseBundle newDatabase) {
        if (oldDatabase == null) {
            DatabaseUpdate.$$$reportNull$$$0(0);
        }
        if (newDatabase == null) {
            DatabaseUpdate.$$$reportNull$$$0(1);
        }
        DatabaseUpdate.checkDatabase(oldDatabase);
        DatabaseUpdate.checkDatabase(newDatabase);
        this.previousVersion = oldDatabase.getVersion();
        this.currentVersion = newDatabase.getVersion();
        this.deletedEntities = new HashMap<String, EntityBundle>(oldDatabase.getEntitiesByTableName());
        this.newEntities = new HashMap<String, EntityBundle>();
        this.modifiedEntities = new HashMap<String, EntityUpdate>();
        this.renamedEntities = new HashMap<String, String>();
        this.tablesToForeignKeyCheck = new HashSet<String>();
        HashMultimap tableToReferencedTableMapping = HashMultimap.create();
        for (EntityBundle newEntity : newDatabase.getEntities()) {
            EntityBundle oldEntity = this.deletedEntities.remove(newEntity.getTableName());
            if (oldEntity != null) {
                if (!SchemaDiffUtil.isTableTypeTheSame(oldEntity, newEntity)) {
                    this.deletedEntities.put(oldEntity.getTableName(), oldEntity);
                    this.newEntities.put(newEntity.getTableName(), newEntity);
                } else if (!oldEntity.isSchemaEqual(newEntity)) {
                    EntityUpdate entityUpdate = new EntityUpdate(oldEntity, newEntity);
                    this.modifiedEntities.put(entityUpdate.getNewTableName(), entityUpdate);
                    if (entityUpdate.foreignKeysWereUpdated()) {
                        this.tablesToForeignKeyCheck.add(entityUpdate.getNewTableName());
                    }
                }
            } else {
                this.newEntities.put(newEntity.getTableName(), newEntity);
            }
            for (ForeignKeyBundle foreignKey : newEntity.getForeignKeys()) {
                tableToReferencedTableMapping.put((Object)newEntity.getTableName(), (Object)foreignKey.getTable());
            }
        }
        for (Map.Entry tableToReferencedTableEntry : tableToReferencedTableMapping.entries()) {
            String referencedTable = (String)tableToReferencedTableEntry.getValue();
            if (!this.modifiedEntities.containsKey(referencedTable) && !this.newEntities.containsKey(referencedTable)) continue;
            this.tablesToForeignKeyCheck.add((String)tableToReferencedTableEntry.getKey());
        }
        this.deletedViews = new ArrayList<DatabaseViewBundle>();
        this.newOrModifiedViews = new ArrayList<DatabaseViewBundle>();
        if (oldDatabase.getViews().isEmpty()) {
            if (!newDatabase.getViews().isEmpty()) {
                this.newOrModifiedViews.addAll(newDatabase.getViews());
            }
        } else if (newDatabase.getViews().isEmpty()) {
            this.deletedViews.addAll(oldDatabase.getViews());
        } else {
            Map<String, DatabaseViewBundle> oldViews = oldDatabase.getViews().stream().collect(Collectors.toMap(DatabaseViewBundle::getViewName, view -> view));
            for (DatabaseViewBundle newView : newDatabase.getViews()) {
                DatabaseViewBundle oldView = oldViews.get(newView.getViewName());
                if (oldView != null) {
                    if (!oldView.isSchemaEqual(newView)) {
                        this.newOrModifiedViews.add(newView);
                        continue;
                    }
                    oldViews.remove(newView.getViewName());
                    continue;
                }
                this.newOrModifiedViews.add(newView);
            }
            this.deletedViews.addAll(oldViews.values());
        }
    }

    @NotNull
    public Map<String, EntityUpdate> getModifiedEntities() {
        Map<String, EntityUpdate> map2 = this.modifiedEntities;
        if (map2 == null) {
            DatabaseUpdate.$$$reportNull$$$0(2);
        }
        return map2;
    }

    @NotNull
    public Map<String, EntityBundle> getNewEntities() {
        Map<String, EntityBundle> map2 = this.newEntities;
        if (map2 == null) {
            DatabaseUpdate.$$$reportNull$$$0(3);
        }
        return map2;
    }

    @NotNull
    public Map<String, EntityBundle> getDeletedEntities() {
        Map<String, EntityBundle> map2 = this.deletedEntities;
        if (map2 == null) {
            DatabaseUpdate.$$$reportNull$$$0(4);
        }
        return map2;
    }

    @NotNull
    public Map<String, String> getRenamedEntities() {
        Map<String, String> map2 = this.renamedEntities;
        if (map2 == null) {
            DatabaseUpdate.$$$reportNull$$$0(5);
        }
        return map2;
    }

    public Set<String> getTablesToForeignKeyCheck() {
        return this.tablesToForeignKeyCheck;
    }

    @NotNull
    public List<DatabaseViewBundle> getNewOrModifiedViews() {
        List<DatabaseViewBundle> list = this.newOrModifiedViews;
        if (list == null) {
            DatabaseUpdate.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public List<DatabaseViewBundle> getDeletedViews() {
        List<DatabaseViewBundle> list = this.deletedViews;
        if (list == null) {
            DatabaseUpdate.$$$reportNull$$$0(7);
        }
        return list;
    }

    public int getCurrentVersion() {
        return this.currentVersion;
    }

    public int getPreviousVersion() {
        return this.previousVersion;
    }

    public void applyRenameMapping(@NotNull Map<String, String> oldToNewNameMapping) {
        if (oldToNewNameMapping == null) {
            DatabaseUpdate.$$$reportNull$$$0(8);
        }
        for (Map.Entry<String, String> tableNames : oldToNewNameMapping.entrySet()) {
            EntityBundle oldEntity = this.deletedEntities.remove(tableNames.getKey());
            EntityBundle newEntity = this.newEntities.remove(tableNames.getValue());
            if (oldEntity == null || newEntity == null) {
                throw new IllegalArgumentException("Invalid old table name to new table name mapping");
            }
            if (!(!SchemaDiffUtil.isTableStructureTheSame(oldEntity, newEntity) || newEntity instanceof FtsEntityBundle && SchemaDiffUtil.ftsTableNeedsExternalContentSource((FtsEntityBundle)newEntity))) {
                this.renamedEntities.put(tableNames.getKey(), tableNames.getValue());
                continue;
            }
            this.modifiedEntities.put(newEntity.getTableName(), new EntityUpdate(oldEntity, newEntity));
        }
    }

    private static void checkDatabase(@NotNull DatabaseBundle databaseBundle) {
        if (databaseBundle == null) {
            DatabaseUpdate.$$$reportNull$$$0(9);
        }
        Preconditions.checkArgument((databaseBundle.getEntities() != null ? 1 : 0) != 0, (Object)"Invalid DatabaseBundle object: the list of entities is null.");
        Preconditions.checkArgument((databaseBundle.getViews() != null ? 1 : 0) != 0, (Object)"Invalid DatabaseBundle object: the list of views is null.");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldDatabase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDatabase";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/room/migrations/update/DatabaseUpdate";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldToNewNameMapping";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseBundle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/room/migrations/update/DatabaseUpdate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiedEntities";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewEntities";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeletedEntities";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenamedEntities";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewOrModifiedViews";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeletedViews";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applyRenameMapping";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkDatabase";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

