/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.room.migrations.ui;

import com.android.tools.idea.room.migrations.json.EntityBundle;
import com.android.tools.idea.room.migrations.ui.GenerateMigrationWizard;
import com.android.tools.idea.room.migrations.ui.GenerateMigrationWizardData;
import com.android.tools.idea.room.migrations.ui.GenerateMigrationWizardStep;
import com.android.tools.idea.room.migrations.update.EntityUpdate;
import com.android.tools.idea.room.migrations.update.SchemaDiffUtil;
import com.intellij.ide.wizard.CommitStepException;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class GenerateMigrationWizardRenameTablesStep
implements GenerateMigrationWizardStep {
    private static final String RENAME_TABLES_STEP_LABEL = "Specify which of the following tables has been renamed and what is the new name for each of them";
    private boolean shouldBeSkipped;
    private GenerateMigrationWizardData wizardData;
    private GenerateMigrationWizard.RenamePanel renameTablesStepPanel;

    public GenerateMigrationWizardRenameTablesStep(@NotNull GenerateMigrationWizardData wizardData) {
        if (wizardData == null) {
            GenerateMigrationWizardRenameTablesStep.$$$reportNull$$$0(0);
        }
        this.wizardData = wizardData;
        ArrayList<String> oldTableNames = new ArrayList<String>(wizardData.getDatabaseUpdate().getDeletedEntities().keySet());
        ArrayList<String> newTableNames = new ArrayList<String>(wizardData.getDatabaseUpdate().getNewEntities().keySet());
        this.renameTablesStepPanel = new GenerateMigrationWizard.RenamePanel(RENAME_TABLES_STEP_LABEL, oldTableNames, newTableNames);
        this.shouldBeSkipped = oldTableNames.isEmpty();
    }

    public void _init() {
    }

    public void _commit(boolean finishChosen) throws CommitStepException {
        Map<String, String> oldToNewTableNames = this.renameTablesStepPanel.getOldToNewNamesMapping();
        this.wizardData.updateRenamedTables(oldToNewTableNames);
        if (!oldToNewTableNames.isEmpty()) {
            this.updateUserIdentifiedEntityUpdates();
        }
    }

    public Icon getIcon() {
        return null;
    }

    public JComponent getComponent() {
        return this.renameTablesStepPanel.getRenameStepPanel();
    }

    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    private void updateUserIdentifiedEntityUpdates() {
        ArrayList<EntityUpdate> userIdentifiedEntityUpdates = new ArrayList<EntityUpdate>();
        for (Map.Entry<String, String> tableNames : this.renameTablesStepPanel.getOldToNewNamesMapping().entrySet()) {
            EntityUpdate entityUpdate;
            EntityBundle oldEntity = this.wizardData.getDatabaseUpdate().getDeletedEntities().get(tableNames.getKey());
            EntityBundle newEntity = this.wizardData.getDatabaseUpdate().getNewEntities().get(tableNames.getValue());
            assert (oldEntity != null && newEntity != null);
            if (SchemaDiffUtil.isTableStructureTheSame(oldEntity, newEntity) || (entityUpdate = new EntityUpdate(oldEntity, newEntity)).getDeletedFields().isEmpty()) continue;
            userIdentifiedEntityUpdates.add(entityUpdate);
        }
        this.wizardData.updateUserIdentifiedEntityUpdates(userIdentifiedEntityUpdates);
    }

    @Override
    public boolean shouldBeSkipped() {
        return this.shouldBeSkipped;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizardData", "com/android/tools/idea/room/migrations/ui/GenerateMigrationWizardRenameTablesStep", "<init>"));
    }
}

