/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.room.migrations.ui;

import com.android.tools.idea.room.migrations.ui.GenerateMigrationWizard;
import com.android.tools.idea.room.migrations.ui.GenerateMigrationWizardData;
import com.android.tools.idea.room.migrations.ui.GenerateMigrationWizardStep;
import com.android.tools.idea.room.migrations.update.EntityUpdate;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.ui.components.JBPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class GenerateMigrationWizardRenameColumnsStep
implements GenerateMigrationWizardStep {
    private static final String RENAME_COLUMNS_STEP_LABEL_TEMPLATE = "Specify which of the following columns from table %s has been renamed and what is the new name for each of them";
    private boolean shouldBeSkipped;
    private GenerateMigrationWizardData wizardData;
    private Map<String, GenerateMigrationWizard.RenamePanel> tableToRenameColumnsPanelMapping;
    private Map<String, GenerateMigrationWizard.RenamePanel> renamedTableToRenameColumnsPanelMapping;
    private JBPanel rootPanel;
    private JBPanel dynamicPanel;

    public GenerateMigrationWizardRenameColumnsStep(@NotNull GenerateMigrationWizardData wizardData) {
        if (wizardData == null) {
            GenerateMigrationWizardRenameColumnsStep.$$$reportNull$$$0(0);
        }
        this.wizardData = wizardData;
        this.tableToRenameColumnsPanelMapping = new HashMap<String, GenerateMigrationWizard.RenamePanel>();
        this.rootPanel = new JBPanel();
        this.rootPanel.setLayout((LayoutManager)new BoxLayout((Container)this.rootPanel, 1));
        for (EntityUpdate entityUpdate : wizardData.getDatabaseUpdate().getModifiedEntities().values()) {
            if (entityUpdate.getDeletedFields().isEmpty()) continue;
            String tableName = entityUpdate.getNewTableName();
            ArrayList<String> oldColumnNames = new ArrayList<String>(entityUpdate.getDeletedFields().keySet());
            ArrayList<String> newColumnNames = new ArrayList<String>(entityUpdate.getNewFields().keySet());
            GenerateMigrationWizard.RenamePanel renameColumnsPanel = new GenerateMigrationWizard.RenamePanel(String.format(RENAME_COLUMNS_STEP_LABEL_TEMPLATE, tableName), oldColumnNames, newColumnNames);
            this.tableToRenameColumnsPanelMapping.put(tableName, renameColumnsPanel);
            this.rootPanel.add((Component)renameColumnsPanel.getRenameStepPanel());
        }
        this.shouldBeSkipped = this.tableToRenameColumnsPanelMapping.isEmpty();
        this.dynamicPanel = new JBPanel();
        this.dynamicPanel.setLayout((LayoutManager)new BoxLayout((Container)this.dynamicPanel, 1));
        this.rootPanel.add((Component)this.dynamicPanel);
    }

    public void _init() {
        this.dynamicPanel.removeAll();
        this.renamedTableToRenameColumnsPanelMapping = new HashMap<String, GenerateMigrationWizard.RenamePanel>();
        for (EntityUpdate entityUpdate : this.wizardData.getUserIdentifiedEntityUpdates()) {
            String tableName = entityUpdate.getNewTableName();
            ArrayList<String> oldColumnNames = new ArrayList<String>(entityUpdate.getDeletedFields().keySet());
            ArrayList<String> newColumnNames = new ArrayList<String>(entityUpdate.getNewFields().keySet());
            GenerateMigrationWizard.RenamePanel renameColumnsPanel = new GenerateMigrationWizard.RenamePanel(String.format(RENAME_COLUMNS_STEP_LABEL_TEMPLATE, tableName), oldColumnNames, newColumnNames);
            this.renamedTableToRenameColumnsPanelMapping.put(tableName, renameColumnsPanel);
            this.dynamicPanel.add((Component)renameColumnsPanel.getRenameStepPanel());
        }
        this.shouldBeSkipped |= this.renamedTableToRenameColumnsPanelMapping.isEmpty();
    }

    public void _commit(boolean finishChosen) throws CommitStepException {
        HashMap<String, Map<String, String>> tableToRenamedColumnsMapping = new HashMap<String, Map<String, String>>();
        this.tableToRenameColumnsPanelMapping.forEach((tableName, renameColumnsPanel) -> tableToRenamedColumnsMapping.put((String)tableName, renameColumnsPanel.getOldToNewNamesMapping()));
        this.renamedTableToRenameColumnsPanelMapping.forEach((tableName, renameColumnsPanel) -> tableToRenamedColumnsMapping.put((String)tableName, renameColumnsPanel.getOldToNewNamesMapping()));
        this.wizardData.updateTableToRenamedColumnsMapping(tableToRenamedColumnsMapping);
    }

    public Icon getIcon() {
        return null;
    }

    public JComponent getComponent() {
        return this.rootPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @Override
    public boolean shouldBeSkipped() {
        return this.shouldBeSkipped;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizardData", "com/android/tools/idea/room/migrations/ui/GenerateMigrationWizardRenameColumnsStep", "<init>"));
    }
}

