/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.room.migrations.ui;

import com.android.tools.idea.room.migrations.ui.GenerateMigrationWizardData;
import com.android.tools.idea.room.migrations.ui.GenerateMigrationWizardRenameColumnsStep;
import com.android.tools.idea.room.migrations.ui.GenerateMigrationWizardRenameTablesStep;
import com.android.tools.idea.room.migrations.ui.GenerateMigrationWizardSelectDestinationStep;
import com.android.tools.idea.room.migrations.ui.GenerateMigrationWizardStep;
import com.android.tools.idea.room.migrations.update.DatabaseUpdate;
import com.intellij.ide.wizard.AbstractWizard;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateMigrationWizard
extends AbstractWizard<GenerateMigrationWizardStep> {
    private static final String WIZARD_TITLE = "Generate a Room Migration";
    private GenerateMigrationWizardData myWizardData;
    private GenerateMigrationWizardStep selectDestinationStep;
    private GenerateMigrationWizardStep renameTablesStep;
    private GenerateMigrationWizardStep renameColumnsStep;

    public GenerateMigrationWizard(@NotNull Project project, @NotNull PsiPackage targetPackage, @NotNull PsiDirectory migrationClassDirectory, @NotNull PsiDirectory migrationTestDirectory, @NotNull DatabaseUpdate databaseUpdate) {
        if (project == null) {
            GenerateMigrationWizard.$$$reportNull$$$0(0);
        }
        if (targetPackage == null) {
            GenerateMigrationWizard.$$$reportNull$$$0(1);
        }
        if (migrationClassDirectory == null) {
            GenerateMigrationWizard.$$$reportNull$$$0(2);
        }
        if (migrationTestDirectory == null) {
            GenerateMigrationWizard.$$$reportNull$$$0(3);
        }
        if (databaseUpdate == null) {
            GenerateMigrationWizard.$$$reportNull$$$0(4);
        }
        super(WIZARD_TITLE, project);
        this.myWizardData = new GenerateMigrationWizardData(project, targetPackage, migrationClassDirectory, migrationTestDirectory, databaseUpdate);
        this.selectDestinationStep = new GenerateMigrationWizardSelectDestinationStep(this.myWizardData);
        this.renameTablesStep = new GenerateMigrationWizardRenameTablesStep(this.myWizardData);
        this.renameColumnsStep = new GenerateMigrationWizardRenameColumnsStep(this.myWizardData);
        this.addStep(this.selectDestinationStep);
        if (!this.renameTablesStep.shouldBeSkipped()) {
            this.addStep(this.renameTablesStep);
        }
        if (!this.renameColumnsStep.shouldBeSkipped()) {
            this.addStep(this.renameColumnsStep);
        }
        this.init();
    }

    protected boolean isLastStep() {
        return super.isLastStep() || this.allNextStepsCanBeSkipped(this.getCurrentStep());
    }

    protected int getNextStep(int step2) {
        int nextStep;
        if (step2 == this.getStepCount() - 1 || this.allNextStepsCanBeSkipped(step2)) {
            return step2;
        }
        for (nextStep = step2 + 1; nextStep < this.getStepCount() - 1 && ((GenerateMigrationWizardStep)this.mySteps.get(nextStep)).shouldBeSkipped(); ++nextStep) {
        }
        return nextStep;
    }

    protected int getPreviousStep(int step2) {
        int previousStep;
        if (step2 == 0) {
            return step2;
        }
        for (previousStep = step2 - 1; previousStep > 0 && ((GenerateMigrationWizardStep)this.mySteps.get(previousStep)).shouldBeSkipped(); --previousStep) {
        }
        return previousStep;
    }

    @Nullable
    protected String getHelpID() {
        return null;
    }

    @NotNull
    public PsiPackage getTargetPackage() {
        PsiPackage psiPackage = this.myWizardData.getTargetPackage();
        if (psiPackage == null) {
            GenerateMigrationWizard.$$$reportNull$$$0(5);
        }
        return psiPackage;
    }

    @NotNull
    public PsiDirectory getMigrationClassDirectory() {
        PsiDirectory psiDirectory = this.myWizardData.getMigrationClassDirectory();
        if (psiDirectory == null) {
            GenerateMigrationWizard.$$$reportNull$$$0(6);
        }
        return psiDirectory;
    }

    @NotNull
    public PsiDirectory getMigrationTestDirectory() {
        PsiDirectory psiDirectory = this.myWizardData.getMigrationTestDirectory();
        if (psiDirectory == null) {
            GenerateMigrationWizard.$$$reportNull$$$0(7);
        }
        return psiDirectory;
    }

    @NotNull
    public DatabaseUpdate getUserReviewedDatabaseUpdate() {
        DatabaseUpdate databaseUpdate = this.myWizardData.getUserReviewedDatabaseUpdate();
        if (databaseUpdate == null) {
            GenerateMigrationWizard.$$$reportNull$$$0(8);
        }
        return databaseUpdate;
    }

    private boolean allNextStepsCanBeSkipped(int step2) {
        for (int futureStep = step2 + 1; futureStep < this.getStepCount(); ++futureStep) {
            if (((GenerateMigrationWizardStep)this.mySteps.get(futureStep)).shouldBeSkipped()) continue;
            return false;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPackage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "migrationClassDirectory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "migrationTestDirectory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseUpdate";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/room/migrations/ui/GenerateMigrationWizard";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/room/migrations/ui/GenerateMigrationWizard";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetPackage";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMigrationClassDirectory";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMigrationTestDirectory";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserReviewedDatabaseUpdate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RenamePanel {
        private static final String HEADER_NAME_LABEL = "Old Name";
        private static final String HEADER_OPERATION_LABEL = "Operation";
        private static final String HEADER_NEW_NAME_LABEL = "New Name";
        private List<RenamePanelElement> renameStepElements;
        private JBPanel renameStepPanel;

        public RenamePanel(@NotNull String label, @NotNull List<String> oldNames, @NotNull List<String> newNames) {
            if (label == null) {
                RenamePanel.$$$reportNull$$$0(0);
            }
            if (oldNames == null) {
                RenamePanel.$$$reportNull$$$0(1);
            }
            if (newNames == null) {
                RenamePanel.$$$reportNull$$$0(2);
            }
            this.renameStepElements = new ArrayList<RenamePanelElement>();
            this.renameStepPanel = new JBPanel((LayoutManager)new BorderLayout());
            JBLabel renameStepPanelLabel = new JBLabel(label);
            this.renameStepPanel.add((Component)renameStepPanelLabel, (Object)"North");
            renameStepPanelLabel.setLabelFor((Component)this.renameStepPanel);
            JBPanel listPanel = new JBPanel();
            listPanel.setLayout((LayoutManager)new BoxLayout((Container)listPanel, 1));
            JBPanel headerPanel = new JBPanel();
            headerPanel.setLayout((LayoutManager)new BoxLayout((Container)headerPanel, 0));
            headerPanel.setMaximumSize(new Dimension(900, 35));
            JBLabel tableNameLabel = new JBLabel(HEADER_NAME_LABEL);
            tableNameLabel.setMaximumSize(new Dimension(300, 30));
            JBLabel operationLabel = new JBLabel(HEADER_OPERATION_LABEL);
            operationLabel.setMaximumSize(new Dimension(300, 30));
            JBLabel newNameLabel = new JBLabel(HEADER_NEW_NAME_LABEL);
            newNameLabel.setMaximumSize(new Dimension(300, 30));
            headerPanel.add((Component)tableNameLabel);
            headerPanel.add((Component)operationLabel);
            headerPanel.add((Component)newNameLabel);
            listPanel.add((Component)headerPanel);
            for (String oldName : oldNames) {
                RenamePanelElement renameStepElement = new RenamePanelElement(oldName, newNames);
                this.renameStepElements.add(renameStepElement);
                listPanel.add((Component)renameStepElement.getRenameStepElementPanel());
            }
            JBScrollPane renameStepScrollPane = new JBScrollPane();
            renameStepScrollPane.getViewport().setView((Component)listPanel);
            this.renameStepPanel.add((Component)renameStepScrollPane, (Object)"Center");
        }

        @NotNull
        public JBPanel getRenameStepPanel() {
            JBPanel jBPanel = this.renameStepPanel;
            if (jBPanel == null) {
                RenamePanel.$$$reportNull$$$0(3);
            }
            return jBPanel;
        }

        @NotNull
        public Map<String, String> getOldToNewNamesMapping() {
            HashMap<String, String> oldToNewNamesMapping = new HashMap<String, String>();
            for (RenamePanelElement renameStepElement : this.renameStepElements) {
                if (!renameStepElement.markedAsRenamed()) continue;
                oldToNewNamesMapping.put(renameStepElement.getInitialName(), renameStepElement.getNewName());
            }
            HashMap<String, String> hashMap = oldToNewNamesMapping;
            if (hashMap == null) {
                RenamePanel.$$$reportNull$$$0(4);
            }
            return hashMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "label";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldNames";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newNames";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/room/migrations/ui/GenerateMigrationWizard$RenamePanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/room/migrations/ui/GenerateMigrationWizard$RenamePanel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRenameStepPanel";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOldToNewNamesMapping";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class RenamePanelElement {
        public static final int MAX_PANEL_WIDTH = 900;
        public static final int MAX_PANEL_HEIGHT = 35;
        public static final int MAX_PANEL_COMPONENT_WIDTH = 300;
        public static final int MAX_PANEL_COMPONENT_HEIGHT = 30;
        private static final String DELETED = "deleted";
        private static final String RENAMED = "renamed";
        private static final String[] STATUSES = new String[]{"deleted", "renamed"};
        private JBLabel initialName;
        private ComboBox<String> statusComboBox;
        private ComboBox<String> newNamesComboBox;
        private JBPanel renameStepElementPanel;

        public RenamePanelElement(@NotNull String initialName, @NotNull List<String> newNames) {
            if (initialName == null) {
                RenamePanelElement.$$$reportNull$$$0(0);
            }
            if (newNames == null) {
                RenamePanelElement.$$$reportNull$$$0(1);
            }
            this.initialName = new JBLabel(initialName);
            this.initialName.setMaximumSize(new Dimension(300, 30));
            this.statusComboBox = new ComboBox((Object[])STATUSES);
            this.statusComboBox.setMaximumSize(new Dimension(300, 30));
            this.newNamesComboBox = new ComboBox();
            newNames.forEach(newName2 -> this.newNamesComboBox.addItem(newName2));
            this.newNamesComboBox.setMaximumSize(new Dimension(300, 30));
            this.newNamesComboBox.setEnabled(false);
            this.renameStepElementPanel = new JBPanel();
            this.renameStepElementPanel.setLayout((LayoutManager)new BoxLayout((Container)this.renameStepElementPanel, 0));
            this.renameStepElementPanel.add((Component)this.initialName);
            this.renameStepElementPanel.add(this.statusComboBox);
            this.renameStepElementPanel.add(this.newNamesComboBox);
            this.renameStepElementPanel.setMaximumSize(new Dimension(900, 35));
            this.statusComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getItem().equals(RenamePanelElement.RENAMED)) {
                        if (e.getStateChange() == 1) {
                            newNamesComboBox.setEnabled(true);
                        } else {
                            newNamesComboBox.setEnabled(false);
                        }
                    }
                }
            });
        }

        @NotNull
        public String getInitialName() {
            String string = this.initialName.getText();
            if (string == null) {
                RenamePanelElement.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        String getStatus() {
            String string = (String)this.statusComboBox.getItemAt(this.statusComboBox.getSelectedIndex());
            if (string == null) {
                RenamePanelElement.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        String getNewName() {
            String string = (String)this.newNamesComboBox.getItemAt(this.newNamesComboBox.getSelectedIndex());
            if (string == null) {
                RenamePanelElement.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public JBPanel getRenameStepElementPanel() {
            JBPanel jBPanel = this.renameStepElementPanel;
            if (jBPanel == null) {
                RenamePanelElement.$$$reportNull$$$0(5);
            }
            return jBPanel;
        }

        public boolean markedAsRenamed() {
            return this.getStatus().equals(RENAMED);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initialName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newNames";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/room/migrations/ui/GenerateMigrationWizard$RenamePanelElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/room/migrations/ui/GenerateMigrationWizard$RenamePanelElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInitialName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatus";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNewName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRenameStepElementPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

