/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.room.migrations.json;

import com.android.tools.idea.room.migrations.json.BundleUtil;
import com.android.tools.idea.room.migrations.json.FieldBundle;
import com.android.tools.idea.room.migrations.json.ForeignKeyBundle;
import com.android.tools.idea.room.migrations.json.IndexBundle;
import com.android.tools.idea.room.migrations.json.PrimaryKeyBundle;
import com.android.tools.idea.room.migrations.json.SchemaEquality;
import com.android.tools.idea.room.migrations.json.SchemaEqualityUtil;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class EntityBundle
implements SchemaEquality<EntityBundle> {
    static final String NEW_TABLE_PREFIX = "_new_";
    @SerializedName(value="tableName")
    private final String mTableName;
    @SerializedName(value="createSql")
    private final String mCreateSql;
    @SerializedName(value="fields")
    private final List<FieldBundle> mFields;
    @SerializedName(value="primaryKey")
    private final PrimaryKeyBundle mPrimaryKey;
    @SerializedName(value="indices")
    private final List<IndexBundle> mIndices;
    @SerializedName(value="foreignKeys")
    private final List<ForeignKeyBundle> mForeignKeys;
    private transient String mNewTableName;
    private transient Map<String, FieldBundle> mFieldsByColumnName;

    public EntityBundle(String tableName, String createSql, List<FieldBundle> fields, PrimaryKeyBundle primaryKey, List<IndexBundle> indices, List<ForeignKeyBundle> foreignKeys) {
        this.mTableName = tableName;
        this.mCreateSql = createSql;
        this.mFields = fields;
        this.mPrimaryKey = primaryKey;
        this.mIndices = indices;
        this.mForeignKeys = foreignKeys;
    }

    public String getNewTableName() {
        if (this.mNewTableName == null) {
            this.mNewTableName = NEW_TABLE_PREFIX + this.mTableName;
        }
        return this.mNewTableName;
    }

    public Map<String, FieldBundle> getFieldsByColumnName() {
        if (this.mFieldsByColumnName == null) {
            this.mFieldsByColumnName = new HashMap<String, FieldBundle>();
            for (FieldBundle bundle : this.mFields) {
                this.mFieldsByColumnName.put(bundle.getColumnName(), bundle);
            }
        }
        return this.mFieldsByColumnName;
    }

    public String getTableName() {
        return this.mTableName;
    }

    public String getCreateSql() {
        return this.mCreateSql;
    }

    public List<FieldBundle> getFields() {
        return this.mFields;
    }

    public PrimaryKeyBundle getPrimaryKey() {
        return this.mPrimaryKey;
    }

    public List<IndexBundle> getIndices() {
        return this.mIndices;
    }

    public List<ForeignKeyBundle> getForeignKeys() {
        return this.mForeignKeys;
    }

    public String createTable() {
        return BundleUtil.replaceTableName(this.mCreateSql, this.getTableName());
    }

    public String createNewTable() {
        return BundleUtil.replaceTableName(this.mCreateSql, this.getNewTableName());
    }

    @NotNull
    public String renameToOriginal() {
        String string = "ALTER TABLE " + this.getNewTableName() + " RENAME TO " + this.getTableName();
        if (string == null) {
            EntityBundle.$$$reportNull$$$0(0);
        }
        return string;
    }

    public Collection<String> buildCreateQueries() {
        ArrayList<String> result2 = new ArrayList<String>();
        result2.add(this.createTable());
        for (IndexBundle indexBundle : this.mIndices) {
            result2.add(indexBundle.create(this.getTableName()));
        }
        return result2;
    }

    @Override
    public boolean isSchemaEqual(EntityBundle other) {
        if (!this.mTableName.equals(other.mTableName)) {
            return false;
        }
        return SchemaEqualityUtil.checkSchemaEquality(this.getFieldsByColumnName(), other.getFieldsByColumnName()) && SchemaEqualityUtil.checkSchemaEquality(this.mPrimaryKey, other.mPrimaryKey) && SchemaEqualityUtil.checkSchemaEquality(this.mIndices, other.mIndices) && SchemaEqualityUtil.checkSchemaEquality(this.mForeignKeys, other.mForeignKeys);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/room/migrations/json/EntityBundle", "renameToOriginal"));
    }
}

