/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.room.migrations.generators;

import com.android.tools.idea.lang.androidSql.parser.AndroidSqlLexer;
import com.android.tools.idea.room.migrations.json.DatabaseViewBundle;
import com.android.tools.idea.room.migrations.json.EntityBundle;
import com.android.tools.idea.room.migrations.json.FieldBundle;
import com.android.tools.idea.room.migrations.json.ForeignKeyBundle;
import com.android.tools.idea.room.migrations.json.FtsEntityBundle;
import com.android.tools.idea.room.migrations.json.FtsOptionsBundle;
import com.android.tools.idea.room.migrations.json.IndexBundle;
import com.android.tools.idea.room.migrations.json.PrimaryKeyBundle;
import com.android.tools.idea.room.migrations.update.DatabaseUpdate;
import com.android.tools.idea.room.migrations.update.EntityUpdate;
import com.android.tools.idea.room.migrations.update.SchemaDiffUtil;
import com.intellij.openapi.util.InvalidDataException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlStatementsGenerator {
    private static final String TMP_TABLE_NAME_TEMPLATE = "%s_data$android_studio_tmp";

    @NotNull
    public static List<String> getMigrationStatements(@NotNull DatabaseUpdate databaseUpdate) {
        if (databaseUpdate == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(0);
        }
        ArrayList<String> updateStatements = new ArrayList<String>();
        databaseUpdate.getRenamedEntities().forEach((oldName, newName2) -> updateStatements.add(SqlStatementsGenerator.getRenameTableStatement(oldName, newName2)));
        for (EntityBundle entity : databaseUpdate.getNewEntities().values()) {
            updateStatements.add(SqlStatementsGenerator.getCreateTableStatement(entity.getTableName(), entity));
        }
        for (EntityUpdate entityUpdate : databaseUpdate.getModifiedEntities().values()) {
            updateStatements.addAll(SqlStatementsGenerator.getMigrationStatements(entityUpdate));
        }
        for (EntityBundle entity : databaseUpdate.getDeletedEntities().values()) {
            updateStatements.add(SqlStatementsGenerator.getDropTableStatement(entity.getTableName()));
        }
        for (DatabaseViewBundle view : databaseUpdate.getDeletedViews()) {
            updateStatements.add(SqlStatementsGenerator.getDropViewStatement(view));
        }
        for (DatabaseViewBundle view : databaseUpdate.getNewOrModifiedViews()) {
            updateStatements.add(SqlStatementsGenerator.getCreateViewStatement(view));
        }
        for (String tableName : databaseUpdate.getTablesToForeignKeyCheck()) {
            updateStatements.add(SqlStatementsGenerator.getForeignKeyConstraintCheck(tableName));
        }
        ArrayList<String> arrayList = updateStatements;
        if (arrayList == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public static List<String> getMigrationStatements(@NotNull EntityUpdate entityUpdate) {
        if (entityUpdate == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(2);
        }
        String tableName = entityUpdate.getNewTableName();
        ArrayList<String> updateStatements = new ArrayList<String>();
        if (entityUpdate.isComplexUpdate()) {
            if (entityUpdate.shouldCreateAnFtsEntity() && SchemaDiffUtil.ftsTableNeedsExternalContentSource((FtsEntityBundle)entityUpdate.getNewState())) {
                updateStatements.addAll(SqlStatementsGenerator.getComplexUpdateForFtsTableWithExternalContent(entityUpdate));
            } else {
                updateStatements.addAll(SqlStatementsGenerator.getComplexTableUpdate(entityUpdate));
            }
        } else {
            if (entityUpdate.shouldRenameTable()) {
                updateStatements.add(SqlStatementsGenerator.getRenameTableStatement(entityUpdate.getOldTableName(), entityUpdate.getNewTableName()));
            }
            Map<String, FieldBundle> newFields = entityUpdate.getNewFields();
            for (FieldBundle fieldBundle : newFields.values()) {
                updateStatements.add(SqlStatementsGenerator.getAddColumnStatement(tableName, fieldBundle));
            }
            Map<FieldBundle, String> renamedFields = entityUpdate.getRenamedFields();
            for (Map.Entry<FieldBundle, String> entry : renamedFields.entrySet()) {
                updateStatements.add(SqlStatementsGenerator.getRenameColumnStatement(tableName, entry.getValue(), entry.getKey().getColumnName()));
            }
            Map<FieldBundle, String> map2 = entityUpdate.getValuesForUninitializedFields();
            if (!map2.isEmpty()) {
                updateStatements.add(SqlStatementsGenerator.getUpdateColumnsValuesStatement(tableName, map2));
            }
        }
        for (IndexBundle index2 : entityUpdate.getIndicesToBeDropped()) {
            updateStatements.add(SqlStatementsGenerator.getDropIndexStatement(index2));
        }
        for (IndexBundle index2 : entityUpdate.getIndicesToBeCreated()) {
            updateStatements.add(SqlStatementsGenerator.getCreateIndexStatement(index2, tableName));
        }
        ArrayList<String> arrayList = updateStatements;
        if (arrayList == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    private static List<String> getComplexTableUpdate(@NotNull EntityUpdate entityUpdate) {
        if (entityUpdate == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(4);
        }
        ArrayList<String> updateStatements = new ArrayList<String>();
        String dataSource = SqlStatementsGenerator.getDataSourceForComplexUpdate(entityUpdate);
        Map<String, String> columnNameToColumnValue = SqlStatementsGenerator.getColumnNameToColumnValueMapping(entityUpdate);
        if (columnNameToColumnValue.isEmpty()) {
            updateStatements.add(SqlStatementsGenerator.getDropTableStatement(entityUpdate.getOldTableName()));
            updateStatements.add(SqlStatementsGenerator.getCreateTableStatement(entityUpdate.getNewTableName(), entityUpdate.getNewState()));
        } else {
            String oldTableName = !entityUpdate.shouldRenameTable() ? entityUpdate.getNewTableName() : entityUpdate.getOldTableName();
            String newTableName = !entityUpdate.shouldRenameTable() ? String.format(TMP_TABLE_NAME_TEMPLATE, oldTableName) : entityUpdate.getNewTableName();
            updateStatements.add(SqlStatementsGenerator.getCreateTableStatement(newTableName, entityUpdate.getNewState()));
            updateStatements.add(SqlStatementsGenerator.getInsertIntoTableStatement(newTableName, new ArrayList<String>(columnNameToColumnValue.keySet()), SqlStatementsGenerator.getSelectFromTableStatement(dataSource, new ArrayList<String>(columnNameToColumnValue.values()))));
            updateStatements.add(SqlStatementsGenerator.getDropTableStatement(oldTableName));
            if (!entityUpdate.shouldRenameTable()) {
                updateStatements.add(SqlStatementsGenerator.getRenameTableStatement(newTableName, oldTableName));
            }
        }
        ArrayList<String> arrayList = updateStatements;
        if (arrayList == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static List<String> getComplexUpdateForFtsTableWithExternalContent(@NotNull EntityUpdate entityUpdate) {
        if (entityUpdate == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(6);
        }
        ArrayList<String> updateStatements = new ArrayList<String>();
        String oldTableName = entityUpdate.getOldTableName();
        String newTableName = entityUpdate.getNewTableName();
        String dataSource = SqlStatementsGenerator.getDataSourceForComplexUpdate(entityUpdate);
        Map<String, String> columnNameToColumnValue = SqlStatementsGenerator.getColumnNameToColumnValueMapping(entityUpdate);
        updateStatements.add(SqlStatementsGenerator.getDropTableStatement(oldTableName));
        updateStatements.add(SqlStatementsGenerator.getCreateTableStatement(newTableName, entityUpdate.getNewState()));
        updateStatements.add(SqlStatementsGenerator.getInsertIntoTableStatement(newTableName, new ArrayList<String>(columnNameToColumnValue.keySet()), SqlStatementsGenerator.getSelectFromTableStatement(dataSource, new ArrayList<String>(columnNameToColumnValue.values()))));
        return updateStatements;
    }

    @NotNull
    private static String getSelectFromTableStatement(@NotNull String tableName, @NotNull List<String> columnNames) {
        if (tableName == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(7);
        }
        if (columnNames == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(8);
        }
        tableName = AndroidSqlLexer.getValidName(tableName);
        StringBuilder statement = new StringBuilder(String.format("SELECT %s\n", SqlStatementsGenerator.getColumnEnumeration(columnNames)));
        statement.append(String.format("\tFROM %s;", tableName));
        String string = statement.toString();
        if (string == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private static String getInsertIntoTableStatement(@NotNull String tableName, @NotNull List<String> columnNames, @NotNull String values2) {
        if (tableName == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(10);
        }
        if (columnNames == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(11);
        }
        if (values2 == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(12);
        }
        tableName = AndroidSqlLexer.getValidName(tableName);
        StringBuilder statement = new StringBuilder(String.format("INSERT INTO %s (%s)\n\t", tableName, SqlStatementsGenerator.getColumnEnumeration(columnNames)));
        statement.append(values2);
        if (!statement.toString().endsWith(";")) {
            statement.append(";");
        }
        String string = statement.toString();
        if (string == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private static String getRenameTableStatement(@NotNull String oldName, @NotNull String newName2) {
        if (oldName == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(14);
        }
        if (newName2 == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(15);
        }
        String string = String.format("ALTER TABLE %s RENAME TO %s;", AndroidSqlLexer.getValidName(oldName), AndroidSqlLexer.getValidName(newName2));
        if (string == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private static String getCreateTableStatement(@NotNull String tableName, @NotNull EntityBundle entity) {
        if (tableName == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(17);
        }
        if (entity == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(18);
        }
        if (entity instanceof FtsEntityBundle) {
            return SqlStatementsGenerator.getCreateTableStatementFromEntityBundle(tableName, entity);
        }
        tableName = AndroidSqlLexer.getValidName(tableName);
        StringBuilder statement = new StringBuilder(String.format("CREATE TABLE %s\n(\n", tableName));
        for (FieldBundle field2 : entity.getFields()) {
            statement.append(String.format("\t%s,\n", SqlStatementsGenerator.getColumnDescription(field2)));
            if (!SqlStatementsGenerator.shouldAddAutoIncrementToColumn(field2, entity.getPrimaryKey())) continue;
            statement.replace(statement.length() - 2, statement.length(), "");
            statement.append(" PRIMARY KEY AUTOINCREMENT,\n");
        }
        if (!entity.getPrimaryKey().isAutoGenerate()) {
            statement.append(String.format("\t%s,\n", SqlStatementsGenerator.getPrimaryKeyConstraint(entity.getPrimaryKey())));
        }
        if (entity.getForeignKeys() != null) {
            for (ForeignKeyBundle foreignKey : entity.getForeignKeys()) {
                statement.append(String.format("\t%s,\n", SqlStatementsGenerator.getForeignKeyConstraint(foreignKey)));
            }
        }
        statement.replace(statement.length() - 2, statement.length() - 1, "");
        statement.append(");");
        String string = statement.toString();
        if (string == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    private static String getCreateTableStatementFromEntityBundle(@NotNull String tableName, @NotNull EntityBundle entity) {
        Object statement;
        if (tableName == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(20);
        }
        if (entity == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(21);
        }
        if (!((String)(statement = entity.getCreateSql().replace("${TABLE_NAME}", tableName))).trim().endsWith(";")) {
            statement = (String)statement + ";";
        }
        String string = statement;
        if (string == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    private static String getDropTableStatement(@NotNull String tableName) {
        if (tableName == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(23);
        }
        tableName = AndroidSqlLexer.getValidName(tableName);
        String string = String.format("DROP TABLE %s;", tableName);
        if (string == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    private static String getAddColumnStatement(@NotNull String tableName, @NotNull FieldBundle field2) {
        if (tableName == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(25);
        }
        if (field2 == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(26);
        }
        tableName = AndroidSqlLexer.getValidName(tableName);
        String string = String.format("ALTER TABLE %s ADD COLUMN %s;", tableName, SqlStatementsGenerator.getColumnDescription(field2));
        if (string == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(27);
        }
        return string;
    }

    private static String getRenameColumnStatement(@NotNull String tableName, @NotNull String oldColumnName, @NotNull String newColumnName) {
        if (tableName == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(28);
        }
        if (oldColumnName == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(29);
        }
        if (newColumnName == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(30);
        }
        tableName = AndroidSqlLexer.getValidName(tableName);
        oldColumnName = AndroidSqlLexer.getValidName(oldColumnName);
        newColumnName = AndroidSqlLexer.getValidName(newColumnName);
        return String.format("ALTER TABLE %s RENAME COLUMN %s TO %s;", tableName, oldColumnName, newColumnName);
    }

    @NotNull
    private static String getColumnDescription(@NotNull FieldBundle field2) {
        if (field2 == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(31);
        }
        StringBuilder fieldDescription = new StringBuilder(String.format("%s %s", AndroidSqlLexer.getValidName(field2.getColumnName()), field2.getAffinity()));
        if (field2.getDefaultValue() != null) {
            fieldDescription.append(String.format(" DEFAULT %s", SqlStatementsGenerator.toSqlStringLiteral(field2.getDefaultValue())));
        }
        if (field2.isNonNull()) {
            fieldDescription.append(" NOT NULL");
        }
        String string = fieldDescription.toString();
        if (string == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(32);
        }
        return string;
    }

    @NotNull
    private static String getPrimaryKeyConstraint(@NotNull PrimaryKeyBundle primaryKey) {
        if (primaryKey == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(33);
        }
        String string = String.format("PRIMARY KEY (%s)", SqlStatementsGenerator.getColumnEnumeration(primaryKey.getColumnNames()));
        if (string == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(34);
        }
        return string;
    }

    @NotNull
    private static String getForeignKeyConstraint(@NotNull ForeignKeyBundle foreignKey) {
        if (foreignKey == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(35);
        }
        String onUpdate = foreignKey.getOnUpdate() != null && !foreignKey.getOnUpdate().isEmpty() ? String.format(" ON UPDATE %s", foreignKey.getOnUpdate()) : "";
        String onDelete = foreignKey.getOnDelete() != null && !foreignKey.getOnDelete().isEmpty() ? String.format(" ON DELETE %s", foreignKey.getOnDelete()) : "";
        String string = String.format("FOREIGN KEY (%s) REFERENCES %s (%s)%s%s", SqlStatementsGenerator.getColumnEnumeration(foreignKey.getColumns()), AndroidSqlLexer.getValidName(foreignKey.getTable()), SqlStatementsGenerator.getColumnEnumeration(foreignKey.getReferencedColumns()), onUpdate, onDelete);
        if (string == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(36);
        }
        return string;
    }

    private static String getForeignKeyConstraintCheck(@NotNull String tableName) {
        if (tableName == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(37);
        }
        return String.format("PRAGMA foreign_key_check(%s);", AndroidSqlLexer.getValidName(tableName));
    }

    @NotNull
    private static String getCreateIndexStatement(@NotNull IndexBundle index2, @NotNull String tableName) {
        if (index2 == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(38);
        }
        if (tableName == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(39);
        }
        tableName = AndroidSqlLexer.getValidName(tableName);
        StringBuilder statement = new StringBuilder("CREATE ");
        if (index2.isUnique()) {
            statement.append("UNIQUE ");
        }
        statement.append(String.format("INDEX %s ON %s (%s);", AndroidSqlLexer.getValidName(index2.getName()), tableName, SqlStatementsGenerator.getColumnEnumeration(index2.getColumnNames())));
        String string = statement.toString();
        if (string == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(40);
        }
        return string;
    }

    @NotNull
    private static String getDropIndexStatement(@NotNull IndexBundle index2) {
        if (index2 == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(41);
        }
        String string = String.format("DROP INDEX %s;", AndroidSqlLexer.getValidName(index2.getName()));
        if (string == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(42);
        }
        return string;
    }

    @NotNull
    private static String getUpdateColumnsValuesStatement(@NotNull String tableName, @NotNull Map<FieldBundle, String> newFieldsValues) {
        if (tableName == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(43);
        }
        if (newFieldsValues == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(44);
        }
        tableName = AndroidSqlLexer.getValidName(tableName);
        StringBuilder statement = new StringBuilder(String.format("UPDATE %s\nSET", tableName));
        String valueAssignments = newFieldsValues.keySet().stream().map(fieldBundle -> String.format("\t%s = %s", fieldBundle.getColumnName(), SqlStatementsGenerator.toSqlStringLiteral((String)newFieldsValues.get(fieldBundle)))).collect(Collectors.joining(",\n"));
        statement.append(valueAssignments);
        statement.append(";");
        String string = statement.toString();
        if (string == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(45);
        }
        return string;
    }

    @NotNull
    private static String getCreateViewStatement(@NotNull DatabaseViewBundle view) {
        Object statement;
        if (view == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(46);
        }
        if (!((String)(statement = view.getCreateSql().replace("${VIEW_NAME}", AndroidSqlLexer.getValidName(view.getViewName())))).trim().endsWith(";")) {
            statement = (String)statement + ";";
        }
        String string = statement;
        if (string == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(47);
        }
        return string;
    }

    @NotNull
    private static String getDropViewStatement(@NotNull DatabaseViewBundle view) {
        if (view == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(48);
        }
        String string = String.format("DROP VIEW %s;", AndroidSqlLexer.getValidName(view.getViewName()));
        if (string == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(49);
        }
        return string;
    }

    @NotNull
    private static String getColumnEnumeration(@NotNull List<String> columnNames) {
        if (columnNames == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(50);
        }
        String string = columnNames.stream().map(c -> AndroidSqlLexer.getValidName(c)).collect(Collectors.joining(", "));
        if (string == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(51);
        }
        return string;
    }

    @NotNull
    private static String toSqlStringLiteral(@NotNull String value2) {
        if (value2 == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(52);
        }
        if (value2.contains("'")) {
            value2 = value2.replaceAll("'", "''");
        }
        String string = String.format("'%s'", value2);
        if (string == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(53);
        }
        return string;
    }

    private static boolean shouldAddAutoIncrementToColumn(@NotNull FieldBundle field2, @NotNull PrimaryKeyBundle primaryKey) {
        if (field2 == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(54);
        }
        if (primaryKey == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(55);
        }
        return primaryKey.isAutoGenerate() && field2.getAffinity().toLowerCase(Locale.US).equals("integer") && primaryKey.getColumnNames().size() == 1 && primaryKey.getColumnNames().get(0).equals(field2.getColumnName());
    }

    @NotNull
    private static String getDataSourceForComplexUpdate(@NotNull EntityUpdate entityUpdate) {
        if (entityUpdate == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(56);
        }
        EntityBundle newState = entityUpdate.getNewState();
        if (entityUpdate.shouldCreateAnFtsEntity() && SchemaDiffUtil.ftsTableNeedsExternalContentSource((FtsEntityBundle)newState)) {
            String string = ((FtsEntityBundle)newState).getFtsOptions().getContentTable();
            if (string == null) {
                SqlStatementsGenerator.$$$reportNull$$$0(57);
            }
            return string;
        }
        if (entityUpdate.shouldRenameTable()) {
            String string = entityUpdate.getOldTableName();
            if (string == null) {
                SqlStatementsGenerator.$$$reportNull$$$0(58);
            }
            return string;
        }
        String string = entityUpdate.getNewTableName();
        if (string == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(59);
        }
        return string;
    }

    @Nullable
    private static String getValueForField(@NotNull FieldBundle field2, @NotNull EntityUpdate entityUpdate) {
        FtsOptionsBundle ftsOptions;
        String userSpecifiedValue;
        if (field2 == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(60);
        }
        if (entityUpdate == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(61);
        }
        if ((userSpecifiedValue = entityUpdate.getValuesForUninitializedFields().get(field2)) != null) {
            return SqlStatementsGenerator.toSqlStringLiteral(userSpecifiedValue);
        }
        if (entityUpdate.shouldCreateAnFtsEntity() && (ftsOptions = ((FtsEntityBundle)entityUpdate.getNewState()).getFtsOptions()) != null && ftsOptions.getContentTable() != null && !ftsOptions.getContentTable().isEmpty()) {
            return AndroidSqlLexer.getValidName(field2.getColumnName());
        }
        String oldColumnName = entityUpdate.getRenamedFields().get(field2);
        if (oldColumnName != null) {
            return AndroidSqlLexer.getValidName(oldColumnName);
        }
        String columnName = field2.getColumnName();
        if (entityUpdate.getUnmodifiedFields().get(columnName) != null || entityUpdate.getModifiedFields().get(columnName) != null) {
            return AndroidSqlLexer.getValidName(columnName);
        }
        return null;
    }

    @NotNull
    private static Map<String, String> getColumnNameToColumnValueMapping(@NotNull EntityUpdate entityUpdate) {
        if (entityUpdate == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(62);
        }
        LinkedHashMap<String, String> columnNameToColumnValue = new LinkedHashMap<String, String>();
        for (FieldBundle field2 : entityUpdate.getAllFields()) {
            String value2 = SqlStatementsGenerator.getValueForField(field2, entityUpdate);
            if (value2 == null) {
                if (!SqlStatementsGenerator.columnNeedsUserSpecifiedValue(field2)) continue;
                throw new InvalidDataException("NOT NULL column without default value or user specified value.");
            }
            columnNameToColumnValue.put(AndroidSqlLexer.getValidName(field2.getColumnName()), value2);
        }
        LinkedHashMap<String, String> linkedHashMap = columnNameToColumnValue;
        if (linkedHashMap == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(63);
        }
        return linkedHashMap;
    }

    private static boolean columnNeedsUserSpecifiedValue(@NotNull FieldBundle field2) {
        if (field2 == null) {
            SqlStatementsGenerator.$$$reportNull$$$0(64);
        }
        return field2.isNonNull() && (field2.getDefaultValue() == null || field2.getDefaultValue().isEmpty());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 24: 
            case 27: 
            case 32: 
            case 34: 
            case 36: 
            case 40: 
            case 42: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 53: 
            case 57: 
            case 58: 
            case 59: 
            case 63: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 24: 
            case 27: 
            case 32: 
            case 34: 
            case 36: 
            case 40: 
            case 42: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 53: 
            case 57: 
            case 58: 
            case 59: 
            case 63: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseUpdate";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 24: 
            case 27: 
            case 32: 
            case 34: 
            case 36: 
            case 40: 
            case 42: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 53: 
            case 57: 
            case 58: 
            case 59: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/room/migrations/generators/SqlStatementsGenerator";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 56: 
            case 61: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entityUpdate";
                break;
            }
            case 7: 
            case 10: 
            case 17: 
            case 20: 
            case 23: 
            case 25: 
            case 28: 
            case 37: 
            case 39: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableName";
                break;
            }
            case 8: 
            case 11: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnNames";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
            case 26: 
            case 31: 
            case 54: 
            case 60: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldColumnName";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newColumnName";
                break;
            }
            case 33: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primaryKey";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foreignKey";
                break;
            }
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFieldsValues";
                break;
            }
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/room/migrations/generators/SqlStatementsGenerator";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMigrationStatements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComplexTableUpdate";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectFromTableStatement";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getInsertIntoTableStatement";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenameTableStatement";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateTableStatement";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateTableStatementFromEntityBundle";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getDropTableStatement";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddColumnStatement";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnDescription";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimaryKeyConstraint";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getForeignKeyConstraint";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateIndexStatement";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getDropIndexStatement";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdateColumnsValuesStatement";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateViewStatement";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getDropViewStatement";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnEnumeration";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "toSqlStringLiteral";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSourceForComplexUpdate";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnNameToColumnValueMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMigrationStatements";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 24: 
            case 27: 
            case 32: 
            case 34: 
            case 36: 
            case 40: 
            case 42: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 53: 
            case 57: 
            case 58: 
            case 59: 
            case 63: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getComplexTableUpdate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getComplexUpdateForFtsTableWithExternalContent";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSelectFromTableStatement";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getInsertIntoTableStatement";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getRenameTableStatement";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getCreateTableStatement";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getCreateTableStatementFromEntityBundle";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getDropTableStatement";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getAddColumnStatement";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getRenameColumnStatement";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getColumnDescription";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getPrimaryKeyConstraint";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getForeignKeyConstraint";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getForeignKeyConstraintCheck";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getCreateIndexStatement";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getDropIndexStatement";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getUpdateColumnsValuesStatement";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getCreateViewStatement";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getDropViewStatement";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getColumnEnumeration";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "toSqlStringLiteral";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddAutoIncrementToColumn";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourceForComplexUpdate";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getValueForField";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getColumnNameToColumnValueMapping";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "columnNeedsUserSpecifiedValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 24: 
            case 27: 
            case 32: 
            case 34: 
            case 36: 
            case 40: 
            case 42: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 53: 
            case 57: 
            case 58: 
            case 59: 
            case 63: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

