/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.room.migrations;

import com.android.tools.idea.projectsystem.TestArtifactSearchScopes;
import com.android.tools.idea.room.migrations.GenerateRoomMigrationAction;
import com.android.tools.idea.room.migrations.generators.JavaMigrationClassGenerator;
import com.android.tools.idea.room.migrations.generators.JavaMigrationTestGenerator;
import com.android.tools.idea.room.migrations.json.SchemaBundle;
import com.android.tools.idea.room.migrations.ui.GenerateMigrationWizard;
import com.android.tools.idea.room.migrations.update.DatabaseUpdate;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/room/migrations/GenerateRoomMigrationAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getDatabaseClassFullyQualifiedName", "", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "schemaJsonFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getDefaultTargetPackage", "Lcom/intellij/psi/PsiPackage;", "databaseFullyQualifiedName", "getMigrationDefaultTargetDirectory", "Lcom/intellij/psi/PsiDirectory;", "getTestDefaultTargetDirectory", "intellij.android.room"})
public final class GenerateRoomMigrationAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        Object[] objectArray = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (objectArray == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"e.getData(CommonDataKeys\u2026UAL_FILE_ARRAY) ?: return");
        Object[] files2 = objectArray;
        if (files2.length == 2) {
            Object[] $this$sortBy$iv = files2;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.length > 1) {
                boolean bl = false;
                ArraysKt.sortWith((Object[])$this$sortBy$iv, (Comparator)new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        VirtualFile it = (VirtualFile)a;
                        boolean bl2 = false;
                        VirtualFile virtualFile = it;
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"it");
                        it = (VirtualFile)b;
                        Comparable comparable = (Comparable)((Object)virtualFile.getNameWithoutExtension());
                        bl2 = false;
                        VirtualFile virtualFile2 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"it");
                        String string = virtualFile2.getNameWithoutExtension();
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
                    }
                });
            }
            Module module2 = ModuleUtilCore.findModuleForFile((VirtualFile)files2[0], (Project)project2);
            if (module2 == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"ModuleUtilCore.findModul\u2026es[0], project) ?: return");
            Module module3 = module2;
            Object object = files2[0];
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"files[0]");
            String string = this.getDatabaseClassFullyQualifiedName(project2, module3, (VirtualFile)object);
            if (string == null) {
                return;
            }
            String databaseClassQualifiedName = string;
            PsiPackage psiPackage = this.getDefaultTargetPackage(databaseClassQualifiedName, project2);
            if (psiPackage == null) {
                return;
            }
            PsiPackage targetPackage = psiPackage;
            PsiDirectory psiDirectory = this.getMigrationDefaultTargetDirectory(project2, module3);
            if (psiDirectory == null) {
                return;
            }
            PsiDirectory migrationClassDirectory = psiDirectory;
            PsiDirectory psiDirectory2 = this.getTestDefaultTargetDirectory(project2, module3);
            if (psiDirectory2 == null) {
                return;
            }
            PsiDirectory migrationTestDirectory = psiDirectory2;
            Object object2 = files2[0];
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"files[0]");
            SchemaBundle schemaBundle = SchemaBundle.deserialize(object2.getInputStream());
            if (schemaBundle == null) {
                return;
            }
            SchemaBundle oldSchema = schemaBundle;
            Object object3 = files2[1];
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"files[1]");
            SchemaBundle schemaBundle2 = SchemaBundle.deserialize(object3.getInputStream());
            if (schemaBundle2 == null) {
                return;
            }
            SchemaBundle newSchema = schemaBundle2;
            DatabaseUpdate databaseUpdate = new DatabaseUpdate(oldSchema.getDatabase(), newSchema.getDatabase());
            GenerateMigrationWizard migrationWizard = new GenerateMigrationWizard(project2, targetPackage, migrationClassDirectory, migrationTestDirectory, databaseUpdate);
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            if (!application.isUnitTestMode() && !migrationWizard.showAndGet()) {
                return;
            }
            WriteCommandAction.runWriteCommandAction((Project)project2, (Runnable)new Runnable(project2, migrationWizard, databaseClassQualifiedName, databaseUpdate){
                final /* synthetic */ Project $project;
                final /* synthetic */ GenerateMigrationWizard $migrationWizard;
                final /* synthetic */ String $databaseClassQualifiedName;
                final /* synthetic */ DatabaseUpdate $databaseUpdate;

                public final void run() {
                    try {
                        JavaMigrationClassGenerator javaMigrationClassGenerator = new JavaMigrationClassGenerator(this.$project);
                        PsiClass psiClass = javaMigrationClassGenerator.createMigrationClass(this.$migrationWizard.getTargetPackage(), this.$migrationWizard.getMigrationClassDirectory(), this.$migrationWizard.getUserReviewedDatabaseUpdate());
                        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"javaMigrationClassGenera\u2026erReviewedDatabaseUpdate)");
                        PsiClass migrationClass = psiClass;
                        CharSequence charSequence = migrationClass.getQualifiedName();
                        boolean bl = false;
                        boolean bl2 = false;
                        if (!(charSequence == null || charSequence.length() == 0)) {
                            JavaMigrationTestGenerator javaMigrationTestGenerator = new JavaMigrationTestGenerator(this.$project);
                            PsiPackage psiPackage = this.$migrationWizard.getTargetPackage();
                            PsiDirectory psiDirectory = this.$migrationWizard.getMigrationTestDirectory();
                            String string = migrationClass.getQualifiedName();
                            Intrinsics.checkNotNull((Object)string);
                            javaMigrationTestGenerator.createMigrationTest(psiPackage, psiDirectory, this.$databaseClassQualifiedName, string, this.$databaseUpdate.getPreviousVersion(), this.$databaseUpdate.getCurrentVersion());
                        }
                    }
                    catch (Exception e) {
                        Messages.showInfoMessage((Project)this.$project, (String)e.getMessage(), (String)"Failed to generate a migration");
                    }
                }
                {
                    this.$project = project;
                    this.$migrationWizard = generateMigrationWizard;
                    this.$databaseClassQualifiedName = string;
                    this.$databaseUpdate = databaseUpdate;
                }
            });
        }
    }

    private final PsiDirectory getMigrationDefaultTargetDirectory(Project project, Module module2) {
        PsiDirectory psiDirectory;
        Object[] objectArray = ProjectUtil.getRootManager((Module)module2).getContentEntries();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"module.rootManager.contentEntries");
        VirtualFile virtualFile = (VirtualFile)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.flatMap((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)getMigrationDefaultTargetDirectory.1.INSTANCE), (Function1)getMigrationDefaultTargetDirectory.2.INSTANCE), (Function1)getMigrationDefaultTargetDirectory.3.INSTANCE));
        if (virtualFile != null) {
            VirtualFile virtualFile2 = virtualFile;
            boolean bl = false;
            boolean bl2 = false;
            VirtualFile it = virtualFile2;
            boolean bl3 = false;
            psiDirectory = PsiManager.getInstance((Project)project).findDirectory(it);
        } else {
            psiDirectory = null;
        }
        return psiDirectory;
    }

    private final PsiDirectory getTestDefaultTargetDirectory(Project project, Module module2) {
        PsiDirectory psiDirectory;
        TestArtifactSearchScopes testScopes = TestArtifactSearchScopes.Companion.getInstance(module2);
        Object[] objectArray = ProjectUtil.getRootManager((Module)module2).getContentEntries();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"module.rootManager.contentEntries");
        VirtualFile virtualFile = (VirtualFile)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.flatMap((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)getTestDefaultTargetDirectory.1.INSTANCE), (Function1)getTestDefaultTargetDirectory.2.INSTANCE), (Function1)getTestDefaultTargetDirectory.3.INSTANCE), (Function1)((Function1)new Function1<VirtualFile, Boolean>(testScopes){
            final /* synthetic */ TestArtifactSearchScopes $testScopes;

            public final boolean invoke(@NotNull VirtualFile it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                TestArtifactSearchScopes testArtifactSearchScopes = this.$testScopes;
                return testArtifactSearchScopes != null ? testArtifactSearchScopes.isAndroidTestSource(it) : true;
            }
            {
                this.$testScopes = testArtifactSearchScopes;
                super(1);
            }
        })));
        if (virtualFile != null) {
            VirtualFile virtualFile2 = virtualFile;
            boolean bl = false;
            boolean bl2 = false;
            VirtualFile it = virtualFile2;
            boolean bl3 = false;
            psiDirectory = PsiManager.getInstance((Project)project).findDirectory(it);
        } else {
            psiDirectory = null;
        }
        return psiDirectory;
    }

    private final PsiPackage getDefaultTargetPackage(String databaseFullyQualifiedName, Project project) {
        String string = StringUtil.getPackageName((String)databaseFullyQualifiedName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.getPackageNam\u2026tabaseFullyQualifiedName)");
        String packageName = string;
        return JavaPsiFacade.getInstance((Project)project).findPackage(packageName);
    }

    private final String getDatabaseClassFullyQualifiedName(Project project, Module module2, VirtualFile schemaJsonFile) {
        VirtualFile virtualFile = schemaJsonFile.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"schemaJsonFile.parent");
        if (!virtualFile.isDirectory()) {
            return null;
        }
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        VirtualFile virtualFile2 = schemaJsonFile.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"schemaJsonFile.parent");
        PsiClass psiClass = javaPsiFacade.findClass(virtualFile2.getName(), module2.getModuleWithDependenciesAndLibrariesScope(false));
        if (psiClass == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"JavaPsiFacade.getInstanc\u2026           ?: return null");
        PsiClass databaseClass = psiClass;
        return databaseClass.getQualifiedName();
    }

    public GenerateRoomMigrationAction() {
        super("Generate a Room migration");
    }
}

