/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resources.base;

import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import com.android.tools.idea.resources.base.Base128InputStream;
import com.android.tools.idea.resources.base.Base128OutputStream;
import com.android.tools.idea.resources.base.BasicResourceItem;
import com.android.tools.idea.resources.base.BasicResourceItemBase;
import com.android.tools.idea.resources.base.BasicStyleResourceItem;
import com.android.tools.idea.resources.base.BasicStyleableResourceItem;
import com.android.tools.idea.resources.base.BasicValueResourceItemBase;
import com.android.tools.idea.resources.base.LoadableResourceRepository;
import com.android.tools.idea.resources.base.NamespaceResolver;
import com.android.tools.idea.resources.base.RepositoryConfiguration;
import com.android.tools.idea.resources.base.ResourceSourceFile;
import com.google.common.collect.ListMultimap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceSerializationUtil {
    private static final Logger LOG = Logger.getInstance(ResourceSerializationUtil.class);

    public static void createPersistentCache(@NotNull Path cacheFile, @NotNull byte[] fileHeader, @NotNull Base128StreamWriter contentWriter) {
        Path tempFile;
        if (cacheFile == null) {
            ResourceSerializationUtil.$$$reportNull$$$0(0);
        }
        if (fileHeader == null) {
            ResourceSerializationUtil.$$$reportNull$$$0(1);
        }
        if (contentWriter == null) {
            ResourceSerializationUtil.$$$reportNull$$$0(2);
        }
        try {
            Files.deleteIfExists(cacheFile);
        }
        catch (IOException e) {
            LOG.warn("Unable to delete " + cacheFile.toString(), (Throwable)e);
        }
        try {
            tempFile = FileUtilRt.createTempFile((File)cacheFile.getParent().toFile(), (String)cacheFile.getFileName().toString(), (String)".tmp").toPath();
        }
        catch (IOException e) {
            LOG.error("Unable to create a temporary file in " + cacheFile.getParent().toString(), (Throwable)e);
            return;
        }
        try (Base128OutputStream stream = new Base128OutputStream(tempFile);){
            stream.write(fileHeader);
            contentWriter.write(stream);
        }
        catch (Throwable e) {
            LOG.error("Unable to create cache file " + tempFile.toString(), e);
            ResourceSerializationUtil.deleteIgnoringErrors(tempFile);
            return;
        }
        try {
            Files.move(tempFile, cacheFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (NoSuchFileException e) {
        }
        catch (IOException e) {
            LOG.error("Unable to create cache file " + cacheFile.toString(), (Throwable)e);
            ResourceSerializationUtil.deleteIgnoringErrors(tempFile);
        }
    }

    public static void writeResourcesToStream(@NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> resources, @NotNull Base128OutputStream stream, @NotNull Predicate<FolderConfiguration> configFilter) throws IOException {
        FolderConfiguration configuration;
        if (resources == null) {
            ResourceSerializationUtil.$$$reportNull$$$0(3);
        }
        if (stream == null) {
            ResourceSerializationUtil.$$$reportNull$$$0(4);
        }
        if (configFilter == null) {
            ResourceSerializationUtil.$$$reportNull$$$0(5);
        }
        Object2IntOpenHashMap qualifierStringIndexes = new Object2IntOpenHashMap();
        qualifierStringIndexes.defaultReturnValue(-1);
        Object2IntOpenHashMap sourceFileIndexes = new Object2IntOpenHashMap();
        sourceFileIndexes.defaultReturnValue(-1);
        Object2IntOpenHashMap namespaceResolverIndexes = new Object2IntOpenHashMap();
        namespaceResolverIndexes.defaultReturnValue(-1);
        int itemCount = 0;
        Collection<ListMultimap<String, ResourceItem>> resourceMaps = resources.values();
        for (ListMultimap<String, ResourceItem> resourceMap : resourceMaps) {
            for (ResourceItem item : resourceMap.values()) {
                ResourceSourceFile sourceFile;
                configuration = item.getConfiguration();
                if (!configFilter.test(configuration)) continue;
                String qualifier = configuration.getQualifierString();
                if (!qualifierStringIndexes.containsKey((Object)qualifier)) {
                    qualifierStringIndexes.put((Object)qualifier, qualifierStringIndexes.size());
                }
                if (item instanceof BasicValueResourceItemBase && !sourceFileIndexes.containsKey((Object)(sourceFile = ((BasicValueResourceItemBase)item).getSourceFile()))) {
                    sourceFileIndexes.put((Object)sourceFile, sourceFileIndexes.size());
                }
                if (item instanceof ResourceValue) {
                    ResourceSerializationUtil.addToNamespaceResolverIndexes(((ResourceValue)item).getNamespaceResolver(), (Object2IntMap<ResourceNamespace.Resolver>)namespaceResolverIndexes);
                }
                if (item instanceof BasicStyleResourceItem) {
                    for (StyleItemResourceValue styleItem : ((BasicStyleResourceItem)item).getDefinedItems()) {
                        ResourceSerializationUtil.addToNamespaceResolverIndexes(styleItem.getNamespaceResolver(), (Object2IntMap<ResourceNamespace.Resolver>)namespaceResolverIndexes);
                    }
                } else if (item instanceof BasicStyleableResourceItem) {
                    for (AttrResourceValue attr2 : ((BasicStyleableResourceItem)item).getAllAttributes()) {
                        ResourceSerializationUtil.addToNamespaceResolverIndexes(attr2.getNamespaceResolver(), (Object2IntMap<ResourceNamespace.Resolver>)namespaceResolverIndexes);
                    }
                }
                ++itemCount;
            }
        }
        ResourceSerializationUtil.writeStrings((Object2IntMap<String>)qualifierStringIndexes, stream);
        ResourceSerializationUtil.writeSourceFiles((Object2IntMap<ResourceSourceFile>)sourceFileIndexes, stream, (Object2IntMap<String>)qualifierStringIndexes);
        ResourceSerializationUtil.writeNamespaceResolvers((Object2IntMap<ResourceNamespace.Resolver>)namespaceResolverIndexes, stream);
        stream.writeInt(itemCount);
        for (ListMultimap<String, ResourceItem> resourceMap : resourceMaps) {
            for (ResourceItem item : resourceMap.values()) {
                configuration = item.getConfiguration();
                if (!configFilter.test(configuration)) continue;
                ((BasicResourceItemBase)item).serialize(stream, (Object2IntMap<String>)qualifierStringIndexes, (Object2IntMap<ResourceSourceFile>)sourceFileIndexes, (Object2IntMap<ResourceNamespace.Resolver>)namespaceResolverIndexes);
            }
        }
    }

    private static void addToNamespaceResolverIndexes(@NotNull ResourceNamespace.Resolver resolver, @NotNull Object2IntMap<ResourceNamespace.Resolver> namespaceResolverIndexes) {
        if (resolver == null) {
            ResourceSerializationUtil.$$$reportNull$$$0(6);
        }
        if (namespaceResolverIndexes == null) {
            ResourceSerializationUtil.$$$reportNull$$$0(7);
        }
        if (!namespaceResolverIndexes.containsKey((Object)resolver)) {
            namespaceResolverIndexes.put((Object)resolver, namespaceResolverIndexes.size());
        }
    }

    public static void readResourcesFromStream(@NotNull Base128InputStream stream, @NotNull Map<String, String> stringCache, @Nullable Map<NamespaceResolver, NamespaceResolver> namespaceResolverCache, @NotNull LoadableResourceRepository repository, @NotNull Consumer<BasicResourceItem> resourceConsumer) throws IOException {
        int i2;
        if (stream == null) {
            ResourceSerializationUtil.$$$reportNull$$$0(8);
        }
        if (stringCache == null) {
            ResourceSerializationUtil.$$$reportNull$$$0(9);
        }
        if (repository == null) {
            ResourceSerializationUtil.$$$reportNull$$$0(10);
        }
        if (resourceConsumer == null) {
            ResourceSerializationUtil.$$$reportNull$$$0(11);
        }
        stream.setStringCache(stringCache);
        int n = stream.readInt();
        if (n == 0) {
            return;
        }
        ArrayList<RepositoryConfiguration> configurations = new ArrayList<RepositoryConfiguration>(n);
        for (int i3 = 0; i3 < n; ++i3) {
            String configQualifier = stream.readString();
            if (configQualifier == null) {
                throw Base128InputStream.StreamFormatException.invalidFormat();
            }
            FolderConfiguration folderConfig = FolderConfiguration.getConfigForQualifierString((String)configQualifier);
            if (folderConfig == null) {
                throw Base128InputStream.StreamFormatException.invalidFormat();
            }
            configurations.add(new RepositoryConfiguration(repository, folderConfig));
        }
        n = stream.readInt();
        ArrayList<ResourceSourceFile> newSourceFiles = new ArrayList<ResourceSourceFile>(n);
        for (int i4 = 0; i4 < n; ++i4) {
            ResourceSourceFile sourceFile = repository.deserializeResourceSourceFile(stream, configurations);
            newSourceFiles.add(sourceFile);
        }
        n = stream.readInt();
        ArrayList<ResourceNamespace.Resolver> newNamespaceResolvers = new ArrayList<ResourceNamespace.Resolver>(n);
        for (i2 = 0; i2 < n; ++i2) {
            NamespaceResolver namespaceResolver2 = NamespaceResolver.deserialize(stream);
            if (namespaceResolverCache != null) {
                namespaceResolver2 = namespaceResolverCache.computeIfAbsent(namespaceResolver2, Function.identity());
            }
            newNamespaceResolvers.add(namespaceResolver2);
        }
        n = stream.readInt();
        for (i2 = 0; i2 < n; ++i2) {
            BasicResourceItemBase item = BasicResourceItemBase.deserialize(stream, configurations, newSourceFiles, newNamespaceResolvers);
            resourceConsumer.accept(item);
        }
    }

    @NotNull
    public static byte[] getCacheFileHeader(@NotNull Base128StreamWriter headerWriter) {
        if (headerWriter == null) {
            ResourceSerializationUtil.$$$reportNull$$$0(12);
        }
        ByteArrayOutputStream header = new ByteArrayOutputStream();
        try (Base128OutputStream stream = new Base128OutputStream(header);){
            headerWriter.write(stream);
        }
        catch (IOException e) {
            throw new Error("Internal error", e);
        }
        byte[] byArray = header.toByteArray();
        if (byArray == null) {
            ResourceSerializationUtil.$$$reportNull$$$0(13);
        }
        return byArray;
    }

    private static void deleteIgnoringErrors(@NotNull Path file2) {
        if (file2 == null) {
            ResourceSerializationUtil.$$$reportNull$$$0(14);
        }
        try {
            Files.deleteIfExists(file2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static <K> void writeStrings(@NotNull Object2IntMap<String> qualifierStringIndexes, @NotNull Base128OutputStream stream) throws IOException {
        if (qualifierStringIndexes == null) {
            ResourceSerializationUtil.$$$reportNull$$$0(15);
        }
        if (stream == null) {
            ResourceSerializationUtil.$$$reportNull$$$0(16);
        }
        String[] strings = new String[qualifierStringIndexes.size()];
        for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(qualifierStringIndexes)) {
            strings[entry.getIntValue()] = (String)entry.getKey();
        }
        stream.writeInt(strings.length);
        for (String str : strings) {
            stream.writeString(str);
        }
    }

    private static void writeSourceFiles(@NotNull Object2IntMap<ResourceSourceFile> sourceFileIndexes, @NotNull Base128OutputStream stream, @NotNull Object2IntMap<String> qualifierStringIndexes) throws IOException {
        if (sourceFileIndexes == null) {
            ResourceSerializationUtil.$$$reportNull$$$0(17);
        }
        if (stream == null) {
            ResourceSerializationUtil.$$$reportNull$$$0(18);
        }
        if (qualifierStringIndexes == null) {
            ResourceSerializationUtil.$$$reportNull$$$0(19);
        }
        ResourceSourceFile[] sourceFiles = new ResourceSourceFile[sourceFileIndexes.size()];
        for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(sourceFileIndexes)) {
            sourceFiles[entry.getIntValue()] = (ResourceSourceFile)entry.getKey();
        }
        stream.writeInt(sourceFiles.length);
        for (ResourceSourceFile sourceFile : sourceFiles) {
            sourceFile.serialize(stream, qualifierStringIndexes);
        }
    }

    private static void writeNamespaceResolvers(@NotNull Object2IntMap<ResourceNamespace.Resolver> namespaceResolverIndexes, @NotNull Base128OutputStream stream) throws IOException {
        if (namespaceResolverIndexes == null) {
            ResourceSerializationUtil.$$$reportNull$$$0(20);
        }
        if (stream == null) {
            ResourceSerializationUtil.$$$reportNull$$$0(21);
        }
        ResourceNamespace.Resolver[] resolvers = new ResourceNamespace.Resolver[namespaceResolverIndexes.size()];
        for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(namespaceResolverIndexes)) {
            resolvers[entry.getIntValue()] = (ResourceNamespace.Resolver)entry.getKey();
        }
        stream.writeInt(resolvers.length);
        for (ResourceNamespace.Resolver resolver : resolvers) {
            NamespaceResolver serializableResolver = resolver == ResourceNamespace.Resolver.EMPTY_RESOLVER ? NamespaceResolver.EMPTY : (NamespaceResolver)resolver;
            serializableResolver.serialize(stream);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileHeader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentWriter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resources";
                break;
            }
            case 4: 
            case 8: 
            case 16: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFilter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 7: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceResolverIndexes";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringCache";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceConsumer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerWriter";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/resources/base/ResourceSerializationUtil";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierStringIndexes";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFileIndexes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/resources/base/ResourceSerializationUtil";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCacheFileHeader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPersistentCache";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeResourcesToStream";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addToNamespaceResolverIndexes";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readResourcesFromStream";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCacheFileHeader";
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "deleteIgnoringErrors";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "writeStrings";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "writeSourceFiles";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "writeNamespaceResolvers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface Base128StreamWriter {
        public void write(@NotNull Base128OutputStream var1) throws IOException;
    }
}

