/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resources.base;

import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.DensityBasedResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValueImpl;
import com.android.ide.common.resources.AndroidAaptIgnore;
import com.android.ide.common.resources.PatternBasedFileFilter;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourcesUtil;
import com.android.ide.common.resources.ValueResourceNameValidator;
import com.android.ide.common.resources.ValueXmlHelper;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.util.PathString;
import com.android.resources.Arity;
import com.android.resources.Density;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.tools.idea.resources.base.BasicArrayResourceItem;
import com.android.tools.idea.resources.base.BasicAttrResourceItem;
import com.android.tools.idea.resources.base.BasicDensityBasedFileResourceItem;
import com.android.tools.idea.resources.base.BasicFileResourceItem;
import com.android.tools.idea.resources.base.BasicForeignAttrResourceItem;
import com.android.tools.idea.resources.base.BasicPluralsResourceItem;
import com.android.tools.idea.resources.base.BasicResourceItem;
import com.android.tools.idea.resources.base.BasicResourceItemBase;
import com.android.tools.idea.resources.base.BasicStyleResourceItem;
import com.android.tools.idea.resources.base.BasicStyleableResourceItem;
import com.android.tools.idea.resources.base.BasicTextValueResourceItem;
import com.android.tools.idea.resources.base.BasicValueResourceItem;
import com.android.tools.idea.resources.base.BasicValueResourceItemBase;
import com.android.tools.idea.resources.base.CommentTrackingXmlPullParser;
import com.android.tools.idea.resources.base.FileFilter;
import com.android.tools.idea.resources.base.LoadableResourceRepository;
import com.android.tools.idea.resources.base.RepositoryConfiguration;
import com.android.tools.idea.resources.base.ResourceSourceFile;
import com.android.tools.idea.resources.base.ResourceSourceFileImpl;
import com.android.tools.idea.resources.base.ResourceUrlParser;
import com.android.tools.idea.resources.base.ValueResourceXmlParser;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class RepositoryLoader<T extends LoadableResourceRepository>
implements FileFilter {
    private static final Logger LOG = Logger.getInstance(RepositoryLoader.class);
    private final Set<AttributeFormat> DEFAULT_ATTR_FORMATS;
    private final PatternBasedFileFilter myFileFilter;
    @NotNull
    private final Map<ResourceType, Set<String>> myPublicResources;
    @NotNull
    private final ListMultimap<String, BasicAttrResourceItem> myAttrs;
    @NotNull
    private final ListMultimap<String, BasicAttrResourceItem> myAttrCandidates;
    @NotNull
    private final ListMultimap<String, BasicStyleableResourceItem> myStyleables;
    @NotNull
    protected ResourceVisibility myDefaultVisibility;
    @NotNull
    protected final Map<String, FolderConfiguration> myFolderConfigCache;
    @NotNull
    private final Map<FolderConfiguration, RepositoryConfiguration> myConfigCache;
    @NotNull
    private final ValueResourceXmlParser myParser;
    @NotNull
    private final XmlTextExtractor myTextExtractor;
    @NotNull
    private final ResourceUrlParser myUrlParser;
    @NotNull
    private final Table<ResourceType, String, BasicValueResourceItemBase> myValueFileResources;
    @NotNull
    protected final Path myResourceDirectoryOrFile;
    @NotNull
    private final PathString myResourceDirectoryOrFilePath;
    private final boolean myLoadingFromZipArchive;
    @NotNull
    private final ResourceNamespace myNamespace;
    @Nullable
    private final Collection<PathString> myResourceFilesAndFolders;
    @Nullable
    protected ZipFile myZipFile;

    public RepositoryLoader(@NotNull Path resourceDirectoryOrFile, @Nullable Collection<PathString> resourceFilesAndFolders, @NotNull ResourceNamespace namespace) {
        if (resourceDirectoryOrFile == null) {
            RepositoryLoader.$$$reportNull$$$0(0);
        }
        if (namespace == null) {
            RepositoryLoader.$$$reportNull$$$0(1);
        }
        this.DEFAULT_ATTR_FORMATS = Sets.immutableEnumSet((Enum)AttributeFormat.BOOLEAN, (Enum[])new AttributeFormat[]{AttributeFormat.COLOR, AttributeFormat.DIMENSION, AttributeFormat.FLOAT, AttributeFormat.FRACTION, AttributeFormat.INTEGER, AttributeFormat.REFERENCE, AttributeFormat.STRING});
        this.myFileFilter = new PatternBasedFileFilter(new AndroidAaptIgnore(System.getenv("ANDROID_AAPT_IGNORE")));
        this.myPublicResources = new EnumMap<ResourceType, Set<String>>(ResourceType.class);
        this.myAttrs = ArrayListMultimap.create();
        this.myAttrCandidates = ArrayListMultimap.create();
        this.myStyleables = ArrayListMultimap.create();
        this.myDefaultVisibility = ResourceVisibility.PRIVATE;
        this.myFolderConfigCache = new HashMap<String, FolderConfiguration>();
        this.myConfigCache = new HashMap<FolderConfiguration, RepositoryConfiguration>();
        this.myParser = new ValueResourceXmlParser();
        this.myTextExtractor = new XmlTextExtractor();
        this.myUrlParser = new ResourceUrlParser();
        this.myValueFileResources = Tables.newCustomTable(new EnumMap(ResourceType.class), () -> new LinkedHashMap());
        this.myResourceDirectoryOrFile = resourceDirectoryOrFile;
        this.myResourceDirectoryOrFilePath = new PathString(this.myResourceDirectoryOrFile);
        this.myLoadingFromZipArchive = RepositoryLoader.isZipArchive(resourceDirectoryOrFile);
        this.myNamespace = namespace;
        this.myResourceFilesAndFolders = resourceFilesAndFolders;
    }

    @NotNull
    public final Path getResourceDirectoryOrFile() {
        Path path2 = this.myResourceDirectoryOrFile;
        if (path2 == null) {
            RepositoryLoader.$$$reportNull$$$0(2);
        }
        return path2;
    }

    public final boolean isLoadingFromZipArchive() {
        return this.myLoadingFromZipArchive;
    }

    @NotNull
    public final ResourceNamespace getNamespace() {
        ResourceNamespace resourceNamespace = this.myNamespace;
        if (resourceNamespace == null) {
            RepositoryLoader.$$$reportNull$$$0(3);
        }
        return resourceNamespace;
    }

    public void loadRepositoryContents(@NotNull T repository) {
        if (repository == null) {
            RepositoryLoader.$$$reportNull$$$0(4);
        }
        if (this.myLoadingFromZipArchive) {
            this.loadFromZip(repository);
        } else {
            this.loadFromResFolder(repository);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFromZip(@NotNull T repository) {
        if (repository == null) {
            RepositoryLoader.$$$reportNull$$$0(5);
        }
        try (ZipFile zipFile = new ZipFile(this.myResourceDirectoryOrFile.toFile());){
            this.myZipFile = zipFile;
            this.loadPublicResourceNames();
            boolean shouldParseResourceIds = !this.loadIdsFromRTxt();
            zipFile.stream().forEach(zipEntry -> {
                if (!zipEntry.isDirectory()) {
                    PathString path2 = new PathString(zipEntry.getName());
                    this.loadResourceFile(path2, repository, shouldParseResourceIds);
                }
            });
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Failed to load resources from " + this.myResourceDirectoryOrFile.toString(), (Throwable)e);
        }
        finally {
            this.myZipFile = null;
        }
        this.finishLoading(repository);
    }

    protected void loadFromResFolder(@NotNull T repository) {
        if (repository == null) {
            RepositoryLoader.$$$reportNull$$$0(6);
        }
        try {
            if (Files.notExists(this.myResourceDirectoryOrFile, new LinkOption[0])) {
                return;
            }
            this.loadPublicResourceNames();
            boolean shouldParseResourceIds = !this.loadIdsFromRTxt();
            Object sourceFilesAndFolders = this.myResourceFilesAndFolders == null ? ImmutableList.of((Object)this.myResourceDirectoryOrFile) : ContainerUtil.map(this.myResourceFilesAndFolders, PathString::toPath);
            List<PathString> resourceFiles = this.findResourceFiles((List<Path>)sourceFilesAndFolders);
            for (PathString file2 : resourceFiles) {
                this.loadResourceFile(file2, repository, shouldParseResourceIds);
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Failed to load resources from " + this.myResourceDirectoryOrFile.toString(), (Throwable)e);
        }
        this.finishLoading(repository);
    }

    protected final void loadResourceFile(@NotNull PathString file2, @NotNull T repository, boolean shouldParseResourceIds) {
        FolderInfo folderInfo;
        String folderName;
        if (file2 == null) {
            RepositoryLoader.$$$reportNull$$$0(7);
        }
        if (repository == null) {
            RepositoryLoader.$$$reportNull$$$0(8);
        }
        if ((folderName = file2.getParentFileName()) != null && (folderInfo = FolderInfo.create(folderName, this.myFolderConfigCache)) != null) {
            RepositoryConfiguration configuration = this.getConfiguration(repository, folderInfo.configuration);
            this.loadResourceFile(file2, folderInfo, configuration, shouldParseResourceIds);
        }
    }

    protected void finishLoading(@NotNull T repository) {
        if (repository == null) {
            RepositoryLoader.$$$reportNull$$$0(9);
        }
        this.processAttrsAndStyleables();
    }

    @NotNull
    public final String getSourceFileProtocol() {
        if (this.myLoadingFromZipArchive) {
            return "jar";
        }
        return "file";
    }

    @NotNull
    public final String getResourcePathPrefix() {
        if (this.myLoadingFromZipArchive) {
            String string = RepositoryLoader.portableFileName(this.myResourceDirectoryOrFile.toString()) + "!/res/";
            if (string == null) {
                RepositoryLoader.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = RepositoryLoader.portableFileName(this.myResourceDirectoryOrFile.toString()) + "/";
        if (string == null) {
            RepositoryLoader.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public final String getResourceUrlPrefix() {
        if (this.myLoadingFromZipArchive) {
            String string = "jar://" + RepositoryLoader.portableFileName(this.myResourceDirectoryOrFile.toString()) + "!/res/";
            if (string == null) {
                RepositoryLoader.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = RepositoryLoader.portableFileName(this.myResourceDirectoryOrFile.toString()) + "/";
        if (string == null) {
            RepositoryLoader.$$$reportNull$$$0(13);
        }
        return string;
    }

    protected boolean loadIdsFromRTxt() {
        return false;
    }

    @Override
    public boolean isIgnored(@NotNull Path fileOrDirectory, @NotNull BasicFileAttributes attrs) {
        if (fileOrDirectory == null) {
            RepositoryLoader.$$$reportNull$$$0(14);
        }
        if (attrs == null) {
            RepositoryLoader.$$$reportNull$$$0(15);
        }
        if (fileOrDirectory.equals(this.myResourceDirectoryOrFile)) {
            return false;
        }
        return this.myFileFilter.isIgnored(fileOrDirectory.toString(), attrs.isDirectory());
    }

    protected void loadPublicResourceNames() {
        Path valuesFolder = this.myResourceDirectoryOrFile.resolve("values");
        Path publicXmlFile = valuesFolder.resolve("public.xml");
        try (BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(publicXmlFile, new OpenOption[0]));){
            CommentTrackingXmlPullParser parser = new CommentTrackingXmlPullParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
            parser.setInput(stream, StandardCharsets.UTF_8.name());
            ResourceType groupType = null;
            ResourceType lastType = null;
            String lastTypeName = "";
            while (true) {
                int event;
                if ((event = parser.nextToken()) == 2) {
                    if (parser.getName().equals("public")) {
                        ResourceType type;
                        String name = null;
                        String typeName = groupType == null ? null : groupType.getName();
                        int n = parser.getAttributeCount();
                        for (int i2 = 0; i2 < n; ++i2) {
                            String attribute = parser.getAttributeName(i2);
                            if (attribute.equals("name")) {
                                name = parser.getAttributeValue(i2);
                                if (typeName == null) continue;
                                break;
                            }
                            if (!attribute.equals("type")) continue;
                            typeName = parser.getAttributeValue(i2);
                        }
                        if (name == null || name.startsWith("__removed") || typeName == null && groupType == null || parser.getLastComment() != null && RepositoryLoader.containsWord(parser.getLastComment(), "@hide")) continue;
                        if (groupType != null) {
                            type = groupType;
                        } else if (typeName.equals(lastTypeName)) {
                            type = lastType;
                        } else {
                            lastType = type = ResourceType.fromXmlValue((String)typeName);
                            lastTypeName = typeName;
                        }
                        if (type != null) {
                            this.addPublicResourceName(type, name);
                            continue;
                        }
                        LOG.error("Public resource declaration \"" + name + "\" of type " + typeName + " points to unknown resource type.");
                        continue;
                    }
                    if (!parser.getName().equals("public-group")) continue;
                    String typeName = parser.getAttributeValue(null, "type");
                    groupType = typeName == null ? null : ResourceType.fromXmlValue((String)typeName);
                    continue;
                }
                if (event == 3) {
                    if (!parser.getName().equals("public-group")) continue;
                    groupType = null;
                    continue;
                }
                if (event == 1) break;
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (NoSuchFileException e) {
        }
        catch (Exception e) {
            LOG.error("Can't read and parse " + publicXmlFile.toString(), (Throwable)e);
        }
    }

    protected final void addPublicResourceName(ResourceType type, String name) {
        Set names = this.myPublicResources.computeIfAbsent(type, t -> new HashSet());
        names.add(name);
    }

    private static boolean containsWord(@NotNull String text2, @NotNull String word) {
        int start2;
        if (text2 == null) {
            RepositoryLoader.$$$reportNull$$$0(16);
        }
        if (word == null) {
            RepositoryLoader.$$$reportNull$$$0(17);
        }
        int end = 0;
        do {
            if ((start2 = text2.indexOf(word, end)) < 0) {
                return false;
            }
            end = start2 + word.length();
        } while (start2 != 0 && !Character.isWhitespace(text2.charAt(start2)) || end != text2.length() && !Character.isWhitespace(text2.charAt(end)));
        return true;
    }

    @NotNull
    private List<PathString> findResourceFiles(@NotNull List<Path> filesOrFolders) {
        if (filesOrFolders == null) {
            RepositoryLoader.$$$reportNull$$$0(18);
        }
        ResourceFileCollector fileCollector = new ResourceFileCollector(this);
        for (Path file2 : filesOrFolders) {
            try {
                Files.walkFileTree(file2, fileCollector);
            }
            catch (IOException iOException) {}
        }
        for (IOException e : fileCollector.ioErrors) {
            LOG.error("Error loading resources from " + this.myResourceDirectoryOrFile.toString(), (Throwable)e);
        }
        Collections.sort(fileCollector.resourceFiles);
        List<PathString> list = fileCollector.resourceFiles;
        if (list == null) {
            RepositoryLoader.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    protected final RepositoryConfiguration getConfiguration(@NotNull T repository, @NotNull FolderConfiguration folderConfiguration) {
        RepositoryConfiguration repositoryConfiguration;
        if (repository == null) {
            RepositoryLoader.$$$reportNull$$$0(20);
        }
        if (folderConfiguration == null) {
            RepositoryLoader.$$$reportNull$$$0(21);
        }
        if ((repositoryConfiguration = this.myConfigCache.get(folderConfiguration)) != null) {
            RepositoryConfiguration repositoryConfiguration2 = repositoryConfiguration;
            if (repositoryConfiguration2 == null) {
                RepositoryLoader.$$$reportNull$$$0(22);
            }
            return repositoryConfiguration2;
        }
        repositoryConfiguration = new RepositoryConfiguration((LoadableResourceRepository)repository, folderConfiguration);
        this.myConfigCache.put(folderConfiguration, repositoryConfiguration);
        RepositoryConfiguration repositoryConfiguration3 = repositoryConfiguration;
        if (repositoryConfiguration3 == null) {
            RepositoryLoader.$$$reportNull$$$0(23);
        }
        return repositoryConfiguration3;
    }

    private void loadResourceFile(@NotNull PathString file2, @NotNull FolderInfo folderInfo, @NotNull RepositoryConfiguration configuration, boolean shouldParseResourceIds) {
        if (file2 == null) {
            RepositoryLoader.$$$reportNull$$$0(24);
        }
        if (folderInfo == null) {
            RepositoryLoader.$$$reportNull$$$0(25);
        }
        if (configuration == null) {
            RepositoryLoader.$$$reportNull$$$0(26);
        }
        if (folderInfo.resourceType == null) {
            if (RepositoryLoader.isXmlFile(file2)) {
                this.parseValueResourceFile(file2, configuration);
            }
        } else {
            if (shouldParseResourceIds && folderInfo.isIdGenerating && RepositoryLoader.isXmlFile(file2)) {
                this.parseIdGeneratingResourceFile(file2, configuration);
            }
            BasicFileResourceItem item = this.createFileResourceItem(file2, folderInfo.resourceType, configuration);
            this.addResourceItem(item);
        }
    }

    protected static boolean isXmlFile(@NotNull PathString file2) {
        if (file2 == null) {
            RepositoryLoader.$$$reportNull$$$0(27);
        }
        return RepositoryLoader.isXmlFile(file2.getFileName());
    }

    protected static boolean isXmlFile(@NotNull String filename) {
        if (filename == null) {
            RepositoryLoader.$$$reportNull$$$0(28);
        }
        return SdkUtils.endsWithIgnoreCase((String)filename, (String)".xml");
    }

    private void addResourceItem(@NotNull BasicResourceItemBase item) {
        if (item == null) {
            RepositoryLoader.$$$reportNull$$$0(29);
        }
        this.addResourceItem(item, item.getRepository());
    }

    protected abstract void addResourceItem(@NotNull BasicResourceItem var1, @NotNull T var2);

    protected final void parseValueResourceFile(@NotNull PathString file2, @NotNull RepositoryConfiguration configuration) {
        if (file2 == null) {
            RepositoryLoader.$$$reportNull$$$0(30);
        }
        if (configuration == null) {
            RepositoryLoader.$$$reportNull$$$0(31);
        }
        try (InputStream stream = this.getInputStream(file2);){
            int event;
            ResourceSourceFile sourceFile = this.createResourceSourceFile(file2, configuration);
            this.myParser.setInput(stream, null);
            do {
                String resourceName;
                ResourceType resourceType;
                event = this.myParser.nextToken();
                int depth = this.myParser.getDepth();
                if (event != 2 || this.myParser.getPrefix() != null) continue;
                String tagName = this.myParser.getName();
                assert (depth <= 2);
                if (depth == 1) {
                    if (tagName.equals("resources")) continue;
                    break;
                }
                if (depth <= 1 || (resourceType = this.getResourceType(tagName, file2)) == null || resourceType == ResourceType.PUBLIC || (resourceName = this.myParser.getAttributeValue(null, "name")) == null) continue;
                this.validateResourceName(resourceName, resourceType, file2);
                BasicValueResourceItemBase item = this.createResourceItem(resourceType, resourceName, sourceFile);
                this.addValueResourceItem(item);
            } while (event != 1);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (XmlSyntaxException | IOException | RuntimeException | XmlPullParserException e) {
            this.handleParsingError(file2, (Exception)e);
        }
        this.addValueFileResources();
    }

    @NotNull
    protected ResourceSourceFile createResourceSourceFile(@NotNull PathString file2, @NotNull RepositoryConfiguration configuration) {
        if (file2 == null) {
            RepositoryLoader.$$$reportNull$$$0(32);
        }
        if (configuration == null) {
            RepositoryLoader.$$$reportNull$$$0(33);
        }
        return new ResourceSourceFileImpl(this.getResRelativePath(file2), configuration);
    }

    private void addValueResourceItem(@NotNull BasicValueResourceItemBase item) {
        ResourceType resourceType;
        if (item == null) {
            RepositoryLoader.$$$reportNull$$$0(34);
        }
        if ((resourceType = item.getType()) == ResourceType.ATTR) {
            RepositoryLoader.addAttr((BasicAttrResourceItem)item, this.myAttrs);
        } else if (resourceType == ResourceType.STYLEABLE) {
            this.myStyleables.put((Object)item.getName(), (Object)((BasicStyleableResourceItem)item));
        } else {
            this.myValueFileResources.put((Object)resourceType, (Object)item.getName(), (Object)item);
        }
    }

    protected final void addValueFileResources() {
        for (BasicValueResourceItemBase item : this.myValueFileResources.values()) {
            this.addResourceItem(item);
        }
        this.myValueFileResources.clear();
    }

    protected final void parseIdGeneratingResourceFile(@NotNull PathString file2, @NotNull RepositoryConfiguration configuration) {
        if (file2 == null) {
            RepositoryLoader.$$$reportNull$$$0(35);
        }
        if (configuration == null) {
            RepositoryLoader.$$$reportNull$$$0(36);
        }
        try (InputStream stream = this.getInputStream(file2);){
            int event;
            ResourceSourceFile sourceFile = this.createResourceSourceFile(file2, configuration);
            KXmlParser parser = new KXmlParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser.setInput(stream, null);
            do {
                if ((event = parser.nextToken()) != 2) continue;
                int numAttributes = parser.getAttributeCount();
                for (int i2 = 0; i2 < numAttributes; ++i2) {
                    String idValue = parser.getAttributeValue(i2);
                    if (!idValue.startsWith("@+id/") || idValue.length() <= "@+id/".length()) continue;
                    String resourceName = idValue.substring("@+id/".length());
                    this.addIdResourceItem(resourceName, sourceFile);
                }
            } while (event != 1);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (IOException | RuntimeException | XmlPullParserException e) {
            this.handleParsingError(file2, (Exception)e);
        }
        this.addValueFileResources();
    }

    protected void handleParsingError(@NotNull PathString file2, @NotNull Exception e) {
        if (file2 == null) {
            RepositoryLoader.$$$reportNull$$$0(37);
        }
        if (e == null) {
            RepositoryLoader.$$$reportNull$$$0(38);
        }
        LOG.warn("Failed to parse " + file2.toString(), (Throwable)e);
    }

    @NotNull
    protected InputStream getInputStream(@NotNull PathString file2) throws IOException {
        if (file2 == null) {
            RepositoryLoader.$$$reportNull$$$0(39);
        }
        if (this.myZipFile == null) {
            Path path2 = file2.toPath();
            Preconditions.checkArgument((path2 != null ? 1 : 0) != 0);
            return new BufferedInputStream(Files.newInputStream(path2, new OpenOption[0]));
        }
        ZipEntry entry = this.myZipFile.getEntry(file2.getPortablePath());
        if (entry == null) {
            throw new NoSuchFileException(file2.getPortablePath());
        }
        return new BufferedInputStream(this.myZipFile.getInputStream(entry));
    }

    protected final void addIdResourceItem(@NotNull String resourceName, @NotNull ResourceSourceFile sourceFile) {
        ResourceVisibility visibility;
        BasicValueResourceItem item;
        if (resourceName == null) {
            RepositoryLoader.$$$reportNull$$$0(40);
        }
        if (sourceFile == null) {
            RepositoryLoader.$$$reportNull$$$0(41);
        }
        if (!RepositoryLoader.resourceAlreadyDefined(item = new BasicValueResourceItem(ResourceType.ID, resourceName, sourceFile, visibility = this.getVisibility(ResourceType.ID, resourceName), null))) {
            this.addValueResourceItem(item);
        }
    }

    @NotNull
    private BasicFileResourceItem createFileResourceItem(@NotNull PathString file2, @NotNull ResourceType resourceType, @NotNull RepositoryConfiguration configuration) {
        DensityQualifier densityQualifier;
        if (file2 == null) {
            RepositoryLoader.$$$reportNull$$$0(42);
        }
        if (resourceType == null) {
            RepositoryLoader.$$$reportNull$$$0(43);
        }
        if (configuration == null) {
            RepositoryLoader.$$$reportNull$$$0(44);
        }
        String resourceName = SdkUtils.fileNameToResourceName((String)file2.getFileName());
        ResourceVisibility visibility = this.getVisibility(resourceType, resourceName);
        Density density = null;
        if (DensityBasedResourceValue.isDensityBasedResourceType((ResourceType)resourceType) && (densityQualifier = configuration.getFolderConfiguration().getDensityQualifier()) != null) {
            density = densityQualifier.getValue();
        }
        return this.createFileResourceItem(file2, resourceType, resourceName, configuration, visibility, density);
    }

    @NotNull
    protected final BasicFileResourceItem createFileResourceItem(@NotNull PathString file2, @NotNull ResourceType type, @NotNull String name, @NotNull RepositoryConfiguration configuration, @NotNull ResourceVisibility visibility, @Nullable Density density) {
        if (file2 == null) {
            RepositoryLoader.$$$reportNull$$$0(45);
        }
        if (type == null) {
            RepositoryLoader.$$$reportNull$$$0(46);
        }
        if (name == null) {
            RepositoryLoader.$$$reportNull$$$0(47);
        }
        if (configuration == null) {
            RepositoryLoader.$$$reportNull$$$0(48);
        }
        if (visibility == null) {
            RepositoryLoader.$$$reportNull$$$0(49);
        }
        String relativePath = this.getResRelativePath(file2);
        return density == null ? new BasicFileResourceItem(type, name, configuration, visibility, relativePath) : new BasicDensityBasedFileResourceItem(type, name, configuration, visibility, relativePath, density);
    }

    @NotNull
    private BasicValueResourceItemBase createResourceItem(@NotNull ResourceType type, @NotNull String name, @NotNull ResourceSourceFile sourceFile) throws IOException, XmlPullParserException, XmlSyntaxException {
        if (type == null) {
            RepositoryLoader.$$$reportNull$$$0(50);
        }
        if (name == null) {
            RepositoryLoader.$$$reportNull$$$0(51);
        }
        if (sourceFile == null) {
            RepositoryLoader.$$$reportNull$$$0(52);
        }
        switch (type) {
            case ARRAY: {
                return this.createArrayItem(name, sourceFile);
            }
            case ATTR: {
                return this.createAttrItem(name, sourceFile);
            }
            case PLURALS: {
                return this.createPluralsItem(name, sourceFile);
            }
            case STRING: {
                return this.createStringItem(type, name, sourceFile, true);
            }
            case STYLE: {
                return this.createStyleItem(name, sourceFile);
            }
            case STYLEABLE: {
                return this.createStyleableItem(name, sourceFile);
            }
            case ANIMATOR: 
            case DRAWABLE: 
            case INTERPOLATOR: 
            case LAYOUT: 
            case MENU: 
            case MIPMAP: 
            case TRANSITION: {
                return this.createFileReferenceItem(type, name, sourceFile);
            }
        }
        return this.createStringItem(type, name, sourceFile, false);
    }

    @NotNull
    private BasicArrayResourceItem createArrayItem(@NotNull String name, @NotNull ResourceSourceFile sourceFile) throws IOException, XmlPullParserException, XmlSyntaxException {
        if (name == null) {
            RepositoryLoader.$$$reportNull$$$0(53);
        }
        if (sourceFile == null) {
            RepositoryLoader.$$$reportNull$$$0(54);
        }
        String indexValue = this.myParser.getAttributeValue("http://schemas.android.com/tools", "index");
        ResourceNamespace.Resolver namespaceResolver2 = this.myParser.getNamespaceResolver();
        ArrayList<String> values2 = new ArrayList<String>();
        this.forSubTags("item", () -> {
            String text2 = this.myTextExtractor.extractText((XmlPullParser)this.myParser, false);
            values2.add(text2);
        });
        int index2 = 0;
        if (indexValue != null) {
            try {
                index2 = Integer.parseUnsignedInt(indexValue);
            }
            catch (NumberFormatException e) {
                throw new XmlSyntaxException("The value of the " + namespaceResolver2.prefixToUri("http://schemas.android.com/tools") + ":index attribute is not a valid number.", (XmlPullParser)this.myParser, this.getDisplayName(sourceFile));
            }
            if (index2 >= values2.size()) {
                throw new XmlSyntaxException("The value of the " + namespaceResolver2.prefixToUri("http://schemas.android.com/tools") + ":index attribute is out of bounds.", (XmlPullParser)this.myParser, this.getDisplayName(sourceFile));
            }
        }
        ResourceVisibility visibility = this.getVisibility(ResourceType.ARRAY, name);
        BasicArrayResourceItem item = new BasicArrayResourceItem(name, sourceFile, visibility, values2, index2);
        item.setNamespaceResolver(namespaceResolver2);
        BasicArrayResourceItem basicArrayResourceItem = item;
        if (basicArrayResourceItem == null) {
            RepositoryLoader.$$$reportNull$$$0(55);
        }
        return basicArrayResourceItem;
    }

    @NotNull
    private BasicAttrResourceItem createAttrItem(@NotNull String name, @NotNull ResourceSourceFile sourceFile) throws IOException, XmlPullParserException, XmlSyntaxException {
        BasicAttrResourceItem item;
        ResourceNamespace attrNamespace;
        if (name == null) {
            RepositoryLoader.$$$reportNull$$$0(56);
        }
        if (sourceFile == null) {
            RepositoryLoader.$$$reportNull$$$0(57);
        }
        ResourceNamespace.Resolver namespaceResolver2 = this.myParser.getNamespaceResolver();
        this.myUrlParser.parseResourceUrl(name);
        if (this.myUrlParser.hasNamespacePrefix("android")) {
            attrNamespace = ResourceNamespace.ANDROID;
        } else {
            String prefix = this.myUrlParser.getNamespacePrefix();
            attrNamespace = ResourceNamespace.fromNamespacePrefix((String)prefix, (ResourceNamespace)this.myNamespace, (ResourceNamespace.Resolver)this.myParser.getNamespaceResolver());
            if (attrNamespace == null) {
                throw new XmlSyntaxException("Undefined prefix of attr resource name \"" + name + "\"", (XmlPullParser)this.myParser, this.getDisplayName(sourceFile));
            }
        }
        name = this.myUrlParser.getName();
        String description2 = this.myParser.getLastComment();
        String groupName = this.myParser.getAttrGroupComment();
        String formatString = this.myParser.getAttributeValue(null, "format");
        Set<Object> formats = StringUtil.isEmpty((String)formatString) ? EnumSet.noneOf(AttributeFormat.class) : AttributeFormat.parse((String)formatString);
        HashMap valueMap = Maps.newHashMapWithExpectedSize((int)8);
        HashMap descriptionMap = Maps.newHashMapWithExpectedSize((int)8);
        this.forSubTags(null, () -> {
            if (this.myParser.getPrefix() == null) {
                AttributeFormat format2;
                String tagName = this.myParser.getName();
                Object object = tagName.equals("enum") ? AttributeFormat.ENUM : (format2 = tagName.equals("flag") ? AttributeFormat.FLAGS : null);
                if (format2 != null) {
                    formats.add(format2);
                    String valueName = this.myParser.getAttributeValue(null, "name");
                    if (valueName != null) {
                        String valueDescription = this.myParser.getLastComment();
                        if (valueDescription != null) {
                            descriptionMap.put(valueName, valueDescription);
                        }
                        String value2 = this.myParser.getAttributeValue(null, "value");
                        Integer numericValue = null;
                        if (value2 != null) {
                            try {
                                numericValue = Long.decode(value2).intValue();
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        valueMap.put(valueName, numericValue);
                    }
                }
            }
        });
        if (attrNamespace.equals((Object)this.myNamespace)) {
            ResourceVisibility visibility = this.getVisibility(ResourceType.ATTR, name);
            item = new BasicAttrResourceItem(name, sourceFile, visibility, description2, groupName, formats, valueMap, descriptionMap);
        } else {
            item = new BasicForeignAttrResourceItem(attrNamespace, name, sourceFile, description2, groupName, formats, (Map<String, Integer>)valueMap, (Map<String, String>)descriptionMap);
        }
        item.setNamespaceResolver(namespaceResolver2);
        BasicForeignAttrResourceItem basicForeignAttrResourceItem = item;
        if (basicForeignAttrResourceItem == null) {
            RepositoryLoader.$$$reportNull$$$0(58);
        }
        return basicForeignAttrResourceItem;
    }

    @NotNull
    private BasicPluralsResourceItem createPluralsItem(@NotNull String name, @NotNull ResourceSourceFile sourceFile) throws IOException, XmlPullParserException, XmlSyntaxException {
        if (name == null) {
            RepositoryLoader.$$$reportNull$$$0(59);
        }
        if (sourceFile == null) {
            RepositoryLoader.$$$reportNull$$$0(60);
        }
        String defaultQuantity = this.myParser.getAttributeValue("http://schemas.android.com/tools", "quantity");
        ResourceNamespace.Resolver namespaceResolver2 = this.myParser.getNamespaceResolver();
        EnumMap<Arity, String> values2 = new EnumMap<Arity, String>(Arity.class);
        this.forSubTags("item", () -> {
            Arity quantity;
            String quantityValue = this.myParser.getAttributeValue(null, "quantity");
            if (quantityValue != null && (quantity = Arity.getEnum((String)quantityValue)) != null) {
                String text2 = this.myTextExtractor.extractText((XmlPullParser)this.myParser, false);
                values2.put(quantity, text2);
            }
        });
        Arity defaultArity = null;
        if (!(defaultQuantity == null || (defaultArity = Arity.getEnum((String)defaultQuantity)) != null && values2.containsKey(defaultArity))) {
            throw new XmlSyntaxException("Invalid value of the " + namespaceResolver2.prefixToUri("http://schemas.android.com/tools") + ":quantity attribute.", (XmlPullParser)this.myParser, this.getDisplayName(sourceFile));
        }
        ResourceVisibility visibility = this.getVisibility(ResourceType.PLURALS, name);
        BasicPluralsResourceItem item = new BasicPluralsResourceItem(name, sourceFile, visibility, values2, defaultArity);
        item.setNamespaceResolver(namespaceResolver2);
        BasicPluralsResourceItem basicPluralsResourceItem = item;
        if (basicPluralsResourceItem == null) {
            RepositoryLoader.$$$reportNull$$$0(61);
        }
        return basicPluralsResourceItem;
    }

    @NotNull
    private BasicValueResourceItem createStringItem(@NotNull ResourceType type, @NotNull String name, @NotNull ResourceSourceFile sourceFile, boolean withRowXml) throws IOException, XmlPullParserException {
        String rawXml;
        if (type == null) {
            RepositoryLoader.$$$reportNull$$$0(62);
        }
        if (name == null) {
            RepositoryLoader.$$$reportNull$$$0(63);
        }
        if (sourceFile == null) {
            RepositoryLoader.$$$reportNull$$$0(64);
        }
        ResourceNamespace.Resolver namespaceResolver2 = this.myParser.getNamespaceResolver();
        String text2 = type == ResourceType.ID ? null : this.myTextExtractor.extractText((XmlPullParser)this.myParser, withRowXml);
        String string = rawXml = type == ResourceType.ID ? null : this.myTextExtractor.getRawXml();
        assert (withRowXml || rawXml == null);
        ResourceVisibility visibility = this.getVisibility(type, name);
        BasicValueResourceItem item = rawXml == null ? new BasicValueResourceItem(type, name, sourceFile, visibility, text2) : new BasicTextValueResourceItem(type, name, sourceFile, visibility, text2, rawXml);
        item.setNamespaceResolver(namespaceResolver2);
        BasicValueResourceItem basicValueResourceItem = item;
        if (basicValueResourceItem == null) {
            RepositoryLoader.$$$reportNull$$$0(65);
        }
        return basicValueResourceItem;
    }

    @NotNull
    private BasicStyleResourceItem createStyleItem(@NotNull String name, @NotNull ResourceSourceFile sourceFile) throws IOException, XmlPullParserException {
        if (name == null) {
            RepositoryLoader.$$$reportNull$$$0(66);
        }
        if (sourceFile == null) {
            RepositoryLoader.$$$reportNull$$$0(67);
        }
        ResourceNamespace.Resolver namespaceResolver2 = this.myParser.getNamespaceResolver();
        String parentStyle = this.myParser.getAttributeValue(null, "parent");
        if (parentStyle != null && !parentStyle.isEmpty()) {
            this.myUrlParser.parseResourceUrl(parentStyle);
            parentStyle = this.myUrlParser.getQualifiedName();
        }
        ArrayList<StyleItemResourceValue> styleItems = new ArrayList<StyleItemResourceValue>();
        this.forSubTags("item", () -> {
            ResourceNamespace.Resolver itemNamespaceResolver = this.myParser.getNamespaceResolver();
            String itemName = this.myParser.getAttributeValue(null, "name");
            if (itemName != null) {
                String text2 = this.myTextExtractor.extractText((XmlPullParser)this.myParser, false);
                StyleItemResourceValueImpl styleItem = new StyleItemResourceValueImpl(this.myNamespace, itemName, text2, sourceFile.getRepository().getLibraryName());
                styleItem.setNamespaceResolver(itemNamespaceResolver);
                styleItems.add((StyleItemResourceValue)styleItem);
            }
        });
        ResourceVisibility visibility = this.getVisibility(ResourceType.STYLE, name);
        BasicStyleResourceItem item = new BasicStyleResourceItem(name, sourceFile, visibility, parentStyle, styleItems);
        item.setNamespaceResolver(namespaceResolver2);
        BasicStyleResourceItem basicStyleResourceItem = item;
        if (basicStyleResourceItem == null) {
            RepositoryLoader.$$$reportNull$$$0(68);
        }
        return basicStyleResourceItem;
    }

    @NotNull
    private BasicStyleableResourceItem createStyleableItem(@NotNull String name, @NotNull ResourceSourceFile sourceFile) throws IOException, XmlPullParserException {
        if (name == null) {
            RepositoryLoader.$$$reportNull$$$0(69);
        }
        if (sourceFile == null) {
            RepositoryLoader.$$$reportNull$$$0(70);
        }
        ResourceNamespace.Resolver namespaceResolver2 = this.myParser.getNamespaceResolver();
        ArrayList<AttrResourceValue> attrs = new ArrayList<AttrResourceValue>();
        this.forSubTags("attr", () -> {
            String attrName = this.myParser.getAttributeValue(null, "name");
            if (attrName != null) {
                try {
                    BasicAttrResourceItem attr2 = this.createAttrItem(attrName, sourceFile);
                    attrs.add((AttrResourceValue)(attr2.getFormats().isEmpty() ? attr2 : attr2.createReference()));
                    if (attr2.getNamespace().equals((Object)this.myNamespace) && (this.myNamespace != ResourceNamespace.RES_AUTO || !attr2.getFormats().isEmpty())) {
                        RepositoryLoader.addAttr(attr2, this.myAttrCandidates);
                    }
                }
                catch (XmlSyntaxException e) {
                    LOG.error((Throwable)e);
                }
            }
        });
        BasicStyleableResourceItem item = new BasicStyleableResourceItem(name, sourceFile, ResourceVisibility.PUBLIC, attrs);
        item.setNamespaceResolver(namespaceResolver2);
        BasicStyleableResourceItem basicStyleableResourceItem = item;
        if (basicStyleableResourceItem == null) {
            RepositoryLoader.$$$reportNull$$$0(71);
        }
        return basicStyleableResourceItem;
    }

    private static void addAttr(@NotNull BasicAttrResourceItem attr2, @NotNull ListMultimap<String, BasicAttrResourceItem> map2) {
        List attrs;
        int i2;
        if (attr2 == null) {
            RepositoryLoader.$$$reportNull$$$0(72);
        }
        if (map2 == null) {
            RepositoryLoader.$$$reportNull$$$0(73);
        }
        if ((i2 = RepositoryLoader.findResourceWithSameNameAndConfiguration((ResourceItem)attr2, attrs = map2.get((Object)attr2.getName()))) >= 0) {
            BasicAttrResourceItem existing2 = (BasicAttrResourceItem)attrs.get(i2);
            if (!attr2.getFormats().isEmpty()) {
                if (existing2.getFormats().isEmpty()) {
                    attrs.set(i2, attr2);
                } else if (!attr2.getFormats().equals(existing2.getFormats())) {
                    if (attr2.getFormats().containsAll(existing2.getFormats())) {
                        existing2.setFormats(attr2.getFormats());
                    } else if (existing2.getFormats().containsAll(attr2.getFormats())) {
                        attr2.setFormats(existing2.getFormats());
                    } else {
                        ImmutableSet formats = EnumSet.copyOf(attr2.getFormats());
                        formats.addAll(existing2.getFormats());
                        formats = ImmutableSet.copyOf(formats);
                        attr2.setFormats((Set<AttributeFormat>)formats);
                        existing2.setFormats((Set<AttributeFormat>)formats);
                    }
                }
            }
            if (existing2.getFormats().isEmpty() && !attr2.getFormats().isEmpty()) {
                attrs.set(i2, attr2);
            }
        } else {
            attrs.add(attr2);
        }
    }

    private void processAttrsAndStyleables() {
        for (BasicAttrResourceItem attr2 : this.myAttrs.values()) {
            this.addAttrWithAdjustedFormats(attr2);
        }
        for (BasicAttrResourceItem attr2 : this.myAttrCandidates.values()) {
            List attrs;
            int i2 = RepositoryLoader.findResourceWithSameNameAndConfiguration((ResourceItem)attr2, attrs = this.myAttrs.get((Object)attr2.getName()));
            if (i2 >= 0) continue;
            this.addAttrWithAdjustedFormats(attr2);
        }
        for (BasicStyleableResourceItem styleable : this.myStyleables.values()) {
            this.addResourceItem(RepositoryLoader.resolveAttrReferences(styleable));
        }
    }

    @NotNull
    public static BasicStyleableResourceItem resolveAttrReferences(@NotNull BasicStyleableResourceItem styleable) {
        if (styleable == null) {
            RepositoryLoader.$$$reportNull$$$0(74);
        }
        LoadableResourceRepository repository = styleable.getRepository();
        List<AttrResourceValue> attributes = styleable.getAllAttributes();
        ArrayList<AttrResourceValue> resolvedAttributes = null;
        for (int i2 = 0; i2 < attributes.size(); ++i2) {
            AttrResourceValue attr2 = attributes.get(i2);
            AttrResourceValue canonicalAttr = BasicStyleableResourceItem.getCanonicalAttr(attr2, (ResourceRepository)repository);
            if (canonicalAttr != attr2) {
                if (resolvedAttributes == null) {
                    resolvedAttributes = new ArrayList<AttrResourceValue>(attributes.size());
                    for (int j = 0; j < i2; ++j) {
                        resolvedAttributes.add(attributes.get(j));
                    }
                }
                resolvedAttributes.add(canonicalAttr);
                continue;
            }
            if (resolvedAttributes == null) continue;
            resolvedAttributes.add(attr2);
        }
        if (resolvedAttributes != null) {
            ResourceNamespace.Resolver namespaceResolver2 = styleable.getNamespaceResolver();
            styleable = new BasicStyleableResourceItem(styleable.getName(), styleable.getSourceFile(), styleable.getVisibility(), resolvedAttributes);
            styleable.setNamespaceResolver(namespaceResolver2);
        }
        BasicStyleableResourceItem basicStyleableResourceItem = styleable;
        if (basicStyleableResourceItem == null) {
            RepositoryLoader.$$$reportNull$$$0(75);
        }
        return basicStyleableResourceItem;
    }

    private void addAttrWithAdjustedFormats(@NotNull BasicAttrResourceItem attr2) {
        if (attr2 == null) {
            RepositoryLoader.$$$reportNull$$$0(76);
        }
        if (attr2.getFormats().isEmpty()) {
            attr2 = new BasicAttrResourceItem(attr2.getName(), attr2.getSourceFile(), attr2.getVisibility(), attr2.getDescription(), attr2.getGroupName(), this.DEFAULT_ATTR_FORMATS, Collections.emptyMap(), Collections.emptyMap());
        }
        this.addResourceItem(attr2);
    }

    private static boolean resourceAlreadyDefined(@NotNull BasicResourceItemBase resource) {
        LoadableResourceRepository repository;
        List items2;
        if (resource == null) {
            RepositoryLoader.$$$reportNull$$$0(77);
        }
        return RepositoryLoader.findResourceWithSameNameAndConfiguration((ResourceItem)resource, items2 = (repository = resource.getRepository()).getResources(resource.getNamespace(), resource.getType(), resource.getName())) >= 0;
    }

    private static int findResourceWithSameNameAndConfiguration(@NotNull ResourceItem resource, @NotNull List<? extends ResourceItem> items2) {
        if (resource == null) {
            RepositoryLoader.$$$reportNull$$$0(78);
        }
        if (items2 == null) {
            RepositoryLoader.$$$reportNull$$$0(79);
        }
        for (int i2 = 0; i2 < items2.size(); ++i2) {
            ResourceItem item = items2.get(i2);
            if (!item.getConfiguration().equals((Object)resource.getConfiguration())) continue;
            return i2;
        }
        return -1;
    }

    @NotNull
    private BasicValueResourceItem createFileReferenceItem(@NotNull ResourceType type, @NotNull String name, @NotNull ResourceSourceFile sourceFile) throws IOException, XmlPullParserException {
        if (type == null) {
            RepositoryLoader.$$$reportNull$$$0(80);
        }
        if (name == null) {
            RepositoryLoader.$$$reportNull$$$0(81);
        }
        if (sourceFile == null) {
            RepositoryLoader.$$$reportNull$$$0(82);
        }
        ResourceNamespace.Resolver namespaceResolver2 = this.myParser.getNamespaceResolver();
        String text2 = this.myTextExtractor.extractText((XmlPullParser)this.myParser, false).trim();
        if (!(text2.isEmpty() || text2.startsWith("@") || text2.startsWith("?"))) {
            text2 = text2.replace('/', File.separatorChar);
        }
        ResourceVisibility visibility = this.getVisibility(type, name);
        BasicValueResourceItem item = new BasicValueResourceItem(type, name, sourceFile, visibility, text2);
        item.setNamespaceResolver(namespaceResolver2);
        BasicValueResourceItem basicValueResourceItem = item;
        if (basicValueResourceItem == null) {
            RepositoryLoader.$$$reportNull$$$0(83);
        }
        return basicValueResourceItem;
    }

    @Nullable
    private ResourceType getResourceType(@NotNull String tagName, @NotNull PathString file2) throws XmlSyntaxException {
        ResourceType type;
        if (tagName == null) {
            RepositoryLoader.$$$reportNull$$$0(84);
        }
        if (file2 == null) {
            RepositoryLoader.$$$reportNull$$$0(85);
        }
        if ((type = ResourceType.fromXmlTagName((String)tagName)) == null) {
            String typeAttr;
            if ("eat-comment".equals(tagName) || "skip".equals(tagName)) {
                return null;
            }
            if (tagName.equals("item") && (typeAttr = this.myParser.getAttributeValue(null, "type")) != null) {
                type = ResourceType.fromClassName((String)typeAttr);
                if (type != null) {
                    return type;
                }
                throw new XmlSyntaxException("Invalid type attribute \"" + typeAttr + "\"", (XmlPullParser)this.myParser, this.getDisplayName(file2));
            }
            throw new XmlSyntaxException("Invalid tag name \"" + tagName + "\"", (XmlPullParser)this.myParser, this.getDisplayName(file2));
        }
        return type;
    }

    private void forSubTags(@Nullable String tagName, @NotNull XmlTagVisitor subtagVisitor) throws IOException, XmlPullParserException {
        int event;
        if (subtagVisitor == null) {
            RepositoryLoader.$$$reportNull$$$0(86);
        }
        int elementDepth = this.myParser.getDepth();
        do {
            if ((event = this.myParser.nextToken()) != 2 || tagName != null && (!tagName.equals(this.myParser.getName()) || this.myParser.getPrefix() != null)) continue;
            subtagVisitor.visitTag();
        } while (event != 1 && (event != 3 || this.myParser.getDepth() > elementDepth));
    }

    private void validateResourceName(@NotNull String resourceName, @NotNull ResourceType resourceType, @NotNull PathString file2) throws XmlSyntaxException {
        String error;
        if (resourceName == null) {
            RepositoryLoader.$$$reportNull$$$0(87);
        }
        if (resourceType == null) {
            RepositoryLoader.$$$reportNull$$$0(88);
        }
        if (file2 == null) {
            RepositoryLoader.$$$reportNull$$$0(89);
        }
        if ((error = ValueResourceNameValidator.getErrorText((String)resourceName, (ResourceType)resourceType)) != null) {
            throw new XmlSyntaxException(error, (XmlPullParser)this.myParser, this.getDisplayName(file2));
        }
    }

    @NotNull
    private String getDisplayName(@NotNull PathString file2) {
        if (file2 == null) {
            RepositoryLoader.$$$reportNull$$$0(90);
        }
        Object object = file2.isAbsolute() ? file2.getNativePath() : file2.getPortablePath() + " in " + this.myResourceDirectoryOrFile.toString();
        if (object == null) {
            RepositoryLoader.$$$reportNull$$$0(91);
        }
        return object;
    }

    @NotNull
    private String getDisplayName(@NotNull ResourceSourceFile sourceFile) {
        String relativePath;
        if (sourceFile == null) {
            RepositoryLoader.$$$reportNull$$$0(92);
        }
        Preconditions.checkArgument(((relativePath = sourceFile.getRelativePath()) != null ? 1 : 0) != 0);
        return this.getDisplayName(new PathString(relativePath));
    }

    @NotNull
    protected final ResourceVisibility getVisibility(@NotNull ResourceType resourceType, @NotNull String resourceName) {
        Set<String> names;
        if (resourceType == null) {
            RepositoryLoader.$$$reportNull$$$0(93);
        }
        if (resourceName == null) {
            RepositoryLoader.$$$reportNull$$$0(94);
        }
        ResourceVisibility resourceVisibility = (names = this.myPublicResources.get(resourceType)) != null && names.contains(this.getKeyForVisibilityLookup(resourceName)) ? ResourceVisibility.PUBLIC : this.myDefaultVisibility;
        if (resourceVisibility == null) {
            RepositoryLoader.$$$reportNull$$$0(95);
        }
        return resourceVisibility;
    }

    @NotNull
    protected String getKeyForVisibilityLookup(@NotNull String resourceName) {
        if (resourceName == null) {
            RepositoryLoader.$$$reportNull$$$0(96);
        }
        String string = ResourcesUtil.resourceNameToFieldName((String)resourceName);
        if (string == null) {
            RepositoryLoader.$$$reportNull$$$0(97);
        }
        return string;
    }

    @NotNull
    protected final String getResRelativePath(@NotNull PathString file2) {
        if (file2 == null) {
            RepositoryLoader.$$$reportNull$$$0(98);
        }
        if (file2.isAbsolute()) {
            String string = this.myResourceDirectoryOrFilePath.relativize(file2).getPortablePath();
            if (string == null) {
                RepositoryLoader.$$$reportNull$$$0(99);
            }
            return string;
        }
        assert (file2.getNameCount() != 0);
        assert (file2.segment(0).equals("res"));
        String string = file2.subpath(1, file2.getNameCount()).getPortablePath();
        if (string == null) {
            RepositoryLoader.$$$reportNull$$$0(100);
        }
        return string;
    }

    private static boolean isZipArchive(@NotNull Path resourceDirectoryOrFile) {
        String filename;
        if (resourceDirectoryOrFile == null) {
            RepositoryLoader.$$$reportNull$$$0(101);
        }
        return SdkUtils.endsWithIgnoreCase((String)(filename = resourceDirectoryOrFile.getFileName().toString()), (String)".aar") || SdkUtils.endsWithIgnoreCase((String)filename, (String)".jar") || SdkUtils.endsWithIgnoreCase((String)filename, (String)".zip");
    }

    @NotNull
    public static String portableFileName(@NotNull String fileName) {
        if (fileName == null) {
            RepositoryLoader.$$$reportNull$$$0(102);
        }
        String string = fileName.replace(File.separatorChar, '/');
        if (string == null) {
            RepositoryLoader.$$$reportNull$$$0(103);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 22: 
            case 23: 
            case 55: 
            case 58: 
            case 61: 
            case 65: 
            case 68: 
            case 71: 
            case 75: 
            case 83: 
            case 91: 
            case 95: 
            case 97: 
            case 99: 
            case 100: 
            case 103: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 22: 
            case 23: 
            case 55: 
            case 58: 
            case 61: 
            case 65: 
            case 68: 
            case 71: 
            case 75: 
            case 83: 
            case 91: 
            case 95: 
            case 97: 
            case 99: 
            case 100: 
            case 103: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceDirectoryOrFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 22: 
            case 23: 
            case 55: 
            case 58: 
            case 61: 
            case 65: 
            case 68: 
            case 71: 
            case 75: 
            case 83: 
            case 91: 
            case 95: 
            case 97: 
            case 99: 
            case 100: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/resources/base/RepositoryLoader";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 7: 
            case 24: 
            case 27: 
            case 30: 
            case 32: 
            case 35: 
            case 37: 
            case 39: 
            case 42: 
            case 45: 
            case 85: 
            case 89: 
            case 90: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDirectory";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrs";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesOrFolders";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderConfiguration";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderInfo";
                break;
            }
            case 26: 
            case 31: 
            case 33: 
            case 36: 
            case 44: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 40: 
            case 87: 
            case 94: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
            case 41: 
            case 52: 
            case 54: 
            case 57: 
            case 60: 
            case 64: 
            case 67: 
            case 70: 
            case 82: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 43: 
            case 88: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceType";
                break;
            }
            case 46: 
            case 50: 
            case 62: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 47: 
            case 51: 
            case 53: 
            case 56: 
            case 59: 
            case 63: 
            case 66: 
            case 69: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibility";
                break;
            }
            case 72: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleable";
                break;
            }
            case 77: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subtagVisitor";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/resources/base/RepositoryLoader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceDirectoryOrFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourcePathPrefix";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceUrlPrefix";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findResourceFiles";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "createArrayItem";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttrItem";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "createPluralsItem";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "createStringItem";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "createStyleItem";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "createStyleableItem";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAttrReferences";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileReferenceItem";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibility";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyForVisibilityLookup";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "getResRelativePath";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "portableFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 22: 
            case 23: 
            case 55: 
            case 58: 
            case 61: 
            case 65: 
            case 68: 
            case 71: 
            case 75: 
            case 83: 
            case 91: 
            case 95: 
            case 97: 
            case 99: 
            case 100: 
            case 103: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadRepositoryContents";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadFromZip";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadFromResFolder";
                break;
            }
            case 7: 
            case 8: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "loadResourceFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "finishLoading";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "containsWord";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findResourceFiles";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguration";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isXmlFile";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addResourceItem";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "parseValueResourceFile";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createResourceSourceFile";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addValueResourceItem";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "parseIdGeneratingResourceFile";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "handleParsingError";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "addIdResourceItem";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "createFileResourceItem";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "createResourceItem";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "createArrayItem";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "createAttrItem";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "createPluralsItem";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "createStringItem";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "createStyleItem";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "createStyleableItem";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "addAttr";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "resolveAttrReferences";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "addAttrWithAdjustedFormats";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "resourceAlreadyDefined";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "findResourceWithSameNameAndConfiguration";
                break;
            }
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "createFileReferenceItem";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getResourceType";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "forSubTags";
                break;
            }
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "validateResourceName";
                break;
            }
            case 90: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayName";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "getVisibility";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "getKeyForVisibilityLookup";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "getResRelativePath";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "isZipArchive";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "portableFileName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 22: 
            case 23: 
            case 55: 
            case 58: 
            case 61: 
            case 65: 
            case 68: 
            case 71: 
            case 75: 
            case 83: 
            case 91: 
            case 95: 
            case 97: 
            case 99: 
            case 100: 
            case 103: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class XmlSyntaxException
    extends Exception {
        XmlSyntaxException(@NotNull String error, @NotNull XmlPullParser parser, @NotNull String filename) {
            if (error == null) {
                XmlSyntaxException.$$$reportNull$$$0(0);
            }
            if (parser == null) {
                XmlSyntaxException.$$$reportNull$$$0(1);
            }
            if (filename == null) {
                XmlSyntaxException.$$$reportNull$$$0(2);
            }
            super(error + " at " + filename + " line " + parser.getLineNumber());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "error";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parser";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filename";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/resources/base/RepositoryLoader$XmlSyntaxException";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class XmlTextExtractor {
        @NotNull
        private final StringBuilder text = new StringBuilder();
        @NotNull
        private final StringBuilder rawXml = new StringBuilder();
        @NotNull
        private final Deque<Boolean> textInclusionState = new ArrayDeque<Boolean>();
        private boolean nontrivialRawXml;

        private XmlTextExtractor() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        String extractText(@NotNull XmlPullParser parser, boolean withRawXml) throws IOException, XmlPullParserException {
            int event;
            if (parser == null) {
                XmlTextExtractor.$$$reportNull$$$0(0);
            }
            this.text.setLength(0);
            this.rawXml.setLength(0);
            this.textInclusionState.clear();
            this.nontrivialRawXml = false;
            int elementDepth = parser.getDepth();
            block6: do {
                event = parser.nextToken();
                switch (event) {
                    case 2: {
                        String tagName = parser.getName();
                        if ("g".equals(tagName) && XmlTextExtractor.isXliffNamespace(parser.getNamespace())) {
                            boolean includeNestedText = this.getTextInclusionState();
                            String example = parser.getAttributeValue(null, "example");
                            if (example != null) {
                                this.text.append('(').append(example).append(')');
                                includeNestedText = false;
                            } else {
                                String id = parser.getAttributeValue(null, "id");
                                if (id != null && !id.equals("id")) {
                                    this.text.append('$').append('{').append(id).append('}');
                                    includeNestedText = false;
                                }
                            }
                            this.textInclusionState.addLast(includeNestedText);
                        }
                        if (!withRawXml) break;
                        this.nontrivialRawXml = true;
                        this.rawXml.append('<');
                        String prefix = parser.getPrefix();
                        if (prefix != null) {
                            this.rawXml.append(prefix).append(':');
                        }
                        this.rawXml.append(tagName);
                        int numAttr = parser.getAttributeCount();
                        for (int i2 = 0; i2 < numAttr; ++i2) {
                            this.rawXml.append(' ');
                            String attributePrefix = parser.getAttributePrefix(i2);
                            if (attributePrefix != null) {
                                this.rawXml.append(attributePrefix).append(':');
                            }
                            this.rawXml.append(parser.getAttributeName(i2)).append('=').append('\"');
                            XmlUtils.appendXmlAttributeValue((StringBuilder)this.rawXml, (String)parser.getAttributeValue(i2));
                            this.rawXml.append('\"');
                        }
                        this.rawXml.append('>');
                        break;
                    }
                    case 3: {
                        if (parser.getDepth() <= elementDepth) break block6;
                        String tagName = parser.getName();
                        if (withRawXml) {
                            this.rawXml.append('<').append('/');
                            String prefix = parser.getPrefix();
                            if (prefix != null) {
                                this.rawXml.append(prefix).append(':');
                            }
                            this.rawXml.append(tagName).append('>');
                        }
                        if (!"g".equals(tagName) || !XmlTextExtractor.isXliffNamespace(parser.getNamespace())) break;
                        this.textInclusionState.removeLast();
                        break;
                    }
                    case 4: 
                    case 6: {
                        String textPiece = parser.getText();
                        if (this.getTextInclusionState()) {
                            this.text.append(textPiece);
                        }
                        if (!withRawXml) break;
                        this.rawXml.append(textPiece);
                        break;
                    }
                    case 5: {
                        String textPiece = parser.getText();
                        if (this.getTextInclusionState()) {
                            this.text.append(textPiece);
                        }
                        if (!withRawXml) break;
                        this.nontrivialRawXml = true;
                        this.rawXml.append("<![CDATA[").append(textPiece).append("]]>");
                    }
                }
            } while (event != 1);
            String string = ValueXmlHelper.unescapeResourceString((String)this.text.toString(), (boolean)false, (boolean)true);
            if (string == null) {
                XmlTextExtractor.$$$reportNull$$$0(1);
            }
            return string;
        }

        private boolean getTextInclusionState() {
            return this.textInclusionState.isEmpty() || this.textInclusionState.getLast() != false;
        }

        @Nullable
        String getRawXml() {
            return this.nontrivialRawXml ? this.rawXml.toString() : null;
        }

        private static boolean isXliffNamespace(@Nullable String namespaceUri) {
            return namespaceUri != null && namespaceUri.startsWith("urn:oasis:names:tc:xliff:document:");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parser";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/resources/base/RepositoryLoader$XmlTextExtractor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/resources/base/RepositoryLoader$XmlTextExtractor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "extractText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "extractText";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ResourceFileCollector
    implements FileVisitor<Path> {
        @NotNull
        final List<PathString> resourceFiles;
        @NotNull
        final List<IOException> ioErrors;
        @NotNull
        final FileFilter fileFilter;

        private ResourceFileCollector(@NotNull FileFilter filter2) {
            if (filter2 == null) {
                ResourceFileCollector.$$$reportNull$$$0(0);
            }
            this.resourceFiles = new ArrayList<PathString>();
            this.ioErrors = new ArrayList<IOException>();
            this.fileFilter = filter2;
        }

        @Override
        @NotNull
        public FileVisitResult preVisitDirectory(@NotNull Path dir, @NotNull BasicFileAttributes attrs) {
            if (dir == null) {
                ResourceFileCollector.$$$reportNull$$$0(1);
            }
            if (attrs == null) {
                ResourceFileCollector.$$$reportNull$$$0(2);
            }
            if (this.fileFilter.isIgnored(dir, attrs)) {
                FileVisitResult fileVisitResult = FileVisitResult.SKIP_SUBTREE;
                if (fileVisitResult == null) {
                    ResourceFileCollector.$$$reportNull$$$0(3);
                }
                return fileVisitResult;
            }
            FileVisitResult fileVisitResult = FileVisitResult.CONTINUE;
            if (fileVisitResult == null) {
                ResourceFileCollector.$$$reportNull$$$0(4);
            }
            return fileVisitResult;
        }

        @Override
        @NotNull
        public FileVisitResult visitFile(@NotNull Path file2, @NotNull BasicFileAttributes attrs) {
            if (file2 == null) {
                ResourceFileCollector.$$$reportNull$$$0(5);
            }
            if (attrs == null) {
                ResourceFileCollector.$$$reportNull$$$0(6);
            }
            if (this.fileFilter.isIgnored(file2, attrs)) {
                FileVisitResult fileVisitResult = FileVisitResult.SKIP_SUBTREE;
                if (fileVisitResult == null) {
                    ResourceFileCollector.$$$reportNull$$$0(7);
                }
                return fileVisitResult;
            }
            this.resourceFiles.add(new PathString(file2));
            FileVisitResult fileVisitResult = FileVisitResult.CONTINUE;
            if (fileVisitResult == null) {
                ResourceFileCollector.$$$reportNull$$$0(8);
            }
            return fileVisitResult;
        }

        @Override
        @NotNull
        public FileVisitResult visitFileFailed(@NotNull Path file2, @NotNull IOException exc) {
            if (file2 == null) {
                ResourceFileCollector.$$$reportNull$$$0(9);
            }
            if (exc == null) {
                ResourceFileCollector.$$$reportNull$$$0(10);
            }
            this.ioErrors.add(exc);
            FileVisitResult fileVisitResult = FileVisitResult.CONTINUE;
            if (fileVisitResult == null) {
                ResourceFileCollector.$$$reportNull$$$0(11);
            }
            return fileVisitResult;
        }

        @Override
        @NotNull
        public FileVisitResult postVisitDirectory(@NotNull Path dir, @Nullable IOException exc) {
            if (dir == null) {
                ResourceFileCollector.$$$reportNull$$$0(12);
            }
            FileVisitResult fileVisitResult = FileVisitResult.CONTINUE;
            if (fileVisitResult == null) {
                ResourceFileCollector.$$$reportNull$$$0(13);
            }
            return fileVisitResult;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 8: 
                case 11: 
                case 13: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 8: 
                case 11: 
                case 13: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 1: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dir";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attrs";
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 8: 
                case 11: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/resources/base/RepositoryLoader$ResourceFileCollector";
                    break;
                }
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exc";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/resources/base/RepositoryLoader$ResourceFileCollector";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "preVisitDirectory";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "visitFile";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "visitFileFailed";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "postVisitDirectory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "preVisitDirectory";
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 8: 
                case 11: 
                case 13: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "visitFile";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "visitFileFailed";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "postVisitDirectory";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 8: 
                case 11: 
                case 13: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class FolderInfo {
        @NotNull
        public final ResourceFolderType folderType;
        @NotNull
        public final FolderConfiguration configuration;
        @Nullable
        public final ResourceType resourceType;
        public final boolean isIdGenerating;

        private FolderInfo(@NotNull ResourceFolderType folderType, @NotNull FolderConfiguration configuration, @Nullable ResourceType resourceType, boolean isIdGenerating) {
            if (folderType == null) {
                FolderInfo.$$$reportNull$$$0(0);
            }
            if (configuration == null) {
                FolderInfo.$$$reportNull$$$0(1);
            }
            this.configuration = configuration;
            this.resourceType = resourceType;
            this.folderType = folderType;
            this.isIdGenerating = isIdGenerating;
        }

        @Nullable
        public static FolderInfo create(@NotNull String folderName, @NotNull Map<String, FolderConfiguration> folderConfigCache) {
            boolean isIdGenerating;
            ResourceType resourceType;
            ResourceFolderType folderType;
            if (folderName == null) {
                FolderInfo.$$$reportNull$$$0(2);
            }
            if (folderConfigCache == null) {
                FolderInfo.$$$reportNull$$$0(3);
            }
            if ((folderType = ResourceFolderType.getFolderType((String)folderName)) == null) {
                return null;
            }
            String qualifier = FolderConfiguration.getQualifier((String)folderName);
            FolderConfiguration config = folderConfigCache.computeIfAbsent(qualifier, q -> FolderConfiguration.getConfigForQualifierString((String)q));
            if (config == null) {
                return null;
            }
            config.normalizeByRemovingRedundantVersionQualifier();
            if (folderType == ResourceFolderType.VALUES) {
                resourceType = null;
                isIdGenerating = false;
            } else {
                resourceType = FolderTypeRelationship.getNonIdRelatedResourceType((ResourceFolderType)folderType);
                isIdGenerating = FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType);
            }
            return new FolderInfo(folderType, config, resourceType, isIdGenerating);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "folderType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "folderName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "folderConfigCache";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/resources/base/RepositoryLoader$FolderInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface XmlTagVisitor {
        public void visitTag() throws IOException, XmlPullParserException;
    }
}

