/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resources.base;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.tools.idea.resources.base.Base128InputStream;
import com.android.tools.idea.resources.base.Base128OutputStream;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class NamespaceResolver
implements ResourceNamespace.Resolver {
    public static final NamespaceResolver EMPTY = new NamespaceResolver(ArrayUtil.EMPTY_STRING_ARRAY);
    @NotNull
    private final String[] prefixesAndUris;

    NamespaceResolver(@NotNull XmlPullParser parser) throws XmlPullParserException {
        if (parser == null) {
            NamespaceResolver.$$$reportNull$$$0(0);
        }
        int namespaceCount = parser.getNamespaceCount(parser.getDepth());
        this.prefixesAndUris = new String[namespaceCount * 2];
        int j = this.prefixesAndUris.length;
        for (int i2 = 0; i2 < namespaceCount; ++i2) {
            this.prefixesAndUris[--j] = parser.getNamespaceUri(i2);
            this.prefixesAndUris[--j] = parser.getNamespacePrefix(i2);
        }
    }

    private NamespaceResolver(@NotNull String[] prefixesAndUris) {
        if (prefixesAndUris == null) {
            NamespaceResolver.$$$reportNull$$$0(1);
        }
        this.prefixesAndUris = prefixesAndUris;
    }

    int getNamespaceCount() {
        return this.prefixesAndUris.length / 2;
    }

    @Nullable
    public String prefixToUri(@NotNull String namespacePrefix) {
        if (namespacePrefix == null) {
            NamespaceResolver.$$$reportNull$$$0(2);
        }
        for (int i2 = 0; i2 < this.prefixesAndUris.length; i2 += 2) {
            if (!namespacePrefix.equals(this.prefixesAndUris[i2])) continue;
            return this.prefixesAndUris[i2 + 1];
        }
        return null;
    }

    @Nullable
    public String uriToPrefix(@NotNull String namespaceUri) {
        if (namespaceUri == null) {
            NamespaceResolver.$$$reportNull$$$0(3);
        }
        for (int i2 = 0; i2 < this.prefixesAndUris.length; i2 += 2) {
            if (!namespaceUri.equals(this.prefixesAndUris[i2 + 1])) continue;
            return this.prefixesAndUris[i2];
        }
        return null;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NamespaceResolver other = (NamespaceResolver)obj;
        return Arrays.equals(this.prefixesAndUris, other.prefixesAndUris);
    }

    public int hashCode() {
        return Arrays.hashCode(this.prefixesAndUris);
    }

    public void serialize(@NotNull Base128OutputStream stream) throws IOException {
        if (stream == null) {
            NamespaceResolver.$$$reportNull$$$0(4);
        }
        stream.writeInt(this.getNamespaceCount());
        for (String str : this.prefixesAndUris) {
            stream.writeString(str);
        }
    }

    @NotNull
    public static NamespaceResolver deserialize(@NotNull Base128InputStream stream) throws IOException {
        if (stream == null) {
            NamespaceResolver.$$$reportNull$$$0(5);
        }
        int n = stream.readInt() * 2;
        String[] prefixesAndUris = new String[n];
        for (int i2 = 0; i2 < n; ++i2) {
            String s = stream.readString();
            if (s == null) {
                throw Base128InputStream.StreamFormatException.invalidFormat();
            }
            prefixesAndUris[i2] = s;
        }
        return new NamespaceResolver(prefixesAndUris);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixesAndUris";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespacePrefix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceUri";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/resources/base/NamespaceResolver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "prefixToUri";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "uriToPrefix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "serialize";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "deserialize";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

