/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resources.base;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValueImpl;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.tools.idea.resources.base.Base128InputStream;
import com.android.tools.idea.resources.base.Base128OutputStream;
import com.android.tools.idea.resources.base.BasicValueResourceItemBase;
import com.android.tools.idea.resources.base.LoadableResourceRepository;
import com.android.tools.idea.resources.base.ResourceSourceFile;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.intellij.openapi.diagnostic.Logger;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BasicStyleResourceItem
extends BasicValueResourceItemBase
implements StyleResourceValue {
    private static final Logger LOG = Logger.getInstance(BasicStyleResourceItem.class);
    @Nullable
    private final String myParentStyle;
    @NotNull
    private final Table<ResourceNamespace, String, StyleItemResourceValue> myStyleItemTable;

    public BasicStyleResourceItem(@NotNull String name, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceVisibility visibility, @Nullable String parentStyle, @NotNull Collection<StyleItemResourceValue> styleItems) {
        if (name == null) {
            BasicStyleResourceItem.$$$reportNull$$$0(0);
        }
        if (sourceFile == null) {
            BasicStyleResourceItem.$$$reportNull$$$0(1);
        }
        if (visibility == null) {
            BasicStyleResourceItem.$$$reportNull$$$0(2);
        }
        if (styleItems == null) {
            BasicStyleResourceItem.$$$reportNull$$$0(3);
        }
        super(ResourceType.STYLE, name, sourceFile, visibility);
        this.myParentStyle = parentStyle;
        ImmutableTable.Builder tableBuilder = ImmutableTable.builder();
        HashMap<ResourceReference, StyleItemResourceValue> duplicateCheckMap = new HashMap<ResourceReference, StyleItemResourceValue>();
        for (StyleItemResourceValue styleItem : styleItems) {
            ResourceReference attr2 = styleItem.getAttr();
            if (attr2 == null) continue;
            StyleItemResourceValue previouslyDefined = duplicateCheckMap.put(attr2, styleItem);
            if (previouslyDefined == null) {
                tableBuilder.put((Object)attr2.getNamespace(), (Object)attr2.getName(), (Object)styleItem);
                continue;
            }
            if (previouslyDefined.equals(styleItem)) continue;
            LOG.warn("Conflicting definitions of \"" + styleItem.getAttrName() + "\" in style \"" + name + "\"");
        }
        this.myStyleItemTable = tableBuilder.build();
    }

    @Nullable
    public String getParentStyleName() {
        return this.myParentStyle;
    }

    @Nullable
    public StyleItemResourceValue getItem(@NotNull ResourceNamespace namespace, @NotNull String name) {
        if (namespace == null) {
            BasicStyleResourceItem.$$$reportNull$$$0(4);
        }
        if (name == null) {
            BasicStyleResourceItem.$$$reportNull$$$0(5);
        }
        return (StyleItemResourceValue)this.myStyleItemTable.get((Object)namespace, (Object)name);
    }

    @Nullable
    public StyleItemResourceValue getItem(@NotNull ResourceReference attr2) {
        if (attr2 == null) {
            BasicStyleResourceItem.$$$reportNull$$$0(6);
        }
        assert (attr2.getResourceType() == ResourceType.ATTR);
        return (StyleItemResourceValue)this.myStyleItemTable.get((Object)attr2.getNamespace(), (Object)attr2.getName());
    }

    @NotNull
    public Collection<StyleItemResourceValue> getDefinedItems() {
        Collection collection2 = this.myStyleItemTable.values();
        if (collection2 == null) {
            BasicStyleResourceItem.$$$reportNull$$$0(7);
        }
        return collection2;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BasicStyleResourceItem other = (BasicStyleResourceItem)obj;
        return Objects.equals(this.myParentStyle, other.myParentStyle) && this.myStyleItemTable.equals(other.myStyleItemTable);
    }

    @Override
    public void serialize(@NotNull Base128OutputStream stream, @NotNull Object2IntMap<String> configIndexes, @NotNull Object2IntMap<ResourceSourceFile> sourceFileIndexes, @NotNull Object2IntMap<ResourceNamespace.Resolver> namespaceResolverIndexes) throws IOException {
        if (stream == null) {
            BasicStyleResourceItem.$$$reportNull$$$0(8);
        }
        if (configIndexes == null) {
            BasicStyleResourceItem.$$$reportNull$$$0(9);
        }
        if (sourceFileIndexes == null) {
            BasicStyleResourceItem.$$$reportNull$$$0(10);
        }
        if (namespaceResolverIndexes == null) {
            BasicStyleResourceItem.$$$reportNull$$$0(11);
        }
        super.serialize(stream, configIndexes, sourceFileIndexes, namespaceResolverIndexes);
        stream.writeString(this.myParentStyle);
        stream.writeInt(this.myStyleItemTable.size());
        for (StyleItemResourceValue styleItem : this.myStyleItemTable.values()) {
            stream.writeString(styleItem.getAttrName());
            stream.writeString(styleItem.getValue());
            int index2 = namespaceResolverIndexes.getInt((Object)styleItem.getNamespaceResolver());
            assert (index2 >= 0);
            stream.writeInt(index2);
        }
    }

    @NotNull
    static BasicStyleResourceItem deserialize(@NotNull Base128InputStream stream, @NotNull String name, @NotNull ResourceVisibility visibility, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceNamespace.Resolver resolver, @NotNull List<ResourceNamespace.Resolver> namespaceResolvers) throws IOException {
        if (stream == null) {
            BasicStyleResourceItem.$$$reportNull$$$0(12);
        }
        if (name == null) {
            BasicStyleResourceItem.$$$reportNull$$$0(13);
        }
        if (visibility == null) {
            BasicStyleResourceItem.$$$reportNull$$$0(14);
        }
        if (sourceFile == null) {
            BasicStyleResourceItem.$$$reportNull$$$0(15);
        }
        if (resolver == null) {
            BasicStyleResourceItem.$$$reportNull$$$0(16);
        }
        if (namespaceResolvers == null) {
            BasicStyleResourceItem.$$$reportNull$$$0(17);
        }
        LoadableResourceRepository repository = sourceFile.getRepository();
        ResourceNamespace namespace = repository.getNamespace();
        String libraryName = repository.getLibraryName();
        String parentStyle = stream.readString();
        int n = stream.readInt();
        ArrayList<StyleItemResourceValue> styleItems = n == 0 ? Collections.emptyList() : new ArrayList<StyleItemResourceValue>(n);
        for (int i2 = 0; i2 < n; ++i2) {
            String attrName = stream.readString();
            if (attrName == null) {
                throw Base128InputStream.StreamFormatException.invalidFormat();
            }
            String value2 = stream.readString();
            ResourceNamespace.Resolver itemResolver = namespaceResolvers.get(stream.readInt());
            StyleItemResourceValueImpl styleItem = new StyleItemResourceValueImpl(namespace, attrName, value2, libraryName);
            styleItem.setNamespaceResolver(itemResolver);
            styleItems.add((StyleItemResourceValue)styleItem);
        }
        BasicStyleResourceItem item = new BasicStyleResourceItem(name, sourceFile, visibility, parentStyle, styleItems);
        item.setNamespaceResolver(resolver);
        BasicStyleResourceItem basicStyleResourceItem = item;
        if (basicStyleResourceItem == null) {
            BasicStyleResourceItem.$$$reportNull$$$0(18);
        }
        return basicStyleResourceItem;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibility";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleItems";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/resources/base/BasicStyleResourceItem";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configIndexes";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFileIndexes";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceResolverIndexes";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceResolvers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/resources/base/BasicStyleResourceItem";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefinedItems";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getItem";
                break;
            }
            case 7: 
            case 18: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

