/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resources.base;

import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.tools.idea.resources.base.Base128InputStream;
import com.android.tools.idea.resources.base.Base128OutputStream;
import com.android.tools.idea.resources.base.BasicAttrReference;
import com.android.tools.idea.resources.base.BasicForeignAttrResourceItem;
import com.android.tools.idea.resources.base.BasicValueResourceItemBase;
import com.android.tools.idea.resources.base.ResourceSourceFile;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicAttrResourceItem
extends BasicValueResourceItemBase
implements AttrResourceValue {
    @NotNull
    private Set<AttributeFormat> myFormats;
    @NotNull
    private final Map<String, Integer> myValueMap;
    @NotNull
    private final Map<String, String> myValueDescriptionMap;
    @Nullable
    private final String myDescription;
    @Nullable
    private final String myGroupName;

    public BasicAttrResourceItem(@NotNull String name, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceVisibility visibility, @Nullable String description2, @Nullable String groupName, @NotNull Set<AttributeFormat> formats, @NotNull Map<String, Integer> valueMap, @NotNull Map<String, String> valueDescriptionMap) {
        if (name == null) {
            BasicAttrResourceItem.$$$reportNull$$$0(0);
        }
        if (sourceFile == null) {
            BasicAttrResourceItem.$$$reportNull$$$0(1);
        }
        if (visibility == null) {
            BasicAttrResourceItem.$$$reportNull$$$0(2);
        }
        if (formats == null) {
            BasicAttrResourceItem.$$$reportNull$$$0(3);
        }
        if (valueMap == null) {
            BasicAttrResourceItem.$$$reportNull$$$0(4);
        }
        if (valueDescriptionMap == null) {
            BasicAttrResourceItem.$$$reportNull$$$0(5);
        }
        super(ResourceType.ATTR, name, sourceFile, visibility);
        this.myDescription = description2;
        this.myGroupName = groupName;
        this.myFormats = ImmutableSet.copyOf(formats);
        this.myValueMap = valueMap.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(valueMap);
        this.myValueDescriptionMap = valueDescriptionMap.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(valueDescriptionMap);
    }

    @NotNull
    public final Set<AttributeFormat> getFormats() {
        Set<AttributeFormat> set = this.myFormats;
        if (set == null) {
            BasicAttrResourceItem.$$$reportNull$$$0(6);
        }
        return set;
    }

    public final void setFormats(@NotNull Set<AttributeFormat> formats) {
        if (formats == null) {
            BasicAttrResourceItem.$$$reportNull$$$0(7);
        }
        this.myFormats = ImmutableSet.copyOf(formats);
    }

    @NotNull
    public final Map<String, Integer> getAttributeValues() {
        Map<String, Integer> map2 = this.myValueMap;
        if (map2 == null) {
            BasicAttrResourceItem.$$$reportNull$$$0(8);
        }
        return map2;
    }

    @Nullable
    public final String getValueDescription(@NotNull String valueName) {
        if (valueName == null) {
            BasicAttrResourceItem.$$$reportNull$$$0(9);
        }
        return this.myValueDescriptionMap.get(valueName);
    }

    @Nullable
    public final String getDescription() {
        return this.myDescription;
    }

    @Nullable
    public final String getGroupName() {
        return this.myGroupName;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BasicAttrResourceItem other = (BasicAttrResourceItem)obj;
        return Objects.equals(this.myDescription, other.myDescription) && Objects.equals(this.myGroupName, other.myGroupName) && this.myFormats.equals(other.myFormats) && this.myValueMap.equals(other.myValueMap) && this.myValueDescriptionMap.equals(other.myValueDescriptionMap);
    }

    @NotNull
    public BasicAttrReference createReference() {
        BasicAttrReference attrReference = new BasicAttrReference(this.getNamespace(), this.getName(), this.getSourceFile(), this.getVisibility(), this.myDescription, this.myGroupName);
        attrReference.setNamespaceResolver(this.getNamespaceResolver());
        BasicAttrReference basicAttrReference = attrReference;
        if (basicAttrReference == null) {
            BasicAttrResourceItem.$$$reportNull$$$0(10);
        }
        return basicAttrReference;
    }

    @Override
    public void serialize(@NotNull Base128OutputStream stream, @NotNull Object2IntMap<String> configIndexes, @NotNull Object2IntMap<ResourceSourceFile> sourceFileIndexes, @NotNull Object2IntMap<ResourceNamespace.Resolver> namespaceResolverIndexes) throws IOException {
        if (stream == null) {
            BasicAttrResourceItem.$$$reportNull$$$0(11);
        }
        if (configIndexes == null) {
            BasicAttrResourceItem.$$$reportNull$$$0(12);
        }
        if (sourceFileIndexes == null) {
            BasicAttrResourceItem.$$$reportNull$$$0(13);
        }
        if (namespaceResolverIndexes == null) {
            BasicAttrResourceItem.$$$reportNull$$$0(14);
        }
        super.serialize(stream, configIndexes, sourceFileIndexes, namespaceResolverIndexes);
        BasicAttrResourceItem.serializeAttrValue(this, this.getRepository().getNamespace(), stream);
    }

    static void serializeAttrValue(@NotNull AttrResourceValue attr2, @NotNull ResourceNamespace defaultNamespace2, @NotNull Base128OutputStream stream) throws IOException {
        ResourceNamespace namespace;
        if (attr2 == null) {
            BasicAttrResourceItem.$$$reportNull$$$0(15);
        }
        if (defaultNamespace2 == null) {
            BasicAttrResourceItem.$$$reportNull$$$0(16);
        }
        if (stream == null) {
            BasicAttrResourceItem.$$$reportNull$$$0(17);
        }
        String namespaceSuffix = (namespace = attr2.getNamespace()).equals((Object)defaultNamespace2) ? null : namespace.getXmlNamespaceUri().substring("http://schemas.android.com/".length());
        stream.writeString(namespaceSuffix);
        stream.writeString(attr2.getDescription());
        stream.writeString(attr2.getGroupName());
        int formatMask = 0;
        for (AttributeFormat format2 : attr2.getFormats()) {
            formatMask |= 1 << format2.ordinal();
        }
        stream.writeInt(formatMask);
        Map attributeValues = attr2.getAttributeValues();
        stream.writeInt(attributeValues.size());
        for (Map.Entry entry : attributeValues.entrySet()) {
            String name = (String)entry.getKey();
            stream.writeString(name);
            Integer value2 = (Integer)entry.getValue();
            int v = value2 == null ? Integer.MIN_VALUE : value2 + 1;
            stream.writeInt(v);
            String description2 = attr2.getValueDescription(name);
            stream.writeString(description2);
        }
    }

    @NotNull
    static BasicValueResourceItemBase deserialize(@NotNull Base128InputStream stream, @NotNull String name, @NotNull ResourceVisibility visibility, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceNamespace.Resolver resolver) throws IOException {
        BasicValueResourceItemBase item;
        ResourceNamespace namespace;
        if (stream == null) {
            BasicAttrResourceItem.$$$reportNull$$$0(18);
        }
        if (name == null) {
            BasicAttrResourceItem.$$$reportNull$$$0(19);
        }
        if (visibility == null) {
            BasicAttrResourceItem.$$$reportNull$$$0(20);
        }
        if (sourceFile == null) {
            BasicAttrResourceItem.$$$reportNull$$$0(21);
        }
        if (resolver == null) {
            BasicAttrResourceItem.$$$reportNull$$$0(22);
        }
        String namespaceSuffix = stream.readString();
        String description2 = stream.readString();
        String groupName = stream.readString();
        int formatMask = stream.readInt();
        EnumSet<AttributeFormat> formats = EnumSet.noneOf(AttributeFormat.class);
        AttributeFormat[] attributeFormatValues = AttributeFormat.values();
        for (int ordinal = 0; ordinal < attributeFormatValues.length && formatMask != 0; ++ordinal, formatMask >>>= 1) {
            if ((formatMask & 1) == 0) continue;
            formats.add(attributeFormatValues[ordinal]);
        }
        int n = stream.readInt();
        HashMap valueMap = n == 0 ? Collections.emptyMap() : Maps.newHashMapWithExpectedSize((int)n);
        HashMap descriptionMap = n == 0 ? Collections.emptyMap() : Maps.newHashMapWithExpectedSize((int)n);
        for (int i2 = 0; i2 < n; ++i2) {
            String valueDescription;
            String valueName = stream.readString();
            int value2 = stream.readInt();
            if (value2 != Integer.MIN_VALUE) {
                valueMap.put(valueName, value2 - 1);
            }
            if ((valueDescription = stream.readString()) == null) continue;
            descriptionMap.put(valueName, valueDescription);
        }
        if (formats.isEmpty() && valueMap.isEmpty()) {
            ResourceNamespace resourceNamespace = namespace = namespaceSuffix == null ? sourceFile.getRepository().getNamespace() : ResourceNamespace.fromNamespaceUri((String)("http://schemas.android.com/" + namespaceSuffix));
            if (namespace == null) {
                throw Base128InputStream.StreamFormatException.invalidFormat();
            }
            item = new BasicAttrReference(namespace, name, sourceFile, visibility, description2, groupName);
        } else if (namespaceSuffix == null) {
            item = new BasicAttrResourceItem(name, sourceFile, visibility, description2, groupName, formats, valueMap, descriptionMap);
        } else {
            namespace = ResourceNamespace.fromNamespaceUri((String)("http://schemas.android.com/" + namespaceSuffix));
            if (namespace == null) {
                throw Base128InputStream.StreamFormatException.invalidFormat();
            }
            item = new BasicForeignAttrResourceItem(namespace, name, sourceFile, description2, groupName, formats, (Map<String, Integer>)valueMap, (Map<String, String>)descriptionMap);
        }
        item.setNamespaceResolver(resolver);
        BasicAttrResourceItem basicAttrResourceItem = item;
        if (basicAttrResourceItem == null) {
            BasicAttrResourceItem.$$$reportNull$$$0(23);
        }
        return basicAttrResourceItem;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 2: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibility";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formats";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueMap";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueDescriptionMap";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/resources/base/BasicAttrResourceItem";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueName";
                break;
            }
            case 11: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configIndexes";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFileIndexes";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceResolverIndexes";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultNamespace";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/resources/base/BasicAttrResourceItem";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormats";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeValues";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createReference";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 23: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setFormats";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getValueDescription";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "serializeAttrValue";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

