/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resources.aar;

import com.android.tools.idea.resources.aar.FrameworkResourceRepository;
import com.android.tools.idea.resources.base.Base128OutputStream;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.util.io.FileUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.NotNull;

public class FrameworkResJarCreator {
    public static void main(@NotNull String[] args) {
        if (args == null) {
            FrameworkResJarCreator.$$$reportNull$$$0(0);
        }
        if (args.length != 2) {
            FrameworkResJarCreator.printUsage(FrameworkResJarCreator.class.getName());
            System.exit(1);
        }
        Path resDirectory = Paths.get(args[0], new String[0]).toAbsolutePath().normalize();
        Path jarFile = Paths.get(args[1], new String[0]).toAbsolutePath().normalize();
        try {
            FrameworkResJarCreator.createJar(resDirectory, jarFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @VisibleForTesting
    static void createJar(@NotNull Path resDirectory, @NotNull Path jarFile) throws IOException {
        if (resDirectory == null) {
            FrameworkResJarCreator.$$$reportNull$$$0(1);
        }
        if (jarFile == null) {
            FrameworkResJarCreator.$$$reportNull$$$0(2);
        }
        FrameworkResourceRepository repository = FrameworkResourceRepository.create(resDirectory, null, null, false);
        Set<String> languages2 = repository.getLanguageGroups();
        try (ZipOutputStream zip = new ZipOutputStream(Files.newOutputStream(jarFile, new OpenOption[0]));){
            for (String language : languages2) {
                String entryName = FrameworkResourceRepository.getResourceTableNameForLanguage(language);
                FrameworkResJarCreator.createZipEntry(entryName, FrameworkResJarCreator.getEncodedResources(repository, language), zip);
            }
            Path parentDir = resDirectory.getParent();
            List<Path> files2 = FrameworkResJarCreator.getContainedFiles(resDirectory);
            for (Path file2 : files2) {
                String relativePath = FileUtil.toSystemIndependentName((String)parentDir.relativize(file2).toString());
                if (relativePath.equals("res/version")) continue;
                FrameworkResJarCreator.createZipEntry(relativePath, Files.readAllBytes(file2), zip);
            }
        }
    }

    @NotNull
    private static List<Path> getContainedFiles(@NotNull Path resDirectory) throws IOException {
        if (resDirectory == null) {
            FrameworkResJarCreator.$$$reportNull$$$0(3);
        }
        final ArrayList<Path> files2 = new ArrayList<Path>();
        Files.walkFileTree(resDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            @NotNull
            public FileVisitResult visitFile(@NotNull Path file2, @NotNull BasicFileAttributes attrs) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (attrs == null) {
                    1.$$$reportNull$$$0(1);
                }
                files2.add(file2);
                FileVisitResult fileVisitResult = FileVisitResult.CONTINUE;
                if (fileVisitResult == null) {
                    1.$$$reportNull$$$0(2);
                }
                return fileVisitResult;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "attrs";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/android/tools/idea/resources/aar/FrameworkResJarCreator$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/android/tools/idea/resources/aar/FrameworkResJarCreator$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitFile";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFile";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        Collections.sort(files2);
        ArrayList<Path> arrayList = files2;
        if (arrayList == null) {
            FrameworkResJarCreator.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static void createZipEntry(@NotNull String name, @NotNull byte[] content2, @NotNull ZipOutputStream zip) throws IOException {
        if (name == null) {
            FrameworkResJarCreator.$$$reportNull$$$0(5);
        }
        if (content2 == null) {
            FrameworkResJarCreator.$$$reportNull$$$0(6);
        }
        if (zip == null) {
            FrameworkResJarCreator.$$$reportNull$$$0(7);
        }
        ZipEntry entry = new ZipEntry(name);
        zip.putNextEntry(entry);
        zip.write(content2);
        zip.closeEntry();
    }

    @NotNull
    private static byte[] getEncodedResources(@NotNull FrameworkResourceRepository repository, @NotNull String language) throws IOException {
        if (repository == null) {
            FrameworkResJarCreator.$$$reportNull$$$0(8);
        }
        if (language == null) {
            FrameworkResJarCreator.$$$reportNull$$$0(9);
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try (Base128OutputStream stream = new Base128OutputStream(byteStream);){
            repository.writeToStream(stream, config -> language.equals(FrameworkResourceRepository.getLanguageGroup(config)));
        }
        byte[] byArray = byteStream.toByteArray();
        if (byArray == null) {
            FrameworkResJarCreator.$$$reportNull$$$0(10);
        }
        return byArray;
    }

    private static void printUsage(@NotNull String programName) {
        if (programName == null) {
            FrameworkResJarCreator.$$$reportNull$$$0(11);
        }
        System.out.println(String.format("Usage: %s <res_directory> <jar_file>", programName));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resDirectory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarFile";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/resources/aar/FrameworkResJarCreator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zip";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "programName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/resources/aar/FrameworkResJarCreator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainedFiles";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEncodedResources";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "main";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createJar";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getContainedFiles";
                break;
            }
            case 4: 
            case 10: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createZipEntry";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getEncodedResources";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "printUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

