/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resources.aar;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.AbstractResourceRepository;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceItemWithVisibility;
import com.android.ide.common.resources.ResourceVisitor;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.tools.idea.resources.aar.AarResourceRepository;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAarResourceRepository
extends AbstractResourceRepository
implements AarResourceRepository {
    @NotNull
    protected final ResourceNamespace myNamespace;
    @NotNull
    protected final Map<ResourceType, ListMultimap<String, ResourceItem>> myResources;
    @NotNull
    private final Map<ResourceType, Set<ResourceItem>> myPublicResources;
    @Nullable
    protected final String myLibraryName;

    AbstractAarResourceRepository(@NotNull ResourceNamespace namespace, @Nullable String libraryName) {
        if (namespace == null) {
            AbstractAarResourceRepository.$$$reportNull$$$0(0);
        }
        this.myResources = new EnumMap<ResourceType, ListMultimap<String, ResourceItem>>(ResourceType.class);
        this.myPublicResources = new EnumMap<ResourceType, Set<ResourceItem>>(ResourceType.class);
        this.myNamespace = namespace;
        this.myLibraryName = libraryName;
    }

    @NotNull
    protected final ListMultimap<String, ResourceItem> getResourcesInternal(@NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType) {
        if (namespace == null) {
            AbstractAarResourceRepository.$$$reportNull$$$0(1);
        }
        if (resourceType == null) {
            AbstractAarResourceRepository.$$$reportNull$$$0(2);
        }
        if (!namespace.equals((Object)this.myNamespace)) {
            ImmutableListMultimap immutableListMultimap = ImmutableListMultimap.of();
            if (immutableListMultimap == null) {
                AbstractAarResourceRepository.$$$reportNull$$$0(3);
            }
            return immutableListMultimap;
        }
        ListMultimap<String, ResourceItem> listMultimap = this.myResources.getOrDefault(resourceType, (ListMultimap<String, ResourceItem>)ImmutableListMultimap.of());
        if (listMultimap == null) {
            AbstractAarResourceRepository.$$$reportNull$$$0(4);
        }
        return listMultimap;
    }

    @NotNull
    private ListMultimap<String, ResourceItem> getOrCreateMap(@NotNull ResourceType resourceType) {
        if (resourceType == null) {
            AbstractAarResourceRepository.$$$reportNull$$$0(5);
        }
        ListMultimap listMultimap = this.myResources.computeIfAbsent(resourceType, type -> ArrayListMultimap.create());
        if (listMultimap == null) {
            AbstractAarResourceRepository.$$$reportNull$$$0(6);
        }
        return listMultimap;
    }

    protected final void addResourceItem(@NotNull ResourceItem item) {
        if (item == null) {
            AbstractAarResourceRepository.$$$reportNull$$$0(7);
        }
        ListMultimap<String, ResourceItem> multimap = this.getOrCreateMap(item.getType());
        multimap.put((Object)item.getName(), (Object)item);
    }

    protected final void populatePublicResourcesMap() {
        for (Map.Entry<ResourceType, ListMultimap<String, ResourceItem>> entry : this.myResources.entrySet()) {
            ResourceType resourceType = entry.getKey();
            ImmutableSet.Builder setBuilder = null;
            ListMultimap<String, ResourceItem> items2 = entry.getValue();
            for (ResourceItem item : items2.values()) {
                if (((ResourceItemWithVisibility)item).getVisibility() != ResourceVisibility.PUBLIC) continue;
                if (setBuilder == null) {
                    setBuilder = ImmutableSet.builder();
                }
                setBuilder.add((Object)item);
            }
            this.myPublicResources.put(resourceType, (Set<ResourceItem>)(setBuilder == null ? ImmutableSet.of() : setBuilder.build()));
        }
    }

    protected void freezeResources() {
        for (Map.Entry<ResourceType, ListMultimap<String, ResourceItem>> entry : this.myResources.entrySet()) {
            this.myResources.put(entry.getKey(), (ListMultimap<String, ResourceItem>)ImmutableListMultimap.copyOf((Multimap)((Multimap)entry.getValue())));
        }
    }

    @NotNull
    public ResourceVisitor.VisitResult accept(@NotNull ResourceVisitor visitor2) {
        if (visitor2 == null) {
            AbstractAarResourceRepository.$$$reportNull$$$0(8);
        }
        if (visitor2.shouldVisitNamespace(this.myNamespace) && AbstractResourceRepository.acceptByResources(this.myResources, (ResourceVisitor)visitor2) == ResourceVisitor.VisitResult.ABORT) {
            ResourceVisitor.VisitResult visitResult = ResourceVisitor.VisitResult.ABORT;
            if (visitResult == null) {
                AbstractAarResourceRepository.$$$reportNull$$$0(9);
            }
            return visitResult;
        }
        ResourceVisitor.VisitResult visitResult = ResourceVisitor.VisitResult.CONTINUE;
        if (visitResult == null) {
            AbstractAarResourceRepository.$$$reportNull$$$0(10);
        }
        return visitResult;
    }

    @NotNull
    public List<ResourceItem> getResources(@NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType, @NotNull String resourceName) {
        ListMultimap<String, ResourceItem> map2;
        List items2;
        if (namespace == null) {
            AbstractAarResourceRepository.$$$reportNull$$$0(11);
        }
        if (resourceType == null) {
            AbstractAarResourceRepository.$$$reportNull$$$0(12);
        }
        if (resourceName == null) {
            AbstractAarResourceRepository.$$$reportNull$$$0(13);
        }
        Object object = (items2 = (map2 = this.getResourcesInternal(namespace, resourceType)).get((Object)resourceName)) == null ? ImmutableList.of() : items2;
        if (object == null) {
            AbstractAarResourceRepository.$$$reportNull$$$0(14);
        }
        return object;
    }

    @NotNull
    public ListMultimap<String, ResourceItem> getResources(@NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType) {
        if (namespace == null) {
            AbstractAarResourceRepository.$$$reportNull$$$0(15);
        }
        if (resourceType == null) {
            AbstractAarResourceRepository.$$$reportNull$$$0(16);
        }
        return this.getResourcesInternal(namespace, resourceType);
    }

    @NotNull
    public Collection<ResourceItem> getPublicResources(@NotNull ResourceNamespace namespace, @NotNull ResourceType type) {
        if (namespace == null) {
            AbstractAarResourceRepository.$$$reportNull$$$0(17);
        }
        if (type == null) {
            AbstractAarResourceRepository.$$$reportNull$$$0(18);
        }
        if (!namespace.equals((Object)this.myNamespace)) {
            Set<ResourceItem> set = Collections.emptySet();
            if (set == null) {
                AbstractAarResourceRepository.$$$reportNull$$$0(19);
            }
            return set;
        }
        Set<ResourceItem> resourceItems = this.myPublicResources.get(type);
        Set<Object> set = resourceItems == null ? Collections.emptySet() : resourceItems;
        if (set == null) {
            AbstractAarResourceRepository.$$$reportNull$$$0(20);
        }
        return set;
    }

    @NotNull
    public final ResourceNamespace getNamespace() {
        ResourceNamespace resourceNamespace = this.myNamespace;
        if (resourceNamespace == null) {
            AbstractAarResourceRepository.$$$reportNull$$$0(21);
        }
        return resourceNamespace;
    }

    @Override
    @Nullable
    public final String getLibraryName() {
        return this.myLibraryName;
    }

    @Override
    @NotNull
    public final String getDisplayName() {
        String string = this.myLibraryName == null ? "Android Framework" : this.myLibraryName;
        if (string == null) {
            AbstractAarResourceRepository.$$$reportNull$$$0(22);
        }
        return string;
    }

    @Override
    public final boolean containsUserDefinedResources() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 2: 
            case 5: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceType";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/resources/aar/AbstractAarResourceRepository";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/resources/aar/AbstractAarResourceRepository";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourcesInternal";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateMap";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "accept";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getResources";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublicResources";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getResourcesInternal";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateMap";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addResourceItem";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getResources";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPublicResources";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

