/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resources.aar;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.AndroidManifestPackageNameUtils;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.symbols.SymbolIo;
import com.android.ide.common.symbols.SymbolTable;
import com.android.ide.common.util.PathString;
import com.android.projectmodel.ResourceFolder;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.tools.idea.resources.aar.AbstractAarResourceRepository;
import com.android.tools.idea.resources.aar.CachingData;
import com.android.tools.idea.resources.base.Base128InputStream;
import com.android.tools.idea.resources.base.Base128OutputStream;
import com.android.tools.idea.resources.base.BasicResourceItem;
import com.android.tools.idea.resources.base.NamespaceResolver;
import com.android.tools.idea.resources.base.RepositoryConfiguration;
import com.android.tools.idea.resources.base.RepositoryLoader;
import com.android.tools.idea.resources.base.ResourceSerializationUtil;
import com.android.tools.idea.resources.base.ResourceSourceFileImpl;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.NullableLazyValue;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class AarSourceResourceRepository
extends AbstractAarResourceRepository {
    static final String CACHE_FILE_FORMAT_VERSION = "3";
    private static final byte[] CACHE_FILE_HEADER = "Resource cache".getBytes(StandardCharsets.UTF_8);
    private static final Logger LOG = Logger.getInstance(AarSourceResourceRepository.class);
    @NotNull
    protected final Path myResourceDirectoryOrFile;
    protected boolean myLoadedFromCache;
    @NotNull
    private final String mySourceFileProtocol;
    @NotNull
    private final String myResourcePathPrefix;
    @NotNull
    private final String myResourceUrlPrefix;
    @NotNull
    private final NullableLazyValue<String> myManifestPackageName;

    protected AarSourceResourceRepository(@NotNull RepositoryLoader loader, @Nullable String libraryName) {
        if (loader == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(0);
        }
        super(loader.getNamespace(), libraryName);
        this.myResourceDirectoryOrFile = loader.getResourceDirectoryOrFile();
        this.mySourceFileProtocol = loader.getSourceFileProtocol();
        this.myResourcePathPrefix = loader.getResourcePathPrefix();
        this.myResourceUrlPrefix = loader.getResourceUrlPrefix();
        this.myManifestPackageName = NullableLazyValue.createValue(() -> {
            try {
                PathString manifestPath = this.getSourceFile("../AndroidManifest.xml", true);
                return AndroidManifestPackageNameUtils.getPackageNameFromManifestFile((PathString)manifestPath);
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (IOException e) {
                LOG.error("Failed to read manifest AndroidManifest.xml for " + this.getDisplayName(), (Throwable)e);
                return null;
            }
        });
    }

    @NotNull
    public static AarSourceResourceRepository create(@NotNull Path resourceDirectoryOrFile, @NotNull String libraryName) {
        if (resourceDirectoryOrFile == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(1);
        }
        if (libraryName == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(2);
        }
        return AarSourceResourceRepository.create(resourceDirectoryOrFile, libraryName, null);
    }

    @NotNull
    public static AarSourceResourceRepository create(@NotNull Path resourceDirectoryOrFile, @NotNull String libraryName, @Nullable CachingData cachingData) {
        if (resourceDirectoryOrFile == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(3);
        }
        if (libraryName == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(4);
        }
        return AarSourceResourceRepository.create(resourceDirectoryOrFile, null, ResourceNamespace.RES_AUTO, libraryName, cachingData);
    }

    @NotNull
    public static AarSourceResourceRepository create(@NotNull ResourceFolder resourceFolder, @NotNull String libraryName, @Nullable CachingData cachingData) {
        Path resDir;
        if (resourceFolder == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(5);
        }
        if (libraryName == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(6);
        }
        Preconditions.checkArgument(((resDir = resourceFolder.getRoot().toPath()) != null ? 1 : 0) != 0);
        return AarSourceResourceRepository.create(resDir, resourceFolder.getResources(), ResourceNamespace.RES_AUTO, libraryName, cachingData);
    }

    @NotNull
    private static AarSourceResourceRepository create(@NotNull Path resourceDirectoryOrFile, @Nullable Collection<PathString> resourceFilesAndFolders, @NotNull ResourceNamespace namespace, @NotNull String libraryName, @Nullable CachingData cachingData) {
        Executor executor;
        if (resourceDirectoryOrFile == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(7);
        }
        if (namespace == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(8);
        }
        if (libraryName == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(9);
        }
        Loader loader = new Loader(resourceDirectoryOrFile, resourceFilesAndFolders, namespace);
        AarSourceResourceRepository repository = new AarSourceResourceRepository(loader, libraryName);
        if (cachingData != null && resourceFilesAndFolders == null && repository.loadFromPersistentCache(cachingData)) {
            AarSourceResourceRepository aarSourceResourceRepository = repository;
            if (aarSourceResourceRepository == null) {
                AarSourceResourceRepository.$$$reportNull$$$0(10);
            }
            return aarSourceResourceRepository;
        }
        loader.loadRepositoryContents(repository);
        repository.populatePublicResourcesMap();
        repository.freezeResources();
        if (cachingData != null && resourceFilesAndFolders == null && (executor = cachingData.getCacheCreationExecutor()) != null) {
            executor.execute(() -> repository.createPersistentCache(cachingData));
        }
        AarSourceResourceRepository aarSourceResourceRepository = repository;
        if (aarSourceResourceRepository == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(11);
        }
        return aarSourceResourceRepository;
    }

    @Override
    @NotNull
    public Path getOrigin() {
        Path path2 = this.myResourceDirectoryOrFile;
        if (path2 == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(12);
        }
        return path2;
    }

    @TestOnly
    @NotNull
    public static AarSourceResourceRepository createForTest(@NotNull Path resourceDirectoryOrFile, @NotNull ResourceNamespace namespace, @NotNull String libraryName) {
        if (resourceDirectoryOrFile == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(13);
        }
        if (namespace == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(14);
        }
        if (libraryName == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(15);
        }
        return AarSourceResourceRepository.create(resourceDirectoryOrFile, null, namespace, libraryName, null);
    }

    @Nullable
    public String getPackageName() {
        String packageName = this.myNamespace.getPackageName();
        return packageName == null ? (String)this.myManifestPackageName.getValue() : packageName;
    }

    @Override
    @NotNull
    public PathString getSourceFile(@NotNull String relativeResourcePath, boolean forFileResource) {
        if (relativeResourcePath == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(16);
        }
        return new PathString(this.mySourceFileProtocol, this.myResourcePathPrefix + relativeResourcePath);
    }

    @Override
    @NotNull
    public String getResourceUrl(@NotNull String relativeResourcePath) {
        if (relativeResourcePath == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(17);
        }
        String string = this.myResourceUrlPrefix + relativeResourcePath;
        if (string == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(18);
        }
        return string;
    }

    private boolean loadFromPersistentCache(@NotNull CachingData cachingData) {
        if (cachingData == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(19);
        }
        byte[] header = ResourceSerializationUtil.getCacheFileHeader(stream -> this.writeCacheHeaderContent(cachingData, stream));
        return this.loadFromPersistentCache(cachingData.getCacheFile(), header);
    }

    private void createPersistentCache(@NotNull CachingData cachingData) {
        if (cachingData == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(20);
        }
        byte[] header = ResourceSerializationUtil.getCacheFileHeader(stream -> this.writeCacheHeaderContent(cachingData, stream));
        ResourceSerializationUtil.createPersistentCache(cachingData.getCacheFile(), header, stream -> this.writeToStream(stream, config -> true));
    }

    protected void writeCacheHeaderContent(@NotNull CachingData cachingData, @NotNull Base128OutputStream stream) throws IOException {
        if (cachingData == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(21);
        }
        if (stream == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(22);
        }
        stream.write(CACHE_FILE_HEADER);
        stream.writeString(CACHE_FILE_FORMAT_VERSION);
        stream.writeString(this.myResourceDirectoryOrFile.toString());
        stream.writeString(cachingData.getContentVersion());
        stream.writeString(cachingData.getCodeVersion());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadFromPersistentCache(@NotNull Path cacheFile, @NotNull byte[] fileHeader) {
        if (cacheFile == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(23);
        }
        if (fileHeader == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(24);
        }
        try (Base128InputStream stream = new Base128InputStream(cacheFile);){
            if (!stream.validateContents(fileHeader)) {
                boolean bl = false;
                return bl;
            }
            this.loadFromStream(stream, Maps.newHashMapWithExpectedSize((int)1000), null);
            this.populatePublicResourcesMap();
            this.freezeResources();
            this.myLoadedFromCache = true;
            boolean bl = true;
            return bl;
        }
        catch (NoSuchFileException e) {
            return false;
        }
        catch (ProcessCanceledException e) {
            this.cleanupAfterFailedLoadingFromCache();
            throw e;
        }
        catch (Throwable e) {
            this.cleanupAfterFailedLoadingFromCache();
            LOG.warn("Failed to load resources from cache file " + cacheFile.toString(), e);
            return false;
        }
    }

    protected void cleanupAfterFailedLoadingFromCache() {
        this.myResources.clear();
    }

    void writeToStream(@NotNull Base128OutputStream stream, @NotNull Predicate<FolderConfiguration> configFilter) throws IOException {
        if (stream == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(25);
        }
        if (configFilter == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(26);
        }
        ResourceSerializationUtil.writeResourcesToStream(this.myResources, stream, configFilter);
    }

    protected void loadFromStream(@NotNull Base128InputStream stream, @NotNull Map<String, String> stringCache, @Nullable Map<NamespaceResolver, NamespaceResolver> namespaceResolverCache) throws IOException {
        if (stream == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(27);
        }
        if (stringCache == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(28);
        }
        ResourceSerializationUtil.readResourcesFromStream(stream, stringCache, namespaceResolverCache, this, item -> this.addResourceItem((ResourceItem)item));
    }

    @TestOnly
    boolean isLoadedFromCache() {
        return this.myLoadedFromCache;
    }

    @NotNull
    public String toString() {
        String string = this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)) + " for " + this.myResourceDirectoryOrFile;
        if (string == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(29);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceDirectoryOrFile";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceFolder";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/resources/aar/AarSourceResourceRepository";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeResourcePath";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachingData";
                break;
            }
            case 22: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheFile";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileHeader";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFilter";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/resources/aar/AarSourceResourceRepository";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrigin";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceUrl";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 29: {
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createForTest";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getResourceUrl";
                break;
            }
            case 19: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "loadFromPersistentCache";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createPersistentCache";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "writeCacheHeaderContent";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "writeToStream";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "loadFromStream";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Loader
    extends RepositoryLoader<AarSourceResourceRepository> {
        @NotNull
        private Set<String> myRTxtIds;

        Loader(@NotNull Path resourceDirectoryOrFile, @Nullable Collection<PathString> resourceFilesAndFolders, @NotNull ResourceNamespace namespace) {
            if (resourceDirectoryOrFile == null) {
                Loader.$$$reportNull$$$0(0);
            }
            if (namespace == null) {
                Loader.$$$reportNull$$$0(1);
            }
            super(resourceDirectoryOrFile, resourceFilesAndFolders, namespace);
            this.myRTxtIds = ImmutableSet.of();
        }

        @Override
        protected boolean loadIdsFromRTxt() {
            if (this.myZipFile == null) {
                Path rDotTxt = this.myResourceDirectoryOrFile.resolveSibling("R.txt");
                if (Files.exists(rDotTxt, new LinkOption[0])) {
                    try {
                        SymbolTable symbolTable = SymbolIo.readFromAaptNoValues((File)rDotTxt.toFile(), null);
                        this.myRTxtIds = Loader.computeIds(symbolTable);
                        return true;
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to load id resources from " + rDotTxt.toString(), (Throwable)e);
                    }
                }
            } else {
                ZipEntry zipEntry = this.myZipFile.getEntry("R.txt");
                if (zipEntry != null) {
                    boolean bl;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(this.myZipFile.getInputStream(zipEntry), StandardCharsets.UTF_8));
                    try {
                        SymbolTable symbolTable = SymbolIo.readFromAaptNoValues((BufferedReader)reader, (String)("R.txt in " + this.myResourceDirectoryOrFile), null);
                        this.myRTxtIds = Loader.computeIds(symbolTable);
                        bl = true;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (ProcessCanceledException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            LOG.warn("Failed to load id resources from R.txt in " + this.myResourceDirectoryOrFile, (Throwable)e);
                        }
                    }
                    reader.close();
                    return bl;
                }
                return false;
            }
            return false;
        }

        @Override
        protected void finishLoading(@NotNull AarSourceResourceRepository repository) {
            if (repository == null) {
                Loader.$$$reportNull$$$0(2);
            }
            super.finishLoading(repository);
            this.createResourcesForRTxtIds(repository);
        }

        private void createResourcesForRTxtIds(@NotNull AarSourceResourceRepository repository) {
            if (repository == null) {
                Loader.$$$reportNull$$$0(3);
            }
            if (!this.myRTxtIds.isEmpty()) {
                RepositoryConfiguration configuration = this.getConfiguration(repository, ResourceItem.DEFAULT_CONFIGURATION);
                ResourceSourceFileImpl sourceFile = new ResourceSourceFileImpl(null, configuration);
                for (String name : this.myRTxtIds) {
                    this.addIdResourceItem(name, sourceFile);
                }
                this.addValueFileResources();
            }
        }

        private static Set<String> computeIds(@NotNull SymbolTable symbolTable) {
            if (symbolTable == null) {
                Loader.$$$reportNull$$$0(4);
            }
            return symbolTable.getSymbols().row((Object)ResourceType.ID).values().stream().map(s -> s.getCanonicalName()).collect(Collectors.toSet());
        }

        @Override
        protected void loadPublicResourceNames() {
            if (this.myZipFile == null) {
                Path file2 = this.myResourceDirectoryOrFile.resolveSibling("public.txt");
                try (BufferedReader reader = Files.newBufferedReader(file2);){
                    this.readPublicResourceNames(reader);
                }
                catch (NoSuchFileException e) {
                    this.myDefaultVisibility = ResourceVisibility.PUBLIC;
                }
                catch (IOException e) {
                    LOG.warn("Error reading " + file2.toString(), (Throwable)e);
                }
            } else {
                ZipEntry zipEntry = this.myZipFile.getEntry("public.txt");
                if (zipEntry == null) {
                    this.myDefaultVisibility = ResourceVisibility.PUBLIC;
                } else {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.myZipFile.getInputStream(zipEntry), StandardCharsets.UTF_8));){
                        this.readPublicResourceNames(reader);
                    }
                    catch (IOException e) {
                        LOG.warn("Error reading public.txt from " + this.myResourceDirectoryOrFile, (Throwable)e);
                    }
                }
            }
        }

        @Override
        protected void addResourceItem(@NotNull BasicResourceItem item, @NotNull AarSourceResourceRepository repository) {
            if (item == null) {
                Loader.$$$reportNull$$$0(5);
            }
            if (repository == null) {
                Loader.$$$reportNull$$$0(6);
            }
            repository.addResourceItem((ResourceItem)item);
        }

        private void readPublicResourceNames(@NotNull BufferedReader reader) throws IOException {
            String line2;
            if (reader == null) {
                Loader.$$$reportNull$$$0(7);
            }
            while ((line2 = reader.readLine()) != null) {
                ResourceType type;
                int delimiterPos = (line2 = line2.trim()).indexOf(32);
                if (delimiterPos <= 0 || delimiterPos + 1 >= line2.length() || (type = ResourceType.fromXmlTagName((String)line2.substring(0, delimiterPos))) == null) continue;
                String name = line2.substring(delimiterPos + 1);
                this.addPublicResourceName(type, name);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resourceDirectoryOrFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespace";
                    break;
                }
                case 2: 
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repository";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "symbolTable";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reader";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/resources/aar/AarSourceResourceRepository$Loader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "finishLoading";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createResourcesForRTxtIds";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computeIds";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addResourceItem";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "readPublicResourceNames";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

