/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.SampleDataResourceValueImpl;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.sampledata.SampleDataCsvParser;
import com.android.ide.common.resources.sampledata.SampleDataHolder;
import com.android.ide.common.resources.sampledata.SampleDataJsonParser;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.ResolvableResourceItem;
import com.android.tools.idea.sampledata.datasource.HardcodedContent;
import com.google.common.base.Joiner;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SampleDataResourceItem
implements ResourceItem,
ResolvableResourceItem {
    private static final Logger LOG = Logger.getInstance(SampleDataResourceItem.class);
    private static final Cache<String, SampleDataHolder> sSampleDataCache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).softValues().weigher((key, value2) -> value2.getFileSizeMb()).maximumWeight(50L).build();
    @NotNull
    private final SingleNamespaceResourceRepository myOwner;
    @NotNull
    private final String myName;
    @NotNull
    private final Function<OutputStream, Exception> myDataSource;
    @NotNull
    private final Supplier<Long> myDataSourceModificationStamp;
    @Nullable
    private final SmartPsiElementPointer<PsiElement> mySourceElement;
    @Nullable
    private ResourceValue myResourceValue;
    @NotNull
    private final ContentType myContentType;

    private SampleDataResourceItem(@NotNull SingleNamespaceResourceRepository owner, @NotNull String name, @NotNull Function<OutputStream, Exception> dataSource, @NotNull Supplier<Long> dataSourceModificationStamp, @Nullable SmartPsiElementPointer<PsiElement> sourceElement, @NotNull ContentType contentType) {
        if (owner == null) {
            SampleDataResourceItem.$$$reportNull$$$0(0);
        }
        if (name == null) {
            SampleDataResourceItem.$$$reportNull$$$0(1);
        }
        if (dataSource == null) {
            SampleDataResourceItem.$$$reportNull$$$0(2);
        }
        if (dataSourceModificationStamp == null) {
            SampleDataResourceItem.$$$reportNull$$$0(3);
        }
        if (contentType == null) {
            SampleDataResourceItem.$$$reportNull$$$0(4);
        }
        this.myOwner = owner;
        this.myName = name;
        this.myDataSource = dataSource;
        this.myDataSourceModificationStamp = dataSourceModificationStamp;
        this.mySourceElement = sourceElement;
        this.myContentType = contentType;
    }

    public static void invalidateCache() {
        sSampleDataCache.invalidateAll();
    }

    @NotNull
    static SampleDataResourceItem getFromStaticDataSource(@NotNull SingleNamespaceResourceRepository repository, @NotNull String name, @NotNull Function<OutputStream, Exception> source, @NotNull ContentType contentType) {
        if (repository == null) {
            SampleDataResourceItem.$$$reportNull$$$0(5);
        }
        if (name == null) {
            SampleDataResourceItem.$$$reportNull$$$0(6);
        }
        if (source == null) {
            SampleDataResourceItem.$$$reportNull$$$0(7);
        }
        if (contentType == null) {
            SampleDataResourceItem.$$$reportNull$$$0(8);
        }
        return new SampleDataResourceItem(repository, name, source, () -> 1L, null, contentType);
    }

    @NotNull
    private static SampleDataResourceItem getFromPlainFile(@NotNull SingleNamespaceResourceRepository repository, @NotNull SmartPsiElementPointer<PsiElement> filePointer) {
        if (repository == null) {
            SampleDataResourceItem.$$$reportNull$$$0(9);
        }
        if (filePointer == null) {
            SampleDataResourceItem.$$$reportNull$$$0(10);
        }
        VirtualFile vFile = filePointer.getVirtualFile();
        String fileName = vFile.getName();
        return new SampleDataResourceItem(repository, fileName, output -> {
            PsiElement sourceElement = filePointer.getElement();
            if (sourceElement == null) {
                LOG.warn("File pointer was invalidated and the repository was not refreshed");
                return null;
            }
            try {
                output.write(sourceElement.getText().getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                LOG.warn("Unable to load content from plain file " + fileName, (Throwable)e);
                return e;
            }
            return null;
        }, () -> vFile.getModificationStamp() + 1L, filePointer, ContentType.UNKNOWN);
    }

    @NotNull
    private static SampleDataResourceItem getFromDirectory(@NotNull SingleNamespaceResourceRepository repository, @NotNull SmartPsiElementPointer<PsiElement> directoryPointer) {
        if (repository == null) {
            SampleDataResourceItem.$$$reportNull$$$0(11);
        }
        if (directoryPointer == null) {
            SampleDataResourceItem.$$$reportNull$$$0(12);
        }
        VirtualFile directory = directoryPointer.getVirtualFile();
        return new SampleDataResourceItem(repository, directory.getName(), output -> {
            try (PrintStream printStream = new PrintStream((OutputStream)output, false, StandardCharsets.UTF_8.name());){
                Arrays.stream(directory.getChildren()).filter(child -> !child.isDirectory()).sorted(Comparator.comparing(VirtualFile::getName)).forEach(file2 -> printStream.println(file2.getPath()));
            }
            catch (UnsupportedEncodingException e) {
                LOG.error((Throwable)e);
            }
            return null;
        }, () -> directory.getModificationStamp() + 1L, directoryPointer, ContentType.IMAGE);
    }

    @NotNull
    private static SampleDataResourceItem getFromJsonFile(@NotNull SingleNamespaceResourceRepository repository, @NotNull SmartPsiElementPointer<PsiElement> jsonPointer, @NotNull String contentPath) {
        if (repository == null) {
            SampleDataResourceItem.$$$reportNull$$$0(13);
        }
        if (jsonPointer == null) {
            SampleDataResourceItem.$$$reportNull$$$0(14);
        }
        if (contentPath == null) {
            SampleDataResourceItem.$$$reportNull$$$0(15);
        }
        VirtualFile vFile = jsonPointer.getVirtualFile();
        String fileName = vFile.getName();
        return new SampleDataResourceItem(repository, fileName + contentPath, output -> {
            if (contentPath.isEmpty()) {
                return null;
            }
            PsiElement source = jsonPointer.getElement();
            if (source == null) {
                LOG.warn("JSON file pointer was invalidated and the repository was not refreshed");
                return null;
            }
            try {
                StringReader input = new StringReader(source.getText());
                SampleDataJsonParser parser = SampleDataJsonParser.parse((Reader)input);
                if (parser != null) {
                    output.write(parser.getContentFromPath(contentPath));
                }
            }
            catch (IOException e) {
                LOG.warn("Unable to load content from json file " + fileName, (Throwable)e);
                return e;
            }
            return null;
        }, () -> vFile.getModificationStamp() + 1L, jsonPointer, ContentType.UNKNOWN);
    }

    @NotNull
    private static String getTextFromPsiElementPointer(SmartPsiElementPointer<PsiElement> pointer) {
        PsiElement rootJsonElement = pointer.getElement();
        return rootJsonElement != null ? rootJsonElement.getText() : "";
    }

    @NotNull
    public static List<SampleDataResourceItem> getFromPsiFileSystemItem(@NotNull SingleNamespaceResourceRepository repository, @NotNull PsiFileSystemItem sampleDataSource) throws IOException {
        String extension;
        if (repository == null) {
            SampleDataResourceItem.$$$reportNull$$$0(16);
        }
        if (sampleDataSource == null) {
            SampleDataResourceItem.$$$reportNull$$$0(17);
        }
        if ((extension = sampleDataSource.getVirtualFile().getExtension()) == null) {
            extension = "";
        }
        SmartPsiElementPointer psiPointer = SmartPointerManager.getInstance((Project)sampleDataSource.getProject()).createSmartPsiElementPointer((PsiElement)sampleDataSource);
        switch (extension) {
            case "json": {
                SampleDataJsonParser parser;
                String jsonText = SampleDataResourceItem.getTextFromPsiElementPointer((SmartPsiElementPointer<PsiElement>)psiPointer);
                try (StringReader reader = new StringReader(jsonText);){
                    parser = SampleDataJsonParser.parse((Reader)reader);
                }
                if (parser == null) {
                    List<SampleDataResourceItem> list = Collections.emptyList();
                    if (list == null) {
                        SampleDataResourceItem.$$$reportNull$$$0(18);
                    }
                    return list;
                }
                Set possiblePaths = parser.getPossiblePaths();
                ImmutableList.Builder items2 = ImmutableList.builder();
                for (String path2 : possiblePaths) {
                    items2.add((Object)SampleDataResourceItem.getFromJsonFile(repository, (SmartPsiElementPointer<PsiElement>)psiPointer, path2));
                }
                ImmutableList immutableList = items2.build();
                if (immutableList == null) {
                    SampleDataResourceItem.$$$reportNull$$$0(19);
                }
                return immutableList;
            }
            case "csv": {
                SampleDataCsvParser parser;
                String csvText = SampleDataResourceItem.getTextFromPsiElementPointer((SmartPsiElementPointer<PsiElement>)psiPointer);
                try (StringReader reader = new StringReader(csvText);){
                    parser = SampleDataCsvParser.parse((Reader)reader);
                }
                Set possiblePaths = parser.getPossiblePaths();
                ImmutableList.Builder items3 = ImmutableList.builder();
                for (String path3 : possiblePaths) {
                    items3.add((Object)new SampleDataResourceItem(repository, sampleDataSource.getName() + path3, new HardcodedContent(Joiner.on((char)'\n').join((Iterable)parser.getPath(path3))), () -> psiPointer.getVirtualFile().getModificationStamp() + 1L, (SmartPsiElementPointer<PsiElement>)psiPointer, ContentType.UNKNOWN));
                }
                ImmutableList immutableList = items3.build();
                if (immutableList == null) {
                    SampleDataResourceItem.$$$reportNull$$$0(20);
                }
                return immutableList;
            }
        }
        ImmutableList immutableList = ImmutableList.of((Object)(sampleDataSource instanceof PsiDirectory ? SampleDataResourceItem.getFromDirectory(repository, (SmartPsiElementPointer<PsiElement>)psiPointer) : SampleDataResourceItem.getFromPlainFile(repository, (SmartPsiElementPointer<PsiElement>)psiPointer)));
        if (immutableList == null) {
            SampleDataResourceItem.$$$reportNull$$$0(21);
        }
        return immutableList;
    }

    @Nullable
    private byte[] getContent(@Nullable Runnable onCachedOutOfDate) {
        SampleDataHolder value2 = (SampleDataHolder)sSampleDataCache.getIfPresent((Object)this.getName());
        if (value2 == null || value2.getLastModification() == 0L || value2.getLastModification() != this.myDataSourceModificationStamp.get().longValue()) {
            long lastModificationStamp = this.myDataSourceModificationStamp.get();
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                Exception e = this.myDataSource.apply(output);
                if (e == null) {
                    byte[] content2 = output.toByteArray();
                    value2 = new SampleDataHolder(this.getName(), lastModificationStamp, content2.length / 1000000, content2);
                    sSampleDataCache.put((Object)this.getName(), (Object)value2);
                }
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
            if (onCachedOutOfDate != null) {
                onCachedOutOfDate.run();
            }
        }
        return value2 != null ? value2.getContents() : null;
    }

    @Nullable
    public String getValueText() {
        byte[] content2 = this.getContent(null);
        return content2 != null ? new String(content2, StandardCharsets.UTF_8) : null;
    }

    @NotNull
    public SingleNamespaceResourceRepository getRepository() {
        SingleNamespaceResourceRepository singleNamespaceResourceRepository = this.myOwner;
        if (singleNamespaceResourceRepository == null) {
            SampleDataResourceItem.$$$reportNull$$$0(22);
        }
        return singleNamespaceResourceRepository;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            SampleDataResourceItem.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    public ResourceType getType() {
        ResourceType resourceType = ResourceType.SAMPLE_DATA;
        if (resourceType == null) {
            SampleDataResourceItem.$$$reportNull$$$0(24);
        }
        return resourceType;
    }

    @Nullable
    public String getLibraryName() {
        return null;
    }

    @NotNull
    public ResourceNamespace getNamespace() {
        ResourceNamespace resourceNamespace = this.myOwner.getNamespace();
        if (resourceNamespace == null) {
            SampleDataResourceItem.$$$reportNull$$$0(25);
        }
        return resourceNamespace;
    }

    @NotNull
    public ResourceReference getReferenceToSelf() {
        return new ResourceReference(this.getNamespace(), this.getType(), this.getName());
    }

    @NotNull
    public FolderConfiguration getConfiguration() {
        FolderConfiguration folderConfiguration = DEFAULT_CONFIGURATION;
        if (folderConfiguration == null) {
            SampleDataResourceItem.$$$reportNull$$$0(26);
        }
        return folderConfiguration;
    }

    @NotNull
    public String getKey() {
        String string = this.getType() + "/" + this.getName();
        if (string == null) {
            SampleDataResourceItem.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    public ResourceValue getResourceValue() {
        byte[] content2 = this.getContent(() -> {
            this.myResourceValue = null;
        });
        if (this.myResourceValue == null) {
            this.myResourceValue = new SampleDataResourceValueImpl(this.getReferenceToSelf(), content2);
        }
        ResourceValue resourceValue2 = this.myResourceValue;
        if (resourceValue2 == null) {
            SampleDataResourceItem.$$$reportNull$$$0(28);
        }
        return resourceValue2;
    }

    @Nullable
    public PathString getSource() {
        return null;
    }

    public boolean isFileBased() {
        return false;
    }

    @Override
    @NotNull
    public ResolveResult createResolveResult() {
        return new ResolveResult(){

            @Nullable
            public PsiElement getElement() {
                return SampleDataResourceItem.this.mySourceElement != null ? SampleDataResourceItem.this.mySourceElement.getElement() : null;
            }

            public boolean isValidResult() {
                return true;
            }
        };
    }

    @NotNull
    public ContentType getContentType() {
        ContentType contentType = this.myContentType;
        if (contentType == null) {
            SampleDataResourceItem.$$$reportNull$$$0(29);
        }
        return contentType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSourceModificationStamp";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePointer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryPointer";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonPointer";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentPath";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sampleDataSource";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/SampleDataResourceItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/SampleDataResourceItem";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFromPsiFileSystemItem";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepository";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceValue";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFromStaticDataSource";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFromPlainFile";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFromDirectory";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFromJsonFile";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getFromPsiFileSystemItem";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ContentType {
        UNKNOWN,
        TEXT,
        IMAGE;

    }
}

