/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.databinding.util.DataBindingUtil;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.project.AndroidProjectBuildNotifications;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.annotations.NotNull;

public class ResourceNotificationManager {
    private final Project myProject;
    private final Map<Module, ModuleEventObserver> myModuleToObserverMap = Maps.newHashMap();
    private final Map<VirtualFile, FileEventObserver> myFileToObserverMap = Maps.newHashMap();
    private final Map<Configuration, ConfigurationEventObserver> myConfigurationToObserverMap = Maps.newHashMap();
    private ProjectPsiTreeObserver myProjectPsiTreeObserver;
    private final ProjectBuildObserver myProjectBuildObserver = new ProjectBuildObserver();
    private boolean myPendingNotify;
    private long myModificationCount;
    private EnumSet<Reason> myEvents = EnumSet.noneOf(Reason.class);
    private final Object CHANGE_PENDING_LOCK = new Object();

    public ResourceNotificationManager(Project project) {
        this.myProject = project;
    }

    @NotNull
    public static ResourceNotificationManager getInstance(@NotNull Project project) {
        if (project == null) {
            ResourceNotificationManager.$$$reportNull$$$0(0);
        }
        ResourceNotificationManager resourceNotificationManager = (ResourceNotificationManager)project.getService(ResourceNotificationManager.class);
        if (resourceNotificationManager == null) {
            ResourceNotificationManager.$$$reportNull$$$0(1);
        }
        return resourceNotificationManager;
    }

    @NotNull
    public ResourceVersion getCurrentVersion(@NotNull AndroidFacet facet2, PsiFile file2, Configuration configuration) {
        if (facet2 == null) {
            ResourceNotificationManager.$$$reportNull$$$0(2);
        }
        LocalResourceRepository repository = ResourceRepositoryManager.getAppResources(facet2);
        if (file2 != null) {
            long fileStamp = file2.getModificationStamp();
            if (configuration != null) {
                return new ResourceVersion(repository.getModificationCount(), fileStamp, configuration.getModificationCount(), configuration.getConfigurationManager().getStateVersion(), this.myModificationCount);
            }
            return new ResourceVersion(repository.getModificationCount(), fileStamp, 0L, 0L, this.myModificationCount);
        }
        return new ResourceVersion(repository.getModificationCount(), 0L, 0L, 0L, this.myModificationCount);
    }

    public synchronized ResourceVersion addListener(@NotNull ResourceChangeListener listener2, @NotNull AndroidFacet facet2, VirtualFile file2, Configuration configuration) {
        Module module2;
        ModuleEventObserver moduleEventObserver;
        if (listener2 == null) {
            ResourceNotificationManager.$$$reportNull$$$0(3);
        }
        if (facet2 == null) {
            ResourceNotificationManager.$$$reportNull$$$0(4);
        }
        if ((moduleEventObserver = this.myModuleToObserverMap.get(module2 = facet2.getModule())) == null) {
            if (this.myModuleToObserverMap.isEmpty()) {
                if (this.myProjectPsiTreeObserver == null) {
                    this.myProjectPsiTreeObserver = new ProjectPsiTreeObserver();
                }
                this.myProjectBuildObserver.startListening();
            }
            moduleEventObserver = new ModuleEventObserver(facet2);
            this.myModuleToObserverMap.put(module2, moduleEventObserver);
        }
        moduleEventObserver.addListener(listener2);
        if (file2 != null) {
            FileEventObserver fileEventObserver = this.myFileToObserverMap.get(file2);
            if (fileEventObserver == null) {
                fileEventObserver = new FileEventObserver(module2);
                this.myFileToObserverMap.put(file2, fileEventObserver);
            }
            fileEventObserver.addListener(listener2);
            if (configuration != null) {
                ConfigurationEventObserver configurationEventObserver = this.myConfigurationToObserverMap.get(configuration);
                if (configurationEventObserver == null) {
                    configurationEventObserver = new ConfigurationEventObserver(configuration);
                    this.myConfigurationToObserverMap.put(configuration, configurationEventObserver);
                }
                configurationEventObserver.addListener(listener2);
            }
        } else assert (configuration == null) : configuration;
        return this.getCurrentVersion(facet2, file2 != null ? AndroidPsiUtils.getPsiFileSafely((Project)this.myProject, (VirtualFile)file2) : null, configuration);
    }

    public synchronized void removeListener(@NotNull ResourceChangeListener listener2, AndroidFacet facet2, VirtualFile file2, Configuration configuration) {
        if (listener2 == null) {
            ResourceNotificationManager.$$$reportNull$$$0(5);
        }
        if (file2 != null) {
            FileEventObserver fileEventObserver;
            ConfigurationEventObserver configurationEventObserver;
            if (configuration != null && (configurationEventObserver = this.myConfigurationToObserverMap.get(configuration)) != null) {
                configurationEventObserver.removeListener(listener2);
                if (!configurationEventObserver.hasListeners()) {
                    this.myConfigurationToObserverMap.remove(configuration);
                }
            }
            if ((fileEventObserver = this.myFileToObserverMap.get(file2)) != null) {
                fileEventObserver.removeListener(listener2);
                if (!fileEventObserver.hasListeners()) {
                    this.myFileToObserverMap.remove(file2);
                }
            }
        } else assert (configuration == null) : configuration;
        Module module2 = facet2.getModule();
        ModuleEventObserver moduleEventObserver = this.myModuleToObserverMap.get(module2);
        if (moduleEventObserver != null) {
            moduleEventObserver.removeListener(listener2);
            if (!moduleEventObserver.hasListeners()) {
                this.myModuleToObserverMap.remove(module2);
                if (this.myModuleToObserverMap.isEmpty() && this.myProjectPsiTreeObserver != null) {
                    this.myProjectBuildObserver.stopListening();
                    this.myProjectPsiTreeObserver = null;
                }
            }
        }
    }

    public synchronized PsiTreeChangeListener getPsiListener() {
        return this.myProjectPsiTreeObserver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notice(Reason reason) {
        this.myEvents.add(reason);
        Object object = this.CHANGE_PENDING_LOCK;
        synchronized (object) {
            if (this.myPendingNotify) {
                return;
            }
            this.myPendingNotify = true;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            Object object = this.CHANGE_PENDING_LOCK;
            synchronized (object) {
                if (!this.myPendingNotify) {
                    return;
                }
                this.myPendingNotify = false;
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                EnumSet<Reason> reason1 = this.myEvents;
                this.myEvents = EnumSet.noneOf(Reason.class);
                this.notifyListeners(reason1);
                this.myEvents.clear();
            });
        });
    }

    private void notifyListeners(EnumSet<Reason> reason) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        for (ModuleEventObserver moduleEventObserver : this.myModuleToObserverMap.values()) {
            moduleEventObserver.notifyListeners(reason);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/ResourceNotificationManager";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/ResourceNotificationManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentVersion";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Reason {
        RESOURCE_EDIT,
        EDIT,
        CONFIGURATION_CHANGED,
        SDK_CHANGED,
        VARIANT_CHANGED,
        GRADLE_SYNC,
        PROJECT_BUILD,
        IMAGE_RESOURCE_CHANGED;

    }

    public static class ResourceVersion {
        private final long myResourceGeneration;
        private final long myFileGeneration;
        private final long myConfigurationGeneration;
        private final long myProjectConfigurationGeneration;
        private final long myOtherGeneration;

        private ResourceVersion(long resourceGeneration, long fileGeneration, long configurationGeneration, long projectConfigurationGeneration, long otherGeneration) {
            this.myResourceGeneration = resourceGeneration;
            this.myFileGeneration = fileGeneration;
            this.myConfigurationGeneration = configurationGeneration;
            this.myProjectConfigurationGeneration = projectConfigurationGeneration;
            this.myOtherGeneration = otherGeneration;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResourceVersion version2 = (ResourceVersion)o;
            if (this.myResourceGeneration != version2.myResourceGeneration) {
                return false;
            }
            if (this.myFileGeneration != version2.myFileGeneration) {
                return false;
            }
            if (this.myConfigurationGeneration != version2.myConfigurationGeneration) {
                return false;
            }
            if (this.myProjectConfigurationGeneration != version2.myProjectConfigurationGeneration) {
                return false;
            }
            return this.myOtherGeneration == version2.myOtherGeneration;
        }

        public int hashCode() {
            int result2 = (int)(this.myResourceGeneration ^ this.myResourceGeneration >>> 32);
            result2 = 31 * result2 + (int)(this.myFileGeneration ^ this.myFileGeneration >>> 32);
            result2 = 31 * result2 + (int)(this.myConfigurationGeneration ^ this.myConfigurationGeneration >>> 32);
            result2 = 31 * result2 + (int)(this.myProjectConfigurationGeneration ^ this.myProjectConfigurationGeneration >>> 32);
            result2 = 31 * result2 + (int)(this.myOtherGeneration ^ this.myOtherGeneration >>> 32);
            return result2;
        }

        public String toString() {
            return "ResourceVersion{resource=" + this.myResourceGeneration + ", file=" + this.myFileGeneration + ", configuration=" + this.myConfigurationGeneration + ", projectConfiguration=" + this.myProjectConfigurationGeneration + ", other=" + this.myOtherGeneration + "}";
        }
    }

    public static interface ResourceChangeListener {
        public void resourcesChanged(@NotNull Set<Reason> var1);
    }

    private class ConfigurationEventObserver
    implements ConfigurationListener {
        private final Configuration myConfiguration;
        private List<ResourceChangeListener> myListeners = Lists.newArrayListWithExpectedSize((int)2);

        private ConfigurationEventObserver(Configuration configuration) {
            this.myConfiguration = configuration;
        }

        private void addListener(@NotNull ResourceChangeListener listener2) {
            if (listener2 == null) {
                ConfigurationEventObserver.$$$reportNull$$$0(0);
            }
            if (this.myListeners.isEmpty()) {
                this.registerListeners();
            }
            this.myListeners.add(listener2);
        }

        private void removeListener(@NotNull ResourceChangeListener listener2) {
            if (listener2 == null) {
                ConfigurationEventObserver.$$$reportNull$$$0(1);
            }
            this.myListeners.remove(listener2);
            if (this.myListeners.isEmpty()) {
                this.unregisterListeners();
            }
        }

        private boolean hasListeners() {
            return !this.myListeners.isEmpty();
        }

        private void registerListeners() {
            this.myConfiguration.addListener(this);
        }

        private void unregisterListeners() {
            this.myConfiguration.removeListener(this);
        }

        @Override
        public boolean changed(int flags) {
            if ((flags & 0x4FE) != 0) {
                ResourceNotificationManager.this.notice(Reason.CONFIGURATION_CHANGED);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "listener";
            objectArray2[1] = "com/android/tools/idea/res/ResourceNotificationManager$ConfigurationEventObserver";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addListener";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeListener";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class FileEventObserver
    implements BulkFileListener {
        private List<ResourceChangeListener> myListeners = Lists.newArrayListWithExpectedSize((int)2);
        private Module myModule;
        private MessageBusConnection myMessageBusConnection;

        private FileEventObserver(Module module2) {
            this.myModule = module2;
        }

        private void addListener(@NotNull ResourceChangeListener listener2) {
            if (listener2 == null) {
                FileEventObserver.$$$reportNull$$$0(0);
            }
            if (this.myListeners.isEmpty()) {
                this.registerListeners();
            }
            this.myListeners.add(listener2);
        }

        private void removeListener(@NotNull ResourceChangeListener listener2) {
            if (listener2 == null) {
                FileEventObserver.$$$reportNull$$$0(1);
            }
            this.myListeners.remove(listener2);
            if (this.myListeners.isEmpty()) {
                this.unregisterListeners();
            }
        }

        private void registerListeners() {
            this.myMessageBusConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myModule);
            this.myMessageBusConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)this);
        }

        private void unregisterListeners() {
            this.myMessageBusConnection.disconnect();
        }

        public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
            if (events == null) {
                FileEventObserver.$$$reportNull$$$0(2);
            }
            events.stream().filter(e -> {
                VirtualFile file2 = e.getFile();
                if (file2 == null || !ImageFileTypeManager.getInstance().isImage(file2)) {
                    return false;
                }
                VirtualFile parent = file2.getParent();
                if (parent == null) {
                    return false;
                }
                ResourceFolderType resType = ResourceFolderType.getFolderType((String)parent.getName());
                return ResourceFolderType.DRAWABLE == resType || ResourceFolderType.MIPMAP == resType;
            }).findAny().ifPresent(e -> ResourceNotificationManager.this.notice(Reason.IMAGE_RESOURCE_CHANGED));
        }

        private boolean hasListeners() {
            return !this.myListeners.isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "events";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/res/ResourceNotificationManager$FileEventObserver";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addListener";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeListener";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "after";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ProjectPsiTreeObserver
    implements PsiTreeChangeListener {
        boolean myIgnoreChildrenChanged;

        private ProjectPsiTreeObserver() {
        }

        public void beforeChildAddition(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                ProjectPsiTreeObserver.$$$reportNull$$$0(0);
            }
        }

        public void beforeChildRemoval(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                ProjectPsiTreeObserver.$$$reportNull$$$0(1);
            }
        }

        public void beforeChildReplacement(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                ProjectPsiTreeObserver.$$$reportNull$$$0(2);
            }
        }

        public void beforeChildMovement(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                ProjectPsiTreeObserver.$$$reportNull$$$0(3);
            }
        }

        public void beforeChildrenChange(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                ProjectPsiTreeObserver.$$$reportNull$$$0(4);
            }
            this.myIgnoreChildrenChanged = false;
        }

        public void beforePropertyChange(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                ProjectPsiTreeObserver.$$$reportNull$$$0(5);
            }
        }

        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                ProjectPsiTreeObserver.$$$reportNull$$$0(6);
            }
            this.myIgnoreChildrenChanged = true;
            if (this.isIgnorable(event)) {
                return;
            }
            if (this.isRelevantFile(event)) {
                String text2;
                PsiElement child = event.getChild();
                PsiElement parent = event.getParent();
                if (child instanceof XmlAttribute && parent instanceof XmlTag) {
                    if (((XmlAttribute)child).getValueElement() == null) {
                        return;
                    }
                } else if (parent instanceof XmlAttribute && child instanceof XmlAttributeValue) {
                    XmlAttributeValue attributeValue = (XmlAttributeValue)child;
                    attributeValue.getValue();
                    if (attributeValue.getValue().isEmpty()) {
                        return;
                    }
                } else if (parent instanceof XmlAttributeValue && child instanceof XmlToken && event.getOldChild() == null && (text2 = child.getText()).startsWith("@") && !DataBindingUtil.isBindingExpression(text2)) {
                    if (text2.equals("@") || text2.equals("@android:")) {
                        return;
                    }
                    ResourceUrl url = ResourceUrl.parse((String)text2);
                    if (url != null && url.name.isEmpty()) {
                        return;
                    }
                }
                ResourceNotificationManager.this.notice(Reason.EDIT);
            } else {
                ResourceNotificationManager.this.notice(Reason.RESOURCE_EDIT);
            }
        }

        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                ProjectPsiTreeObserver.$$$reportNull$$$0(7);
            }
            this.myIgnoreChildrenChanged = true;
            if (this.isIgnorable(event)) {
                return;
            }
            if (this.isRelevantFile(event)) {
                XmlAttributeValue valueElement;
                PsiElement child = event.getChild();
                PsiElement parent = event.getParent();
                if (parent instanceof XmlAttribute && child instanceof XmlToken && ((valueElement = ((XmlAttribute)parent).getValueElement()) == null || valueElement.getValue().isEmpty())) {
                    return;
                }
                ResourceNotificationManager.this.notice(Reason.EDIT);
            } else {
                ResourceNotificationManager.this.notice(Reason.RESOURCE_EDIT);
            }
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                ProjectPsiTreeObserver.$$$reportNull$$$0(8);
            }
            this.myIgnoreChildrenChanged = true;
            if (this.isIgnorable(event)) {
                return;
            }
            if (this.isRelevantFile(event)) {
                PsiElement child = event.getChild();
                PsiElement parent = event.getParent();
                if (parent instanceof XmlAttribute && child instanceof XmlToken) {
                    XmlAttributeValue valueElement = ((XmlAttribute)parent).getValueElement();
                    if (valueElement == null || valueElement.getValue().isEmpty()) {
                        return;
                    }
                } else if (parent instanceof XmlAttributeValue && child instanceof XmlToken && event.getOldChild() != null) {
                    String newText = child.getText();
                    String prevText = event.getOldChild().getText();
                    if (newText.startsWith("@") && !DataBindingUtil.isBindingExpression(newText)) {
                        ResourceUrl prevUrl = ResourceUrl.parse((String)prevText);
                        ResourceUrl newUrl = ResourceUrl.parse((String)newText);
                        if (prevUrl != null && prevUrl.name.isEmpty()) {
                            prevUrl = null;
                        }
                        if (newUrl != null && newUrl.name.isEmpty()) {
                            newUrl = null;
                        }
                        if (prevUrl == null && newUrl == null) {
                            return;
                        }
                    }
                }
                ResourceNotificationManager.this.notice(Reason.EDIT);
            } else {
                ResourceNotificationManager.this.notice(Reason.RESOURCE_EDIT);
            }
        }

        public void childMoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                ProjectPsiTreeObserver.$$$reportNull$$$0(9);
            }
            this.check(event);
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                ProjectPsiTreeObserver.$$$reportNull$$$0(10);
            }
            if (this.myIgnoreChildrenChanged) {
                return;
            }
            this.check(event);
        }

        public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                ProjectPsiTreeObserver.$$$reportNull$$$0(11);
            }
            if ("fileName".equals(event.getPropertyName())) {
                ResourceNotificationManager.this.notice(Reason.RESOURCE_EDIT);
            }
        }

        private boolean isRelevantFile(PsiTreeChangeEvent event) {
            PsiFile file2;
            return !ResourceNotificationManager.this.myFileToObserverMap.isEmpty() && (file2 = event.getFile()) != null && ResourceNotificationManager.this.myFileToObserverMap.containsKey(file2.getVirtualFile());
        }

        private boolean isIgnorable(PsiTreeChangeEvent event) {
            PsiElement child = event.getChild();
            PsiElement parent = event.getParent();
            if (child instanceof PsiErrorElement || parent instanceof XmlComment) {
                return true;
            }
            if ((child instanceof PsiWhiteSpace || child instanceof XmlText || parent instanceof XmlText) && IdeResourcesUtil.getFolderType(event.getFile()) != ResourceFolderType.VALUES) {
                return true;
            }
            PsiFile file2 = event.getFile();
            return file2 != null && (file2.getParent() == null || !file2.getViewProvider().isPhysical());
        }

        private void check(PsiTreeChangeEvent event) {
            PsiFile file2;
            if (this.isIgnorable(event)) {
                return;
            }
            if (this.isRelevantFile(event) && (file2 = event.getFile()) != null) {
                ResourceNotificationManager.this.notice(Reason.EDIT);
                return;
            }
            ResourceNotificationManager.this.notice(Reason.RESOURCE_EDIT);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/android/tools/idea/res/ResourceNotificationManager$ProjectPsiTreeObserver";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeChildAddition";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeChildRemoval";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeChildReplacement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeChildMovement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeChildrenChange";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforePropertyChange";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childAdded";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childRemoved";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childReplaced";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childMoved";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childrenChanged";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "propertyChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ProjectBuildObserver
    implements AndroidProjectBuildNotifications.AndroidProjectBuildListener {
        private boolean myAlreadyAddedBuildListener;
        private boolean myIgnoreBuildEvents;

        private ProjectBuildObserver() {
        }

        private void startListening() {
            if (!this.myAlreadyAddedBuildListener) {
                this.myAlreadyAddedBuildListener = true;
                AndroidProjectBuildNotifications.subscribe(ResourceNotificationManager.this.myProject, this);
            }
            this.myIgnoreBuildEvents = false;
        }

        private void stopListening() {
            this.myIgnoreBuildEvents = true;
        }

        @Override
        public void buildComplete(@NotNull AndroidProjectBuildNotifications.BuildContext context) {
            if (context == null) {
                ProjectBuildObserver.$$$reportNull$$$0(0);
            }
            if (!this.myIgnoreBuildEvents) {
                ++ResourceNotificationManager.this.myModificationCount;
                ResourceNotificationManager.this.notice(Reason.PROJECT_BUILD);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/res/ResourceNotificationManager$ProjectBuildObserver", "buildComplete"));
        }
    }

    private class ModuleEventObserver
    implements ModificationTracker,
    ResourceFolderManager.ResourceFolderListener {
        private final AndroidFacet myFacet;
        private long myGeneration;
        private final Object myListenersLock;
        private MessageBusConnection myConnection;
        private final List<ResourceChangeListener> myListeners;

        private ModuleEventObserver(AndroidFacet facet2) {
            if (facet2 == null) {
                ModuleEventObserver.$$$reportNull$$$0(0);
            }
            this.myListenersLock = new Object();
            this.myListeners = Lists.newArrayListWithExpectedSize((int)4);
            this.myFacet = facet2;
            this.myGeneration = this.getAppResourcesModificationCount();
        }

        public long getModificationCount() {
            return this.myGeneration;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addListener(@NotNull ResourceChangeListener listener2) {
            if (listener2 == null) {
                ModuleEventObserver.$$$reportNull$$$0(1);
            }
            Object object = this.myListenersLock;
            synchronized (object) {
                if (this.myListeners.isEmpty()) {
                    this.registerListeners();
                }
                this.myListeners.add(listener2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeListener(@NotNull ResourceChangeListener listener2) {
            if (listener2 == null) {
                ModuleEventObserver.$$$reportNull$$$0(2);
            }
            Object object = this.myListenersLock;
            synchronized (object) {
                this.myListeners.remove(listener2);
                if (this.myListeners.isEmpty()) {
                    this.unregisterListeners();
                }
            }
        }

        private void registerListeners() {
            if (AndroidModel.isRequired(this.myFacet)) {
                ResourceRepositoryManager.getProjectResources(this.myFacet);
                assert (this.myConnection == null);
                this.myConnection = this.myFacet.getModule().getProject().getMessageBus().connect((Disposable)this.myFacet);
                this.myConnection.subscribe(ResourceFolderManager.TOPIC, (Object)this);
                ResourceFolderManager.getInstance(this.myFacet);
            }
        }

        private void unregisterListeners() {
            if (this.myConnection != null) {
                this.myConnection.disconnect();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyListeners(EnumSet<Reason> reason) {
            ArrayList listeners;
            if (this.myFacet.isDisposed()) {
                return;
            }
            long generation = this.getAppResourcesModificationCount();
            if (reason.size() == 1 && reason.contains((Object)Reason.RESOURCE_EDIT) && generation == this.myGeneration) {
                return;
            }
            this.myGeneration = generation;
            ApplicationManager.getApplication().assertIsDispatchThread();
            Iterator iterator = this.myListenersLock;
            synchronized (iterator) {
                listeners = Lists.newArrayList(this.myListeners);
            }
            for (ResourceChangeListener listener2 : listeners) {
                listener2.resourcesChanged(reason);
            }
        }

        private long getAppResourcesModificationCount() {
            LocalResourceRepository appResources = ResourceRepositoryManager.getInstance(this.myFacet).getExistingAppResources();
            return appResources == null ? 0L : appResources.getModificationCount();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean hasListeners() {
            Object object = this.myListenersLock;
            synchronized (object) {
                return !this.myListeners.isEmpty();
            }
        }

        @Override
        public void mainResourceFoldersChanged(@NotNull AndroidFacet facet2, @NotNull List<? extends VirtualFile> folders) {
            if (facet2 == null) {
                ModuleEventObserver.$$$reportNull$$$0(3);
            }
            if (folders == null) {
                ModuleEventObserver.$$$reportNull$$$0(4);
            }
            if (facet2.getModule() == this.myFacet.getModule()) {
                ++ResourceNotificationManager.this.myModificationCount;
                ResourceNotificationManager.this.notice(Reason.GRADLE_SYNC);
            }
        }

        @Override
        public void testResourceFoldersChanged(@NotNull AndroidFacet facet2, @NotNull List<? extends VirtualFile> folders) {
            if (facet2 == null) {
                ModuleEventObserver.$$$reportNull$$$0(5);
            }
            if (folders == null) {
                ModuleEventObserver.$$$reportNull$$$0(6);
            }
            if (facet2.getModule() == this.myFacet.getModule()) {
                ++ResourceNotificationManager.this.myModificationCount;
                ResourceNotificationManager.this.notice(Reason.GRADLE_SYNC);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "facet";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "folders";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/res/ResourceNotificationManager$ModuleEventObserver";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addListener";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeListener";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mainResourceFoldersChanged";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "testResourceFoldersChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

