/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleableResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceType;
import com.android.tools.idea.LogAnonymizerUtil;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import gnu.trove.TIntArrayList;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

public class ResourceClassGenerator {
    private static final Logger LOG = Logger.getInstance(ResourceClassGenerator.class);
    private Map<ResourceType, TObjectIntHashMap<String>> myCache;
    private Map<String, TIntArrayList> myStyleableCache;
    @NotNull
    private final ResourceRepository myResources;
    @NotNull
    private final NumericIdProvider myIdProvider;
    @NotNull
    private final ResourceNamespace myNamespace;

    private ResourceClassGenerator(@NotNull NumericIdProvider idProvider, @NotNull ResourceRepository resources, @NotNull ResourceNamespace namespace) {
        if (idProvider == null) {
            ResourceClassGenerator.$$$reportNull$$$0(0);
        }
        if (resources == null) {
            ResourceClassGenerator.$$$reportNull$$$0(1);
        }
        if (namespace == null) {
            ResourceClassGenerator.$$$reportNull$$$0(2);
        }
        this.myIdProvider = idProvider;
        this.myResources = resources;
        this.myNamespace = namespace;
    }

    @NotNull
    public static ResourceClassGenerator create(@NotNull NumericIdProvider manager, @NotNull ResourceRepository resources, @NotNull ResourceNamespace namespace) {
        if (manager == null) {
            ResourceClassGenerator.$$$reportNull$$$0(3);
        }
        if (resources == null) {
            ResourceClassGenerator.$$$reportNull$$$0(4);
        }
        if (namespace == null) {
            ResourceClassGenerator.$$$reportNull$$$0(5);
        }
        return new ResourceClassGenerator(manager, resources, namespace);
    }

    @Nullable
    public byte[] generate(String fqcn) {
        String className2 = fqcn.replace('.', '/');
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("generate(%s)", LogAnonymizerUtil.anonymizeClassName((String)className2)));
        }
        ClassWriter cw = new ClassWriter(0);
        cw.visit(50, 49, className2, null, Type.getInternalName(Object.class), null);
        int index2 = className2.lastIndexOf(36);
        if (index2 != -1) {
            String typeName = className2.substring(index2 + 1);
            ResourceType type = ResourceType.fromClassName((String)typeName);
            if (type == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("  type '%s' doesn't exist", typeName));
                }
                return null;
            }
            cw.visitInnerClass(className2, className2.substring(0, index2), typeName, 25);
            if (this.myCache == null) {
                this.myCache = Maps.newHashMap();
            }
            if (type == ResourceType.STYLEABLE) {
                if (this.myStyleableCache == null) {
                    this.myCache.put(ResourceType.STYLEABLE, (TObjectIntHashMap<String>)new TObjectIntHashMap());
                    this.myStyleableCache = Maps.newHashMap();
                    this.generateStyleable(cw, className2);
                } else {
                    TObjectIntHashMap<String> indexFieldsCache = this.myCache.get(ResourceType.STYLEABLE);
                    assert (indexFieldsCache != null);
                    ResourceClassGenerator.generateFields(cw, indexFieldsCache);
                    this.generateIntArraysFromCache(cw, className2);
                }
            } else {
                TObjectIntHashMap typeCache = this.myCache.get(type);
                if (typeCache == null) {
                    typeCache = new TObjectIntHashMap();
                    this.myCache.put(type, (TObjectIntHashMap<String>)typeCache);
                    this.generateValuesForType(cw, type, (TObjectIntHashMap<String>)typeCache);
                } else {
                    ResourceClassGenerator.generateFields(cw, typeCache);
                }
            }
        } else {
            for (ResourceType t : this.myResources.getResourceTypes(this.myNamespace)) {
                if (!t.getHasInnerClass()) continue;
                cw.visitInnerClass(className2 + "$" + t.getName(), className2, t.getName(), 25);
            }
        }
        ResourceClassGenerator.generateConstructor(cw);
        cw.visitEnd();
        return cw.toByteArray();
    }

    private void generateValuesForType(@NotNull ClassWriter cw, @NotNull ResourceType resType, @NotNull TObjectIntHashMap<String> cache) {
        if (cw == null) {
            ResourceClassGenerator.$$$reportNull$$$0(6);
        }
        if (resType == null) {
            ResourceClassGenerator.$$$reportNull$$$0(7);
        }
        if (cache == null) {
            ResourceClassGenerator.$$$reportNull$$$0(8);
        }
        Set resourceNames = this.myResources.getResourceNames(this.myNamespace, resType);
        for (String name : resourceNames) {
            int initialValue = this.myIdProvider.getOrGenerateId(new ResourceReference(this.myNamespace, resType, name));
            name = IdeResourcesUtil.getFieldNameByResourceName(name);
            ResourceClassGenerator.generateField(cw, name, initialValue);
            cache.put((Object)name, initialValue);
        }
    }

    @NotNull
    private static List<ResourceReference> getStyleableAttributes(@NotNull ResourceItem item) {
        if (item == null) {
            ResourceClassGenerator.$$$reportNull$$$0(9);
        }
        ResourceValue resourceValue2 = (ResourceValue)ApplicationManager.getApplication().runReadAction(() -> item.getResourceValue());
        assert (resourceValue2 instanceof StyleableResourceValue);
        StyleableResourceValue dv = (StyleableResourceValue)resourceValue2;
        List list = Lists.transform((List)dv.getAllAttributes(), ResourceValue::asReference);
        if (list == null) {
            ResourceClassGenerator.$$$reportNull$$$0(10);
        }
        return list;
    }

    private void generateStyleable(@NotNull ClassWriter cw, String className2) {
        String fieldName;
        if (cw == null) {
            ResourceClassGenerator.$$$reportNull$$$0(11);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("generateStyleable(%s)", LogAnonymizerUtil.anonymizeClassName((String)className2)));
        }
        boolean debug = LOG.isDebugEnabled() && LogAnonymizerUtil.isPublicClass((String)className2);
        TObjectIntHashMap<String> indexFieldsCache = this.myCache.get(ResourceType.STYLEABLE);
        Set styleableNames = this.myResources.getResourceNames(this.myNamespace, ResourceType.STYLEABLE);
        ArrayList<MergedStyleable> mergedStyleables = new ArrayList<MergedStyleable>(styleableNames.size());
        for (String styleableName : styleableNames) {
            Object item2;
            List items2 = this.myResources.getResources(this.myNamespace, ResourceType.STYLEABLE, styleableName);
            if (items2.isEmpty()) {
                if (!debug) continue;
                LOG.debug("  No items for " + styleableName);
                continue;
            }
            fieldName = IdeResourcesUtil.getFieldNameByResourceName(styleableName);
            cw.visitField(25, fieldName, "[I", null, null);
            if (debug) {
                LOG.debug("  Defined styleable " + fieldName);
            }
            LinkedHashSet<ResourceReference> mergedAttributes = new LinkedHashSet<ResourceReference>();
            for (Object item2 : items2) {
                mergedAttributes.addAll(ResourceClassGenerator.getStyleableAttributes((ResourceItem)item2));
            }
            mergedStyleables.add(new MergedStyleable(styleableName, mergedAttributes));
            int idx = 0;
            item2 = mergedAttributes.iterator();
            while (item2.hasNext()) {
                ResourceReference attr = (ResourceReference)item2.next();
                String styleableEntryName = this.getResourceName(fieldName, attr);
                int fieldValue = idx++;
                cw.visitField(25, styleableEntryName, "I", null, (Object)fieldValue);
                indexFieldsCache.put((Object)styleableEntryName, fieldValue);
                if (!debug) continue;
                LOG.debug("  Defined styleable " + styleableEntryName);
            }
        }
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        for (MergedStyleable mergedStyleable : mergedStyleables) {
            fieldName = IdeResourcesUtil.getFieldNameByResourceName(mergedStyleable.name);
            TIntArrayList values2 = new TIntArrayList();
            for (ResourceReference attr : mergedStyleable.attrs) {
                values2.add(this.myIdProvider.getOrGenerateId(attr));
            }
            this.myStyleableCache.put(fieldName, values2);
            ResourceClassGenerator.generateArrayInitialization(mv, className2, fieldName, values2);
        }
        mv.visitInsn(177);
        mv.visitMaxs(4, 0);
        mv.visitEnd();
    }

    private static void generateFields(@NotNull ClassWriter cw, @NotNull TObjectIntHashMap<String> values2) {
        if (cw == null) {
            ResourceClassGenerator.$$$reportNull$$$0(12);
        }
        if (values2 == null) {
            ResourceClassGenerator.$$$reportNull$$$0(13);
        }
        values2.forEachEntry((name, value2) -> {
            ResourceClassGenerator.generateField(cw, name, value2);
            return true;
        });
    }

    private static void generateField(@NotNull ClassWriter cw, String name, int value2) {
        if (cw == null) {
            ResourceClassGenerator.$$$reportNull$$$0(14);
        }
        cw.visitField(25, name, "I", null, (Object)value2).visitEnd();
    }

    private void generateIntArraysFromCache(@NotNull ClassWriter cw, String className2) {
        if (cw == null) {
            ResourceClassGenerator.$$$reportNull$$$0(15);
        }
        for (String name : this.myStyleableCache.keySet()) {
            cw.visitField(25, name, "[I", null, null);
        }
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        this.myStyleableCache.forEach((arrayName, values2) -> ResourceClassGenerator.generateArrayInitialization(mv, className2, arrayName, values2));
        mv.visitInsn(177);
        mv.visitMaxs(4, 0);
        mv.visitEnd();
    }

    private static void pushIntValue(@NotNull MethodVisitor mv, int value2) {
        if (mv == null) {
            ResourceClassGenerator.$$$reportNull$$$0(16);
        }
        if (value2 >= -1 && value2 <= 5) {
            mv.visitInsn(3 + value2);
        } else if (value2 >= -128 && value2 <= 127) {
            mv.visitIntInsn(16, value2);
        } else if (value2 >= Short.MIN_VALUE && value2 <= Short.MAX_VALUE) {
            mv.visitIntInsn(17, value2);
        } else {
            mv.visitLdcInsn((Object)value2);
        }
    }

    private static void generateArrayInitialization(@NotNull MethodVisitor mv, String className2, String fieldName, @NotNull TIntArrayList values2) {
        if (mv == null) {
            ResourceClassGenerator.$$$reportNull$$$0(17);
        }
        if (values2 == null) {
            ResourceClassGenerator.$$$reportNull$$$0(18);
        }
        if (values2.isEmpty()) {
            return;
        }
        ResourceClassGenerator.pushIntValue(mv, values2.size());
        mv.visitIntInsn(188, 10);
        for (int idx = 0; idx < values2.size(); ++idx) {
            mv.visitInsn(89);
            ResourceClassGenerator.pushIntValue(mv, idx);
            mv.visitLdcInsn((Object)values2.get(idx));
            mv.visitInsn(79);
        }
        mv.visitFieldInsn(179, className2, fieldName, "[I");
    }

    private static void generateConstructor(@NotNull ClassWriter cw) {
        if (cw == null) {
            ResourceClassGenerator.$$$reportNull$$$0(19);
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    public String getResourceName(String styleableName, @NotNull ResourceReference value2) {
        String packageName;
        if (value2 == null) {
            ResourceClassGenerator.$$$reportNull$$$0(20);
        }
        StringBuilder sb = new StringBuilder(30);
        sb.append(styleableName);
        sb.append('_');
        if (!value2.getNamespace().equals((Object)this.myNamespace) && (packageName = value2.getNamespace().getPackageName()) != null) {
            ResourceClassGenerator.appendEscaped(sb, packageName);
            sb.append('_');
        }
        ResourceClassGenerator.appendEscaped(sb, value2.getName());
        return sb.toString();
    }

    private static void appendEscaped(@NotNull StringBuilder sb, @NotNull String v) {
        if (sb == null) {
            ResourceClassGenerator.$$$reportNull$$$0(21);
        }
        if (v == null) {
            ResourceClassGenerator.$$$reportNull$$$0(22);
        }
        int n = v.length();
        for (int i2 = 0; i2 < n; ++i2) {
            char c = v.charAt(i2);
            if (c == '.' || c == ':' || c == '-') {
                sb.append('_');
                continue;
            }
            sb.append(c);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idProvider";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resources";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cw";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/ResourceClassGenerator";
                break;
            }
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mv";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/ResourceClassGenerator";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyleableAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generateValuesForType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getStyleableAttributes";
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "generateStyleable";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "generateFields";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "generateField";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "generateIntArraysFromCache";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "pushIntValue";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "generateArrayInitialization";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "generateConstructor";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getResourceName";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "appendEscaped";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MergedStyleable {
        @NotNull
        final String name;
        @NotNull
        final LinkedHashSet<ResourceReference> attrs;

        private MergedStyleable(@NotNull String name, @NotNull LinkedHashSet<ResourceReference> attrs) {
            if (name == null) {
                MergedStyleable.$$$reportNull$$$0(0);
            }
            if (attrs == null) {
                MergedStyleable.$$$reportNull$$$0(1);
            }
            this.name = name;
            this.attrs = attrs;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "attrs";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/res/ResourceClassGenerator$MergedStyleable";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static interface NumericIdProvider {
        public int getOrGenerateId(@NotNull ResourceReference var1);
    }
}

