/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceVisitor;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.AbstractResourceRepositoryWithLocking;
import com.android.tools.idea.res.MultiResourceRepository;
import com.google.common.collect.ListMultimap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LocalResourceRepository
extends AbstractResourceRepositoryWithLocking
implements ModificationTracker {
    protected static final AtomicLong ourModificationCounter = new AtomicLong();
    private final String myDisplayName;
    @Nullable
    private List<MultiResourceRepository> myParents;
    private volatile long myGeneration;
    private final Object RESOURCE_DIRS_LOCK;
    @Nullable
    private Set<VirtualFile> myResourceDirs;

    protected LocalResourceRepository(@NotNull String displayName) {
        if (displayName == null) {
            LocalResourceRepository.$$$reportNull$$$0(0);
        }
        this.RESOURCE_DIRS_LOCK = new Object();
        this.myDisplayName = displayName;
        this.setModificationCount(ourModificationCounter.incrementAndGet());
    }

    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName;
        if (string == null) {
            LocalResourceRepository.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public String getLibraryName() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParent(@NotNull MultiResourceRepository parent) {
        if (parent == null) {
            LocalResourceRepository.$$$reportNull$$$0(2);
        }
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (this.myParents == null) {
                this.myParents = new ArrayList<MultiResourceRepository>(2);
            }
            this.myParents.add(parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParent(@NotNull MultiResourceRepository parent) {
        if (parent == null) {
            LocalResourceRepository.$$$reportNull$$$0(3);
        }
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (this.myParents != null) {
                this.myParents.remove((Object)parent);
            }
        }
    }

    protected void invalidateParentCaches() {
        if (this.myParents != null) {
            for (MultiResourceRepository parent : this.myParents) {
                parent.invalidateCache();
            }
        }
    }

    protected void invalidateParentCaches(@NotNull SingleNamespaceResourceRepository repository, ResourceType ... types2) {
        if (repository == null) {
            LocalResourceRepository.$$$reportNull$$$0(4);
        }
        if (types2 == null) {
            LocalResourceRepository.$$$reportNull$$$0(5);
        }
        if (this.myParents != null) {
            for (MultiResourceRepository parent : this.myParents) {
                parent.invalidateCache(repository, types2);
            }
        }
    }

    public long getModificationCount() {
        return this.myGeneration;
    }

    protected void setModificationCount(long count) {
        this.myGeneration = count;
    }

    boolean isScanPending(@NotNull PsiFile psiFile2) {
        if (psiFile2 == null) {
            LocalResourceRepository.$$$reportNull$$$0(6);
        }
        return false;
    }

    public void sync() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public final Set<VirtualFile> getResourceDirs() {
        Object object = this.RESOURCE_DIRS_LOCK;
        // MONITORENTER : object
        if (this.myResourceDirs != null) {
            Set<VirtualFile> set = this.myResourceDirs;
            // MONITOREXIT : object
            if (set != null) return set;
            LocalResourceRepository.$$$reportNull$$$0(7);
            return set;
        }
        Set<VirtualFile> set = this.myResourceDirs = this.computeResourceDirs();
        // MONITOREXIT : object
        if (set != null) return set;
        LocalResourceRepository.$$$reportNull$$$0(8);
        return set;
    }

    @NotNull
    protected abstract Set<VirtualFile> computeResourceDirs();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invalidateResourceDirs() {
        Object object = this.RESOURCE_DIRS_LOCK;
        synchronized (object) {
            this.myResourceDirs = null;
        }
        object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (this.myParents != null) {
                for (LocalResourceRepository localResourceRepository : this.myParents) {
                    localResourceRepository.invalidateResourceDirs();
                }
            }
        }
    }

    @NotNull
    public Collection<ResourceItem> getPublicResources(@NotNull ResourceNamespace namespace, @NotNull ResourceType type) {
        if (namespace == null) {
            LocalResourceRepository.$$$reportNull$$$0(9);
        }
        if (type == null) {
            LocalResourceRepository.$$$reportNull$$$0(10);
        }
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Nullable
    ListMultimap<String, ResourceItem> getMapPackageAccessible(@NotNull ResourceNamespace namespace, @NotNull ResourceType type) {
        if (namespace == null) {
            LocalResourceRepository.$$$reportNull$$$0(11);
        }
        if (type == null) {
            LocalResourceRepository.$$$reportNull$$$0(12);
        }
        return this.getMap(namespace, type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/LocalResourceRepository";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/LocalResourceRepository";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceDirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addParent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeParent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invalidateParentCaches";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isScanPending";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPublicResources";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getMapPackageAccessible";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class EmptyRepository
    extends LocalResourceRepository
    implements SingleNamespaceResourceRepository {
        @NotNull
        private final ResourceNamespace myNamespace;

        public EmptyRepository(@NotNull ResourceNamespace namespace) {
            if (namespace == null) {
                EmptyRepository.$$$reportNull$$$0(0);
            }
            super("");
            this.myNamespace = namespace;
        }

        @Override
        @NotNull
        protected Set<VirtualFile> computeResourceDirs() {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                EmptyRepository.$$$reportNull$$$0(1);
            }
            return set;
        }

        @Override
        @Nullable
        protected ListMultimap<String, ResourceItem> getMap(@NotNull ResourceNamespace namespace, @NotNull ResourceType type) {
            if (namespace == null) {
                EmptyRepository.$$$reportNull$$$0(2);
            }
            if (type == null) {
                EmptyRepository.$$$reportNull$$$0(3);
            }
            return null;
        }

        @NotNull
        public ResourceNamespace getNamespace() {
            ResourceNamespace resourceNamespace = this.myNamespace;
            if (resourceNamespace == null) {
                EmptyRepository.$$$reportNull$$$0(4);
            }
            return resourceNamespace;
        }

        @Nullable
        public String getPackageName() {
            return this.myNamespace.getPackageName();
        }

        public ResourceVisitor.VisitResult accept(ResourceVisitor visitor2) {
            return ResourceVisitor.VisitResult.CONTINUE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespace";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/res/LocalResourceRepository$EmptyRepository";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/res/LocalResourceRepository$EmptyRepository";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeResourceDirs";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNamespace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 4: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getMap";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

