/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.resources.ProtoXmlPullParser;
import com.android.ide.common.util.PathString;
import com.android.utils.XmlUtils;
import com.android.zipflinger.ZipMap;
import com.android.zipflinger.ZipRepo;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class FileResourceReader {
    private static final LoadingCache<String, ZipMap> sZipCache = CacheBuilder.newBuilder().maximumSize(10L).expireAfterAccess(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, ZipMap>(){

        public ZipMap load(@NotNull String path2) throws IOException {
            if (path2 == null) {
                1.$$$reportNull$$$0(0);
            }
            return ZipMap.from((File)new File(path2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/res/FileResourceReader$1", "load"));
        }
    });

    @NotNull
    public static byte[] readBytes(@NotNull PathString resourcePath) throws IOException {
        String scheme;
        if (resourcePath == null) {
            FileResourceReader.$$$reportNull$$$0(0);
        }
        switch (scheme = resourcePath.getFilesystemUri().getScheme()) {
            case "file": {
                return FileResourceReader.readFileBytes(resourcePath.getRawPath());
            }
            case "apk": 
            case "jar": {
                String path2 = resourcePath.getRawPath();
                int separatorPos = path2.indexOf("!/");
                int separatorEnd = separatorPos + "!/".length();
                if (separatorPos <= 0 || separatorEnd == path2.length()) {
                    throw new IllegalArgumentException("Invalid path in \"" + resourcePath + "\"");
                }
                return FileResourceReader.readZipEntryBytes(path2.substring(0, separatorPos), path2.substring(separatorEnd));
            }
        }
        throw new IllegalArgumentException("Unknown schema in \"" + resourcePath + "\"");
    }

    @NotNull
    public static byte[] readBytes(@NotNull String resourcePath) throws IOException {
        if (resourcePath == null) {
            FileResourceReader.$$$reportNull$$$0(1);
        }
        if (resourcePath.startsWith("apk:") || resourcePath.startsWith("jar:")) {
            int separatorPos;
            int prefixLength = "apk:".length();
            if (resourcePath.startsWith("//", prefixLength)) {
                prefixLength += "//".length();
            }
            if ((separatorPos = resourcePath.lastIndexOf("!/")) < prefixLength) {
                throw new IllegalArgumentException("Invalid resource path \"" + resourcePath + "\"");
            }
            return FileResourceReader.readZipEntryBytes(resourcePath.substring(prefixLength, separatorPos), resourcePath.substring(separatorPos + "!/".length()));
        }
        if (resourcePath.startsWith("file:")) {
            int prefixLength = "file:".length();
            if (resourcePath.startsWith("//", prefixLength)) {
                prefixLength += "//".length();
            }
            resourcePath = resourcePath.substring(prefixLength);
        }
        return FileResourceReader.readFileBytes(resourcePath);
    }

    @NotNull
    private static byte[] readFileBytes(String filePath) throws IOException {
        byte[] byArray;
        FileInputStream fileStream;
        block5: {
            fileStream = new FileInputStream(filePath);
            ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
            ByteStreams.copy((InputStream)fileStream, (OutputStream)byteOutputStream);
            byArray = byteOutputStream.toByteArray();
            if (byArray != null) break block5;
            FileResourceReader.$$$reportNull$$$0(2);
        }
        return byArray;
        finally {
            fileStream.close();
        }
    }

    @NotNull
    private static byte[] readZipEntryBytes(String zipPath, String zipEntryPath) throws IOException {
        byte[] byArray;
        ZipRepo zipRepo;
        block10: {
            ZipMap zipMap;
            try {
                zipMap = (ZipMap)sZipCache.get((Object)zipPath);
            }
            catch (ExecutionException e) {
                Throwable nested = e.getCause();
                if (nested instanceof IOException) {
                    throw (IOException)nested;
                }
                if (nested instanceof RuntimeException) {
                    throw (RuntimeException)nested;
                }
                if (nested instanceof Error) {
                    throw (Error)nested;
                }
                throw new UncheckedExecutionException(nested);
            }
            zipRepo = new ZipRepo(zipMap);
            ByteBuffer entryContent = zipRepo.getContent(zipEntryPath);
            byte[] bytes = new byte[entryContent.remaining()];
            entryContent.get(bytes);
            byArray = bytes;
            if (byArray != null) break block10;
            FileResourceReader.$$$reportNull$$$0(3);
        }
        return byArray;
        finally {
            zipRepo.close();
        }
    }

    @Nullable
    public static XmlPullParser createXmlPullParser(@NotNull PathString resourcePath) throws IOException {
        if (resourcePath == null) {
            FileResourceReader.$$$reportNull$$$0(4);
        }
        try {
            byte[] contents = FileResourceReader.readBytes(resourcePath);
            return FileResourceReader.createXmlPullParser(contents);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    @Nullable
    public static XmlPullParser createXmlPullParser(@NotNull VirtualFile resourceFile) throws IOException {
        if (resourceFile == null) {
            FileResourceReader.$$$reportNull$$$0(5);
        }
        try {
            byte[] contents = resourceFile.contentsToByteArray();
            return FileResourceReader.createXmlPullParser(contents);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    @NotNull
    public static XmlPullParser createXmlPullParser(@NotNull byte[] contents) {
        ProtoXmlPullParser protoXmlPullParser;
        if (contents == null) {
            FileResourceReader.$$$reportNull$$$0(6);
        }
        try {
            ProtoXmlPullParser parser;
            if (XmlUtils.isProtoXml((byte[])contents)) {
                parser = new ProtoXmlPullParser();
            } else {
                parser = new KXmlParser();
                parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            }
            parser.setInput((InputStream)new ByteArrayInputStream(contents), null);
            protoXmlPullParser = parser;
        }
        catch (XmlPullParserException e) {
            throw new Error("Internal error", e);
        }
        if (protoXmlPullParser == null) {
            FileResourceReader.$$$reportNull$$$0(7);
        }
        return protoXmlPullParser;
    }

    private FileResourceReader() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourcePath";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/FileResourceReader";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/FileResourceReader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "readFileBytes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "readZipEntryBytes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createXmlPullParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readBytes";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createXmlPullParser";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

