/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceVisitor;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.projectmodel.DynamicResourceValue;
import com.android.resources.ResourceType;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.android.tools.idea.res.DynamicValueResourceItem;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryImplUtil;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class DynamicValueResourceRepository
extends LocalResourceRepository
implements Disposable,
SingleNamespaceResourceRepository {
    private final AndroidFacet myFacet;
    @NotNull
    private final ResourceNamespace myNamespace;
    @NotNull
    private final Map<ResourceType, ListMultimap<String, ResourceItem>> myResourceTable;

    private DynamicValueResourceRepository(@NotNull AndroidFacet facet2, @NotNull ResourceNamespace namespace) {
        if (facet2 == null) {
            DynamicValueResourceRepository.$$$reportNull$$$0(0);
        }
        if (namespace == null) {
            DynamicValueResourceRepository.$$$reportNull$$$0(1);
        }
        super("Gradle Dynamic");
        this.myResourceTable = new EnumMap<ResourceType, ListMultimap<String, ResourceItem>>(ResourceType.class);
        this.myFacet = facet2;
        this.myNamespace = namespace;
        assert (AndroidModel.isRequired(facet2));
    }

    private void registerListeners() {
        this.myFacet.getModule().getProject().getMessageBus().connect((Disposable)this).subscribe(ProjectSystemSyncUtil.PROJECT_SYSTEM_SYNC_TOPIC, result2 -> {
            if (result2.isSuccessful()) {
                this.notifyProjectSynced();
            }
        });
    }

    public void dispose() {
    }

    @Nullable
    public String getPackageName() {
        return ResourceRepositoryImplUtil.getPackageName(this.myNamespace, this.myFacet);
    }

    @NotNull
    public static DynamicValueResourceRepository create(@NotNull AndroidFacet facet2, @NotNull ResourceNamespace namespace) {
        if (facet2 == null) {
            DynamicValueResourceRepository.$$$reportNull$$$0(2);
        }
        if (namespace == null) {
            DynamicValueResourceRepository.$$$reportNull$$$0(3);
        }
        DynamicValueResourceRepository repository = new DynamicValueResourceRepository(facet2, namespace);
        try {
            repository.registerListeners();
        }
        catch (Throwable t) {
            Disposer.dispose((Disposable)repository);
            throw t;
        }
        DynamicValueResourceRepository dynamicValueResourceRepository = repository;
        if (dynamicValueResourceRepository == null) {
            DynamicValueResourceRepository.$$$reportNull$$$0(4);
        }
        return dynamicValueResourceRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    @NotNull
    public static DynamicValueResourceRepository createForTest(@NotNull AndroidFacet facet2, @NotNull ResourceNamespace namespace, @NotNull Map<String, DynamicResourceValue> values2) {
        if (facet2 == null) {
            DynamicValueResourceRepository.$$$reportNull$$$0(5);
        }
        if (namespace == null) {
            DynamicValueResourceRepository.$$$reportNull$$$0(6);
        }
        if (values2 == null) {
            DynamicValueResourceRepository.$$$reportNull$$$0(7);
        }
        DynamicValueResourceRepository repository = new DynamicValueResourceRepository(facet2, namespace);
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            repository.addValues(values2);
        }
        Disposer.register((Disposable)facet2, (Disposable)repository);
        DynamicValueResourceRepository dynamicValueResourceRepository = repository;
        if (dynamicValueResourceRepository == null) {
            DynamicValueResourceRepository.$$$reportNull$$$0(8);
        }
        return dynamicValueResourceRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyProjectSynced() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            this.myResourceTable.clear();
            this.invalidateParentCaches(this, ResourceType.values());
        }
    }

    private void addValues(@NotNull Map<String, DynamicResourceValue> resValues) {
        if (resValues == null) {
            DynamicValueResourceRepository.$$$reportNull$$$0(9);
        }
        for (Map.Entry<String, DynamicResourceValue> entry : resValues.entrySet()) {
            DynamicResourceValue field2 = entry.getValue();
            String name = entry.getKey();
            ResourceType type = field2.getType();
            ArrayListMultimap map2 = this.myResourceTable.get(type);
            if (map2 == null) {
                map2 = ArrayListMultimap.create();
                this.myResourceTable.put(type, (ListMultimap<String, ResourceItem>)map2);
            } else if (map2.containsKey((Object)name)) continue;
            DynamicValueResourceItem item = new DynamicValueResourceItem(this, type, name, field2.getValue());
            map2.put((Object)name, (Object)item);
        }
    }

    @Override
    @Nullable
    protected ListMultimap<String, ResourceItem> getMap(@NotNull ResourceNamespace namespace, @NotNull ResourceType type) {
        if (namespace == null) {
            DynamicValueResourceRepository.$$$reportNull$$$0(10);
        }
        if (type == null) {
            DynamicValueResourceRepository.$$$reportNull$$$0(11);
        }
        if (!namespace.equals((Object)this.myNamespace)) {
            return null;
        }
        return this.getResourceTable().get(type);
    }

    @NotNull
    public ResourceNamespace getNamespace() {
        ResourceNamespace resourceNamespace = this.myNamespace;
        if (resourceNamespace == null) {
            DynamicValueResourceRepository.$$$reportNull$$$0(12);
        }
        return resourceNamespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public ResourceVisitor.VisitResult accept(@NotNull ResourceVisitor visitor2) {
        if (visitor2 == null) {
            DynamicValueResourceRepository.$$$reportNull$$$0(13);
        }
        if (visitor2.shouldVisitNamespace(this.myNamespace)) {
            Object object = ITEM_MAP_LOCK;
            synchronized (object) {
                if (DynamicValueResourceRepository.acceptByResources(this.myResourceTable, (ResourceVisitor)visitor2) == ResourceVisitor.VisitResult.ABORT) {
                    ResourceVisitor.VisitResult visitResult = ResourceVisitor.VisitResult.ABORT;
                    // MONITOREXIT @DISABLED, blocks:[2, 5, 6] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
                    if (visitResult == null) {
                        DynamicValueResourceRepository.$$$reportNull$$$0(14);
                    }
                    return visitResult;
                }
            }
        }
        ResourceVisitor.VisitResult visitResult = ResourceVisitor.VisitResult.CONTINUE;
        if (visitResult == null) {
            DynamicValueResourceRepository.$$$reportNull$$$0(15);
        }
        return visitResult;
    }

    private Map<ResourceType, ListMultimap<String, ResourceItem>> getResourceTable() {
        AndroidModel androidModel;
        if (this.myResourceTable.isEmpty() && (androidModel = AndroidModel.get(this.myFacet.getModule())) != null) {
            this.addValues(androidModel.getResValues());
        }
        return this.myResourceTable;
    }

    @Override
    @NotNull
    protected Set<VirtualFile> computeResourceDirs() {
        ImmutableSet immutableSet = ImmutableSet.of();
        if (immutableSet == null) {
            DynamicValueResourceRepository.$$$reportNull$$$0(16);
        }
        return immutableSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/DynamicValueResourceRepository";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resValues";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/DynamicValueResourceRepository";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createForTest";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "accept";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "computeResourceDirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createForTest";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addValues";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getMap";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

