/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.gradle.model.IdeLibrary;
import com.android.ide.common.rendering.api.AssetRepository;
import com.android.projectmodel.ExternalLibrary;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.fonts.DownloadableFontCacheService;
import com.android.tools.idea.projectsystem.IdeaSourceProvider;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.tools.idea.res.FileResourceReader;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.sampledata.datasource.ResourceContent;
import com.google.common.collect.Streams;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.SourceProviderManager;
import org.jetbrains.android.sdk.StudioEmbeddedRenderTarget;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssetRepositoryImpl
extends AssetRepository {
    private static File myFrameworkResDirOrJar;
    private AndroidFacet myFacet;

    public AssetRepositoryImpl(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            AssetRepositoryImpl.$$$reportNull$$$0(0);
        }
        this.myFacet = facet2;
    }

    public boolean isSupported() {
        return true;
    }

    @Nullable
    public InputStream openAsset(@NotNull String path2, int mode) throws IOException {
        if (path2 == null) {
            AssetRepositoryImpl.$$$reportNull$$$0(1);
        }
        assert (this.myFacet != null);
        return AssetRepositoryImpl.getDirectories(this.myFacet, IdeaSourceProvider::getAssetsDirectories, IdeLibrary::getAssetsFolder).map(assetDir -> assetDir.findFileByRelativePath(path2)).map(assetDir -> {
            if (assetDir == null) {
                return null;
            }
            try {
                return assetDir.getInputStream();
            }
            catch (IOException e) {
                return null;
            }
        }).filter(Objects::nonNull).findAny().orElse(null);
    }

    private static boolean isCachedFontFile(@NotNull VirtualFile file2) {
        File fontCachePathFile;
        if (file2 == null) {
            AssetRepositoryImpl.$$$reportNull$$$0(2);
        }
        if ((fontCachePathFile = DownloadableFontCacheService.getInstance().getFontPath()) == null) {
            return false;
        }
        VirtualFile fontCachePath = VirtualFileManager.getInstance().findFileByUrl("file://" + fontCachePathFile.getAbsolutePath());
        if (fontCachePath == null) {
            return false;
        }
        return VfsUtilCore.isAncestor((VirtualFile)fontCachePath, (VirtualFile)file2, (boolean)true);
    }

    @Nullable
    public InputStream openNonAsset(int cookie, @NotNull String path2, int mode) throws IOException {
        Object url;
        if (path2 == null) {
            AssetRepositoryImpl.$$$reportNull$$$0(3);
        }
        assert (this.myFacet != null);
        if (path2.startsWith("apk:") || path2.startsWith("jar:")) {
            return new ByteArrayInputStream(FileResourceReader.readBytes(path2));
        }
        if (path2.startsWith("file://")) {
            url = path2;
        } else {
            if (path2.startsWith("file:")) {
                path2 = path2.substring("file:".length());
            }
            url = "file://" + path2;
        }
        VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl((String)url);
        if (file2 == null) {
            return null;
        }
        return AssetRepositoryImpl.getDirectories(this.myFacet, IdeaSourceProvider::getResDirectories, IdeLibrary::getResFolder).filter(resDir -> VfsUtilCore.isAncestor((VirtualFile)resDir, (VirtualFile)file2, (boolean)true)).map(resDir -> {
            try {
                return file2.getInputStream();
            }
            catch (IOException e) {
                return null;
            }
        }).findAny().orElseGet(() -> {
            if (AssetRepositoryImpl.isCachedFontFile(file2)) {
                try {
                    return file2.getInputStream();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        });
    }

    public boolean isFileResource(@NotNull String path2) {
        if (path2 == null) {
            AssetRepositoryImpl.$$$reportNull$$$0(4);
        }
        return IdeResourcesUtil.isFileResource(path2);
    }

    @NotNull
    private static Stream<VirtualFile> getDirectories(@NotNull AndroidFacet facet2, @NotNull Function<IdeaSourceProvider, Iterable<VirtualFile>> sourceMapper, @NotNull Function<IdeLibrary, String> aarMapper) {
        if (facet2 == null) {
            AssetRepositoryImpl.$$$reportNull$$$0(5);
        }
        if (sourceMapper == null) {
            AssetRepositoryImpl.$$$reportNull$$$0(6);
        }
        if (aarMapper == null) {
            AssetRepositoryImpl.$$$reportNull$$$0(7);
        }
        Stream dirsFromSources = Stream.concat(Stream.of(facet2), AndroidUtils.getAllAndroidDependencies(facet2.getModule(), true).stream()).flatMap(f -> SourceProviderManager.getInstance(f).getCurrentAndSomeFrequentlyUsedInactiveSourceProviders().stream()).distinct().map(sourceMapper).flatMap(Streams::stream);
        VirtualFileManager manager = VirtualFileManager.getInstance();
        Stream<VirtualFile> dirsFromAars = ResourceRepositoryManager.findAarLibraries(facet2).stream().map(aarMapper).map(path2 -> manager.findFileByUrl("file://" + path2)).filter(Objects::nonNull);
        Stream<Object> libraryDepAars = Stream.empty();
        if (((Boolean)StudioFlags.NELE_ASSET_REPOSITORY_INCLUDE_AARS_THROUGH_PROJECT_SYSTEM.get()).booleanValue()) {
            libraryDepAars = ProjectSystemUtil.getModuleSystem(facet2.getModule()).getResolvedLibraryDependencies().stream().map(ExternalLibrary::getLocation).filter(location -> location != null && location.getFileName().endsWith(".aar")).map(path2 -> manager.findFileByUrl("file://" + path2.getPortablePath())).filter(Objects::nonNull);
        }
        Stream<VirtualFile> frameworkDirs = Stream.of(AssetRepositoryImpl.getSdkResDirOrJar(facet2)).filter(Objects::nonNull).map(path2 -> manager.findFileByUrl("file://" + path2)).filter(Objects::nonNull);
        Stream<VirtualFile> sampleDataDirs = Stream.of(ResourceContent.getSampleDataBaseDir(), ResourceContent.getSampleDataUserDir(facet2)).filter(Objects::nonNull).map(dir -> manager.findFileByUrl("file://" + dir.getAbsolutePath())).filter(Objects::nonNull);
        Stream<VirtualFile> stream2 = Stream.of(dirsFromSources, dirsFromAars, frameworkDirs, sampleDataDirs, libraryDepAars).flatMap(stream -> stream);
        if (stream2 == null) {
            AssetRepositoryImpl.$$$reportNull$$$0(8);
        }
        return stream2;
    }

    @Nullable
    private static File getSdkResDirOrJar(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            AssetRepositoryImpl.$$$reportNull$$$0(9);
        }
        if (myFrameworkResDirOrJar == null) {
            ConfigurationManager manager = ConfigurationManager.getOrCreateInstance(facet2);
            IAndroidTarget target = manager.getHighestApiTarget();
            if (target == null) {
                return null;
            }
            CompatibilityRenderTarget compatibilityTarget = StudioEmbeddedRenderTarget.getCompatibilityTarget(target);
            myFrameworkResDirOrJar = compatibilityTarget.getFile(11);
        }
        return myFrameworkResDirOrJar;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceMapper";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aarMapper";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/AssetRepositoryImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/AssetRepositoryImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "openAsset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isCachedFontFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "openNonAsset";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isFileResource";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDirectories";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSdkResDirOrJar";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

