/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.annotations.concurrency.Slow;
import com.android.annotations.concurrency.UiThread;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.fileTypes.FontFileType;
import com.android.tools.idea.gradle.project.sync.GradleFiles;
import com.android.tools.idea.lang.rs.AndroidRenderscriptFileType;
import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.android.tools.idea.res.ResourceNotificationManager;
import com.android.tools.idea.res.SampleDataListener;
import com.intellij.AppTopics;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;

public class AndroidFileChangeListener
implements Disposable {
    private ResourceFolderRegistry myRegistry;
    private Project myProject;
    private ResourceNotificationManager myResourceNotificationManager;
    private EditorNotifications myEditorNotifications;
    @Nullable
    private SampleDataListener mySampleDataListener;

    @NotNull
    public static AndroidFileChangeListener getInstance(@NotNull Project project) {
        if (project == null) {
            AndroidFileChangeListener.$$$reportNull$$$0(0);
        }
        AndroidFileChangeListener androidFileChangeListener = (AndroidFileChangeListener)project.getService(AndroidFileChangeListener.class);
        if (androidFileChangeListener == null) {
            AndroidFileChangeListener.$$$reportNull$$$0(1);
        }
        return androidFileChangeListener;
    }

    private void onProjectOpened(@NotNull Project project) {
        if (project == null) {
            AndroidFileChangeListener.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myResourceNotificationManager = ResourceNotificationManager.getInstance(this.myProject);
        this.myRegistry = ResourceFolderRegistry.getInstance(this.myProject);
        this.myEditorNotifications = EditorNotifications.getInstance((Project)this.myProject);
        PsiManager.getInstance((Project)this.myProject).addPsiTreeChangeListener((PsiTreeChangeListener)new MyPsiListener(), (Disposable)this);
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)new MyDocumentListener(this.myProject, this.myRegistry), (Disposable)this);
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this);
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new MyVfsListener(this.myRegistry));
        connection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new MyFileDocumentManagerListener(this.myRegistry));
    }

    public void dispose() {
    }

    void setSampleDataListener(SampleDataListener sampleDataListener) {
        assert (this.mySampleDataListener == null) : "SampleDataListener already set!";
        this.mySampleDataListener = sampleDataListener;
    }

    static boolean isRelevantFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            AndroidFileChangeListener.$$$reportNull$$$0(3);
        }
        if (fileType == JavaFileType.INSTANCE || fileType == KotlinFileType.INSTANCE) {
            return false;
        }
        if (fileType == XmlFileType.INSTANCE) {
            return true;
        }
        if (fileType.isBinary()) {
            return fileType == ImageFileTypeManager.getInstance().getImageFileType() || fileType == FontFileType.INSTANCE;
        }
        return false;
    }

    public static boolean isPossiblyRelevantFile(@NotNull VirtualFile file2) {
        String extension;
        if (file2 == null) {
            AndroidFileChangeListener.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmpty((String)(extension = file2.getExtension()))) {
            return false;
        }
        return !JavaFileType.INSTANCE.getDefaultExtension().equals(extension) && !"kt".equals(extension);
    }

    @Slow
    public static boolean isRelevantFile(@NotNull VirtualFile file2) {
        String parentName;
        String extension;
        if (file2 == null) {
            AndroidFileChangeListener.$$$reportNull$$$0(5);
        }
        if (StringUtil.isEmpty((String)(extension = file2.getExtension()))) {
            return false;
        }
        if ("java".equals(extension) || "kt".equals(extension)) {
            return false;
        }
        if ("xml".equals(extension)) {
            return true;
        }
        if ("AndroidManifest.xml".equals(file2.getName())) {
            return true;
        }
        if ("aidl".equals(extension)) {
            return true;
        }
        VirtualFile parent = file2.getParent();
        if (parent != null && (parentName = parent.getName()).startsWith("raw")) {
            return true;
        }
        FileType fileType = file2.getFileType();
        return fileType.equals((Object)AndroidRenderscriptFileType.INSTANCE) || AndroidFileChangeListener.isRelevantFileType(fileType);
    }

    static boolean isRelevantFile(@NotNull PsiFile file2) {
        String parentName;
        FileType fileType;
        if (file2 == null) {
            AndroidFileChangeListener.$$$reportNull$$$0(6);
        }
        if ((fileType = file2.getFileType()) == JavaFileType.INSTANCE || fileType == KotlinFileType.INSTANCE) {
            return false;
        }
        if (AndroidFileChangeListener.isRelevantFileType(fileType)) {
            return true;
        }
        PsiDirectory parent = file2.getParent();
        return parent != null && (parentName = parent.getName()).startsWith("raw");
    }

    private void dispatch(@Nullable VirtualFile file2, @NotNull Consumer<PsiTreeChangeListener> invokeCallback) {
        if (invokeCallback == null) {
            AndroidFileChangeListener.$$$reportNull$$$0(7);
        }
        if (file2 != null) {
            this.dispatchToRegistry(file2, invokeCallback);
        }
        this.dispatchToResourceNotificationManager(invokeCallback);
    }

    private void dispatchToRegistry(@NotNull VirtualFile file2, @NotNull Consumer<PsiTreeChangeListener> invokeCallback) {
        if (file2 == null) {
            AndroidFileChangeListener.$$$reportNull$$$0(8);
        }
        if (invokeCallback == null) {
            AndroidFileChangeListener.$$$reportNull$$$0(9);
        }
        while (file2 != null) {
            ResourceFolderRegistry.CachedRepositories cached2 = this.myRegistry.getCached(file2);
            if (cached2 != null) {
                if (cached2.namespaced != null) {
                    invokeCallback.consume((Object)cached2.namespaced.getPsiListener());
                }
                if (cached2.nonNamespaced != null) {
                    invokeCallback.consume((Object)cached2.nonNamespaced.getPsiListener());
                }
                return;
            }
            file2 = file2.getParent();
        }
    }

    private void dispatchToResourceNotificationManager(@NotNull Consumer<PsiTreeChangeListener> invokeCallback) {
        PsiTreeChangeListener resourceNotificationPsiListener;
        if (invokeCallback == null) {
            AndroidFileChangeListener.$$$reportNull$$$0(10);
        }
        if ((resourceNotificationPsiListener = this.myResourceNotificationManager.getPsiListener()) != null) {
            invokeCallback.consume((Object)resourceNotificationPsiListener);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/AndroidFileChangeListener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invokeCallback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/AndroidFileChangeListener";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onProjectOpened";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isRelevantFileType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isPossiblyRelevantFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isRelevantFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "dispatch";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "dispatchToRegistry";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "dispatchToResourceNotificationManager";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyPsiListener
    implements PsiTreeChangeListener {
        private MyPsiListener() {
        }

        public void beforeChildAddition(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiListener.$$$reportNull$$$0(0);
            }
        }

        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            PsiFile psiFile2;
            if (event == null) {
                MyPsiListener.$$$reportNull$$$0(1);
            }
            if ((psiFile2 = event.getFile()) == null) {
                PsiElement child = event.getChild();
                if (child instanceof PsiFile) {
                    VirtualFile file2 = ((PsiFile)child).getVirtualFile();
                    if (file2 != null) {
                        this.computeModulesToInvalidateAttributeDefinitions(file2);
                        if (AndroidFileChangeListener.isRelevantFile(file2)) {
                            this.dispatchChildAdded(event, file2);
                        }
                    }
                } else if (child instanceof PsiDirectory) {
                    PsiDirectory directory = (PsiDirectory)child;
                    this.dispatchChildAdded(event, directory.getVirtualFile());
                }
            } else if (AndroidFileChangeListener.isRelevantFile(psiFile2)) {
                this.dispatchChildAdded(event, psiFile2.getVirtualFile());
            } else if (this.isGradleFileEdit(psiFile2)) {
                this.notifyGradleEdit();
            }
            if (AndroidFileChangeListener.this.mySampleDataListener != null) {
                AndroidFileChangeListener.this.mySampleDataListener.childAdded(event);
            }
        }

        private void dispatchChildAdded(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
            if (event == null) {
                MyPsiListener.$$$reportNull$$$0(2);
            }
            AndroidFileChangeListener.this.dispatch(virtualFile, (Consumer<PsiTreeChangeListener>)((Consumer)listener2 -> listener2.childAdded(event)));
        }

        public void beforeChildRemoval(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiListener.$$$reportNull$$$0(3);
            }
        }

        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            PsiFile psiFile2;
            if (event == null) {
                MyPsiListener.$$$reportNull$$$0(4);
            }
            if ((psiFile2 = event.getFile()) != null && psiFile2.getVirtualFile() != null) {
                this.computeModulesToInvalidateAttributeDefinitions(psiFile2.getVirtualFile());
            }
            if (psiFile2 == null) {
                PsiDirectory directory;
                PsiElement child = event.getChild();
                if (child instanceof PsiFile) {
                    VirtualFile file2 = ((PsiFile)child).getVirtualFile();
                    if (file2 != null && AndroidFileChangeListener.isRelevantFile(file2)) {
                        this.dispatchChildRemoved(event, file2);
                    }
                } else if (child instanceof PsiDirectory && ResourceFolderType.getFolderType((String)(directory = (PsiDirectory)child).getName()) != null) {
                    VirtualFile file3 = directory.getVirtualFile();
                    this.dispatchChildRemoved(event, file3);
                }
            } else if (AndroidFileChangeListener.isRelevantFile(psiFile2)) {
                VirtualFile file4 = psiFile2.getVirtualFile();
                this.dispatchChildRemoved(event, file4);
            } else if (this.isGradleFileEdit(psiFile2)) {
                this.notifyGradleEdit();
            }
            if (AndroidFileChangeListener.this.mySampleDataListener != null) {
                AndroidFileChangeListener.this.mySampleDataListener.childRemoved(event);
            }
        }

        private void dispatchChildRemoved(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
            if (event == null) {
                MyPsiListener.$$$reportNull$$$0(5);
            }
            AndroidFileChangeListener.this.dispatch(virtualFile, (Consumer<PsiTreeChangeListener>)((Consumer)listener2 -> listener2.childRemoved(event)));
        }

        public void beforeChildReplacement(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiListener.$$$reportNull$$$0(6);
            }
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            PsiFile psiFile2;
            if (event == null) {
                MyPsiListener.$$$reportNull$$$0(7);
            }
            if ((psiFile2 = event.getFile()) != null) {
                VirtualFile file2 = psiFile2.getVirtualFile();
                if (file2 != null) {
                    this.computeModulesToInvalidateAttributeDefinitions(file2);
                }
                if (AndroidFileChangeListener.isRelevantFile(psiFile2)) {
                    this.dispatchChildReplaced(event, file2);
                } else if (this.isGradleFileEdit(psiFile2)) {
                    this.notifyGradleEdit();
                }
                if (AndroidFileChangeListener.this.mySampleDataListener != null) {
                    AndroidFileChangeListener.this.mySampleDataListener.childReplaced(event);
                }
            } else {
                PsiElement parent = event.getParent();
                if (parent instanceof PsiDirectory) {
                    PsiDirectory directory = (PsiDirectory)parent;
                    this.dispatchChildReplaced(event, directory.getVirtualFile());
                }
            }
        }

        private void dispatchChildReplaced(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
            if (event == null) {
                MyPsiListener.$$$reportNull$$$0(8);
            }
            AndroidFileChangeListener.this.dispatch(virtualFile, (Consumer<PsiTreeChangeListener>)((Consumer)listener2 -> listener2.childReplaced(event)));
        }

        private boolean isGradleFileEdit(@NotNull PsiFile psiFile2) {
            if (psiFile2 == null) {
                MyPsiListener.$$$reportNull$$$0(9);
            }
            return GradleFiles.getInstance(AndroidFileChangeListener.this.myProject).isGradleFile(psiFile2);
        }

        private void notifyGradleEdit() {
            AndroidFileChangeListener.this.myEditorNotifications.updateAllNotifications();
        }

        public void beforeChildrenChange(@NotNull PsiTreeChangeEvent event) {
            PsiFile psiFile2;
            if (event == null) {
                MyPsiListener.$$$reportNull$$$0(10);
            }
            if ((psiFile2 = event.getFile()) != null && AndroidFileChangeListener.isRelevantFile(psiFile2)) {
                VirtualFile file2 = psiFile2.getVirtualFile();
                this.dispatchBeforeChildrenChange(event, file2);
            }
        }

        private void dispatchBeforeChildrenChange(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
            if (event == null) {
                MyPsiListener.$$$reportNull$$$0(11);
            }
            AndroidFileChangeListener.this.dispatch(virtualFile, (Consumer<PsiTreeChangeListener>)((Consumer)listener2 -> listener2.beforeChildrenChange(event)));
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            PsiFile psiFile2;
            if (event == null) {
                MyPsiListener.$$$reportNull$$$0(12);
            }
            if ((psiFile2 = event.getFile()) != null) {
                VirtualFile file2 = psiFile2.getVirtualFile();
                if (file2 != null) {
                    this.computeModulesToInvalidateAttributeDefinitions(file2);
                }
                if (AndroidFileChangeListener.isRelevantFile(psiFile2)) {
                    this.dispatchChildrenChanged(event, file2);
                }
                if (AndroidFileChangeListener.this.mySampleDataListener != null) {
                    AndroidFileChangeListener.this.mySampleDataListener.childrenChanged(event);
                }
            }
        }

        private void dispatchChildrenChanged(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
            if (event == null) {
                MyPsiListener.$$$reportNull$$$0(13);
            }
            AndroidFileChangeListener.this.dispatch(virtualFile, (Consumer<PsiTreeChangeListener>)((Consumer)listener2 -> listener2.childrenChanged(event)));
        }

        public void beforeChildMovement(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiListener.$$$reportNull$$$0(14);
            }
        }

        public void childMoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiListener.$$$reportNull$$$0(15);
            }
            PsiElement child = event.getChild();
            PsiFile psiFile2 = event.getFile();
            if (psiFile2 == null) {
                if (child instanceof PsiFile && AndroidFileChangeListener.isRelevantFile((PsiFile)child)) {
                    VirtualFile file2 = ((PsiFile)child).getVirtualFile();
                    if (file2 != null) {
                        this.dispatchChildMoved(event, file2);
                        return;
                    }
                    PsiElement oldParent = event.getOldParent();
                    if (oldParent instanceof PsiDirectory) {
                        PsiDirectory directory = (PsiDirectory)oldParent;
                        VirtualFile dir = directory.getVirtualFile();
                        this.dispatchChildMoved(event, dir);
                    }
                }
            } else {
                VirtualFile file3 = psiFile2.getVirtualFile();
                if (file3 != null) {
                    this.computeModulesToInvalidateAttributeDefinitions(file3);
                    if (AndroidFileChangeListener.isRelevantFile(file3)) {
                        this.dispatchChildMoved(event, file3);
                    }
                    if (AndroidFileChangeListener.this.mySampleDataListener != null) {
                        AndroidFileChangeListener.this.mySampleDataListener.childMoved(event);
                    }
                }
            }
        }

        private void dispatchChildMoved(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
            PsiElement oldParent;
            if (event == null) {
                MyPsiListener.$$$reportNull$$$0(16);
            }
            AndroidFileChangeListener.this.dispatch(virtualFile, (Consumer<PsiTreeChangeListener>)((Consumer)listener2 -> listener2.childMoved(event)));
            if (event.getFile() == null && (oldParent = event.getOldParent()) instanceof PsiDirectory) {
                PsiDirectory sourceDir = (PsiDirectory)oldParent;
                AndroidFileChangeListener.this.dispatch(sourceDir.getVirtualFile(), (Consumer<PsiTreeChangeListener>)((Consumer)listener2 -> listener2.childMoved(event)));
            }
        }

        public void beforePropertyChange(@NotNull PsiTreeChangeEvent event) {
            PsiFile psiFile2;
            PsiElement child;
            if (event == null) {
                MyPsiListener.$$$reportNull$$$0(17);
            }
            if ("fileName" == event.getPropertyName() && (child = event.getChild()) instanceof PsiFile && AndroidFileChangeListener.isRelevantFile(psiFile2 = (PsiFile)child)) {
                VirtualFile file2 = psiFile2.getVirtualFile();
                this.dispatchBeforePropertyChange(event, file2);
            }
        }

        private void dispatchBeforePropertyChange(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
            if (event == null) {
                MyPsiListener.$$$reportNull$$$0(18);
            }
            AndroidFileChangeListener.this.dispatch(virtualFile, (Consumer<PsiTreeChangeListener>)((Consumer)listener2 -> listener2.beforePropertyChange(event)));
        }

        public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
            PsiFile psiFile2;
            PsiElement child;
            if (event == null) {
                MyPsiListener.$$$reportNull$$$0(19);
            }
            if ("fileName" == event.getPropertyName() && (child = event.getElement()) instanceof PsiFile && AndroidFileChangeListener.isRelevantFile(psiFile2 = (PsiFile)child)) {
                VirtualFile file2 = psiFile2.getVirtualFile();
                this.dispatchPropertyChanged(event, file2);
            }
        }

        private void dispatchPropertyChanged(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
            if (event == null) {
                MyPsiListener.$$$reportNull$$$0(20);
            }
            AndroidFileChangeListener.this.dispatch(virtualFile, (Consumer<PsiTreeChangeListener>)((Consumer)listener2 -> listener2.propertyChanged(event)));
        }

        private void computeModulesToInvalidateAttributeDefinitions(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyPsiListener.$$$reportNull$$$0(21);
            }
            if (!AndroidFileChangeListener.isRelevantFile(file2)) {
                return;
            }
            AndroidFacet facet2 = AndroidFacet.getInstance((VirtualFile)file2, (Project)AndroidFileChangeListener.this.myProject);
            if (facet2 != null) {
                for (Module module2 : AndroidUtils.getSetWithBackwardDependencies(facet2.getModule())) {
                    AndroidFacet moduleFacet = AndroidFacet.getInstance((Module)module2);
                    if (moduleFacet == null) continue;
                    ModuleResourceManagers.getInstance(moduleFacet).getLocalResourceManager().invalidateAttributeDefinitions();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/res/AndroidFileChangeListener$MyPsiListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeChildAddition";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childAdded";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dispatchChildAdded";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeChildRemoval";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childRemoved";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dispatchChildRemoved";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeChildReplacement";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childReplaced";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dispatchChildReplaced";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isGradleFileEdit";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeChildrenChange";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dispatchBeforeChildrenChange";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childrenChanged";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dispatchChildrenChanged";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeChildMovement";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childMoved";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dispatchChildMoved";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforePropertyChange";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dispatchBeforePropertyChange";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[2] = "propertyChanged";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dispatchPropertyChanged";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computeModulesToInvalidateAttributeDefinitions";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class MyDocumentListener
    implements DocumentListener {
        private final FileDocumentManager myFileDocumentManager;
        private final PsiDocumentManager myPsiDocumentManager;
        private final ResourceFolderRegistry myRegistry;
        private final Project myProject;

        private MyDocumentListener(@NotNull Project project, @NotNull ResourceFolderRegistry registry) {
            if (project == null) {
                MyDocumentListener.$$$reportNull$$$0(0);
            }
            if (registry == null) {
                MyDocumentListener.$$$reportNull$$$0(1);
            }
            this.myPsiDocumentManager = PsiDocumentManager.getInstance((Project)project);
            this.myFileDocumentManager = FileDocumentManager.getInstance();
            this.myRegistry = registry;
            this.myProject = project;
        }

        public void documentChanged(@NotNull DocumentEvent event) {
            VirtualFile virtualFile;
            if (event == null) {
                MyDocumentListener.$$$reportNull$$$0(2);
            }
            if (this.myProject.isDisposed()) {
                return;
            }
            Document document = event.getDocument();
            PsiFile psiFile2 = this.myPsiDocumentManager.getCachedPsiFile(document);
            if (psiFile2 == null && (virtualFile = this.myFileDocumentManager.getFile(document)) != null) {
                this.myRegistry.dispatchToRepositories(virtualFile, ResourceFolderRepository::scheduleScan);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "registry";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/res/AndroidFileChangeListener$MyDocumentListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "documentChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class MyFileDocumentManagerListener
    implements FileDocumentManagerListener {
        private final ResourceFolderRegistry myRegistry;

        private MyFileDocumentManagerListener(ResourceFolderRegistry registry) {
            this.myRegistry = registry;
        }

        public void fileWithNoDocumentChanged(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyFileDocumentManagerListener.$$$reportNull$$$0(0);
            }
            this.myRegistry.dispatchToRepositories(file2, ResourceFolderRepository::scheduleScan);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/res/AndroidFileChangeListener$MyFileDocumentManagerListener", "fileWithNoDocumentChanged"));
        }
    }

    static class MyVfsListener
    implements BulkFileListener {
        private final ResourceFolderRegistry myRegistry;

        private MyVfsListener(@NotNull ResourceFolderRegistry registry) {
            if (registry == null) {
                MyVfsListener.$$$reportNull$$$0(0);
            }
            this.myRegistry = registry;
        }

        @UiThread
        public void before(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
            if (events == null) {
                MyVfsListener.$$$reportNull$$$0(1);
            }
            for (VFileEvent vFileEvent : events) {
                if (vFileEvent instanceof VFileMoveEvent) {
                    this.onFileOrDirectoryRemoved(((VFileMoveEvent)vFileEvent).getFile());
                    continue;
                }
                if (vFileEvent instanceof VFileDeleteEvent) {
                    this.onFileOrDirectoryRemoved(((VFileDeleteEvent)vFileEvent).getFile());
                    continue;
                }
                if (!(vFileEvent instanceof VFilePropertyChangeEvent) || !((VFilePropertyChangeEvent)vFileEvent).getPropertyName().equals("name")) continue;
                this.onFileOrDirectoryRemoved(((VFilePropertyChangeEvent)vFileEvent).getFile());
            }
        }

        public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
            if (events == null) {
                MyVfsListener.$$$reportNull$$$0(2);
            }
            for (VFileEvent vFileEvent : events) {
                if (vFileEvent instanceof VFileCreateEvent) {
                    VFileCreateEvent createEvent = (VFileCreateEvent)vFileEvent;
                    this.onFileOrDirectoryCreated(createEvent.getParent(), createEvent.getChildName());
                    continue;
                }
                if (vFileEvent instanceof VFileCopyEvent) {
                    VFileCopyEvent copyEvent = (VFileCopyEvent)vFileEvent;
                    this.onFileOrDirectoryCreated(copyEvent.getNewParent(), copyEvent.getNewChildName());
                    continue;
                }
                if (vFileEvent instanceof VFileMoveEvent) {
                    VFileMoveEvent moveEvent = (VFileMoveEvent)vFileEvent;
                    this.onFileOrDirectoryCreated(moveEvent.getNewParent(), moveEvent.getFile().getName());
                    continue;
                }
                if (vFileEvent instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)vFileEvent).getPropertyName().equals("name")) {
                    VFilePropertyChangeEvent renameEvent = (VFilePropertyChangeEvent)vFileEvent;
                    VirtualFile parentFile = renameEvent.getFile().getParent();
                    if (parentFile == null) continue;
                    this.onFileOrDirectoryCreated(parentFile, (String)renameEvent.getNewValue());
                    continue;
                }
                if (!(vFileEvent instanceof VFileContentChangeEvent)) continue;
            }
        }

        private void onFileOrDirectoryCreated(@Nullable VirtualFile parent, @NotNull String childName) {
            ResourceFolderRegistry.CachedRepositories cachedRepositories;
            if (childName == null) {
                MyVfsListener.$$$reportNull$$$0(3);
            }
            if (parent == null) {
                return;
            }
            if (!parent.exists()) {
                return;
            }
            VirtualFile created = parent.findChild(childName);
            if (created == null) {
                return;
            }
            if (created.isDirectory()) {
                cachedRepositories = this.myRegistry.getCached(parent);
            } else {
                VirtualFile grandParent = parent.getParent();
                ResourceFolderRegistry.CachedRepositories cachedRepositories2 = cachedRepositories = grandParent == null ? null : this.myRegistry.getCached(grandParent);
            }
            if (cachedRepositories != null) {
                MyVfsListener.onFileOrDirectoryCreated(created, cachedRepositories.namespaced);
                MyVfsListener.onFileOrDirectoryCreated(created, cachedRepositories.nonNamespaced);
            }
        }

        private static void onFileOrDirectoryCreated(@NotNull VirtualFile created, @Nullable ResourceFolderRepository repository) {
            if (created == null) {
                MyVfsListener.$$$reportNull$$$0(4);
            }
            if (repository == null) {
                return;
            }
            if (!created.isDirectory()) {
                repository.onFileCreated(created);
            } else {
                for (VirtualFile child : created.getChildren()) {
                    if (child.isDirectory()) continue;
                    repository.onFileCreated(child);
                }
            }
        }

        private void onFileOrDirectoryRemoved(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyVfsListener.$$$reportNull$$$0(5);
            }
            this.myRegistry.dispatchToRepositories(file2, ResourceFolderRepository::onFileOrDirectoryRemoved);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "registry";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "events";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "created";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/res/AndroidFileChangeListener$MyVfsListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "before";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "after";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onFileOrDirectoryCreated";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onFileOrDirectoryRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MyStartupActivity
    implements StartupActivity {
        public void runActivity(@NotNull Project project) {
            if (project == null) {
                MyStartupActivity.$$$reportNull$$$0(0);
            }
            AndroidFileChangeListener listener2 = AndroidFileChangeListener.getInstance(project);
            listener2.onProjectOpened(project);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/res/AndroidFileChangeListener$MyStartupActivity", "runActivity"));
        }
    }
}

