/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.multi;

import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.OptionalLibrary;
import com.android.sdklib.SdkVersionInfo;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompatibilityRenderTarget
implements IAndroidTarget {
    private final int myApiLevel;
    private final IAndroidTarget myDelegate;
    private final AndroidVersion myVersion;
    private final IAndroidTarget myRealTarget;
    private final String myHashString;

    public CompatibilityRenderTarget(@NotNull IAndroidTarget delegate2, int apiLevel, @Nullable IAndroidTarget realTarget) {
        if (delegate2 == null) {
            CompatibilityRenderTarget.$$$reportNull$$$0(0);
        }
        this.myDelegate = delegate2;
        this.myApiLevel = apiLevel;
        this.myRealTarget = realTarget;
        this.myVersion = realTarget != null ? realTarget.getVersion() : new AndroidVersion(apiLevel, null);
        this.myHashString = "compat-" + AndroidTargetHash.getPlatformHashString((AndroidVersion)this.myVersion);
    }

    public static IAndroidTarget copyWithNewDelegate(@NotNull CompatibilityRenderTarget original, @NotNull IAndroidTarget newDelegate) {
        if (original == null) {
            CompatibilityRenderTarget.$$$reportNull$$$0(1);
        }
        if (newDelegate == null) {
            CompatibilityRenderTarget.$$$reportNull$$$0(2);
        }
        return new CompatibilityRenderTarget(newDelegate, original.myApiLevel, original.myRealTarget);
    }

    @NotNull
    public IAndroidTarget getRenderTarget() {
        IAndroidTarget iAndroidTarget = this.myDelegate;
        if (iAndroidTarget == null) {
            CompatibilityRenderTarget.$$$reportNull$$$0(3);
        }
        return iAndroidTarget;
    }

    @Nullable
    public IAndroidTarget getRealTarget() {
        return this.myRealTarget;
    }

    @NotNull
    public AndroidVersion getVersion() {
        AndroidVersion androidVersion = this.myVersion;
        if (androidVersion == null) {
            CompatibilityRenderTarget.$$$reportNull$$$0(4);
        }
        return androidVersion;
    }

    public String getVersionName() {
        return SdkVersionInfo.getAndroidName((int)this.myApiLevel);
    }

    public String hashString() {
        return this.myHashString;
    }

    public int compareTo(@NotNull IAndroidTarget other) {
        int delta;
        if (other == null) {
            CompatibilityRenderTarget.$$$reportNull$$$0(5);
        }
        if ((delta = this.myApiLevel - other.getVersion().getApiLevel()) != 0) {
            return delta;
        }
        return this.myDelegate.compareTo((Object)other);
    }

    public int getRevision() {
        return 1;
    }

    @NotNull
    public String getPath(int pathId) {
        String string = this.myDelegate.getPath(pathId);
        if (string == null) {
            CompatibilityRenderTarget.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public File getFile(int pathId) {
        File file2 = this.myDelegate.getFile(pathId);
        if (file2 == null) {
            CompatibilityRenderTarget.$$$reportNull$$$0(7);
        }
        return file2;
    }

    @NotNull
    public String getLocation() {
        String string = this.myDelegate.getLocation();
        if (string == null) {
            CompatibilityRenderTarget.$$$reportNull$$$0(8);
        }
        return string;
    }

    public String getVendor() {
        return this.myDelegate.getVendor();
    }

    public String getName() {
        return this.myDelegate.getName();
    }

    public String getFullName() {
        return this.myDelegate.getFullName();
    }

    public String getClasspathName() {
        return this.myDelegate.getClasspathName();
    }

    public String getShortClasspathName() {
        return this.myDelegate.getShortClasspathName();
    }

    public boolean isPlatform() {
        return this.myDelegate.isPlatform();
    }

    public IAndroidTarget getParent() {
        return this.myDelegate.getParent();
    }

    public BuildToolInfo getBuildToolInfo() {
        return this.myDelegate.getBuildToolInfo();
    }

    @NotNull
    public List<String> getBootClasspath() {
        List list = this.myDelegate.getBootClasspath();
        if (list == null) {
            CompatibilityRenderTarget.$$$reportNull$$$0(9);
        }
        return list;
    }

    public boolean hasRenderingLibrary() {
        return this.myDelegate.hasRenderingLibrary();
    }

    @NotNull
    public File[] getSkins() {
        File[] fileArray = this.myDelegate.getSkins();
        if (fileArray == null) {
            CompatibilityRenderTarget.$$$reportNull$$$0(10);
        }
        return fileArray;
    }

    @Nullable
    public File getDefaultSkin() {
        return this.myDelegate.getDefaultSkin();
    }

    @NotNull
    public List<OptionalLibrary> getOptionalLibraries() {
        List list = this.myDelegate.getOptionalLibraries();
        if (list == null) {
            CompatibilityRenderTarget.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public List<OptionalLibrary> getAdditionalLibraries() {
        List list = this.myDelegate.getAdditionalLibraries();
        if (list == null) {
            CompatibilityRenderTarget.$$$reportNull$$$0(12);
        }
        return list;
    }

    public String[] getPlatformLibraries() {
        return this.myDelegate.getPlatformLibraries();
    }

    public String getProperty(String name) {
        return this.myDelegate.getProperty(name);
    }

    public Map<String, String> getProperties() {
        return this.myDelegate.getProperties();
    }

    public boolean canRunOn(IAndroidTarget target) {
        return this.myDelegate.canRunOn(target);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDelegate";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/multi/CompatibilityRenderTarget";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/multi/CompatibilityRenderTarget";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderTarget";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBootClasspath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSkins";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionalLibraries";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalLibraries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewDelegate";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

