/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.classloading;

import com.android.tools.idea.LogAnonymizerUtil;
import com.android.tools.idea.rendering.classloading.ClassConverter;
import com.android.tools.idea.rendering.classloading.InconvertibleClassError;
import com.google.common.base.Suppliers;
import com.google.common.io.ByteStreams;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.lang.UrlClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.org.objectweb.asm.ClassVisitor;

public abstract class RenderClassLoader
extends ClassLoader {
    protected static final Logger LOG = Logger.getInstance(RenderClassLoader.class);
    private final Function<ClassVisitor, ClassVisitor> myProjectClassesTransformationProvider;
    private final Function<ClassVisitor, ClassVisitor> myNonProjectClassesTransformationProvider;
    private final Object myJarClassLoaderLock;
    private final Function<String, String> myNonProjectClassNameLookup;
    private Supplier<UrlClassLoader> myJarClassLoader;
    protected boolean myInsideJarClassLoader;

    public RenderClassLoader(@Nullable ClassLoader parent, @NotNull Function<ClassVisitor, ClassVisitor> projectClassesTransformationProvider, @NotNull Function<ClassVisitor, ClassVisitor> nonProjectClassesTransformationProvider, @NotNull Function<String, String> nonProjectClassNameLookup) {
        if (projectClassesTransformationProvider == null) {
            RenderClassLoader.$$$reportNull$$$0(0);
        }
        if (nonProjectClassesTransformationProvider == null) {
            RenderClassLoader.$$$reportNull$$$0(1);
        }
        if (nonProjectClassNameLookup == null) {
            RenderClassLoader.$$$reportNull$$$0(2);
        }
        super(parent);
        this.myJarClassLoaderLock = new Object();
        this.myJarClassLoader = Suppliers.memoize(() -> this.createJarClassLoader(this.getExternalJars()));
        this.myProjectClassesTransformationProvider = projectClassesTransformationProvider;
        this.myNonProjectClassesTransformationProvider = nonProjectClassesTransformationProvider;
        this.myNonProjectClassNameLookup = nonProjectClassNameLookup;
    }

    @TestOnly
    public RenderClassLoader(@Nullable ClassLoader parent, @NotNull Function<ClassVisitor, ClassVisitor> transformationProvider) {
        if (transformationProvider == null) {
            RenderClassLoader.$$$reportNull$$$0(3);
        }
        this(parent, transformationProvider, transformationProvider, Function.identity());
    }

    public RenderClassLoader(@Nullable ClassLoader parent) {
        this(parent, Function.identity(), Function.identity(), Function.identity());
    }

    protected abstract List<Path> getExternalJars();

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.load(name);
    }

    @NotNull
    protected Class<?> load(String name) throws ClassNotFoundException {
        Class<?> clazz = this.loadClassFromNonProjectDependency(name);
        if (clazz == null) {
            RenderClassLoader.$$$reportNull$$$0(4);
        }
        return clazz;
    }

    @NotNull
    private UrlClassLoader createJarClassLoader(@NotNull List<Path> files2) {
        if (files2 == null) {
            RenderClassLoader.$$$reportNull$$$0(5);
        }
        return new UrlClassLoader(UrlClassLoader.build().parent((ClassLoader)this).files(files2).allowLock(false).setLogErrorOnMissingJar(false), false){

            public Enumeration<URL> getResources(String name) throws IOException {
                return this.findResources(name);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    protected Class<?> loadClassFromNonProjectDependency(@NotNull String name) throws ClassNotFoundException {
        Class<?> clazz;
        InputStream is;
        block18: {
            UrlClassLoader jarClassLoaders;
            if (name == null) {
                RenderClassLoader.$$$reportNull$$$0(6);
            }
            Object object = this.myJarClassLoaderLock;
            synchronized (object) {
                jarClassLoaders = this.myJarClassLoader.get();
            }
            String diskLookupName = this.myNonProjectClassNameLookup.apply(name);
            this.myInsideJarClassLoader = true;
            is = jarClassLoaders.getResourceAsStream(diskLookupName.replace('.', '/') + ".class");
            if (is == null) {
                throw new ClassNotFoundException(name);
            }
            byte[] data = ByteStreams.toByteArray((InputStream)is);
            if (!ClassConverter.isValidClassFile(data)) {
                throw new ClassFormatError(name);
            }
            byte[] rewritten = ClassConverter.rewriteClass(data, this.myNonProjectClassesTransformationProvider);
            clazz = this.defineClassAndPackage(name, rewritten, 0, rewritten.length);
            if (is == null) break block18;
            is.close();
        }
        this.myInsideJarClassLoader = false;
        Class<?> clazz2 = clazz;
        if (clazz2 == null) {
            RenderClassLoader.$$$reportNull$$$0(7);
        }
        return clazz2;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | ClassNotFoundException e) {
                        LOG.debug((Throwable)e);
                        this.myInsideJarClassLoader = false;
                    }
                }
                catch (Throwable throwable3) {
                    this.myInsideJarClassLoader = false;
                    throw throwable3;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("ClassNotFoundException(%s)", name));
        }
        throw new ClassNotFoundException(name);
    }

    @Nullable
    protected Class<?> loadClassFile(String fqcn, @NotNull VirtualFile classFile) {
        if (classFile == null) {
            RenderClassLoader.$$$reportNull$$$0(8);
        }
        try {
            byte[] data = classFile.contentsToByteArray();
            return this.loadClass(fqcn, data);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @NotNull
    protected Class<?> loadClass(@NotNull String fqcn, byte @NotNull [] data) {
        Class<?> clazz;
        if (fqcn == null) {
            RenderClassLoader.$$$reportNull$$$0(9);
        }
        if (data == null) {
            RenderClassLoader.$$$reportNull$$$0(10);
        }
        if (!ClassConverter.isValidClassFile(data)) {
            throw new ClassFormatError(fqcn);
        }
        byte[] rewritten = ClassConverter.rewriteClass(data, this.myProjectClassesTransformationProvider);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Defining class '%s' from disk file", LogAnonymizerUtil.anonymizeClassName((String)fqcn)));
            }
            clazz = this.defineClassAndPackage(fqcn, rewritten, 0, rewritten.length);
        }
        catch (UnsupportedClassVersionError inner) {
            LOG.debug((Throwable)inner);
            throw InconvertibleClassError.wrap(inner, fqcn, data);
        }
        if (clazz == null) {
            RenderClassLoader.$$$reportNull$$$0(11);
        }
        return clazz;
    }

    @NotNull
    protected Class<?> defineClassAndPackage(@NotNull String name, byte @NotNull [] b, int offset2, int len) {
        String packageName;
        Package pkg;
        int i2;
        if (name == null) {
            RenderClassLoader.$$$reportNull$$$0(12);
        }
        if (b == null) {
            RenderClassLoader.$$$reportNull$$$0(13);
        }
        if ((i2 = name.lastIndexOf(46)) > 0 && (pkg = this.getPackage(packageName = name.substring(0, i2))) == null) {
            this.definePackage(packageName, null, null, null, null, null, null, null);
        }
        Class<?> clazz = this.defineClass(name, b, offset2, len);
        if (clazz == null) {
            RenderClassLoader.$$$reportNull$$$0(14);
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean areDependenciesUpToDate() {
        List currentDependencies;
        List<Path> updatedDependencies = this.getExternalJars();
        Object object = this.myJarClassLoaderLock;
        synchronized (object) {
            currentDependencies = this.myJarClassLoader.get().getFiles();
        }
        if (updatedDependencies.size() != currentDependencies.size()) {
            return false;
        }
        return currentDependencies.containsAll(updatedDependencies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Object object = this.myJarClassLoaderLock;
        synchronized (object) {
            return this.myJarClassLoader.get().getResources(name);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectClassesTransformationProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nonProjectClassesTransformationProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nonProjectClassNameLookup";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformationProvider";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/classloading/RenderClassLoader";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqcn";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/classloading/RenderClassLoader";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "loadClassFromNonProjectDependency";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "loadClass";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "defineClassAndPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 14: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createJarClassLoader";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadClassFromNonProjectDependency";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadClassFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadClass";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "defineClassAndPackage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

