/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.classloading;

import com.android.tools.idea.editors.literals.LiteralUsageReference;
import com.android.tools.idea.rendering.classloading.ConstantKey;
import com.android.tools.idea.rendering.classloading.ConstantRemapper;
import com.android.tools.idea.rendering.classloading.DefaultConstantRemapper;
import com.android.tools.idea.rendering.classloading.LiveLiteralsTransformKt;
import com.intellij.openapi.util.SimpleModificationTracker;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0016J\b\u0010\u0017\u001a\u00020\tH\u0007J\u0012\u0010\u0018\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J.\u0010\u001b\u001a\u0004\u0018\u00010\u000f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000fH\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\f\u001a\u001a\u0012\u0004\u0012\u00020\r\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000f0\u000e0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/rendering/classloading/DefaultConstantRemapper;", "Lcom/android/tools/idea/rendering/classloading/ConstantRemapper;", "()V", "allKeys", "Ljava/util/WeakHashMap;", "Lcom/android/tools/idea/rendering/classloading/ConstantKey;", "", "initialValueCache", "", "", "modificationTracker", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "perClassLoaderConstantMap", "Ljava/lang/ClassLoader;", "", "", "addConstant", "", "classLoader", "reference", "Lcom/android/tools/idea/editors/literals/LiteralUsageReference;", "initialValue", "newValue", "allKeysToText", "clearConstants", "getModificationCount", "", "remapConstant", "source", "isStatic", "methodName", "intellij.android.core"})
public final class DefaultConstantRemapper
implements ConstantRemapper {
    private static final WeakHashMap<ClassLoader, Map<ConstantKey, Object>> perClassLoaderConstantMap;
    private static final WeakHashMap<ConstantKey, Boolean> allKeys;
    private static final Set<String> initialValueCache;
    private static final SimpleModificationTracker modificationTracker;
    @NotNull
    public static final DefaultConstantRemapper INSTANCE;

    @Override
    public void addConstant(@Nullable ClassLoader classLoader, @NotNull LiteralUsageReference reference2, @NotNull Object initialValue, @NotNull Object newValue) {
        Intrinsics.checkNotNullParameter((Object)reference2, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        Map<ConstantKey, Object> classLoaderMap2 = perClassLoaderConstantMap.computeIfAbsent(classLoader, addConstant.classLoaderMap.1.INSTANCE);
        initialValueCache.add(initialValue.toString());
        String string = reference2.getFqName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"reference.fqName.asString()");
        ConstantKey constantKey = new ConstantKey(string, initialValue);
        if (allKeys.put(constantKey, true) == null) {
            modificationTracker.incModificationCount();
        }
        Map<ConstantKey, Object> map2 = classLoaderMap2;
        Intrinsics.checkNotNullExpressionValue(map2, (String)"classLoaderMap");
        map2.put(constantKey, newValue);
    }

    @Override
    public void clearConstants(@Nullable ClassLoader classLoader) {
        block1: {
            Map<ConstantKey, Object> map2 = perClassLoaderConstantMap.get(classLoader);
            if (map2 == null) break block1;
            Map<ConstantKey, Object> map3 = map2;
            boolean bl = false;
            boolean bl2 = false;
            Map<ConstantKey, Object> it = map3;
            boolean bl3 = false;
            Map<ConstantKey, Object> map4 = it;
            Intrinsics.checkNotNullExpressionValue(map4, (String)"it");
            Map<ConstantKey, Object> map5 = map4;
            boolean bl4 = false;
            if (!map5.isEmpty()) {
                modificationTracker.incModificationCount();
                it.clear();
            }
        }
    }

    @TestOnly
    @NotNull
    public final String allKeysToText() {
        Set<ConstantKey> set = allKeys.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"allKeys.keys");
        return CollectionsKt.joinToString$default((Iterable)set, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object remapConstant(@Nullable Object source, boolean isStatic, @NotNull String methodName, @Nullable Object initialValue) {
        ConstantKey constantKey;
        void $this$dropWhile$iv;
        Map<ConstantKey, Object> map2;
        ClassLoader classLoader;
        ClassLoader classLoader2;
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        if (initialValue == null || !initialValueCache.contains(initialValue.toString())) {
            return initialValue;
        }
        if (isStatic) {
            Class<?> clazz = source;
            if (!(clazz instanceof Class)) {
                clazz = null;
            }
            Class clazz2 = clazz;
            classLoader2 = clazz2 != null ? clazz2.getClassLoader() : null;
        } else {
            Class<?> clazz = source;
            classLoader2 = classLoader = clazz != null && (clazz = clazz.getClass()) != null ? clazz.getClassLoader() : null;
        }
        if ((map2 = perClassLoaderConstantMap.get(classLoader)) == null) {
            map2 = perClassLoaderConstantMap.get(null);
        }
        if (map2 == null) {
            return initialValue;
        }
        Intrinsics.checkNotNullExpressionValue(map2, (String)"perClassLoaderConstantMa\u2026   ?: return initialValue");
        Map<ConstantKey, Object> classLoaderMap2 = map2;
        Thread thread = Thread.currentThread();
        Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"Thread.currentThread()");
        Object[] objectArray = thread.getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Thread.currentThread().stackTrace");
        Iterable iterable = ArraysKt.drop((Object[])objectArray, (int)2);
        boolean $i$f$dropWhile = false;
        boolean yielding$iv = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$dropWhile$iv) {
            if (yielding$iv) {
                list$iv.add(item$iv);
                continue;
            }
            StackTraceElement it = (StackTraceElement)item$iv;
            boolean bl = false;
            StackTraceElement stackTraceElement = it;
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElement, (String)"it");
            String string = stackTraceElement.getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.className");
            if (StringsKt.startsWith$default((String)string, (String)"com.android.tools.idea.rendering.classloading.", (boolean)false, (int)2, null)) continue;
            list$iv.add(item$iv);
            yielding$iv = true;
        }
        StackTraceElement callerStack = (StackTraceElement)CollectionsKt.first((List)list$iv);
        if (Intrinsics.areEqual((Object)methodName, (Object)"invoke")) {
            StackTraceElement stackTraceElement = callerStack;
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElement, (String)"callerStack");
            String string = stackTraceElement.getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"callerStack.className");
            constantKey = new ConstantKey(LiveLiteralsTransformKt.normalizeClassName(string), initialValue);
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            StackTraceElement stackTraceElement = callerStack;
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElement, (String)"callerStack");
            String string = stackTraceElement.getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"callerStack.className");
            constantKey = new ConstantKey(stringBuilder.append(LiveLiteralsTransformKt.normalizeClassName(string)).append('.').append(methodName).toString(), initialValue);
        }
        ConstantKey lookupKey = constantKey;
        return classLoaderMap2.getOrDefault(lookupKey, initialValue);
    }

    public long getModificationCount() {
        return modificationTracker.getModificationCount();
    }

    private DefaultConstantRemapper() {
    }

    static {
        DefaultConstantRemapper defaultConstantRemapper;
        INSTANCE = defaultConstantRemapper = new DefaultConstantRemapper();
        perClassLoaderConstantMap = new WeakHashMap();
        allKeys = new WeakHashMap();
        boolean bl = false;
        initialValueCache = new LinkedHashSet();
        modificationTracker = new SimpleModificationTracker();
    }
}

