/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.classloading;

import com.android.tools.idea.rendering.classloading.InconvertibleClassError;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Shorts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.lang.JavaVersion;
import java.util.Collection;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;

public class ClassConverter {
    private static final int ourCurrentJdkClassVersion = ClassConverter.jdkToClassVersion(SystemInfo.JAVA_VERSION);

    @NotNull
    static byte[] rewriteClass(@NotNull byte[] classData, @NotNull Function<ClassVisitor, ClassVisitor> getTransformations) {
        if (getTransformations == null) {
            ClassConverter.$$$reportNull$$$0(0);
        }
        if (classData == null) {
            ClassConverter.$$$reportNull$$$0(1);
        }
        ClassWriter classWriter = new ClassWriter(1);
        ClassVisitor classVisitor = getTransformations.apply((ClassVisitor)classWriter);
        ClassReader reader = new ClassReader(classData);
        reader.accept(classVisitor, 0);
        byte[] byArray = classWriter.toByteArray();
        if (byArray == null) {
            ClassConverter.$$$reportNull$$$0(2);
        }
        return byArray;
    }

    public static int jdkToClassVersion(@NotNull String version2) {
        JavaVersion javaVersion;
        if (version2 == null) {
            ClassConverter.$$$reportNull$$$0(3);
        }
        return (javaVersion = JavaVersion.tryParse((String)version2)) != null ? javaVersion.feature + 44 : -1;
    }

    public static String classVersionToJdk(int version2) {
        if (version2 >= 53) {
            return Integer.toString(version2 - 53 + 9);
        }
        return "1." + Integer.toString(version2 - 44);
    }

    public static int findHighestMajorVersion(Collection<Throwable> list) {
        int result2 = 0;
        for (Throwable t : list) {
            if (!(t instanceof InconvertibleClassError)) continue;
            InconvertibleClassError error = (InconvertibleClassError)t;
            result2 = Math.max(result2, error.getMajor());
        }
        return result2;
    }

    public static String getCurrentJdkVersion() {
        String version2 = SystemInfo.JAVA_VERSION;
        int suffix = version2.indexOf(95);
        if (suffix != -1) {
            version2 = version2.substring(0, suffix);
        }
        return version2;
    }

    public static int getCurrentClassVersion() {
        return ourCurrentJdkClassVersion;
    }

    public static boolean isValidClassFile(@NotNull byte[] classData) {
        if (classData == null) {
            ClassConverter.$$$reportNull$$$0(4);
        }
        return classData.length >= 7 && ClassConverter.getMagic(classData) == -889275714;
    }

    public static int getMagic(@NotNull byte[] classData) {
        if (classData == null) {
            ClassConverter.$$$reportNull$$$0(5);
        }
        return Ints.fromBytes((byte)classData[0], (byte)classData[1], (byte)classData[2], (byte)classData[3]);
    }

    public static short getMajorVersion(byte[] classData) {
        return Shorts.fromBytes((byte)classData[6], (byte)classData[7]);
    }

    public static short getMinorVersion(byte[] classData) {
        return Shorts.fromBytes((byte)classData[4], (byte)classData[5]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getTransformations";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/classloading/ClassConverter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/classloading/ClassConverter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "rewriteClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "rewriteClass";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "jdkToClassVersion";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isValidClassFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMagic";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

