/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.google.common.collect.Lists;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ReplaceTagFix
implements Runnable {
    @NotNull
    private final XmlFile myFile;
    @NotNull
    private final String myWrongTag;
    @NotNull
    private final String myRightTag;
    private final String myCommandName;

    public ReplaceTagFix(@NotNull XmlFile file2, @NotNull String wrongTag, @NotNull String rightTag) {
        if (file2 == null) {
            ReplaceTagFix.$$$reportNull$$$0(0);
        }
        if (wrongTag == null) {
            ReplaceTagFix.$$$reportNull$$$0(1);
        }
        if (rightTag == null) {
            ReplaceTagFix.$$$reportNull$$$0(2);
        }
        this.myCommandName = String.format("Replace <%1$s> with <%2$s>", wrongTag, rightTag);
        this.myFile = file2;
        this.myWrongTag = wrongTag;
        this.myRightTag = rightTag;
    }

    @Override
    public void run() {
        WriteCommandAction.writeCommandAction((Project)this.myFile.getProject(), (PsiFile[])new PsiFile[]{this.myFile}).withName(this.myCommandName).run(() -> {
            Collection xmlTags = PsiTreeUtil.findChildrenOfType((PsiElement)this.myFile, XmlTag.class);
            if (!xmlTags.isEmpty()) {
                ArrayList matching = Lists.newArrayListWithExpectedSize((int)xmlTags.size());
                for (XmlTag tag : xmlTags) {
                    if (!tag.getName().equals(this.myWrongTag)) continue;
                    matching.add(tag);
                }
                if (!matching.isEmpty()) {
                    for (XmlTag tag : matching) {
                        tag.setName(this.myRightTag);
                    }
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "wrongTag";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "rightTag";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/rendering/ReplaceTagFix";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

