/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.SdkConstants;
import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.ide.common.rendering.api.AssetRepository;
import com.android.ide.common.rendering.api.DrawableParams;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.IImageFactory;
import com.android.ide.common.rendering.api.ILayoutLog;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.ide.common.util.PathString;
import com.android.resources.LayoutDirection;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.tools.analytics.crash.CrashReport;
import com.android.tools.analytics.crash.CrashReporter;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.diagnostics.crash.StudioExceptionReport;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.layoutlib.RenderParamsFlags;
import com.android.tools.idea.model.ActivityAttributesSnapshot;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.rendering.ActionBarHandler;
import com.android.tools.idea.rendering.CachingImageFactory;
import com.android.tools.idea.rendering.IRenderLogger;
import com.android.tools.idea.rendering.IncludeReference;
import com.android.tools.idea.rendering.LayoutlibCallbackImpl;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.rendering.RenderAsyncActionExecutor;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderProblem;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderSecurityManager;
import com.android.tools.idea.rendering.RenderSecurityManagerFactory;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTaskAllocationTrackerKt;
import com.android.tools.idea.rendering.RenderTaskContext;
import com.android.tools.idea.rendering.StackTraceCapture;
import com.android.tools.idea.rendering.imagepool.ImagePool;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.tools.idea.rendering.parsers.ILayoutPullParserFactory;
import com.android.tools.idea.rendering.parsers.LayoutFilePullParser;
import com.android.tools.idea.rendering.parsers.LayoutPsiPullParser;
import com.android.tools.idea.rendering.parsers.LayoutPullParsers;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.android.tools.idea.res.AssetRepositoryImpl;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceIdManager;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.android.utils.SdkUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.ModuleClassLoader;
import org.jetbrains.android.uipreview.ModuleClassLoaderManager;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassVisitor;

public class RenderTask {
    private static final Logger LOG = Logger.getInstance(RenderTask.class);
    private static final int MIN_BITMAP_SIZE_PX = 1;
    private static final IImageFactory SIMPLE_IMAGE_FACTORY = new IImageFactory(){

        @NotNull
        public BufferedImage getImage(int width, int height) {
            BufferedImage image = new BufferedImage(Math.max(1, width), Math.max(1, height), 2);
            image.setAccelerationPriority(1.0f);
            BufferedImage bufferedImage = image;
            if (bufferedImage == null) {
                1.$$$reportNull$$$0(0);
            }
            return bufferedImage;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderTask$1", "getImage"));
        }
    };
    private static final float MIN_DOWNSCALING_FACTOR = 0.5f;
    private static final int DOWNSCALED_IMAGE_MAX_BYTES = 2500000;
    @VisibleForTesting
    static final ExecutorService ourDisposeService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"RenderTask Dispose Thread", (int)1);
    public static final String GAP_WORKER_CLASS_NAME = "androidx.recyclerview.widget.GapWorker";
    @NotNull
    private final ImagePool myImagePool;
    @NotNull
    private final RenderTaskContext myContext;
    @NotNull
    private final RenderLogger myLogger;
    @NotNull
    private final LayoutlibCallbackImpl myLayoutlibCallback;
    @NotNull
    private final LayoutLibrary myLayoutLib;
    @NotNull
    private final HardwareConfigHelper myHardwareConfigHelper;
    private final float myDefaultQuality;
    @Nullable
    private IncludeReference myIncludedWithin;
    @NotNull
    private SessionParams.RenderingMode myRenderingMode;
    private boolean mySetTransparentBackground;
    private boolean myShowDecorations;
    private boolean myShadowEnabled;
    private boolean myHighQualityShadow;
    private boolean myEnableLayoutScanner;
    private boolean myShowWithToolsVisibilityAndPosition;
    private AssetRepositoryImpl myAssetRepository;
    private long myTimeout;
    @NotNull
    private final Locale myLocale;
    @NotNull
    private final Object myCredential;
    private boolean myProvideCookiesForIncludedViews;
    @Nullable
    private RenderSession myRenderSession;
    @NotNull
    private IImageFactory myCachingImageFactory;
    @Nullable
    private IImageFactory myImageFactoryDelegate;
    private final boolean isSecurityManagerEnabled;
    @NotNull
    private CrashReporter myCrashReporter;
    private final List<CompletableFuture<?>> myRunningFutures;
    @NotNull
    private final AtomicBoolean isDisposed;
    @Nullable
    private XmlFile myXmlFile;
    @NotNull
    private final Function<Module, MergedManifestSnapshot> myManifestProvider;
    @NotNull
    private final ModuleClassLoader myModuleClassLoader;

    RenderTask(@NotNull AndroidFacet facet2, @NotNull RenderService renderService, @NotNull Configuration configuration, @NotNull RenderLogger logger2, @NotNull LayoutLibrary layoutLib, @NotNull Device device, @NotNull Object credential, @NotNull CrashReporter crashReporter, @NotNull ImagePool imagePool, @Nullable ILayoutPullParserFactory parserFactory, boolean isSecurityManagerEnabled, float quality, @NotNull StackTraceCapture stackTraceCaptureElement, @NotNull Function<Module, MergedManifestSnapshot> manifestProvider, boolean privateClassLoader, @NotNull Function<ClassVisitor, ClassVisitor> additionalProjectTransform, @NotNull Function<ClassVisitor, ClassVisitor> additionalNonProjectTransform) {
        if (facet2 == null) {
            RenderTask.$$$reportNull$$$0(0);
        }
        if (renderService == null) {
            RenderTask.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            RenderTask.$$$reportNull$$$0(2);
        }
        if (logger2 == null) {
            RenderTask.$$$reportNull$$$0(3);
        }
        if (layoutLib == null) {
            RenderTask.$$$reportNull$$$0(4);
        }
        if (device == null) {
            RenderTask.$$$reportNull$$$0(5);
        }
        if (credential == null) {
            RenderTask.$$$reportNull$$$0(6);
        }
        if (crashReporter == null) {
            RenderTask.$$$reportNull$$$0(7);
        }
        if (imagePool == null) {
            RenderTask.$$$reportNull$$$0(8);
        }
        if (stackTraceCaptureElement == null) {
            RenderTask.$$$reportNull$$$0(9);
        }
        if (manifestProvider == null) {
            RenderTask.$$$reportNull$$$0(10);
        }
        if (additionalProjectTransform == null) {
            RenderTask.$$$reportNull$$$0(11);
        }
        if (additionalNonProjectTransform == null) {
            RenderTask.$$$reportNull$$$0(12);
        }
        this.myRenderingMode = SessionParams.RenderingMode.NORMAL;
        this.mySetTransparentBackground = false;
        this.myShowDecorations = true;
        this.myShadowEnabled = true;
        this.myHighQualityShadow = true;
        this.myEnableLayoutScanner = false;
        this.myShowWithToolsVisibilityAndPosition = true;
        this.myProvideCookiesForIncludedViews = false;
        this.myCachingImageFactory = SIMPLE_IMAGE_FACTORY;
        this.myRunningFutures = new LinkedList();
        this.isDisposed = new AtomicBoolean(false);
        this.isSecurityManagerEnabled = isSecurityManagerEnabled;
        if (!isSecurityManagerEnabled) {
            LOG.debug("Security manager was disabled");
        }
        this.myLogger = logger2;
        this.myCredential = credential;
        this.myCrashReporter = crashReporter;
        this.myImagePool = imagePool;
        this.myAssetRepository = new AssetRepositoryImpl(facet2);
        this.myHardwareConfigHelper = new HardwareConfigHelper(device);
        ScreenOrientation orientation = configuration.getFullConfig().getScreenOrientationQualifier() != null ? configuration.getFullConfig().getScreenOrientationQualifier().getValue() : ScreenOrientation.PORTRAIT;
        this.myHardwareConfigHelper.setOrientation(orientation);
        this.myLayoutLib = layoutLib;
        LocalResourceRepository appResources = ResourceRepositoryManager.getAppResources(facet2);
        ActionBarHandler actionBarHandler = new ActionBarHandler(this, this.myCredential);
        Module module2 = facet2.getModule();
        ModuleClassLoaderManager manager = ModuleClassLoaderManager.get();
        this.myModuleClassLoader = privateClassLoader ? manager.getPrivate(this.myLayoutLib.getClassLoader(), module2, this, additionalProjectTransform, additionalNonProjectTransform) : manager.getShared(this.myLayoutLib.getClassLoader(), module2, this);
        try {
            this.myLayoutlibCallback = new LayoutlibCallbackImpl(this, this.myLayoutLib, appResources, module2, facet2, this.myLogger, this.myCredential, actionBarHandler, parserFactory, this.myModuleClassLoader);
            if (ResourceIdManager.get(module2).finalIdsUsed()) {
                this.myLayoutlibCallback.loadAndParseRClass();
            }
            AndroidModuleInfo moduleInfo = AndroidModuleInfo.getInstance(facet2);
            this.myLocale = configuration.getLocale();
            this.myContext = new RenderTaskContext(module2.getProject(), module2, configuration, moduleInfo, renderService.getPlatform(facet2));
            this.myDefaultQuality = quality;
            this.restoreDefaultQuality();
            this.myManifestProvider = manifestProvider;
            stackTraceCaptureElement.bind(this);
        }
        catch (Exception ex) {
            this.clearClassLoader();
            throw ex;
        }
    }

    public void setQuality(float quality) {
        if (quality >= 1.0f) {
            this.myCachingImageFactory = SIMPLE_IMAGE_FACTORY;
            return;
        }
        float actualSamplingFactor = 0.5f + Math.max(Math.min(quality, 1.0f), 0.0f) * 0.5f;
        long maxSize = (long)(2500000.0f * actualSamplingFactor);
        this.myCachingImageFactory = new CachingImageFactory((width, height) -> {
            int downscaleWidth = width;
            int downscaleHeight = height;
            int size = width * height;
            if ((long)size > maxSize) {
                double scale = (double)maxSize / (double)size;
                downscaleWidth = (int)((double)downscaleWidth * scale);
                downscaleHeight = (int)((double)downscaleHeight * scale);
            }
            return SIMPLE_IMAGE_FACTORY.getImage(downscaleWidth, downscaleHeight);
        });
    }

    public void restoreDefaultQuality() {
        this.setQuality(this.myDefaultQuality);
    }

    public void setXmlFile(@NotNull XmlFile file2) {
        if (file2 == null) {
            RenderTask.$$$reportNull$$$0(13);
        }
        this.myXmlFile = file2;
        ReadAction.run(() -> this.getContext().setFolderType(IdeResourcesUtil.getFolderType((PsiFile)file2)));
    }

    @Nullable
    public XmlFile getXmlFile() {
        return this.myXmlFile;
    }

    @NotNull
    public IRenderLogger getLogger() {
        RenderLogger renderLogger = this.myLogger;
        if (renderLogger == null) {
            RenderTask.$$$reportNull$$$0(14);
        }
        return renderLogger;
    }

    @NotNull
    public HardwareConfigHelper getHardwareConfigHelper() {
        HardwareConfigHelper hardwareConfigHelper = this.myHardwareConfigHelper;
        if (hardwareConfigHelper == null) {
            RenderTask.$$$reportNull$$$0(15);
        }
        return hardwareConfigHelper;
    }

    public boolean getShowDecorations() {
        return this.myShowDecorations;
    }

    public boolean getShowWithToolsVisibilityAndPosition() {
        return this.myShowWithToolsVisibilityAndPosition;
    }

    public boolean isDisposed() {
        return this.isDisposed.get();
    }

    private void clearGapWorkerCache() {
        if (!this.myLayoutlibCallback.hasLoadedClass(SdkConstants.RECYCLER_VIEW.newName()) && !this.myLayoutlibCallback.hasLoadedClass(SdkConstants.RECYCLER_VIEW.oldName())) {
            return;
        }
        try {
            Class<?> gapWorkerClass = this.myLayoutlibCallback.findClass(GAP_WORKER_CLASS_NAME);
            Field gapWorkerField = gapWorkerClass.getDeclaredField("sGapWorker");
            gapWorkerField.setAccessible(true);
            RenderService.getRenderAsyncActionExecutor().runAsyncAction(() -> {
                try {
                    ThreadLocal gapWorkerFieldValue = (ThreadLocal)gapWorkerField.get(null);
                    gapWorkerFieldValue.set(null);
                    LOG.debug("GapWorker was cleared");
                }
                catch (IllegalAccessException e) {
                    LOG.debug((Throwable)e);
                }
            });
        }
        catch (Throwable t) {
            LOG.debug(t);
        }
    }

    private void clearComposeTables() {
        if (!this.myLayoutlibCallback.hasLoadedClass("androidx.ui.tooling.preview.ComposeViewAdapter")) {
            return;
        }
        try {
            Class<?> inspectableKt = this.myLayoutlibCallback.findClass("androidx.ui.tooling.InspectableKt");
            Field tablesField = inspectableKt.getDeclaredField("tables");
            tablesField.setAccessible(true);
            Set tables = (Set)tablesField.get(null);
            tables.clear();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void clearClassLoader() {
        try {
            ModuleClassLoaderManager.get().release(this.myModuleClassLoader, this);
        }
        catch (Throwable t) {
            LOG.warn(t);
        }
    }

    public Future<?> dispose() {
        if (this.isDisposed.getAndSet(true)) {
            assert (false) : "RenderTask was already disposed";
            return Futures.immediateFailedFuture((Throwable)new IllegalStateException("RenderTask was already disposed"));
        }
        RenderTaskAllocationTrackerKt.captureDisposeStackTrace().bind(this);
        return ourDisposeService.submit(() -> {
            try {
                CompletableFuture[] currentRunningFutures;
                List<CompletableFuture<?>> list = this.myRunningFutures;
                synchronized (list) {
                    currentRunningFutures = this.myRunningFutures.toArray(new CompletableFuture[0]);
                    this.myRunningFutures.clear();
                }
                CompletableFuture.allOf(currentRunningFutures).get(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.debug((Throwable)e);
            }
            this.myLayoutlibCallback.setLogger(IRenderLogger.NULL_LOGGER);
            if (this.myRenderSession != null) {
                try {
                    this.disposeRenderSession(this.myRenderSession);
                    this.myRenderSession = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.myImageFactoryDelegate = null;
            this.myAssetRepository = null;
            this.clearClassLoader();
            return null;
        });
    }

    @NotNull
    public RenderTask setOverrideRenderSize(int overrideRenderWidth, int overrideRenderHeight) {
        this.myHardwareConfigHelper.setOverrideRenderSize(overrideRenderWidth, overrideRenderHeight);
        RenderTask renderTask = this;
        if (renderTask == null) {
            RenderTask.$$$reportNull$$$0(16);
        }
        return renderTask;
    }

    @NotNull
    public RenderTask setMaxRenderSize(int maxRenderWidth, int maxRenderHeight) {
        this.myHardwareConfigHelper.setMaxRenderSize(maxRenderWidth, maxRenderHeight);
        RenderTask renderTask = this;
        if (renderTask == null) {
            RenderTask.$$$reportNull$$$0(17);
        }
        return renderTask;
    }

    @NotNull
    public RenderTask setRenderingMode(@NotNull SessionParams.RenderingMode renderingMode) {
        if (renderingMode == null) {
            RenderTask.$$$reportNull$$$0(18);
        }
        this.myRenderingMode = renderingMode;
        RenderTask renderTask = this;
        if (renderTask == null) {
            RenderTask.$$$reportNull$$$0(19);
        }
        return renderTask;
    }

    @NotNull
    public RenderTask setTimeout(long timeout) {
        this.myTimeout = timeout;
        RenderTask renderTask = this;
        if (renderTask == null) {
            RenderTask.$$$reportNull$$$0(20);
        }
        return renderTask;
    }

    @NotNull
    public RenderTask setTransparentBackground() {
        this.mySetTransparentBackground = true;
        RenderTask renderTask = this;
        if (renderTask == null) {
            RenderTask.$$$reportNull$$$0(21);
        }
        return renderTask;
    }

    @NotNull
    public RenderTask setDecorations(boolean showDecorations) {
        this.myShowDecorations = showDecorations;
        RenderTask renderTask = this;
        if (renderTask == null) {
            RenderTask.$$$reportNull$$$0(22);
        }
        return renderTask;
    }

    public RenderTask setShadowEnabled(boolean shadowEnabled) {
        this.myShadowEnabled = shadowEnabled;
        return this;
    }

    public RenderTask setHighQualityShadows(boolean highQualityShadows) {
        this.myHighQualityShadow = highQualityShadows;
        return this;
    }

    public RenderTask setEnableLayoutScanner(boolean enableLayoutScanner) {
        this.myEnableLayoutScanner = enableLayoutScanner;
        return this;
    }

    @NotNull
    public RenderTask setShowWithToolsVisibilityAndPosition(boolean showWithToolsVisibilityAndPosition) {
        this.myShowWithToolsVisibilityAndPosition = showWithToolsVisibilityAndPosition;
        RenderTask renderTask = this;
        if (renderTask == null) {
            RenderTask.$$$reportNull$$$0(23);
        }
        return renderTask;
    }

    public boolean getProvideCookiesForIncludedViews() {
        return this.myProvideCookiesForIncludedViews;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private RenderResult createRenderSession(@NotNull IImageFactory factory2) {
        RenderSecurityManager securityManager;
        IAndroidTarget target;
        ILayoutPullParser includingParser;
        RenderTaskContext context;
        Module module2;
        if (factory2 == null) {
            RenderTask.$$$reportNull$$$0(24);
        }
        if ((module2 = (context = this.getContext()).getModule()).isDisposed()) {
            return null;
        }
        XmlFile psiFile2 = this.getXmlFile();
        if (psiFile2 == null) {
            throw new IllegalStateException("createRenderSession shouldn't be called on RenderTask without PsiFile");
        }
        if (this.isDisposed.get()) {
            return null;
        }
        Configuration configuration = context.getConfiguration();
        ResourceResolver resolver = ResourceResolver.copy((ResourceResolver)configuration.getResourceResolver());
        if (resolver == null) {
            return null;
        }
        ILayoutPullParser modelParser = LayoutPullParsers.create(this);
        if (modelParser == null) {
            return null;
        }
        this.myLayoutlibCallback.reset();
        if (modelParser instanceof LayoutPsiPullParser) {
            boolean useSrcCompat = DependencyManagementUtil.dependsOn(module2, GoogleMavenArtifactId.APP_COMPAT_V7) || DependencyManagementUtil.dependsOn(module2, GoogleMavenArtifactId.ANDROIDX_APP_COMPAT_V7);
            ((LayoutPsiPullParser)modelParser).setUseSrcCompat(useSrcCompat);
            this.myLayoutlibCallback.setAaptDeclaredResources((Map<String, TagSnapshot>)((LayoutPsiPullParser)modelParser).getAaptDeclaredAttrs());
        }
        if ((includingParser = this.getIncludingLayoutParser((RenderResources)resolver, modelParser)) != null) {
            modelParser = includingParser;
        }
        int simulatedPlatform = (target = configuration.getTarget()) instanceof CompatibilityRenderTarget ? target.getVersion().getApiLevel() : 0;
        HardwareConfig hardwareConfig = this.myHardwareConfigHelper.getConfig();
        SessionParams params = new SessionParams(modelParser, this.myRenderingMode, (Object)module2, hardwareConfig, (RenderResources)resolver, (LayoutlibCallback)this.myLayoutlibCallback, context.getMinSdkVersion().getApiLevel(), context.getTargetSdkVersion().getApiLevel(), (ILayoutLog)this.myLogger, simulatedPlatform);
        params.setAssetRepository((AssetRepository)this.myAssetRepository);
        params.setFlag(RenderParamsFlags.FLAG_KEY_ROOT_TAG, (Object)AndroidUtils.getRootTagName((PsiFile)psiFile2));
        params.setFlag(RenderParamsFlags.FLAG_KEY_RECYCLER_VIEW_SUPPORT, (Object)true);
        params.setFlag(RenderParamsFlags.FLAG_KEY_DISABLE_BITMAP_CACHING, (Object)true);
        params.setFlag(RenderParamsFlags.FLAG_DO_NOT_RENDER_ON_CREATE, (Object)true);
        params.setFlag(RenderParamsFlags.FLAG_KEY_RESULT_IMAGE_AUTO_SCALE, (Object)true);
        params.setFlag(RenderParamsFlags.FLAG_KEY_ENABLE_SHADOW, (Object)this.myShadowEnabled);
        params.setFlag(RenderParamsFlags.FLAG_KEY_RENDER_HIGH_QUALITY_SHADOW, (Object)this.myHighQualityShadow);
        params.setFlag(RenderParamsFlags.FLAG_KEY_ENABLE_LAYOUT_SCANNER, (Object)this.myEnableLayoutScanner);
        params.setFlag(RenderParamsFlags.FLAG_ENABLE_LAYOUT_SCANNER_IMAGE_CHECK, (Object)this.myEnableLayoutScanner);
        params.setExtendedViewInfoMode(true);
        LayoutDirectionQualifier qualifier = configuration.getFullConfig().getLayoutDirectionQualifier();
        if (qualifier != null && qualifier.getValue() == LayoutDirection.RTL && !this.getLayoutLib().isRtl(this.myLocale.toLocaleId())) {
            params.setLocale("ur");
        } else {
            params.setLocale(this.myLocale.toLocaleId());
        }
        try {
            @Nullable MergedManifestSnapshot manifestInfo = this.myManifestProvider.apply(module2);
            params.setRtlSupport(manifestInfo != null && manifestInfo.isRtlSupported());
        }
        catch (Exception manifestInfo) {
            // empty catch block
        }
        Device device = configuration.getDevice();
        if (!this.myShowDecorations || HardwareConfigHelper.isWear((Device)device)) {
            params.setForceNoDecor();
        } else {
            try {
                ResourceValue resource;
                String activity;
                ResourceValue appLabel;
                @Nullable MergedManifestSnapshot manifestInfo = this.myManifestProvider.apply(module2);
                Object object = appLabel = manifestInfo != null ? manifestInfo.getApplicationLabel() : new ResourceValueImpl(ResourceNamespace.RES_AUTO, ResourceType.STRING, "appName", "");
                if (manifestInfo != null) {
                    params.setAppIcon(manifestInfo.getApplicationIcon());
                }
                if ((activity = configuration.getActivity()) != null) {
                    ActivityAttributesSnapshot attributes;
                    params.setActivityName(activity);
                    ActivityAttributesSnapshot activityAttributesSnapshot = attributes = manifestInfo != null ? manifestInfo.getActivityAttributes(activity) : null;
                    if (attributes != null) {
                        if (attributes.getLabel() != null) {
                            appLabel = attributes.getLabel();
                        }
                        if (attributes.getIcon() != null) {
                            params.setAppIcon(attributes.getIcon());
                        }
                    }
                }
                if ((resource = params.getResources().resolveResValue(appLabel)) != null) {
                    params.setAppLabel(resource.getValue());
                }
            }
            catch (Exception manifestInfo) {
                // empty catch block
            }
        }
        if (this.mySetTransparentBackground || this.requiresTransparency()) {
            params.setTransparentBackground();
        }
        params.setImageFactory(factory2);
        if (this.myTimeout > 0L) {
            params.setTimeout(this.myTimeout);
        }
        params.setFontScale(configuration.getFontScale());
        params.setUiMode(configuration.getUiModeFlagValue());
        this.myLayoutlibCallback.setLogger(this.myLogger);
        RenderSecurityManager renderSecurityManager = securityManager = this.isSecurityManagerEnabled ? RenderSecurityManagerFactory.create(module2, context.getPlatform()) : null;
        if (securityManager != null) {
            securityManager.setActive(true, this.myCredential);
        }
        try {
            RenderSession session = this.myLayoutLib.createSession(params);
            if (session.getResult().isSuccess()) {
                session.setSystemBootTimeNanos(0L);
                session.setSystemTimeNanos(0L);
                session.setElapsedFrameTimeNanos(TimeUnit.MILLISECONDS.toNanos(500L));
            }
            RenderResult result2 = RenderResult.create(this, session, (PsiFile)psiFile2, this.myLogger, this.myImagePool.copyOf(session.getImage()));
            RenderSession oldRenderSession = this.myRenderSession;
            this.myRenderSession = session;
            if (oldRenderSession != null) {
                this.disposeRenderSession(oldRenderSession);
            }
            this.addDiagnostics(result2.getRenderResult());
            RenderResult renderResult = result2;
            if (securityManager != null) {
                securityManager.dispose(this.myCredential);
            }
            return renderResult;
        }
        catch (Throwable throwable) {
            try {
                if (securityManager != null) {
                    securityManager.dispose(this.myCredential);
                }
                throw throwable;
            }
            catch (RuntimeException t) {
                this.myLogger.error(null, t.getLocalizedMessage(), t, null, null);
                throw t;
            }
        }
    }

    @Nullable
    private ILayoutPullParser getIncludingLayoutParser(RenderResources resolver, ILayoutPullParser modelParser) {
        XmlFile xmlFile = this.getXmlFile();
        if (xmlFile == null) {
            throw new IllegalStateException("getIncludingLayoutParser shouldn't be called on RenderTask without PsiFile");
        }
        if (!this.myShowWithToolsVisibilityAndPosition) {
            return null;
        }
        if (this.myIncludedWithin == null) {
            String layout2 = IncludeReference.getIncludingLayout(xmlFile);
            Module module2 = this.getContext().getModule();
            this.myIncludedWithin = layout2 != null ? IncludeReference.get(module2, xmlFile, resolver) : IncludeReference.NONE;
        }
        ILayoutPullParser topParser = null;
        if (this.myIncludedWithin != IncludeReference.NONE) {
            assert (Objects.equals(this.myIncludedWithin.getToFile(), xmlFile.getVirtualFile()));
            VirtualFile layoutVirtualFile = this.myIncludedWithin.getFromFile();
            String queryLayoutName = SdkUtils.fileNameToResourceName((String)xmlFile.getName());
            this.myLayoutlibCallback.setLayoutParser(queryLayoutName, modelParser);
            PsiFile psiFile2 = AndroidPsiUtils.getPsiFileSafely((Project)this.getContext().getProject(), (VirtualFile)layoutVirtualFile);
            if (psiFile2 instanceof XmlFile) {
                LayoutPsiPullParser parser = LayoutPsiPullParser.create((XmlFile)psiFile2, this.myLogger);
                parser.setProvideViewCookies(this.myProvideCookiesForIncludedViews);
                topParser = parser;
            } else {
                topParser = LayoutFilePullParser.create(new PathString(this.myIncludedWithin.getFromPath()), ResourceNamespace.TODO());
                if (topParser == null) {
                    this.myLogger.error(null, String.format("Could not read layout file %1$s", this.myIncludedWithin.getFromPath()), null, null, null);
                }
            }
        }
        return topParser;
    }

    private static <T> CompletableFuture<T> immediateFailedFuture(Throwable exception) {
        CompletableFuture future2 = new CompletableFuture();
        future2.completeExceptionally(exception);
        return future2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    @NotNull
    private <V> CompletableFuture<V> runAsyncRenderAction(@NotNull Callable<V> callable, long timeout, @NotNull TimeUnit timeUnit) {
        void unit;
        if (callable == null) {
            RenderTask.$$$reportNull$$$0(25);
        }
        if (timeUnit == null) {
            RenderTask.$$$reportNull$$$0(26);
        }
        if (this.isDisposed.get()) {
            CompletableFuture completableFuture = RenderTask.immediateFailedFuture(new IllegalStateException("RenderTask was already disposed"));
            if (completableFuture != null) return completableFuture;
            RenderTask.$$$reportNull$$$0(27);
            return completableFuture;
        }
        List<CompletableFuture<?>> list = this.myRunningFutures;
        // MONITORENTER : list
        CompletableFuture<V> newFuture = timeout < 1L ? RenderService.getRenderAsyncActionExecutor().runAsyncAction(callable) : RenderService.getRenderAsyncActionExecutor().runAsyncActionWithTimeout(timeout, (TimeUnit)unit, callable);
        this.myRunningFutures.add(newFuture);
        newFuture.whenCompleteAsync((result2, ex) -> {
            List<CompletableFuture<?>> list = this.myRunningFutures;
            synchronized (list) {
                this.myRunningFutures.remove(newFuture);
            }
        });
        CompletableFuture<V> completableFuture = newFuture;
        // MONITOREXIT : list
        if (completableFuture != null) return completableFuture;
        RenderTask.$$$reportNull$$$0(28);
        return completableFuture;
    }

    @VisibleForTesting
    @NotNull
    <V> CompletableFuture<V> runAsyncRenderAction(@NotNull Callable<V> callable) {
        if (callable == null) {
            RenderTask.$$$reportNull$$$0(29);
        }
        return this.runAsyncRenderAction(callable, 0L, TimeUnit.SECONDS);
    }

    @NotNull
    public CompletableFuture<RenderResult> inflate() {
        XmlFile xmlFile = this.getXmlFile();
        if (xmlFile == null) {
            CompletableFuture<RenderResult> completableFuture = RenderTask.immediateFailedFuture(new IllegalStateException("inflate shouldn't be called on RenderTask without PsiFile"));
            if (completableFuture == null) {
                RenderTask.$$$reportNull$$$0(30);
            }
            return completableFuture;
        }
        if (xmlFile.getProject().isDisposed()) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                RenderTask.$$$reportNull$$$0(31);
            }
            return completableFuture;
        }
        CompletionStage completionStage = this.runAsyncRenderAction(() -> this.createRenderSession((width, height) -> {
            if (this.myImageFactoryDelegate != null) {
                return this.myImageFactoryDelegate.getImage(width, height);
            }
            return new BufferedImage(width, height, 2);
        }), RenderAsyncActionExecutor.DEFAULT_RENDER_THREAD_TIMEOUT_MS * 10L, TimeUnit.MILLISECONDS).whenComplete((result2, ex) -> {
            if (ex != null) {
                String message2 = ex.getMessage();
                if (message2 == null) {
                    message2 = ex.toString();
                }
                this.myLogger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, message2, this.myLogger.getProject(), this.myLogger.getLinkManager(), ex));
            }
        });
        if (completionStage == null) {
            RenderTask.$$$reportNull$$$0(32);
        }
        return completionStage;
    }

    @NotNull
    public CompletableFuture<RenderResult> layout() {
        CompletableFuture<RenderResult> completableFuture;
        if (this.myRenderSession == null) {
            CompletableFuture<Object> completableFuture2 = CompletableFuture.completedFuture(null);
            if (completableFuture2 == null) {
                RenderTask.$$$reportNull$$$0(33);
            }
            return completableFuture2;
        }
        assert (this.getXmlFile() != null);
        try {
            RenderSession renderSession = this.myRenderSession;
            XmlFile psiFile2 = this.getXmlFile();
            completableFuture = this.runAsyncRenderAction(() -> this.lambda$layout$8(renderSession, (PsiFile)psiFile2));
        }
        catch (Exception exception) {
            CompletableFuture<Object> completableFuture3 = CompletableFuture.completedFuture(null);
            if (completableFuture3 == null) {
                RenderTask.$$$reportNull$$$0(35);
            }
            return completableFuture3;
        }
        if (completableFuture == null) {
            RenderTask.$$$reportNull$$$0(34);
        }
        return completableFuture;
    }

    @NotNull
    public CompletableFuture<Boolean> executeCallbacks(long timeNanos) {
        if (this.myRenderSession == null) {
            CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(false);
            if (completableFuture == null) {
                RenderTask.$$$reportNull$$$0(36);
            }
            return completableFuture;
        }
        return this.runAsyncRenderAction(() -> {
            this.myRenderSession.setSystemTimeNanos(timeNanos);
            return this.myRenderSession.executeCallbacks(timeNanos);
        }, 500L, TimeUnit.MILLISECONDS);
    }

    @NotNull
    public CompletableFuture<Void> triggerTouchEvent(@NotNull RenderSession.TouchEventType touchEventType, int x, int y, long timeNanos) {
        if (touchEventType == null) {
            RenderTask.$$$reportNull$$$0(37);
        }
        if (this.myRenderSession == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                RenderTask.$$$reportNull$$$0(38);
            }
            return completableFuture;
        }
        CompletableFuture<Void> completableFuture = this.runAsyncRenderAction(() -> {
            this.myRenderSession.setSystemTimeNanos(timeNanos);
            this.myRenderSession.triggerTouchEvent(touchEventType, x, y);
            return null;
        });
        if (completableFuture == null) {
            RenderTask.$$$reportNull$$$0(39);
        }
        return completableFuture;
    }

    private void reportException(@NotNull Throwable e) {
        if (e == null) {
            RenderTask.$$$reportNull$$$0(40);
        }
        this.myCrashReporter.submit((CrashReport)new StudioExceptionReport.Builder().setThrowable(e, false).build());
    }

    @NotNull
    private CompletableFuture<RenderResult> renderInner() {
        XmlFile psiFile2 = this.getXmlFile();
        assert (psiFile2 != null);
        CompletionStage<Object> inflateCompletableResult = this.myRenderSession == null ? this.inflate().whenComplete((renderResult, exception) -> {
            Result result2;
            Result result3 = result2 = renderResult != null ? renderResult.getRenderResult() : null;
            if (result2 == null || !result2.isSuccess()) {
                Throwable e;
                Throwable throwable = e = result2 != null ? result2.getException() : exception;
                if (e != null) {
                    this.reportException(e);
                }
                if (result2 != null) {
                    this.myLogger.error(null, result2.getErrorMessage(), e, null, null);
                }
            }
        }) : CompletableFuture.completedFuture(null);
        CompletionStage completionStage = inflateCompletableResult.thenCompose(arg_0 -> this.lambda$renderInner$14((PsiFile)psiFile2, arg_0));
        if (completionStage == null) {
            RenderTask.$$$reportNull$$$0(41);
        }
        return completionStage;
    }

    @NotNull
    CompletableFuture<RenderResult> render(@NotNull IImageFactory factory2) {
        if (factory2 == null) {
            RenderTask.$$$reportNull$$$0(42);
        }
        this.myImageFactoryDelegate = factory2;
        return this.renderInner();
    }

    @NotNull
    public CompletableFuture<RenderResult> render() {
        CompletableFuture<RenderResult> completableFuture = this.render(this.myCachingImageFactory);
        if (completableFuture == null) {
            RenderTask.$$$reportNull$$$0(43);
        }
        return completableFuture;
    }

    public void setElapsedFrameTimeNanos(long nanos) {
        if (this.myRenderSession != null) {
            this.myRenderSession.setElapsedFrameTimeNanos(nanos);
        }
    }

    private void addDiagnostics(@NotNull Result result2) {
        ILayoutPullParser layoutEmbeddedParser;
        if (result2 == null) {
            RenderTask.$$$reportNull$$$0(44);
        }
        if (!this.myLogger.hasProblems() && !result2.isSuccess()) {
            if (result2.getException() != null || result2.getErrorMessage() != null) {
                this.myLogger.error(null, result2.getErrorMessage(), result2.getException(), null, null);
            } else if (result2.getStatus() == Result.Status.ERROR_TIMEOUT) {
                this.myLogger.error(null, "Rendering timed out.", null, null, null);
            } else {
                this.myLogger.error(null, "Unknown render problem: " + result2.getStatus(), null, null, null);
            }
        } else if (this.myIncludedWithin != null && this.myIncludedWithin != IncludeReference.NONE && (layoutEmbeddedParser = this.myLayoutlibCallback.getLayoutEmbeddedParser()) != null) {
            this.myLogger.error(null, String.format("The surrounding layout (%1$s) did not actually include this layout. Remove tools:showIn=... from the root tag.", this.myIncludedWithin.getFromResourceUrl()), null, null, null);
        }
    }

    @NotNull
    public CompletableFuture<BufferedImage> renderDrawable(@NotNull ResourceValue drawableResourceValue) {
        if (drawableResourceValue == null) {
            RenderTask.$$$reportNull$$$0(45);
        }
        HardwareConfig hardwareConfig = this.myHardwareConfigHelper.getConfig();
        RenderTaskContext context = this.getContext();
        Module module2 = this.getContext().getModule();
        DrawableParams params = new DrawableParams(drawableResourceValue, (Object)module2, hardwareConfig, (RenderResources)context.getConfiguration().getResourceResolver(), (LayoutlibCallback)this.myLayoutlibCallback, context.getMinSdkVersion().getApiLevel(), context.getTargetSdkVersion().getApiLevel(), (ILayoutLog)this.myLogger);
        params.setForceNoDecor();
        params.setAssetRepository((AssetRepository)this.myAssetRepository);
        CompletionStage completionStage = this.runAsyncRenderAction(() -> this.myLayoutLib.renderDrawable(params)).thenCompose(result2 -> {
            Throwable exception;
            if (result2 != null && result2.isSuccess()) {
                Object data = result2.getData();
                if (!(data instanceof BufferedImage)) {
                    data = null;
                }
                return CompletableFuture.completedFuture((BufferedImage)data);
            }
            if (result2.getStatus() == Result.Status.ERROR_NOT_A_DRAWABLE) {
                LOG.debug("renderDrawable called with a non-drawable resource" + drawableResourceValue);
                return CompletableFuture.completedFuture(null);
            }
            Throwable throwable = exception = result2 == null ? new RuntimeException("Rendering failed - null result") : result2.getException();
            if (exception == null) {
                String message2 = result2.getErrorMessage();
                exception = new RuntimeException((String)(message2 == null ? "Rendering failed" : "Rendering failed - " + message2));
            }
            this.reportException(exception);
            return RenderTask.immediateFailedFuture(exception);
        });
        if (completionStage == null) {
            RenderTask.$$$reportNull$$$0(46);
        }
        return completionStage;
    }

    @NotNull
    public List<BufferedImage> renderDrawableAllStates(@Nullable ResourceValue drawableResourceValue) {
        block6: {
            List list;
            if (drawableResourceValue == null) {
                List<BufferedImage> list2 = Collections.emptyList();
                if (list2 == null) {
                    RenderTask.$$$reportNull$$$0(47);
                }
                return list2;
            }
            HardwareConfig hardwareConfig = this.myHardwareConfigHelper.getConfig();
            RenderTaskContext context = this.getContext();
            Module module2 = context.getModule();
            DrawableParams params = new DrawableParams(drawableResourceValue, (Object)module2, hardwareConfig, (RenderResources)context.getConfiguration().getResourceResolver(), (LayoutlibCallback)this.myLayoutlibCallback, context.getMinSdkVersion().getApiLevel(), context.getTargetSdkVersion().getApiLevel(), (ILayoutLog)this.myLogger);
            params.setForceNoDecor();
            params.setAssetRepository((AssetRepository)this.myAssetRepository);
            params.setFlag(RenderParamsFlags.FLAG_KEY_RENDER_ALL_DRAWABLE_STATES, (Object)Boolean.TRUE);
            try {
                Object data;
                Result result2 = RenderService.runRenderAction(() -> this.myLayoutLib.renderDrawable(params));
                if (result2 == null || !result2.isSuccess() || !((data = result2.getData()) instanceof List)) break block6;
                list = (List)data;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (list == null) {
                RenderTask.$$$reportNull$$$0(48);
            }
            return list;
        }
        List<BufferedImage> list = Collections.emptyList();
        if (list == null) {
            RenderTask.$$$reportNull$$$0(49);
        }
        return list;
    }

    @NotNull
    private LayoutLibrary getLayoutLib() {
        LayoutLibrary layoutLibrary = this.myLayoutLib;
        if (layoutLibrary == null) {
            RenderTask.$$$reportNull$$$0(50);
        }
        return layoutLibrary;
    }

    @NotNull
    public LayoutlibCallbackImpl getLayoutlibCallback() {
        LayoutlibCallbackImpl layoutlibCallbackImpl = this.myLayoutlibCallback;
        if (layoutlibCallbackImpl == null) {
            RenderTask.$$$reportNull$$$0(51);
        }
        return layoutlibCallbackImpl;
    }

    private boolean isNonRectangular() {
        ResourceFolderType folderType = this.getContext().getFolderType();
        return folderType == ResourceFolderType.DRAWABLE || folderType == ResourceFolderType.MIPMAP;
    }

    private boolean requiresTransparency() {
        return this.isNonRectangular();
    }

    @NotNull
    public CompletableFuture<Map<XmlTag, ViewInfo>> measureChildren(@NotNull XmlTag parent, @Nullable AttributeFilter filter2) {
        if (parent == null) {
            RenderTask.$$$reportNull$$$0(52);
        }
        LayoutPsiPullParser modelParser = LayoutPsiPullParser.create(filter2, parent, this.myLogger);
        HashMap map2 = new HashMap();
        CompletionStage completionStage = RenderService.getRenderAsyncActionExecutor().runAsyncAction(() -> this.measure(modelParser)).thenComposeAsync(session -> {
            if (session != null) {
                try {
                    Result result2 = session.getResult();
                    if (result2 != null && result2.isSuccess()) {
                        assert (session.getRootViews().size() == 1);
                        ViewInfo root2 = (ViewInfo)session.getRootViews().get(0);
                        List children = root2.getChildren();
                        for (ViewInfo info2 : children) {
                            XmlTag tag = RenderService.getXmlTag(info2);
                            if (tag == null) continue;
                            map2.put(tag, info2);
                        }
                    }
                    CompletableFuture<Map> completableFuture = CompletableFuture.completedFuture(map2);
                    return completableFuture;
                }
                finally {
                    this.disposeRenderSession((RenderSession)session);
                }
            }
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }, (Executor)AppExecutorUtil.getAppExecutorService());
        if (completionStage == null) {
            RenderTask.$$$reportNull$$$0(53);
        }
        return completionStage;
    }

    @NotNull
    public CompletableFuture<ViewInfo> measureChild(@NotNull XmlTag tag, @Nullable AttributeFilter filter2) {
        XmlTag parent;
        if (tag == null) {
            RenderTask.$$$reportNull$$$0(54);
        }
        if ((parent = tag.getParentTag()) == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                RenderTask.$$$reportNull$$$0(55);
            }
            return completableFuture;
        }
        CompletionStage completionStage = this.measureChildren(parent, filter2).thenApply(map2 -> {
            for (Map.Entry entry : map2.entrySet()) {
                if (entry.getKey() != tag) continue;
                return (ViewInfo)entry.getValue();
            }
            return null;
        });
        if (completionStage == null) {
            RenderTask.$$$reportNull$$$0(56);
        }
        return completionStage;
    }

    @Nullable
    private RenderSession measure(ILayoutPullParser parser) {
        RenderTaskContext context = this.getContext();
        ResourceResolver resolver = context.getConfiguration().getResourceResolver();
        this.myLayoutlibCallback.reset();
        HardwareConfig hardwareConfig = this.myHardwareConfigHelper.getConfig();
        Module module2 = this.getContext().getModule();
        SessionParams params = new SessionParams(parser, SessionParams.RenderingMode.NORMAL, (Object)module2, hardwareConfig, (RenderResources)resolver, (LayoutlibCallback)this.myLayoutlibCallback, context.getMinSdkVersion().getApiLevel(), context.getTargetSdkVersion().getApiLevel(), (ILayoutLog)this.myLogger);
        params.setLayoutOnly();
        params.setForceNoDecor();
        params.setExtendedViewInfoMode(true);
        params.setLocale(this.myLocale.toLocaleId());
        params.setAssetRepository((AssetRepository)this.myAssetRepository);
        params.setFlag(RenderParamsFlags.FLAG_KEY_RECYCLER_VIEW_SUPPORT, (Object)true);
        @Nullable MergedManifestSnapshot manifestInfo = this.myManifestProvider.apply(module2);
        params.setRtlSupport(manifestInfo != null && manifestInfo.isRtlSupported());
        try {
            this.myLayoutlibCallback.setLogger(this.myLogger);
            return this.myLayoutLib.createSession(params);
        }
        catch (RuntimeException t) {
            this.myLogger.error(null, t.getLocalizedMessage(), t, null, null);
            throw t;
        }
    }

    @VisibleForTesting
    void setCrashReporter(@NotNull CrashReporter crashReporter) {
        if (crashReporter == null) {
            RenderTask.$$$reportNull$$$0(57);
        }
        this.myCrashReporter = crashReporter;
    }

    @NotNull
    public RenderTaskContext getContext() {
        RenderTaskContext renderTaskContext = this.myContext;
        if (renderTaskContext == null) {
            RenderTask.$$$reportNull$$$0(58);
        }
        return renderTaskContext;
    }

    private void disposeRenderSession(@NotNull RenderSession renderSession) {
        if (renderSession == null) {
            RenderTask.$$$reportNull$$$0(59);
        }
        Optional<Method> disposeMethod = Optional.empty();
        try {
            if (this.myLayoutlibCallback.hasLoadedClass("androidx.ui.tooling.preview.ComposeViewAdapter")) {
                Class<?> composeViewAdapter = this.myLayoutlibCallback.findClass("androidx.ui.tooling.preview.ComposeViewAdapter");
                disposeMethod = Arrays.stream(composeViewAdapter.getMethods()).filter(m -> m.getName().contains("dispose")).findFirst();
            }
        }
        catch (ClassNotFoundException ex) {
            LOG.warn("androidx.ui.tooling.preview.ComposeViewAdapter class not found", (Throwable)ex);
        }
        disposeMethod.ifPresent(m -> m.setAccessible(true));
        Optional<Method> finalDisposeMethod = disposeMethod;
        RenderService.getRenderAsyncActionExecutor().runAsyncAction(() -> {
            finalDisposeMethod.ifPresent(m -> renderSession.execute(() -> renderSession.getRootViews().forEach(v -> RenderTask.disposeIfCompose(v, m))));
            renderSession.dispose();
        });
    }

    private static void disposeIfCompose(@NotNull ViewInfo viewInfo, @NotNull Method disposeMethod) {
        Object viewObject;
        if (viewInfo == null) {
            RenderTask.$$$reportNull$$$0(60);
        }
        if (disposeMethod == null) {
            RenderTask.$$$reportNull$$$0(61);
        }
        if ((viewObject = viewInfo.getViewObject()) == null || !viewObject.getClass().getName().equals("androidx.ui.tooling.preview.ComposeViewAdapter")) {
            return;
        }
        try {
            disposeMethod.invoke(viewObject, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            LOG.warn("Unexpected error while disposing compose view", (Throwable)ex);
        }
    }

    private /* synthetic */ CompletionStage lambda$renderInner$14(PsiFile psiFile2, RenderResult ignored) {
        try {
            return this.runAsyncRenderAction(() -> {
                this.myRenderSession.render();
                RenderResult result2 = RenderResult.create(this, this.myRenderSession, psiFile2, this.myLogger, this.myImagePool.copyOf(this.myRenderSession.getImage()));
                Result renderResult = result2.getRenderResult();
                if (renderResult.getException() != null) {
                    this.reportException(renderResult.getException());
                    this.myLogger.error(null, renderResult.getErrorMessage(), renderResult.getException(), null, null);
                }
                return result2;
            }).whenComplete((result2, ex) -> {
                this.clearComposeTables();
                this.clearGapWorkerCache();
            });
        }
        catch (Exception e) {
            this.reportException(e);
            String message2 = e.getMessage();
            if (message2 == null) {
                message2 = e.toString();
            }
            this.myLogger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, message2, this.myLogger.getProject(), this.myLogger.getLinkManager(), e));
            return CompletableFuture.completedFuture(RenderResult.createRenderTaskErrorResult(psiFile2, e));
        }
    }

    private /* synthetic */ RenderResult lambda$layout$8(RenderSession renderSession, PsiFile psiFile2) throws Exception {
        this.myRenderSession.measure();
        return RenderResult.create(this, renderSession, psiFile2, this.myLogger, ImagePool.NULL_POOLED_IMAGE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 55: 
            case 56: 
            case 58: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 55: 
            case 56: 
            case 58: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderService";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutLib";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credential";
                break;
            }
            case 7: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "crashReporter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imagePool";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackTraceCaptureElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manifestProvider";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalProjectTransform";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalNonProjectTransform";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 55: 
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/RenderTask";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderingMode";
                break;
            }
            case 24: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "touchEventType";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "drawableResourceValue";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderSession";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewInfo";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposeMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/RenderTask";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getHardwareConfigHelper";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "setOverrideRenderSize";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "setMaxRenderSize";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "setRenderingMode";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "setTimeout";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "setTransparentBackground";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "setDecorations";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "setShowWithToolsVisibilityAndPosition";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "runAsyncRenderAction";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "inflate";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "layout";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "executeCallbacks";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "triggerTouchEvent";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "renderInner";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "render";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "renderDrawable";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "renderDrawableAllStates";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayoutLib";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayoutlibCallback";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "measureChildren";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "measureChild";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setXmlFile";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 55: 
            case 56: 
            case 58: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setRenderingMode";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createRenderSession";
                break;
            }
            case 25: 
            case 26: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "runAsyncRenderAction";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "triggerTouchEvent";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "reportException";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "addDiagnostics";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "renderDrawable";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "measureChildren";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "measureChild";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "setCrashReporter";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "disposeRenderSession";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "disposeIfCompose";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 55: 
            case 56: 
            case 58: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface AttributeFilter {
        @Nullable
        public String getAttribute(@NotNull XmlTag var1, @Nullable String var2, @NotNull String var3);
    }
}

