/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.imagepool.ImagePool;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderResult {
    private static Logger LOG = Logger.getInstance(RenderResult.class);
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final RenderLogger myLogger;
    @NotNull
    private final ImmutableList<ViewInfo> myRootViews;
    @NotNull
    private final ImmutableList<ViewInfo> mySystemRootViews;
    @NotNull
    private final ImagePool.Image myImage;
    @Nullable
    private final RenderTask myRenderTask;
    @NotNull
    private final Result myRenderResult;
    @NotNull
    private final Map<Object, Map<ResourceReference, ResourceValue>> myDefaultProperties;
    @NotNull
    private final Map<Object, ResourceReference> myDefaultStyles;
    @NotNull
    private final Module myModule;
    private final ReadWriteLock myDisposeLock;
    @Nullable
    private final Object myValidatorResult;
    private final long myRenderDurationMs;
    private boolean isDisposed;

    protected RenderResult(@NotNull PsiFile file2, @NotNull Module module2, @NotNull RenderLogger logger2, @Nullable RenderTask renderTask, @NotNull Result renderResult, @NotNull ImmutableList<ViewInfo> rootViews, @NotNull ImmutableList<ViewInfo> systemRootViews, @NotNull ImagePool.Image image, @NotNull Map<Object, Map<ResourceReference, ResourceValue>> defaultProperties, @NotNull Map<Object, ResourceReference> defaultStyles, @Nullable Object validatorResult, long renderDurationMs) {
        if (file2 == null) {
            RenderResult.$$$reportNull$$$0(0);
        }
        if (module2 == null) {
            RenderResult.$$$reportNull$$$0(1);
        }
        if (logger2 == null) {
            RenderResult.$$$reportNull$$$0(2);
        }
        if (renderResult == null) {
            RenderResult.$$$reportNull$$$0(3);
        }
        if (rootViews == null) {
            RenderResult.$$$reportNull$$$0(4);
        }
        if (systemRootViews == null) {
            RenderResult.$$$reportNull$$$0(5);
        }
        if (image == null) {
            RenderResult.$$$reportNull$$$0(6);
        }
        if (defaultProperties == null) {
            RenderResult.$$$reportNull$$$0(7);
        }
        if (defaultStyles == null) {
            RenderResult.$$$reportNull$$$0(8);
        }
        this.myDisposeLock = new ReentrantReadWriteLock();
        this.myRenderTask = renderTask;
        this.myModule = module2;
        this.myFile = file2;
        this.myLogger = logger2;
        this.myRenderResult = renderResult;
        this.myRootViews = rootViews;
        this.mySystemRootViews = systemRootViews;
        this.myImage = image;
        this.myDefaultProperties = defaultProperties;
        this.myDefaultStyles = defaultStyles;
        this.myValidatorResult = validatorResult;
        this.myRenderDurationMs = renderDurationMs;
    }

    public boolean processImageIfNotDisposed(@NotNull Consumer<ImagePool.Image> processTask) {
        if (processTask == null) {
            RenderResult.$$$reportNull$$$0(9);
        }
        this.myDisposeLock.readLock().lock();
        try {
            if (this.isDisposed) {
                boolean bl = false;
                return bl;
            }
            processTask.accept(this.myImage);
            boolean bl = true;
            return bl;
        }
        finally {
            this.myDisposeLock.readLock().unlock();
        }
    }

    public void dispose() {
        this.myDisposeLock.writeLock().lock();
        try {
            this.isDisposed = true;
            this.myImage.dispose();
        }
        finally {
            this.myDisposeLock.writeLock().unlock();
        }
    }

    @NotNull
    public static RenderResult create(@NotNull RenderTask renderTask, @NotNull RenderSession session, @NotNull PsiFile file2, @NotNull RenderLogger logger2, @NotNull ImagePool.Image image) {
        if (renderTask == null) {
            RenderResult.$$$reportNull$$$0(10);
        }
        if (session == null) {
            RenderResult.$$$reportNull$$$0(11);
        }
        if (file2 == null) {
            RenderResult.$$$reportNull$$$0(12);
        }
        if (logger2 == null) {
            RenderResult.$$$reportNull$$$0(13);
        }
        if (image == null) {
            RenderResult.$$$reportNull$$$0(14);
        }
        List rootViews = session.getRootViews();
        List systemRootViews = session.getSystemRootViews();
        Map defaultProperties = session.getDefaultNamespacedProperties();
        Map defaultStyles = session.getDefaultNamespacedStyles();
        RenderResult result2 = new RenderResult(file2, renderTask.getContext().getModule(), logger2, renderTask, session.getResult(), (ImmutableList<ViewInfo>)(rootViews != null ? ImmutableList.copyOf((Collection)rootViews) : ImmutableList.of()), (ImmutableList<ViewInfo>)(systemRootViews != null ? ImmutableList.copyOf((Collection)systemRootViews) : ImmutableList.of()), image, (Map<Object, Map<ResourceReference, ResourceValue>>)(defaultProperties != null ? ImmutableMap.copyOf((Map)defaultProperties) : ImmutableMap.of()), (Map<Object, ResourceReference>)(defaultStyles != null ? ImmutableMap.copyOf((Map)defaultStyles) : ImmutableMap.of()), session.getValidationData(), -1L);
        if (LOG.isDebugEnabled()) {
            LOG.debug(result2.toString());
        }
        RenderResult renderResult = result2;
        if (renderResult == null) {
            RenderResult.$$$reportNull$$$0(15);
        }
        return renderResult;
    }

    @NotNull
    public RenderResult createWithDuration(long renderDurationMs) {
        return new RenderResult(this.myFile, this.myModule, this.myLogger, this.myRenderTask, this.myRenderResult, this.myRootViews, this.mySystemRootViews, this.myImage, this.myDefaultProperties, this.myDefaultStyles, this.myValidatorResult, renderDurationMs);
    }

    @NotNull
    public static RenderResult createBlank(@NotNull PsiFile file2) {
        if (file2 == null) {
            RenderResult.$$$reportNull$$$0(16);
        }
        return RenderResult.createErrorResult(file2, Result.Status.ERROR_UNKNOWN.createResult(""), null);
    }

    @NotNull
    public static RenderResult createRenderTaskErrorResult(@NotNull PsiFile file2, @NotNull RenderLogger logger2) {
        if (file2 == null) {
            RenderResult.$$$reportNull$$$0(17);
        }
        if (logger2 == null) {
            RenderResult.$$$reportNull$$$0(18);
        }
        return RenderResult.createErrorResult(file2, Result.Status.ERROR_RENDER_TASK.createResult(), logger2);
    }

    @NotNull
    public static RenderResult createRenderTaskErrorResult(@NotNull PsiFile file2, @Nullable Throwable throwable) {
        if (file2 == null) {
            RenderResult.$$$reportNull$$$0(19);
        }
        return RenderResult.createErrorResult(file2, Result.Status.ERROR_RENDER_TASK.createResult("Render error", throwable), null);
    }

    @NotNull
    private static RenderResult createErrorResult(@NotNull PsiFile file2, @NotNull Result errorResult, @Nullable RenderLogger logger2) {
        if (file2 == null) {
            RenderResult.$$$reportNull$$$0(20);
        }
        if (errorResult == null) {
            RenderResult.$$$reportNull$$$0(21);
        }
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)file2);
        assert (module2 != null);
        RenderResult result2 = new RenderResult(file2, module2, logger2 != null ? logger2 : new RenderLogger(null, module2), null, errorResult, (ImmutableList<ViewInfo>)ImmutableList.of(), (ImmutableList<ViewInfo>)ImmutableList.of(), ImagePool.NULL_POOLED_IMAGE, (Map<Object, Map<ResourceReference, ResourceValue>>)ImmutableMap.of(), (Map<Object, ResourceReference>)ImmutableMap.of(), null, -1L);
        if (LOG.isDebugEnabled()) {
            LOG.debug(result2.toString());
        }
        RenderResult renderResult = result2;
        if (renderResult == null) {
            RenderResult.$$$reportNull$$$0(22);
        }
        return renderResult;
    }

    @NotNull
    public Result getRenderResult() {
        Result result2 = this.myRenderResult;
        if (result2 == null) {
            RenderResult.$$$reportNull$$$0(23);
        }
        return result2;
    }

    @NotNull
    public RenderLogger getLogger() {
        RenderLogger renderLogger = this.myLogger;
        if (renderLogger == null) {
            RenderResult.$$$reportNull$$$0(24);
        }
        return renderLogger;
    }

    @NotNull
    public ImagePool.Image getRenderedImage() {
        this.myDisposeLock.readLock().lock();
        ImagePool.Image image = !this.isDisposed ? this.myImage : ImagePool.NULL_POOLED_IMAGE;
        ImagePool.Image image2 = image;
        if (image2 == null) {
            RenderResult.$$$reportNull$$$0(25);
        }
        return image2;
        finally {
            this.myDisposeLock.readLock().unlock();
        }
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile2 = this.myFile;
        if (psiFile2 == null) {
            RenderResult.$$$reportNull$$$0(26);
        }
        return psiFile2;
    }

    @Nullable
    public RenderTask getRenderTask() {
        return this.myRenderTask;
    }

    @NotNull
    public Module getModule() {
        Module module2 = this.myModule;
        if (module2 == null) {
            RenderResult.$$$reportNull$$$0(27);
        }
        return module2;
    }

    @NotNull
    public ImmutableList<ViewInfo> getRootViews() {
        ImmutableList<ViewInfo> immutableList = this.myRootViews;
        if (immutableList == null) {
            RenderResult.$$$reportNull$$$0(28);
        }
        return immutableList;
    }

    @NotNull
    public ImmutableList<ViewInfo> getSystemRootViews() {
        ImmutableList<ViewInfo> immutableList = this.mySystemRootViews;
        if (immutableList == null) {
            RenderResult.$$$reportNull$$$0(29);
        }
        return immutableList;
    }

    @Nullable
    public Object getValidatorResult() {
        return this.myValidatorResult;
    }

    @NotNull
    public Map<Object, Map<ResourceReference, ResourceValue>> getDefaultProperties() {
        Map<Object, Map<ResourceReference, ResourceValue>> map2 = this.myDefaultProperties;
        if (map2 == null) {
            RenderResult.$$$reportNull$$$0(30);
        }
        return map2;
    }

    @NotNull
    public Map<Object, ResourceReference> getDefaultStyles() {
        Map<Object, ResourceReference> map2 = this.myDefaultStyles;
        if (map2 == null) {
            RenderResult.$$$reportNull$$$0(31);
        }
        return map2;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("renderResult", (Object)this.myRenderResult).add("psiFile", (Object)this.myFile).add("rootViews", this.myRootViews).add("systemViews", this.mySystemRootViews).toString();
    }

    public long getRenderDuration() {
        return this.myRenderDurationMs;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderResult";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootViews";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemRootViews";
                break;
            }
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultProperties";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultStyles";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processTask";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderTask";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/RenderResult";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/RenderResult";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createErrorResult";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderResult";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderedImage";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootViews";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemRootViews";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultProperties";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultStyles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processImageIfNotDisposed";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createBlank";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createRenderTaskErrorResult";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createErrorResult";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

