/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.rendering.HtmlLinkManager;
import com.android.tools.idea.rendering.RenderErrorContributor;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.errors.ui.RenderErrorModel;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.android.utils.HtmlBuilder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.DataContext;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutlibPluginRenderErrorContributor
extends RenderErrorContributor {
    private final HtmlLinkManager myLinkManager;

    protected LayoutlibPluginRenderErrorContributor(@Nullable EditorDesignSurface surface2, @NotNull RenderResult result2, @Nullable DataContext dataContext) {
        if (result2 == null) {
            LayoutlibPluginRenderErrorContributor.$$$reportNull$$$0(0);
        }
        super(surface2, result2, dataContext);
        this.myLinkManager = result2.getLogger().getLinkManager();
    }

    @Override
    public Collection<RenderErrorModel.Issue> reportIssues() {
        RenderResult result2 = this.getResult();
        RenderLogger logger2 = result2.getLogger();
        if (!LayoutLibrary.isNative()) {
            this.reportLayoutlibStandardIssue();
        } else if (logger2.hasErrors()) {
            this.reportLayoutlibNativeIssue();
        }
        return this.getIssues();
    }

    private void reportLayoutlibStandardIssue() {
        HtmlBuilder builder2 = new HtmlBuilder();
        builder2.addLink("Click ", "here", " to enable the new Layout Rendering Engine.", this.myLinkManager.createEnableLayoutlibNativeUrl()).newline().add("If it causes any issue, it can later be disabled using the Settings > Experimental dialog.");
        this.addIssue().setSeverity(HighlightSeverity.INFORMATION).setSummary("Use new Layout Rendering Engine").setHtmlContent(builder2).build();
    }

    private void reportLayoutlibNativeIssue() {
        HtmlBuilder builder2 = new HtmlBuilder();
        builder2.add("Rendering errors might be caused by the new Layout Rendering Engine.").newline().addLink("Disabling it by clicking ", "here", " may fix the issue.", this.myLinkManager.createDisableLayoutlibNativeUrl()).newline().add("It can later be enabled again using the Settings > Experimental dialog.");
        this.addIssue().setSeverity(HighlightSeverity.INFORMATION).setSummary("Disable experimental Layout Rendering Engine.").setHtmlContent(builder2).build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/rendering/LayoutlibPluginRenderErrorContributor", "<init>"));
    }

    public static class LayoutlibPluginProvider
    extends RenderErrorContributor.Provider {
        @Override
        public RenderErrorContributor getContributor(@Nullable EditorDesignSurface surface2, @NotNull RenderResult result2, @Nullable DataContext dataContext) {
            if (result2 == null) {
                LayoutlibPluginProvider.$$$reportNull$$$0(0);
            }
            return new LayoutlibPluginRenderErrorContributor(surface2, result2, dataContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/rendering/LayoutlibPluginRenderErrorContributor$LayoutlibPluginProvider", "getContributor"));
        }
    }
}

