/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.rendering.SetAttributeFix;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.utils.SdkUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncludeReference {
    public static final IncludeReference NONE = new IncludeReference(null, null, null);
    @NotNull
    private final VirtualFile myFromFile;
    @Nullable
    private final VirtualFile myToFile;
    @NotNull
    private final Module myModule;

    private IncludeReference(Module module2, VirtualFile fromFile, @Nullable VirtualFile toFile) {
        this.myModule = module2;
        this.myFromFile = fromFile;
        this.myToFile = toFile;
    }

    public static IncludeReference create(Module module2, VirtualFile fromFile, @Nullable VirtualFile toFile) {
        return new IncludeReference(module2, fromFile, toFile);
    }

    @NotNull
    public Module getModule() {
        Module module2 = this.myModule;
        if (module2 == null) {
            IncludeReference.$$$reportNull$$$0(0);
        }
        return module2;
    }

    @NotNull
    public VirtualFile getFromFile() {
        VirtualFile virtualFile = this.myFromFile;
        if (virtualFile == null) {
            IncludeReference.$$$reportNull$$$0(1);
        }
        return virtualFile;
    }

    @NotNull
    public File getFromPath() {
        File file2 = VfsUtilCore.virtualToIoFile((VirtualFile)this.myFromFile);
        if (file2 == null) {
            IncludeReference.$$$reportNull$$$0(2);
        }
        return file2;
    }

    @Nullable
    public VirtualFile getToFile() {
        return this.myToFile;
    }

    @Nullable
    public File getToPath() {
        return this.myToFile != null ? VfsUtilCore.virtualToIoFile((VirtualFile)this.myToFile) : null;
    }

    @NotNull
    public String getFromDisplayName() {
        if (this.myToFile != null && this.myToFile.getParent() != null && this.myToFile.getParent().equals(this.myFromFile.getParent())) {
            String string = this.myFromFile.getName();
            if (string == null) {
                IncludeReference.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = this.myFromFile.getParent().getName() + "/" + this.myFromFile.getName();
        if (string == null) {
            IncludeReference.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getFromResourceName() {
        String string = SdkUtils.fileNameToResourceName((String)this.myFromFile.getName());
        if (string == null) {
            IncludeReference.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getFromResourceUrl() {
        String string = "@layout/" + this.getFromResourceName();
        if (string == null) {
            IncludeReference.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public static String getIncludingLayout(@NotNull XmlFile file2) {
        if (file2 == null) {
            IncludeReference.$$$reportNull$$$0(7);
        }
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            return (String)ApplicationManager.getApplication().runReadAction(() -> IncludeReference.getIncludingLayout(file2));
        }
        XmlTag rootTag = file2.getRootTag();
        if (rootTag != null && rootTag.isValid()) {
            return rootTag.getAttributeValue("showIn", "http://schemas.android.com/tools");
        }
        return null;
    }

    public static void setIncludingLayout(@NotNull Project project, @NotNull XmlFile xmlFile, @Nullable String layout2) {
        XmlTag tag;
        if (project == null) {
            IncludeReference.$$$reportNull$$$0(8);
        }
        if (xmlFile == null) {
            IncludeReference.$$$reportNull$$$0(9);
        }
        if ((tag = xmlFile.getRootTag()) != null) {
            SetAttributeFix fix = new SetAttributeFix(tag, "showIn", "http://schemas.android.com/tools", layout2);
            fix.executeCommand();
        }
    }

    @NotNull
    public static IncludeReference get(@NotNull Module module2, @NotNull XmlFile file2, @NotNull RenderResources resolver) {
        VirtualFile source;
        ResourceValue resValue;
        ResourceUrl layoutUrl;
        String layoutRef;
        if (module2 == null) {
            IncludeReference.$$$reportNull$$$0(10);
        }
        if (file2 == null) {
            IncludeReference.$$$reportNull$$$0(11);
        }
        if (resolver == null) {
            IncludeReference.$$$reportNull$$$0(12);
        }
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            IncludeReference includeReference = (IncludeReference)ApplicationManager.getApplication().runReadAction(() -> IncludeReference.get(module2, file2, resolver));
            if (includeReference == null) {
                IncludeReference.$$$reportNull$$$0(13);
            }
            return includeReference;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        XmlTag rootTag = file2.getRootTag();
        if (rootTag != null && (layoutRef = rootTag.getAttributeValue("showIn", "http://schemas.android.com/tools")) != null && (layoutUrl = ResourceUrl.parse((String)layoutRef)) != null && (resValue = IdeResourcesUtil.resolve(resolver, layoutUrl, (XmlElement)rootTag)) != null && (source = IdeResourcesUtil.resolveLayout(resolver, resValue)) != null) {
            VirtualFile target = file2.getVirtualFile();
            IncludeReference includeReference = IncludeReference.create(module2, source, target);
            if (includeReference == null) {
                IncludeReference.$$$reportNull$$$0(14);
            }
            return includeReference;
        }
        IncludeReference includeReference = NONE;
        if (includeReference == null) {
            IncludeReference.$$$reportNull$$$0(15);
        }
        return includeReference;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/IncludeReference";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFromFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFromPath";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFromDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFromResourceName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFromResourceUrl";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/IncludeReference";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getIncludingLayout";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setIncludingLayout";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

