/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.SdkConstants;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.resources.ResourceType;
import com.android.support.FragmentTagUtil;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderSecurityManager;
import com.android.tools.idea.rendering.RenderUtils;
import com.android.tools.idea.rendering.ReplaceTagFix;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.android.tools.idea.ui.resourcechooser.util.ResourceChooserHelperKt;
import com.android.tools.idea.ui.resourcemanager.ResourcePickerDialog;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.android.tools.lint.detector.api.Lint;
import com.android.utils.SdkUtils;
import com.android.utils.SparseArray;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.LayoutEditorEvent;
import com.intellij.codeInsight.daemon.impl.quickfix.ClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.intention.impl.CreateClassDialog;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.AlarmFactory;
import com.intellij.util.PsiNavigateUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.ChooseClassDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlLinkManager {
    private static final String URL_EDIT_CLASSPATH = "action:classpath";
    private static final String URL_BUILD = "action:build";
    private static final String URL_SYNC = "action:sync";
    private static final String URL_SHOW_XML = "action:showXml";
    private static final String URL_ACTION_IGNORE_FRAGMENTS = "action:ignoreFragment";
    private static final String URL_RUNNABLE = "runnable:";
    private static final String URL_COMMAND = "command:";
    private static final String URL_REPLACE_TAGS = "replaceTags:";
    private static final String URL_SHOW_TAG = "showTag:";
    private static final String URL_OPEN = "open:";
    private static final String URL_CREATE_CLASS = "createClass:";
    private static final String URL_OPEN_CLASS = "openClass:";
    private static final String URL_ASSIGN_FRAGMENT_URL = "assignFragmentUrl:";
    private static final String URL_ASSIGN_LAYOUT_URL = "assignLayoutUrl:";
    private static final String URL_EDIT_ATTRIBUTE = "editAttribute:";
    private static final String URL_REPLACE_ATTRIBUTE_VALUE = "replaceAttributeValue:";
    private static final String URL_DISABLE_SANDBOX = "disableSandbox:";
    private static final String URL_REFRESH_RENDER = "refreshRender";
    private static final String URL_ADD_DEPENDENCY = "addDependency:";
    private static final String URL_CLEAR_CACHE_AND_NOTIFY = "clearCacheAndNotify";
    private static final String URL_ENABLE_LAYOUTLIB_NATIVE = "enableLayoutlibNative";
    private static final String URL_DISABLE_LAYOUTLIB_NATIVE = "disableLayoutlibNative";
    private SparseArray<Runnable> myLinkRunnables;
    private SparseArray<CommandLink> myLinkCommands;
    private int myNextLinkId = 0;
    private static final NotificationGroup NOTIFICATIONS_GROUP = new NotificationGroup("Render error panel notifications", NotificationDisplayType.BALLOON, false, null, null, null, PluginId.getId((String)"org.jetbrains.android"));

    public static void showNotification(@NotNull String content2) {
        if (content2 == null) {
            HtmlLinkManager.$$$reportNull$$$0(0);
        }
        Notification notification = NOTIFICATIONS_GROUP.createNotification(content2, NotificationType.INFORMATION);
        Notifications.Bus.notify((Notification)notification);
        AlarmFactory.getInstance().create().addRequest(() -> ((Notification)notification).expire(), TimeUnit.SECONDS.toMillis(2L));
    }

    public void handleUrl(@NotNull String url, @Nullable Module module2, @Nullable PsiFile file2, @Nullable DataContext dataContext, @Nullable RenderResult result2, @Nullable EditorDesignSurface surface2) {
        if (url == null) {
            HtmlLinkManager.$$$reportNull$$$0(1);
        }
        if (url.startsWith("http:") || url.startsWith("https:")) {
            BrowserLauncher.getInstance().browse(url, null, module2 == null ? null : module2.getProject());
        } else if (url.startsWith("file:")) {
            assert (module2 != null);
            HtmlLinkManager.handleFileUrl(url, module2);
        } else if (url.startsWith(URL_REPLACE_TAGS)) {
            assert (module2 != null);
            assert (file2 != null);
            HtmlLinkManager.handleReplaceTagsUrl(url, module2, file2);
        } else if (url.equals(URL_BUILD)) {
            assert (module2 != null);
            HtmlLinkManager.handleBuildProjectUrl(url, module2.getProject());
        } else if (url.equals(URL_SYNC)) {
            assert (module2 != null);
            HtmlLinkManager.handleSyncProjectUrl(url, module2.getProject());
        } else if (url.equals(URL_EDIT_CLASSPATH)) {
            assert (module2 != null);
            HtmlLinkManager.handleEditClassPathUrl(url, module2);
        } else if (url.startsWith(URL_CREATE_CLASS)) {
            assert (module2 != null && file2 != null);
            HtmlLinkManager.handleNewClassUrl(url, module2);
        } else if (url.startsWith(URL_OPEN)) {
            assert (module2 != null);
            HtmlLinkManager.handleOpenStackUrl(url, module2);
        } else if (url.startsWith(URL_OPEN_CLASS)) {
            assert (module2 != null);
            HtmlLinkManager.handleOpenClassUrl(url, module2);
        } else if (url.equals(URL_SHOW_XML)) {
            assert (module2 != null && file2 != null);
            HtmlLinkManager.handleShowXmlUrl(url, module2, file2);
        } else if (url.startsWith(URL_SHOW_TAG)) {
            assert (module2 != null && file2 != null);
            HtmlLinkManager.handleShowTagUrl(url, module2, file2);
        } else if (url.startsWith(URL_ASSIGN_FRAGMENT_URL)) {
            assert (module2 != null && file2 != null);
            HtmlLinkManager.handleAssignFragmentUrl(url, module2, file2);
        } else if (url.startsWith(URL_ASSIGN_LAYOUT_URL)) {
            assert (module2 != null && file2 != null);
            HtmlLinkManager.handleAssignLayoutUrl(url, module2, file2);
        } else if (url.equals(URL_ACTION_IGNORE_FRAGMENTS)) {
            assert (result2 != null);
            HtmlLinkManager.handleIgnoreFragments(url, surface2);
        } else if (url.startsWith(URL_EDIT_ATTRIBUTE)) {
            assert (result2 != null);
            if (module2 != null && file2 != null) {
                HtmlLinkManager.handleEditAttribute(url, module2, file2);
            }
        } else if (url.startsWith(URL_REPLACE_ATTRIBUTE_VALUE)) {
            assert (result2 != null);
            if (module2 != null && file2 != null) {
                HtmlLinkManager.handleReplaceAttributeValue(url, module2, file2);
            }
        } else if (url.startsWith(URL_DISABLE_SANDBOX)) {
            assert (module2 != null);
            HtmlLinkManager.handleDisableSandboxUrl(module2, surface2);
        } else if (url.startsWith(URL_RUNNABLE)) {
            Runnable linkRunnable = this.getLinkRunnable(url);
            if (linkRunnable != null) {
                linkRunnable.run();
            }
        } else if (url.startsWith(URL_ADD_DEPENDENCY) && module2 != null) {
            assert (module2.getModuleFile() != null);
            HtmlLinkManager.handleAddDependency(url, module2);
            ProjectSystemUtil.getSyncManager(module2.getProject()).syncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED);
        } else if (url.startsWith(URL_COMMAND)) {
            String idString;
            int id;
            CommandLink command;
            if (this.myLinkCommands != null && url.startsWith(URL_COMMAND) && (command = (CommandLink)this.myLinkCommands.get(id = Integer.decode(idString = url.substring(URL_COMMAND.length())).intValue())) != null) {
                command.executeCommand();
            }
        } else if (url.startsWith(URL_REFRESH_RENDER)) {
            HtmlLinkManager.handleRefreshRenderUrl(surface2);
        } else if (url.startsWith(URL_CLEAR_CACHE_AND_NOTIFY)) {
            HtmlLinkManager.handleRefreshRenderUrl(surface2);
            HtmlLinkManager.showNotification("Cache cleared");
        } else if (url.startsWith(URL_ENABLE_LAYOUTLIB_NATIVE)) {
            HtmlLinkManager.handleEnableLayoutlibNative(true);
        } else if (url.startsWith(URL_DISABLE_LAYOUTLIB_NATIVE)) {
            HtmlLinkManager.handleEnableLayoutlibNative(false);
        } else assert (false) : "Unexpected URL: " + url;
    }

    @Nullable
    public static String createFilePositionUrl(@NotNull File file2, int line2, int column) {
        if (file2 == null) {
            HtmlLinkManager.$$$reportNull$$$0(2);
        }
        try {
            String fileUrl = SdkUtils.fileToUrlString((File)file2);
            if (line2 != -1) {
                if (column > 0) {
                    return fileUrl + ":" + line2 + ":" + column;
                }
                return fileUrl + ":" + line2;
            }
            return fileUrl;
        }
        catch (MalformedURLException e) {
            Logger.getInstance(HtmlLinkManager.class).error((Throwable)e);
            return null;
        }
    }

    private static void handleFileUrl(@NotNull String url, @NotNull Module module2) {
        if (url == null) {
            HtmlLinkManager.$$$reportNull$$$0(3);
        }
        if (module2 == null) {
            HtmlLinkManager.$$$reportNull$$$0(4);
        }
        Project project = module2.getProject();
        try {
            int line2 = -1;
            int column = 0;
            Pattern pattern = Pattern.compile(".*:(\\d+)(:(\\d+))");
            Matcher matcher = pattern.matcher(url);
            if (matcher.matches()) {
                line2 = Integer.parseInt(matcher.group(1));
                column = Integer.parseInt(matcher.group(3));
                url = url.substring(0, matcher.start(1) - 1);
            } else {
                matcher = Pattern.compile(".*:(\\d+)").matcher(url);
                if (matcher.matches()) {
                    line2 = Integer.parseInt(matcher.group(1));
                    url = url.substring(0, matcher.start(1) - 1);
                }
            }
            File ioFile = SdkUtils.urlToFile((String)url);
            VirtualFile file2 = LocalFileSystem.getInstance().findFileByIoFile(ioFile);
            if (file2 != null) {
                HtmlLinkManager.openEditor(project, file2, line2, column);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    String createCommandLink(@NotNull CommandLink command) {
        if (command == null) {
            HtmlLinkManager.$$$reportNull$$$0(5);
        }
        String url = URL_COMMAND + this.myNextLinkId;
        if (this.myLinkCommands == null) {
            this.myLinkCommands = new SparseArray(5);
        }
        this.myLinkCommands.put(this.myNextLinkId, (Object)command);
        ++this.myNextLinkId;
        return url;
    }

    public String createRunnableLink(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            HtmlLinkManager.$$$reportNull$$$0(6);
        }
        String url = URL_RUNNABLE + this.myNextLinkId;
        if (this.myLinkRunnables == null) {
            this.myLinkRunnables = new SparseArray(5);
        }
        this.myLinkRunnables.put(this.myNextLinkId, (Object)runnable2);
        ++this.myNextLinkId;
        return url;
    }

    @Nullable
    private Runnable getLinkRunnable(String url) {
        if (this.myLinkRunnables != null && url.startsWith(URL_RUNNABLE)) {
            String idString = url.substring(URL_RUNNABLE.length());
            int id = Integer.decode(idString);
            return (Runnable)this.myLinkRunnables.get(id);
        }
        return null;
    }

    public String createReplaceTagsUrl(String from, String to) {
        return URL_REPLACE_TAGS + from + "/" + to;
    }

    private static void handleReplaceTagsUrl(@NotNull String url, @NotNull Module module2, @NotNull PsiFile file2) {
        if (url == null) {
            HtmlLinkManager.$$$reportNull$$$0(7);
        }
        if (module2 == null) {
            HtmlLinkManager.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            HtmlLinkManager.$$$reportNull$$$0(9);
        }
        assert (url.startsWith(URL_REPLACE_TAGS)) : url;
        int start2 = URL_REPLACE_TAGS.length();
        int delimiterPos = url.indexOf(47, start2);
        if (delimiterPos != -1) {
            String wrongTag = url.substring(start2, delimiterPos);
            String rightTag = url.substring(delimiterPos + 1);
            new ReplaceTagFix((XmlFile)file2, wrongTag, rightTag).run();
        }
    }

    public String createBuildProjectUrl() {
        return URL_BUILD;
    }

    private static void handleBuildProjectUrl(@NotNull String url, @NotNull Project project) {
        if (url == null) {
            HtmlLinkManager.$$$reportNull$$$0(10);
        }
        if (project == null) {
            HtmlLinkManager.$$$reportNull$$$0(11);
        }
        assert (url.equals(URL_BUILD)) : url;
        ProjectSystemUtil.getProjectSystem(project).buildProject();
    }

    public String createSyncProjectUrl() {
        return URL_SYNC;
    }

    private static void handleSyncProjectUrl(@NotNull String url, @NotNull Project project) {
        if (url == null) {
            HtmlLinkManager.$$$reportNull$$$0(12);
        }
        if (project == null) {
            HtmlLinkManager.$$$reportNull$$$0(13);
        }
        assert (url.equals(URL_SYNC)) : url;
        ProjectSystemSyncManager.SyncReason reason = project.isInitialized() ? ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED : ProjectSystemSyncManager.SyncReason.PROJECT_LOADED;
        ProjectSystemUtil.getProjectSystem(project).getSyncManager().syncProject(reason);
    }

    public String createEditClassPathUrl() {
        return URL_EDIT_CLASSPATH;
    }

    private static void handleEditClassPathUrl(@NotNull String url, @NotNull Module module2) {
        if (url == null) {
            HtmlLinkManager.$$$reportNull$$$0(14);
        }
        if (module2 == null) {
            HtmlLinkManager.$$$reportNull$$$0(15);
        }
        assert (url.equals(URL_EDIT_CLASSPATH)) : url;
        ProjectSettingsService.getInstance((Project)module2.getProject()).openModuleSettings(module2);
    }

    public String createOpenClassUrl(@NotNull String className2) {
        if (className2 == null) {
            HtmlLinkManager.$$$reportNull$$$0(16);
        }
        return URL_OPEN_CLASS + className2;
    }

    private static void handleOpenClassUrl(@NotNull String url, @NotNull Module module2) {
        PsiFile containingFile;
        if (url == null) {
            HtmlLinkManager.$$$reportNull$$$0(17);
        }
        if (module2 == null) {
            HtmlLinkManager.$$$reportNull$$$0(18);
        }
        assert (url.startsWith(URL_OPEN_CLASS)) : url;
        String className2 = url.substring(URL_OPEN_CLASS.length());
        Project project = module2.getProject();
        PsiClass clz = JavaPsiFacade.getInstance((Project)project).findClass(className2, GlobalSearchScope.allScope((Project)project));
        if (clz != null && (containingFile = clz.getContainingFile()) != null) {
            HtmlLinkManager.openEditor(project, containingFile, clz.getTextOffset());
        }
    }

    private static void handleShowXmlUrl(@NotNull String url, @NotNull Module module2, @NotNull PsiFile file2) {
        if (url == null) {
            HtmlLinkManager.$$$reportNull$$$0(19);
        }
        if (module2 == null) {
            HtmlLinkManager.$$$reportNull$$$0(20);
        }
        if (file2 == null) {
            HtmlLinkManager.$$$reportNull$$$0(21);
        }
        assert (url.equals(URL_SHOW_XML)) : url;
        HtmlLinkManager.openEditor(module2.getProject(), file2, 0, -1);
    }

    public String createShowTagUrl(String tag) {
        return URL_SHOW_TAG + tag;
    }

    private static void handleShowTagUrl(@NotNull String url, @NotNull Module module2, @NotNull PsiFile file2) {
        if (url == null) {
            HtmlLinkManager.$$$reportNull$$$0(22);
        }
        if (module2 == null) {
            HtmlLinkManager.$$$reportNull$$$0(23);
        }
        if (file2 == null) {
            HtmlLinkManager.$$$reportNull$$$0(24);
        }
        assert (url.startsWith(URL_SHOW_TAG)) : url;
        String tagName = url.substring(URL_SHOW_TAG.length());
        XmlTag first = (XmlTag)ApplicationManager.getApplication().runReadAction(() -> {
            Collection xmlTags = PsiTreeUtil.findChildrenOfType((PsiElement)file2, XmlTag.class);
            for (XmlTag tag : xmlTags) {
                if (!tagName.equals(tag.getName())) continue;
                return tag;
            }
            return null;
        });
        if (first != null) {
            PsiNavigateUtil.navigate((PsiElement)first);
        } else {
            HtmlLinkManager.openEditor(module2.getProject(), file2, 0, -1);
        }
    }

    public String createNewClassUrl(String className2) {
        return URL_CREATE_CLASS + className2;
    }

    private static void handleNewClassUrl(@NotNull String url, @NotNull Module module2) {
        PsiFile file2;
        PsiClass newClass;
        PsiDirectory targetDirectory;
        String packageName;
        String className2;
        if (url == null) {
            HtmlLinkManager.$$$reportNull$$$0(25);
        }
        if (module2 == null) {
            HtmlLinkManager.$$$reportNull$$$0(26);
        }
        assert (url.startsWith(URL_CREATE_CLASS)) : url;
        String s = url.substring(URL_CREATE_CLASS.length());
        Project project = module2.getProject();
        String title = "Create Custom View";
        int index2 = s.lastIndexOf(46);
        if (index2 == -1) {
            className2 = s;
            packageName = AndroidManifestUtils.getPackageName(module2);
            if (packageName == null) {
                return;
            }
        } else {
            packageName = s.substring(0, index2);
            className2 = s.substring(index2 + 1);
        }
        CreateClassDialog dialog2 = new CreateClassDialog(project, title, className2, packageName, (ClassKind)CreateClassKind.CLASS, true, module2){

            protected boolean reportBaseInSourceSelectionInTest() {
                return true;
            }
        };
        dialog2.show();
        if (dialog2.getExitCode() == 0 && (targetDirectory = dialog2.getTargetDirectory()) != null && (newClass = (PsiClass)WriteCommandAction.writeCommandAction((Project)project).withName("Create Class").compute(() -> {
            PsiClass targetClass = JavaDirectoryService.getInstance().createClass(targetDirectory, className2);
            PsiManager manager = PsiManager.getInstance((Project)project);
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
            PsiElementFactory factory2 = facade.getElementFactory();
            PsiJavaCodeReferenceElement superclassReference = factory2.createReferenceElementByFQClassName("android.view.View", targetClass.getResolveScope());
            PsiReferenceList extendsList = targetClass.getExtendsList();
            if (extendsList != null) {
                extendsList.add((PsiElement)superclassReference);
            }
            GlobalSearchScope scope2 = GlobalSearchScope.allScope((Project)project);
            PsiJavaFile javaFile = (PsiJavaFile)targetClass.getContainingFile();
            PsiImportList importList = javaFile.getImportList();
            if (importList != null) {
                PsiClass attributeSetClass;
                PsiClass contextClass = JavaPsiFacade.getInstance((Project)project).findClass("android.content.Context", scope2);
                if (contextClass != null) {
                    importList.add((PsiElement)factory2.createImportStatement(contextClass));
                }
                if ((attributeSetClass = JavaPsiFacade.getInstance((Project)project).findClass("android.util.AttributeSet", scope2)) != null) {
                    importList.add((PsiElement)factory2.createImportStatement(attributeSetClass));
                }
            }
            PsiMethod constructor1arg = factory2.createMethodFromText("public " + className2 + "(Context context) {\n  this(context, null);\n}\n", (PsiElement)targetClass);
            targetClass.add((PsiElement)constructor1arg);
            PsiMethod constructor2args = factory2.createMethodFromText("public " + className2 + "(Context context, AttributeSet attrs) {\n  this(context, attrs, 0);\n}\n", (PsiElement)targetClass);
            targetClass.add((PsiElement)constructor2args);
            PsiMethod constructor3args = factory2.createMethodFromText("public " + className2 + "(Context context, AttributeSet attrs, int defStyle) {\n  super(context, attrs, defStyle);\n}\n", (PsiElement)targetClass);
            targetClass.add((PsiElement)constructor3args);
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)manager.getProject());
            PsiFile containingFile = targetClass.getContainingFile();
            if (containingFile != null) {
                codeStyleManager.reformat((PsiElement)javaFile);
            }
            return targetClass;
        })) != null && (file2 = newClass.getContainingFile()) != null) {
            HtmlLinkManager.openEditor(project, file2, newClass.getTextOffset());
        }
    }

    public String createOpenStackUrl(@NotNull String className2, @NotNull String methodName, @NotNull String fileName, int lineNumber) {
        if (className2 == null) {
            HtmlLinkManager.$$$reportNull$$$0(27);
        }
        if (methodName == null) {
            HtmlLinkManager.$$$reportNull$$$0(28);
        }
        if (fileName == null) {
            HtmlLinkManager.$$$reportNull$$$0(29);
        }
        return URL_OPEN + className2 + "#" + methodName + ";" + fileName + ":" + lineNumber;
    }

    private static void handleOpenStackUrl(@NotNull String url, @NotNull Module module2) {
        Project project;
        PsiClass clz;
        int line2;
        String className2;
        String fileName;
        if (url == null) {
            HtmlLinkManager.$$$reportNull$$$0(30);
        }
        if (module2 == null) {
            HtmlLinkManager.$$$reportNull$$$0(31);
        }
        assert (url.startsWith(URL_OPEN)) : url;
        int start2 = URL_OPEN.length();
        int semi = url.indexOf(59, start2);
        if (semi != -1) {
            int line3;
            String className3 = url.substring(start2, semi);
            int colon = url.indexOf(58, semi + 1);
            if (colon != -1) {
                fileName = url.substring(semi + 1, colon);
                line3 = Integer.decode(url.substring(colon + 1));
            } else {
                fileName = url.substring(semi + 1);
                line3 = -1;
            }
        } else {
            className2 = url.substring(start2);
            fileName = null;
            line2 = -1;
        }
        String method2 = null;
        int hash2 = className2.indexOf(35);
        if (hash2 != -1) {
            method2 = className2.substring(hash2 + 1);
            className2 = className2.substring(0, hash2);
        }
        if ((clz = JavaPsiFacade.getInstance((Project)(project = module2.getProject())).findClass(className2, GlobalSearchScope.allScope((Project)project))) != null) {
            String name;
            VirtualFile virtualFile;
            PsiFile containingFile = clz.getContainingFile();
            if (fileName != null && containingFile != null && line2 != -1 && (virtualFile = containingFile.getVirtualFile()) != null && fileName.equals(name = virtualFile.getName())) {
                HtmlLinkManager.openEditor(project, containingFile, line2 - 1, -1);
                return;
            }
            if (method2 != null) {
                PsiMethod[] methodsByName;
                for (PsiMethod psiMethod : methodsByName = clz.findMethodsByName(method2, true)) {
                    VirtualFile virtualFile2;
                    PsiFile psiFile2 = psiMethod.getContainingFile();
                    if (psiFile2 == null || (virtualFile2 = psiFile2.getVirtualFile()) == null) continue;
                    OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project, virtualFile2, psiMethod.getTextOffset());
                    FileEditorManager.getInstance((Project)project).openEditor(descriptor2, true);
                    return;
                }
            }
            if (fileName != null) {
                PsiFile[] files2 = FilenameIndex.getFilesByName((Project)project, (String)fileName, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
                for (PsiMethod psiMethod : files2) {
                    if (HtmlLinkManager.openEditor(project, (PsiFile)psiMethod, line2 != -1 ? line2 - 1 : -1, -1)) break;
                }
            }
        }
    }

    private static boolean openEditor(@NotNull Project project, @NotNull PsiFile psiFile2, int line2, int column) {
        VirtualFile file2;
        if (project == null) {
            HtmlLinkManager.$$$reportNull$$$0(32);
        }
        if (psiFile2 == null) {
            HtmlLinkManager.$$$reportNull$$$0(33);
        }
        if ((file2 = psiFile2.getVirtualFile()) != null) {
            return HtmlLinkManager.openEditor(project, file2, line2, column);
        }
        return false;
    }

    private static boolean openEditor(@NotNull Project project, @NotNull VirtualFile file2, int line2, int column) {
        if (project == null) {
            HtmlLinkManager.$$$reportNull$$$0(34);
        }
        if (file2 == null) {
            HtmlLinkManager.$$$reportNull$$$0(35);
        }
        OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project, file2, line2, column);
        FileEditorManager manager = FileEditorManager.getInstance((Project)project);
        if (manager.openTextEditor(descriptor2, true) != null) {
            return true;
        }
        return !manager.openEditor(descriptor2, true).isEmpty();
    }

    private static boolean openEditor(@NotNull Project project, @NotNull PsiFile psiFile2, int offset2) {
        VirtualFile file2;
        if (project == null) {
            HtmlLinkManager.$$$reportNull$$$0(36);
        }
        if (psiFile2 == null) {
            HtmlLinkManager.$$$reportNull$$$0(37);
        }
        if ((file2 = psiFile2.getVirtualFile()) != null) {
            return HtmlLinkManager.openEditor(project, file2, offset2);
        }
        return false;
    }

    private static boolean openEditor(@NotNull Project project, @NotNull VirtualFile file2, int offset2) {
        if (project == null) {
            HtmlLinkManager.$$$reportNull$$$0(38);
        }
        if (file2 == null) {
            HtmlLinkManager.$$$reportNull$$$0(39);
        }
        OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project, file2, offset2);
        return !FileEditorManager.getInstance((Project)project).openEditor(descriptor2, true).isEmpty();
    }

    public String createAssignFragmentUrl(@Nullable String id) {
        return URL_ASSIGN_FRAGMENT_URL + (id != null ? id : "");
    }

    @NotNull
    private static String getFragmentClass(@NotNull Module module2, @NotNull String fqcn) {
        if (module2 == null) {
            HtmlLinkManager.$$$reportNull$$$0(40);
        }
        if (fqcn == null) {
            HtmlLinkManager.$$$reportNull$$$0(41);
        }
        String string = (String)ApplicationManager.getApplication().runReadAction(() -> {
            String jvmClassName;
            Project project = module2.getProject();
            JavaPsiFacade finder = JavaPsiFacade.getInstance((Project)project);
            PsiClass psiClass = finder.findClass(fqcn, module2.getModuleScope());
            if (psiClass == null) {
                psiClass = finder.findClass(fqcn, GlobalSearchScope.allScope((Project)project));
            }
            if (psiClass != null && (jvmClassName = ClassUtil.getJVMClassName((PsiClass)psiClass)) != null) {
                return jvmClassName.replace('/', '.');
            }
            return fqcn;
        });
        if (string == null) {
            HtmlLinkManager.$$$reportNull$$$0(42);
        }
        return string;
    }

    private static void handleAssignFragmentUrl(@NotNull String url, @NotNull Module module2, @NotNull PsiFile file2) {
        if (url == null) {
            HtmlLinkManager.$$$reportNull$$$0(43);
        }
        if (module2 == null) {
            HtmlLinkManager.$$$reportNull$$$0(44);
        }
        if (file2 == null) {
            HtmlLinkManager.$$$reportNull$$$0(45);
        }
        assert (url.startsWith(URL_ASSIGN_FRAGMENT_URL)) : url;
        Predicate<PsiClass> psiFilter = ChooseClassDialog.getUserDefinedPublicAndUnrestrictedFilter();
        String className2 = ChooseClassDialog.openDialog(module2, "Fragments", null, psiFilter, "android.app.Fragment", SdkConstants.CLASS_V4_FRAGMENT.oldName(), SdkConstants.CLASS_V4_FRAGMENT.newName());
        if (className2 == null) {
            return;
        }
        String fragmentClass = HtmlLinkManager.getFragmentClass(module2, className2);
        int start2 = URL_ASSIGN_FRAGMENT_URL.length();
        String id = start2 == url.length() ? null : Lint.stripIdPrefix((String)url.substring(start2));
        WriteCommandAction.writeCommandAction((Project)module2.getProject(), (PsiFile[])new PsiFile[]{file2}).withName("Assign Fragment").run(() -> {
            Collection tags2 = PsiTreeUtil.findChildrenOfType((PsiElement)file2, XmlTag.class);
            for (XmlTag tag : tags2) {
                String tagId;
                if (!FragmentTagUtil.isFragmentTag((String)tag.getName()) || id != null && ((tagId = tag.getAttributeValue("id", "http://schemas.android.com/apk/res/android")) == null || !tagId.endsWith(id) || !id.equals(Lint.stripIdPrefix((String)tagId))) || tag.getAttribute("name", "http://schemas.android.com/apk/res/android") != null || tag.getAttribute("class") != null) continue;
                tag.setAttribute("name", "http://schemas.android.com/apk/res/android", fragmentClass);
                return;
            }
            if (id == null) {
                for (XmlTag tag : tags2) {
                    if (!FragmentTagUtil.isFragmentTag((String)tag.getName())) continue;
                    tag.setAttribute("name", "http://schemas.android.com/apk/res/android", fragmentClass);
                    break;
                }
            }
        });
    }

    public String createPickLayoutUrl(@NotNull String activityName) {
        if (activityName == null) {
            HtmlLinkManager.$$$reportNull$$$0(46);
        }
        return URL_ASSIGN_LAYOUT_URL + activityName;
    }

    public String createAssignLayoutUrl(@NotNull String activityName, @NotNull String layout2) {
        if (activityName == null) {
            HtmlLinkManager.$$$reportNull$$$0(47);
        }
        if (layout2 == null) {
            HtmlLinkManager.$$$reportNull$$$0(48);
        }
        return URL_ASSIGN_LAYOUT_URL + activityName + ":" + layout2;
    }

    private static void handleAssignLayoutUrl(@NotNull String url, @NotNull Module module2, @NotNull PsiFile file2) {
        if (url == null) {
            HtmlLinkManager.$$$reportNull$$$0(49);
        }
        if (module2 == null) {
            HtmlLinkManager.$$$reportNull$$$0(50);
        }
        if (file2 == null) {
            HtmlLinkManager.$$$reportNull$$$0(51);
        }
        assert (url.startsWith(URL_ASSIGN_LAYOUT_URL)) : url;
        int start2 = URL_ASSIGN_LAYOUT_URL.length();
        int layoutStart = url.indexOf(58, start2 + 1);
        Project project = module2.getProject();
        XmlFile xmlFile = (XmlFile)file2;
        if (layoutStart == -1) {
            String activityName = url.substring(start2);
            HtmlLinkManager.pickLayout(module2, xmlFile, activityName);
        } else {
            String activityName = url.substring(start2, layoutStart);
            String layoutName = url.substring(layoutStart + 1);
            String layout2 = "@layout/" + layoutName;
            HtmlLinkManager.assignLayout(project, xmlFile, activityName, layout2);
        }
    }

    private static void pickLayout(@NotNull Module module2, @NotNull XmlFile file2, @NotNull String activityName) {
        String layout2;
        if (module2 == null) {
            HtmlLinkManager.$$$reportNull$$$0(52);
        }
        if (file2 == null) {
            HtmlLinkManager.$$$reportNull$$$0(53);
        }
        if (activityName == null) {
            HtmlLinkManager.$$$reportNull$$$0(54);
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        assert (facet2 != null);
        ResourcePickerDialog dialog2 = ResourceChooserHelperKt.createResourcePickerDialog("Choose a Layout", null, facet2, EnumSet.of(ResourceType.LAYOUT), null, true, false, true, file2.getVirtualFile());
        if (dialog2.showAndGet() && !(layout2 = dialog2.getResourceName()).equals("@layout/" + file2.getName())) {
            HtmlLinkManager.assignLayout(module2.getProject(), file2, activityName, layout2);
        }
    }

    private static void assignLayout(@NotNull Project project, @NotNull XmlFile file2, @NotNull String activityName, @NotNull String layout2) {
        if (project == null) {
            HtmlLinkManager.$$$reportNull$$$0(55);
        }
        if (file2 == null) {
            HtmlLinkManager.$$$reportNull$$$0(56);
        }
        if (activityName == null) {
            HtmlLinkManager.$$$reportNull$$$0(57);
        }
        if (layout2 == null) {
            HtmlLinkManager.$$$reportNull$$$0(58);
        }
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{file2}).withName("Assign Preview Layout").run(() -> {
            IdeResourcesUtil.ensureNamespaceImported(file2, "http://schemas.android.com/tools", null);
            Collection xmlTags = PsiTreeUtil.findChildrenOfType((PsiElement)file2, XmlTag.class);
            for (XmlTag tag : xmlTags) {
                if (!FragmentTagUtil.isFragmentTag((String)tag.getName())) continue;
                String name = tag.getAttributeValue("class");
                if (name == null || name.isEmpty()) {
                    name = tag.getAttributeValue("name", "http://schemas.android.com/apk/res/android");
                }
                if (!activityName.equals(name)) continue;
                tag.setAttribute("layout", "http://schemas.android.com/tools", layout2);
            }
        });
    }

    public String createIgnoreFragmentsUrl() {
        return URL_ACTION_IGNORE_FRAGMENTS;
    }

    private static void handleIgnoreFragments(@NotNull String url, @Nullable EditorDesignSurface surface2) {
        if (url == null) {
            HtmlLinkManager.$$$reportNull$$$0(59);
        }
        assert (url.equals(URL_ACTION_IGNORE_FRAGMENTS));
        RenderLogger.ignoreFragments();
        HtmlLinkManager.requestRender(surface2);
    }

    public String createEditAttributeUrl(String attribute, String value2) {
        return URL_EDIT_ATTRIBUTE + attribute + "/" + value2;
    }

    private static void handleEditAttribute(@NotNull String url, @NotNull Module module2, @NotNull PsiFile file2) {
        if (url == null) {
            HtmlLinkManager.$$$reportNull$$$0(60);
        }
        if (module2 == null) {
            HtmlLinkManager.$$$reportNull$$$0(61);
        }
        if (file2 == null) {
            HtmlLinkManager.$$$reportNull$$$0(62);
        }
        assert (url.startsWith(URL_EDIT_ATTRIBUTE));
        int attributeStart = URL_EDIT_ATTRIBUTE.length();
        int valueStart = url.indexOf(47);
        String attributeName = url.substring(attributeStart, valueStart);
        String value2 = url.substring(valueStart + 1);
        XmlAttribute first = (XmlAttribute)ApplicationManager.getApplication().runReadAction(() -> {
            Collection attributes = PsiTreeUtil.findChildrenOfType((PsiElement)file2, XmlAttribute.class);
            for (XmlAttribute attribute : attributes) {
                if (!attributeName.equals(attribute.getLocalName()) || !value2.equals(attribute.getValue())) continue;
                return attribute;
            }
            return null;
        });
        if (first != null) {
            PsiNavigateUtil.navigate((PsiElement)first.getValueElement());
        } else {
            HtmlLinkManager.openEditor(module2.getProject(), file2, 0, -1);
        }
    }

    public String createReplaceAttributeValueUrl(String attribute, String oldValue, String newValue) {
        return URL_REPLACE_ATTRIBUTE_VALUE + attribute + "/" + oldValue + "/" + newValue;
    }

    private static void handleReplaceAttributeValue(@NotNull String url, @NotNull Module module2, @NotNull PsiFile file2) {
        if (url == null) {
            HtmlLinkManager.$$$reportNull$$$0(63);
        }
        if (module2 == null) {
            HtmlLinkManager.$$$reportNull$$$0(64);
        }
        if (file2 == null) {
            HtmlLinkManager.$$$reportNull$$$0(65);
        }
        assert (url.startsWith(URL_REPLACE_ATTRIBUTE_VALUE));
        int attributeStart = URL_REPLACE_ATTRIBUTE_VALUE.length();
        int valueStart = url.indexOf(47);
        int newValueStart = url.indexOf(47, valueStart + 1);
        String attributeName = url.substring(attributeStart, valueStart);
        String oldValue = url.substring(valueStart + 1, newValueStart);
        String newValue = url.substring(newValueStart + 1);
        WriteCommandAction.writeCommandAction((Project)module2.getProject(), (PsiFile[])new PsiFile[]{file2}).withName("Set Attribute Value").run(() -> {
            Collection attributes = PsiTreeUtil.findChildrenOfType((PsiElement)file2, XmlAttribute.class);
            int oldValueLen = oldValue.length();
            for (XmlAttribute attribute : attributes) {
                Object attributeValue;
                if (!attributeName.equals(attribute.getLocalName()) || (attributeValue = attribute.getValue()) == null) continue;
                if (oldValue.equals(attributeValue)) {
                    attribute.setValue(newValue);
                    continue;
                }
                int index2 = ((String)attributeValue).indexOf(oldValue);
                if (index2 == -1 || index2 != 0 && ((String)attributeValue).charAt(index2 - 1) != '|' || index2 + oldValueLen != ((String)attributeValue).length() && ((String)attributeValue).charAt(index2 + oldValueLen) != '|') continue;
                attributeValue = ((String)attributeValue).substring(0, index2) + newValue + ((String)attributeValue).substring(index2 + oldValueLen);
                attribute.setValue((String)attributeValue);
            }
        });
    }

    public String createDisableSandboxUrl() {
        return URL_DISABLE_SANDBOX;
    }

    private static void handleDisableSandboxUrl(@NotNull Module module2, @Nullable EditorDesignSurface surface2) {
        if (module2 == null) {
            HtmlLinkManager.$$$reportNull$$$0(66);
        }
        RenderSecurityManager.sEnabled = false;
        HtmlLinkManager.requestRender(surface2);
        Messages.showInfoMessage((Project)module2.getProject(), (String)"The custom view rendering sandbox was disabled for this session.\n\nYou can turn it off permanently by adding\nandroid.render.sandbox=false\nto {install}/bin/idea.properties.", (String)"Disabled Rendering Sandbox");
    }

    public String createRefreshRenderUrl() {
        return URL_REFRESH_RENDER;
    }

    public String createClearCacheUrl() {
        return URL_CLEAR_CACHE_AND_NOTIFY;
    }

    private static void handleRefreshRenderUrl(@Nullable EditorDesignSurface surface2) {
        if (surface2 != null) {
            RenderUtils.clearCache(surface2.getConfigurations());
        }
    }

    private static void requestRender(@Nullable EditorDesignSurface surface2) {
        if (surface2 != null) {
            surface2.forceUserRequestedRefresh();
        }
    }

    public String createAddDependencyUrl(GoogleMavenArtifactId artifactId) {
        return URL_ADD_DEPENDENCY + artifactId;
    }

    @VisibleForTesting
    static void handleAddDependency(@NotNull String url, @NotNull Module module2) {
        if (url == null) {
            HtmlLinkManager.$$$reportNull$$$0(67);
        }
        if (module2 == null) {
            HtmlLinkManager.$$$reportNull$$$0(68);
        }
        assert (url.startsWith(URL_ADD_DEPENDENCY)) : url;
        String coordinateStr = url.substring(URL_ADD_DEPENDENCY.length());
        GradleCoordinate coordinate = GradleCoordinate.parseCoordinateString((String)(coordinateStr + ":+"));
        if (coordinate == null) {
            Logger.getInstance(HtmlLinkManager.class).warn("Invalid coordinate " + coordinateStr);
            return;
        }
        if (DependencyManagementUtil.addDependencies(module2, Collections.singletonList(coordinate), false, false).isEmpty()) {
            return;
        }
        Logger.getInstance(HtmlLinkManager.class).warn("Could not add dependency " + coordinate);
    }

    @NotNull
    public String createEnableLayoutlibNativeUrl() {
        return URL_ENABLE_LAYOUTLIB_NATIVE;
    }

    @NotNull
    public String createDisableLayoutlibNativeUrl() {
        return URL_DISABLE_LAYOUTLIB_NATIVE;
    }

    private static void handleEnableLayoutlibNative(boolean enable) {
        LayoutEditorEvent.Builder eventBuilder = LayoutEditorEvent.newBuilder();
        if (enable) {
            eventBuilder.setType(LayoutEditorEvent.LayoutEditorEventType.ENABLE_LAYOUTLIB_NATIVE);
            PluginManagerCore.enablePlugin((String)"com.android.layoutlib.native");
        } else {
            eventBuilder.setType(LayoutEditorEvent.LayoutEditorEventType.DISABLE_LAYOUTLIB_NATIVE);
            PluginManagerCore.enablePlugin((String)"com.android.layoutlib.standard");
            PluginManagerCore.disablePlugin((String)"com.android.layoutlib.native");
        }
        AndroidStudioEvent.Builder studioEvent = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.LAYOUT_EDITOR).setKind(AndroidStudioEvent.EventKind.LAYOUT_EDITOR_EVENT).setLayoutEditorEvent(eventBuilder.build());
        UsageTracker.log((AndroidStudioEvent.Builder)studioEvent);
        PluginManagerConfigurable.shutdownOrRestartApp();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 22: 
            case 25: 
            case 30: 
            case 43: 
            case 49: 
            case 59: 
            case 60: 
            case 63: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: 
            case 9: 
            case 21: 
            case 24: 
            case 35: 
            case 39: 
            case 45: 
            case 51: 
            case 53: 
            case 56: 
            case 62: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 8: 
            case 15: 
            case 18: 
            case 20: 
            case 23: 
            case 26: 
            case 31: 
            case 40: 
            case 44: 
            case 50: 
            case 52: 
            case 61: 
            case 64: 
            case 66: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 11: 
            case 13: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqcn";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/HtmlLinkManager";
                break;
            }
            case 46: 
            case 47: 
            case 54: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activityName";
                break;
            }
            case 48: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/HtmlLinkManager";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getFragmentClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showNotification";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "handleUrl";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createFilePositionUrl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleFileUrl";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLink";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createRunnableLink";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleReplaceTagsUrl";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "handleBuildProjectUrl";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "handleSyncProjectUrl";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "handleEditClassPathUrl";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createOpenClassUrl";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "handleOpenClassUrl";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "handleShowXmlUrl";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "handleShowTagUrl";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "handleNewClassUrl";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createOpenStackUrl";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "handleOpenStackUrl";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "openEditor";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getFragmentClass";
                break;
            }
            case 42: {
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "handleAssignFragmentUrl";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createPickLayoutUrl";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createAssignLayoutUrl";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "handleAssignLayoutUrl";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "pickLayout";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "assignLayout";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "handleIgnoreFragments";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "handleEditAttribute";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "handleReplaceAttributeValue";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "handleDisableSandboxUrl";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "handleAddDependency";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static abstract class CommandLink
    implements Runnable {
        private final String myCommandName;
        private final PsiFile myFile;

        CommandLink(@NotNull String commandName, @NotNull PsiFile file2) {
            if (commandName == null) {
                CommandLink.$$$reportNull$$$0(0);
            }
            if (file2 == null) {
                CommandLink.$$$reportNull$$$0(1);
            }
            this.myCommandName = commandName;
            this.myFile = file2;
        }

        void executeCommand() {
            WriteCommandAction.writeCommandAction((Project)this.myFile.getProject(), (PsiFile[])new PsiFile[]{this.myFile}).withName(this.myCommandName).run(() -> this.run());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "commandName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/rendering/HtmlLinkManager$CommandLink";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

