/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.rendering.GutterIconCache;
import com.android.tools.idea.rendering.GutterIconFactory;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.tools.idea.ui.resourcechooser.common.ResourcePickerSources;
import com.android.tools.idea.ui.resourcechooser.util.ResourceChooserHelperKt;
import com.android.tools.idea.util.FileExtensions;
import com.android.utils.HashCodes;
import com.android.utils.SdkUtils;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Consumer;
import com.intellij.util.ui.EmptyIcon;
import icons.StudioIcons;
import java.awt.MouseInfo;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.android.AndroidAnnotatorUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GutterIconRenderer
extends com.intellij.openapi.editor.markup.GutterIconRenderer
implements DumbAware {
    private static final int PREVIEW_MAX_WIDTH = JBUIScale.scale((int)128);
    private static final int PREVIEW_MAX_HEIGHT = JBUIScale.scale((int)128);
    private static final String PREVIEW_TEXT = "Click Image to Open Resource";
    @NotNull
    private final ResourceResolver myResourceResolver;
    @NotNull
    private final AndroidFacet myFacet;
    @Nullable
    private final VirtualFile myFile;
    @NotNull
    private final Configuration myConfiguration;
    @NotNull
    private final Boolean myEditingXmlFile;
    @NotNull
    private final Consumer<String> myAttributeTask;
    private static final String SET_RESOURCE_COMMAND_NAME = "Resource picked";

    public GutterIconRenderer(@NotNull PsiElement element2, @NotNull ResourceResolver resourceResolver2, @NotNull AndroidFacet facet2, @Nullable VirtualFile file2, @NotNull Configuration configuration) {
        if (element2 == null) {
            GutterIconRenderer.$$$reportNull$$$0(0);
        }
        if (resourceResolver2 == null) {
            GutterIconRenderer.$$$reportNull$$$0(1);
        }
        if (facet2 == null) {
            GutterIconRenderer.$$$reportNull$$$0(2);
        }
        if (configuration == null) {
            GutterIconRenderer.$$$reportNull$$$0(3);
        }
        this.myResourceResolver = resourceResolver2;
        this.myFacet = facet2;
        this.myFile = file2;
        this.myConfiguration = configuration;
        this.myEditingXmlFile = ((PsiFile)ReadAction.compute(() -> ((PsiElement)element2).getContainingFile())).getFileType() == XmlFileType.INSTANCE;
        this.myAttributeTask = new AndroidAnnotatorUtil.SetAttributeConsumer(element2, ResourceType.DRAWABLE);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon2 = this.myFile != null ? GutterIconCache.getInstance().getIcon(this.myFile, (RenderResources)this.myResourceResolver, this.myFacet) : StudioIcons.LayoutEditor.Properties.IMAGE_PICKER;
        Icon icon3 = icon2 == null ? EmptyIcon.ICON_0 : icon2;
        if (icon3 == null) {
            GutterIconRenderer.$$$reportNull$$$0(4);
        }
        return icon3;
    }

    @Nullable
    public AnAction getClickAction() {
        return new GutterIconClickAction(this.myFile, this.myResourceResolver, this.myFacet, this.myConfiguration);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GutterIconRenderer that = (GutterIconRenderer)((Object)o);
        if (!this.myFacet.equals((Object)that.myFacet)) {
            return false;
        }
        return Objects.equals(this.myFile, that.myFile);
    }

    public int hashCode() {
        return HashCodes.mix((int)this.myFacet.hashCode(), (int)Objects.hashCode(this.myFile));
    }

    private void setAttribute(@NotNull String attributeString) {
        if (attributeString == null) {
            GutterIconRenderer.$$$reportNull$$$0(5);
        }
        Project project = this.myFacet.getModule().getProject();
        ApplicationManager.getApplication().invokeLater(() -> WriteCommandAction.runWriteCommandAction((Project)project, (String)SET_RESOURCE_COMMAND_NAME, null, () -> this.myAttributeTask.consume((Object)attributeString), (PsiFile[])new PsiFile[0]), project.getDisposed());
    }

    private static void openImageResourceTab(@NotNull Project project, @NotNull VirtualFile navigationTarget) {
        if (project == null) {
            GutterIconRenderer.$$$reportNull$$$0(6);
        }
        if (navigationTarget == null) {
            GutterIconRenderer.$$$reportNull$$$0(7);
        }
        OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project, navigationTarget, -1);
        FileEditorManager.getInstance((Project)project).openEditor(descriptor2, true);
    }

    @NotNull
    private static PathString getResourcesRoot(@NotNull IAndroidTarget target) {
        String targetResources;
        if (target == null) {
            GutterIconRenderer.$$$reportNull$$$0(8);
        }
        if (SdkUtils.endsWithIgnoreCase((String)(targetResources = target.getPath(11)), (String)".jar")) {
            return new PathString("jar", targetResources + "!/");
        }
        PathString pathString = new PathString("file", targetResources).getParentOrRoot();
        if (pathString == null) {
            GutterIconRenderer.$$$reportNull$$$0(9);
        }
        return pathString;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceResolver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/GutterIconRenderer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeString";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigationTarget";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/GutterIconRenderer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourcesRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setAttribute";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "openImageResourceTab";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getResourcesRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    public static interface NavigationTargetProvider {
        @Nullable
        public VirtualFile getNavigationTarget();
    }

    private class GutterIconClickAction
    extends AnAction
    implements NavigationTargetProvider {
        @Nullable
        private final VirtualFile myFile;
        @NotNull
        private final ResourceResolver myResourceResolver;
        @NotNull
        private final AndroidFacet myFacet;
        @NotNull
        private final Configuration myConfiguration;
        @Nullable
        private VirtualFile myNavigationTarget;
        private boolean myNavigationTargetComputed;

        private GutterIconClickAction(@NotNull VirtualFile file2, @NotNull ResourceResolver resourceResolver2, @NotNull AndroidFacet facet2, Configuration configuration) {
            if (resourceResolver2 == null) {
                GutterIconClickAction.$$$reportNull$$$0(0);
            }
            if (facet2 == null) {
                GutterIconClickAction.$$$reportNull$$$0(1);
            }
            if (configuration == null) {
                GutterIconClickAction.$$$reportNull$$$0(2);
            }
            this.myFile = file2;
            this.myResourceResolver = resourceResolver2;
            this.myFacet = facet2;
            this.myConfiguration = configuration;
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            Editor editor2;
            if (event == null) {
                GutterIconClickAction.$$$reportNull$$$0(3);
            }
            if ((editor2 = (Editor)event.getData(CommonDataKeys.EDITOR)) == null) {
                return;
            }
            Project project = editor2.getProject();
            if (project == null) {
                return;
            }
            if (((Boolean)StudioFlags.NELE_DRAWABLE_POPUP_PICKER.get()).booleanValue()) {
                ArrayList<ResourcePickerSources> pickerSources = new ArrayList<ResourcePickerSources>();
                pickerSources.add(ResourcePickerSources.PROJECT);
                pickerSources.add(ResourcePickerSources.ANDROID);
                pickerSources.add(ResourcePickerSources.LIBRARY);
                if (GutterIconRenderer.this.myEditingXmlFile.booleanValue()) {
                    pickerSources.add(ResourcePickerSources.THEME_ATTR);
                }
                ResourceChooserHelperKt.createAndShowResourcePickerPopup(ResourceType.DRAWABLE, this.myConfiguration, this.myFacet, pickerSources, MouseInfo.getPointerInfo().getLocation(), (Function1<? super String, Unit>)((Function1)resourceReference -> {
                    GutterIconRenderer.this.setAttribute((String)resourceReference);
                    return null;
                }));
            } else {
                VirtualFile navigationTarget = this.getNavigationTarget();
                Runnable onClick = navigationTarget == null ? null : () -> GutterIconRenderer.openImageResourceTab(project, navigationTarget);
                JBPopup preview = this.createPreview(onClick);
                if (preview != null) {
                    preview.show(new RelativePoint((MouseEvent)event.getInputEvent()));
                } else if (navigationTarget != null) {
                    GutterIconRenderer.openImageResourceTab(project, navigationTarget);
                }
            }
        }

        @Nullable
        private JBPopup createPreview(final @Nullable Runnable onClick) {
            if (this.myFile == null) {
                return null;
            }
            Icon icon2 = GutterIconFactory.createIcon(this.myFile, (RenderResources)this.myResourceResolver, PREVIEW_MAX_WIDTH, PREVIEW_MAX_HEIGHT, this.myFacet);
            if (icon2 == null) {
                return null;
            }
            final JBLabel label = new JBLabel(icon2);
            ComponentPopupBuilder builder2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)label, null);
            if (onClick != null) {
                builder2.setAdText(GutterIconRenderer.PREVIEW_TEXT, 0);
            }
            final JBPopup popup2 = builder2.createPopup();
            if (onClick != null) {
                label.addMouseListener((MouseListener)new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        onClick.run();
                        popup2.cancel();
                        label.removeMouseListener((MouseListener)this);
                    }
                });
            }
            return popup2;
        }

        @Override
        @VisibleForTesting
        @Nullable
        public VirtualFile getNavigationTarget() {
            if (!this.myNavigationTargetComputed && this.myFile != null) {
                IAndroidTarget target = this.myConfiguration.getTarget();
                if (target instanceof CompatibilityRenderTarget) {
                    PathString renderResourcesRoot = GutterIconRenderer.getResourcesRoot(target);
                    PathString path2 = FileExtensions.toPathString(this.myFile);
                    if (path2.startsWith(renderResourcesRoot)) {
                        PathString resourcesRoot;
                        VirtualFile file2;
                        IAndroidTarget projectTarget = ConfigurationManager.getOrCreateInstance(this.myFacet).getProjectTarget();
                        if (projectTarget != null && (file2 = FileExtensions.toVirtualFile(path2 = (resourcesRoot = GutterIconRenderer.getResourcesRoot(projectTarget)).resolve(renderResourcesRoot.relativize(path2)))) != null && file2.exists()) {
                            this.myNavigationTarget = file2;
                        }
                    } else {
                        this.myNavigationTarget = this.myFile;
                    }
                }
                this.myNavigationTargetComputed = true;
            }
            return this.myNavigationTarget;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resourceResolver";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "facet";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/rendering/GutterIconRenderer$GutterIconClickAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

