/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.vectordrawable.VdPreview;
import com.android.resources.ResourceUrl;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.rendering.DrawableRenderer;
import com.android.tools.idea.rendering.GutterIconCache;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.utils.XmlUtils;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.Gray;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class GutterIconFactory {
    private static final Logger LOG = Logger.getInstance(GutterIconCache.class);
    private static final int RENDERING_SCALING_FACTOR = 10;

    @Nullable
    public static Icon createIcon(@NotNull VirtualFile file2, @Nullable RenderResources resolver, int maxWidth, int maxHeight, @NotNull AndroidFacet facet2) {
        String path2;
        if (file2 == null) {
            GutterIconFactory.$$$reportNull$$$0(0);
        }
        if (facet2 == null) {
            GutterIconFactory.$$$reportNull$$$0(1);
        }
        if ((path2 = file2.getPath()).endsWith(".xml")) {
            return GutterIconFactory.createXmlIcon(file2, resolver, maxWidth, maxHeight, facet2);
        }
        return GutterIconFactory.createBitmapIcon(file2, maxWidth, maxHeight);
    }

    @NotNull
    private static String getXmlContent(@NotNull VirtualFile file2) throws IOException {
        Document document;
        if (file2 == null) {
            GutterIconFactory.$$$reportNull$$$0(2);
        }
        if ((document = FileDocumentManager.getInstance().getCachedDocument(file2)) == null) {
            return new String(file2.contentsToByteArray());
        }
        String string = document.getText();
        if (string == null) {
            GutterIconFactory.$$$reportNull$$$0(3);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Icon createXmlIcon(@NotNull VirtualFile file2, @Nullable RenderResources resolver, int maxWidth, int maxHeight, @NotNull AndroidFacet facet2) {
        if (file2 == null) {
            GutterIconFactory.$$$reportNull$$$0(4);
        }
        if (facet2 == null) {
            GutterIconFactory.$$$reportNull$$$0(5);
        }
        try {
            RetinaImageIcon retinaIcon;
            BufferedImage image;
            String xml = GutterIconFactory.getXmlContent(file2);
            if (xml.contains("<vector")) {
                VdPreview.TargetSize imageTargetSize = VdPreview.TargetSize.createFromMaxDimension((int)(GutterIconFactory.isRetinaEnabled() ? 2 * maxWidth : maxWidth));
                org.w3c.dom.Document document = XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
                if (document == null) {
                    return null;
                }
                Element root2 = document.getDocumentElement();
                if (root2 == null) {
                    return null;
                }
                if (resolver != null) {
                    GutterIconFactory.replaceResourceReferences(root2, resolver);
                }
                StringBuilder builder2 = new StringBuilder(100);
                image = VdPreview.getPreviewFromVectorDocument((VdPreview.TargetSize)imageTargetSize, (org.w3c.dom.Document)document, (StringBuilder)builder2);
                if (builder2.length() > 0) {
                    LOG.warn("Problems rendering " + file2.getPresentableUrl() + ": " + builder2);
                }
            } else {
                Configuration configuration = ConfigurationManager.getOrCreateInstance(facet2).getConfiguration(file2);
                DrawableRenderer renderer2 = new DrawableRenderer(facet2, configuration);
                Dimension size = new Dimension(maxWidth * 10, maxHeight * 10);
                try {
                    CompletableFuture<BufferedImage> imageFuture = renderer2.renderDrawable(xml, size);
                    image = ApplicationManager.getApplication().isDispatchThread() && !ApplicationManager.getApplication().isUnitTestMode() ? imageFuture.get(250L, TimeUnit.MILLISECONDS) : imageFuture.get();
                }
                catch (Throwable e) {
                    LOG.debug(String.format("Could not read/render icon image %1$s", file2.getPresentableUrl()), e);
                    image = null;
                }
                finally {
                    Disposer.dispose((Disposable)renderer2);
                }
                if (image == null) {
                    return null;
                }
                image = ImageUtils.scale((BufferedImage)image, (double)((double)maxWidth / (double)image.getWidth()), (double)((double)maxHeight / (double)image.getHeight()));
            }
            if (GutterIconFactory.isRetinaEnabled() && (retinaIcon = GutterIconFactory.getRetinaIcon(image)) != null) {
                return retinaIcon;
            }
            return new ImageIcon(image);
        }
        catch (Throwable e) {
            LOG.warn(String.format("Could not read/render icon image %1$s", file2.getPresentableUrl()), e);
            return null;
        }
    }

    private static boolean isRetinaEnabled() {
        return UIUtil.isRetina();
    }

    @VisibleForTesting
    static boolean isReference(String attributeValue) {
        return ResourceUrl.parse((String)attributeValue) != null;
    }

    @VisibleForTesting
    static void replaceResourceReferences(@NotNull Node node2, @NotNull RenderResources resolver) {
        if (node2 == null) {
            GutterIconFactory.$$$reportNull$$$0(6);
        }
        if (resolver == null) {
            GutterIconFactory.$$$reportNull$$$0(7);
        }
        if (node2.getNodeType() == 1) {
            Element element2 = (Element)node2;
            NamedNodeMap attributes = element2.getAttributes();
            int n = attributes.getLength();
            for (int i2 = 0; i2 < n; ++i2) {
                String resolvedValue;
                Node attribute = attributes.item(i2);
                String value2 = attribute.getNodeValue();
                if (!GutterIconFactory.isReference(value2) || GutterIconFactory.isReference(resolvedValue = IdeResourcesUtil.resolveStringValue(resolver, value2))) continue;
                attribute.setNodeValue(resolvedValue);
            }
        }
        for (node2 = node2.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            GutterIconFactory.replaceResourceReferences(node2, resolver);
        }
    }

    @Nullable
    private static Icon createBitmapIcon(@NotNull VirtualFile file2, int maxWidth, int maxHeight) {
        Icon icon2;
        block9: {
            if (file2 == null) {
                GutterIconFactory.$$$reportNull$$$0(8);
            }
            InputStream stream = file2.getInputStream();
            try {
                icon2 = GutterIconFactory.createBitmapIcon(ImageIO.read(stream), maxWidth, maxHeight);
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.warn(String.format("Could not read icon image %1$s", file2.getPresentableUrl()), (Throwable)e);
                    return null;
                }
            }
            stream.close();
        }
        return icon2;
    }

    @Nullable
    private static Icon createBitmapIcon(BufferedImage image, int maxWidth, int maxHeight) {
        if (image != null) {
            double scale;
            BufferedImage scaled;
            RetinaImageIcon retinaIcon;
            int imageWidth = image.getWidth();
            int imageHeight = image.getHeight();
            if (GutterIconFactory.isRetinaEnabled() && (imageWidth > 2 * maxWidth || imageHeight > 2 * maxHeight) && (retinaIcon = GutterIconFactory.getRetinaIcon(scaled = ImageUtils.scale((BufferedImage)image, (double)(scale = 2.0 * Math.min((double)maxWidth / (double)imageWidth, (double)maxHeight / (double)imageHeight)), (double)scale))) != null) {
                return retinaIcon;
            }
            if (imageWidth > maxWidth || imageHeight > maxHeight) {
                scale = Math.min((double)maxWidth / (double)imageWidth, (double)maxHeight / (double)imageHeight);
                if (image.getType() == 13) {
                    BufferedImage bg = ImageUtil.createImage((int)imageWidth, (int)imageHeight, (int)2);
                    Graphics g = bg.getGraphics();
                    g.setColor(Gray.TRANSPARENT);
                    g.fillRect(0, 0, bg.getWidth(), bg.getHeight());
                    StartupUiUtil.drawImage((Graphics)g, (Image)image, (int)0, (int)0, null);
                    g.dispose();
                    image = bg;
                }
                image = ImageUtils.scale((BufferedImage)image, (double)scale, (double)scale);
            }
            return new ImageIcon(image);
        }
        return null;
    }

    @Nullable
    private static RetinaImageIcon getRetinaIcon(@NotNull BufferedImage image) {
        BufferedImage hdpiImage;
        if (image == null) {
            GutterIconFactory.$$$reportNull$$$0(9);
        }
        if (GutterIconFactory.isRetinaEnabled() && (hdpiImage = ImageUtils.convertToRetina((BufferedImage)image)) != null) {
            return new RetinaImageIcon(hdpiImage);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/GutterIconFactory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/GutterIconFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getXmlContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createIcon";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getXmlContent";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createXmlIcon";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "replaceResourceReferences";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createBitmapIcon";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRetinaIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RetinaImageIcon
    extends ImageIcon {
        private RetinaImageIcon(Image image) {
            super(image, "");
        }

        @Override
        public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
            UIUtil.drawImage((Graphics)g, (Image)this.getImage(), (int)x, (int)y, null);
        }
    }
}

