/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.refactoring.modularize;

import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.refactoring.modularize.AndroidCodeAndResourcesGraph;
import com.android.tools.idea.refactoring.modularize.AndroidModularizePreviewPanel;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.XmlRecursiveElementWalkingVisitor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.android.AndroidFileTemplateProvider;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.facet.SourceProviderManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidModularizeProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOGGER = Logger.getInstance(AndroidModularizeProcessor.class);
    private final PsiElement[] myRoots;
    private final Set<PsiClass> myClasses;
    private final Set<ResourceItem> myResources;
    private final Set<PsiElement> myManifestEntries;
    private final AndroidCodeAndResourcesGraph myReferenceGraph;
    private Module myTargetModule;
    private boolean myShouldSelectAllReferences;

    protected AndroidModularizeProcessor(@NotNull Project project, @NotNull PsiElement[] roots, @NotNull Set<PsiClass> classes2, @NotNull Set<ResourceItem> resources, @NotNull Set<PsiElement> manifestEntries, @NotNull AndroidCodeAndResourcesGraph referenceGraph) {
        if (project == null) {
            AndroidModularizeProcessor.$$$reportNull$$$0(0);
        }
        if (classes2 == null) {
            AndroidModularizeProcessor.$$$reportNull$$$0(1);
        }
        if (resources == null) {
            AndroidModularizeProcessor.$$$reportNull$$$0(2);
        }
        if (manifestEntries == null) {
            AndroidModularizeProcessor.$$$reportNull$$$0(3);
        }
        if (referenceGraph == null) {
            AndroidModularizeProcessor.$$$reportNull$$$0(4);
        }
        if (roots == null) {
            AndroidModularizeProcessor.$$$reportNull$$$0(5);
        }
        super(project);
        this.myRoots = roots;
        this.myClasses = classes2;
        this.myResources = resources;
        this.myManifestEntries = manifestEntries;
        this.myReferenceGraph = referenceGraph;
    }

    public void setTargetModule(@NotNull Module module2) {
        if (module2 == null) {
            AndroidModularizeProcessor.$$$reportNull$$$0(6);
        }
        this.myTargetModule = module2;
        this.myShouldSelectAllReferences = true;
        for (PsiElement root2 : this.myRoots) {
            AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)root2);
            if (facet2 == null || AndroidModularizeProcessor.collectModulesClosure(facet2.getModule(), new HashSet<Module>()).contains(this.myTargetModule)) continue;
            this.myShouldSelectAllReferences = false;
            break;
        }
    }

    private static Set<Module> collectModulesClosure(@NotNull Module module2, Set<Module> result2) {
        if (module2 == null) {
            AndroidModularizeProcessor.$$$reportNull$$$0(7);
        }
        if (result2.add(module2)) {
            for (Module depModule : ModuleRootManager.getInstance((Module)module2).getDependencies()) {
                AndroidModularizeProcessor.collectModulesClosure(depModule, result2);
            }
        }
        return result2;
    }

    public int getClassesCount() {
        return this.myClasses.size();
    }

    public int getResourcesCount() {
        return this.myResources.size();
    }

    @VisibleForTesting
    AndroidCodeAndResourcesGraph getReferenceGraph() {
        return this.myReferenceGraph;
    }

    @VisibleForTesting
    boolean shouldSelectAllReferences() {
        return this.myShouldSelectAllReferences;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(final @NotNull UsageInfo[] usages) {
        if (usages == null) {
            AndroidModularizeProcessor.$$$reportNull$$$0(8);
        }
        return new UsageViewDescriptor(){

            @NotNull
            public PsiElement[] getElements() {
                PsiElement[] result2 = new PsiElement[usages.length];
                for (int i2 = 0; i2 < usages.length; ++i2) {
                    result2[i2] = usages[i2].getElement();
                }
                if (result2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return result2;
            }

            public String getProcessedElementsHeader() {
                return "Items to be moved";
            }

            public String getCodeReferencesText(int usagesCount, int filesCount) {
                return String.format(Locale.US, "%1$d resources in %2$d files", usagesCount, filesCount);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/refactoring/modularize/AndroidModularizeProcessor$1", "getElements"));
            }
        };
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        ArrayList<UsageInfo> result2 = new ArrayList<UsageInfo>();
        for (PsiElement psiElement : this.myClasses) {
            result2.add(new UsageInfo(psiElement));
        }
        for (PsiElement psiElement : this.myManifestEntries) {
            result2.add(new UsageInfo(psiElement));
        }
        for (ResourceItem resourceItem : this.myResources) {
            PsiFile psiFile2 = IdeResourcesUtil.getItemPsiFile(this.myProject, resourceItem);
            if (IdeResourcesUtil.getFolderType(psiFile2) == ResourceFolderType.VALUES) {
                XmlTag xmlTag = IdeResourcesUtil.getItemTag(this.myProject, resourceItem);
                if (xmlTag == null) continue;
                result2.add(new ResourceXmlUsageInfo((PsiElement)xmlTag, resourceItem));
                continue;
            }
            if (psiFile2 instanceof PsiBinaryFile) {
                SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)this.myProject);
                SmartPsiElementPointer smartPointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)psiFile2);
                SmartPsiFileRange smartFileRange = smartPointerManager.createSmartPsiFileRangePointer(psiFile2, TextRange.EMPTY_RANGE);
                result2.add(new ResourceXmlUsageInfo(smartPointer, smartFileRange, resourceItem){

                    public boolean isValid() {
                        return true;
                    }

                    @Nullable
                    public Segment getSegment() {
                        return null;
                    }
                });
                continue;
            }
            if (psiFile2 == null) continue;
            result2.add(new ResourceXmlUsageInfo((PsiElement)psiFile2, resourceItem));
        }
        UsageInfo[] usageInfoArray = UsageViewUtil.removeDuplicatedUsages((UsageInfo[])result2.toArray(UsageInfo.EMPTY_ARRAY));
        if (usageInfoArray == null) {
            AndroidModularizeProcessor.$$$reportNull$$$0(9);
        }
        return usageInfoArray;
    }

    protected void previewRefactoring(@NotNull UsageInfo[] usages) {
        PreviewDialog previewDialog;
        if (usages == null) {
            AndroidModularizeProcessor.$$$reportNull$$$0(10);
        }
        if ((previewDialog = new PreviewDialog(this.myProject, this.myReferenceGraph, usages, this.myShouldSelectAllReferences)).showAndGet()) {
            this.execute(previewDialog.getSelectedUsages());
        }
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            AndroidModularizeProcessor.$$$reportNull$$$0(11);
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)this.myTargetModule);
        assert (facet2 != null);
        Iterable<VirtualFile> javaSourceFolders = SourceProviderManager.getInstance(facet2).getSources().getJavaDirectories();
        VirtualFile javaTargetDir = (VirtualFile)Iterables.getFirst(javaSourceFolders, null);
        VirtualFile resDir = ResourceFolderManager.getInstance(facet2).getFolders().get(0);
        ResourceFolderRepository repo = ResourceFolderRegistry.getInstance(this.myProject).get(facet2, resDir);
        final HashSet<XmlFile> touchedXmlFiles = new HashSet<XmlFile>();
        for (UsageInfo usage : usages) {
            final PsiElement element2 = usage.getElement();
            if (usage instanceof ResourceXmlUsageInfo) {
                XmlTag rootTag;
                XmlFile resourceFile;
                ResourceItem resource = ((ResourceXmlUsageInfo)usage).getResourceItem();
                if (element2 instanceof PsiFile) {
                    PsiDirectory targetDir = this.getOrCreateTargetDirectory(repo, resource);
                    if (targetDir == null || targetDir.findFile(((PsiFile)element2).getName()) != null) continue;
                    MoveFilesOrDirectoriesUtil.doMoveFile((PsiFile)((PsiFile)element2), (PsiDirectory)targetDir);
                    continue;
                }
                if (!(element2 instanceof XmlTag) || (resourceFile = (XmlFile)this.getOrCreateTargetValueFile(repo, resource)) == null || (rootTag = resourceFile.getRootTag()) == null || !"resources".equals(rootTag.getName())) continue;
                rootTag.addSubTag((XmlTag)element2.copy(), false);
                element2.delete();
                touchedXmlFiles.add(resourceFile);
                continue;
            }
            if (element2 instanceof XmlTag) {
                final XmlFile manifest = (XmlFile)this.getOrCreateTargetManifestFile(facet2);
                if (manifest == null) continue;
                manifest.acceptChildren((PsiElementVisitor)new XmlRecursiveElementWalkingVisitor(){

                    public void visitXmlTag(XmlTag tag) {
                        if ("manifest".equals(tag.getName())) {
                            XmlTag applicationTag = null;
                            for (PsiElement child : tag.getChildren()) {
                                if (!(child instanceof XmlTag) || !"application".equals(((XmlTag)child).getName())) continue;
                                applicationTag = (XmlTag)child;
                                applicationTag.addSubTag((XmlTag)element2.copy(), false);
                                element2.delete();
                                break;
                            }
                            if (applicationTag == null) {
                                applicationTag = XmlElementFactory.getInstance((Project)AndroidModularizeProcessor.this.myProject).createTagFromText((CharSequence)"<application/>");
                                applicationTag.addSubTag((XmlTag)element2.copy(), false);
                                element2.delete();
                                tag.addSubTag(applicationTag, true);
                            }
                            touchedXmlFiles.add(manifest);
                        } else {
                            super.visitXmlTag(tag);
                        }
                    }
                });
                continue;
            }
            if (!(element2 instanceof PsiClass)) continue;
            String packageName = ((PsiJavaFile)element2.getContainingFile()).getPackageName();
            MoveClassesOrPackagesUtil.doMoveClass((PsiClass)((PsiClass)element2), (PsiDirectory)RefactoringUtil.createPackageDirectoryInSourceRoot((PackageWrapper)new PackageWrapper(PsiManager.getInstance((Project)this.myProject), packageName), (VirtualFile)javaTargetDir), (boolean)true);
        }
        for (XmlFile touchedFile : touchedXmlFiles) {
            CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)touchedFile);
        }
    }

    @Nullable
    private PsiDirectory getOrCreateTargetDirectory(ResourceFolderRepository base, ResourceItem resourceItem) {
        ResourceFolderType folderType;
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        PathString itemFile = resourceItem.getSource();
        if (itemFile != null && (folderType = ResourceFolderType.getFolderType((String)itemFile.getParentFileName())) != null) {
            try {
                return manager.findDirectory(VfsUtil.createDirectoryIfMissing((VirtualFile)base.getResourceDir(), (String)resourceItem.getConfiguration().getFolderName(folderType)));
            }
            catch (Exception ex) {
                LOGGER.debug((Throwable)ex);
            }
        }
        LOGGER.warn("Couldn't determine target folder for resource " + resourceItem);
        return null;
    }

    @Nullable
    private PsiFile getOrCreateTargetValueFile(ResourceFolderRepository base, ResourceItem resourceItem) {
        PathString itemFile = resourceItem.getSource();
        if (itemFile != null) {
            try {
                String name = itemFile.getFileName();
                PsiDirectory dir = this.getOrCreateTargetDirectory(base, resourceItem);
                if (dir != null) {
                    PsiFile result2 = dir.findFile(name);
                    if (result2 != null) {
                        return result2;
                    }
                    return (PsiFile)AndroidFileTemplateProvider.createFromTemplate("valueResourceFile.xml", name, dir);
                }
            }
            catch (Exception ex) {
                LOGGER.debug((Throwable)ex);
            }
        }
        LOGGER.warn("Couldn't determine target file for resource " + resourceItem);
        return null;
    }

    @Nullable
    private PsiFile getOrCreateTargetManifestFile(AndroidFacet facet2) {
        if (facet2.isDisposed()) {
            return null;
        }
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        String manifestFileUrl = (String)Iterables.getFirst(SourceProviderManager.getInstance(facet2).getSources().getManifestFileUrls(), null);
        if (manifestFileUrl != null) {
            PsiDirectory targetDirectory;
            VirtualFile directory;
            VirtualFile manifestFile = VirtualFileManager.getInstance().findFileByUrl(manifestFileUrl);
            if (manifestFile != null) {
                return manager.findFile(manifestFile);
            }
            String parentDir = VfsUtil.getParentDir((String)manifestFileUrl);
            if (parentDir != null && (directory = VirtualFileManager.getInstance().findFileByUrl(parentDir)) != null && (targetDirectory = manager.findDirectory(directory)) != null) {
                try {
                    return (PsiFile)AndroidFileTemplateProvider.createFromTemplate("AndroidManifest.xml", "AndroidManifest.xml", targetDirectory);
                }
                catch (Exception ex) {
                    LOGGER.debug((Throwable)ex);
                }
            }
        }
        LOGGER.warn("Couldn't determine manifest file for module " + this.myTargetModule);
        return null;
    }

    @NotNull
    protected String getCommandName() {
        String string = "Moving " + RefactoringUIUtil.calculatePsiElementDescriptionList((PsiElement[])this.myRoots);
        if (string == null) {
            AndroidModularizeProcessor.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resources";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manifestEntries";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceGraph";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/refactoring/modularize/AndroidModularizeProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/refactoring/modularize/AndroidModularizeProcessor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setTargetModule";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectModulesClosure";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 9: 
            case 12: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "previewRefactoring";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class PreviewDialog
    extends DialogWrapper {
        private final AndroidModularizePreviewPanel myPanel;

        protected PreviewDialog(@Nullable Project project, @NotNull AndroidCodeAndResourcesGraph graph, @NotNull UsageInfo[] infos, boolean shouldSelectAllReferences) {
            if (graph == null) {
                PreviewDialog.$$$reportNull$$$0(0);
            }
            if (infos == null) {
                PreviewDialog.$$$reportNull$$$0(1);
            }
            super(project, true);
            this.myPanel = new AndroidModularizePreviewPanel(graph, infos, shouldSelectAllReferences);
            this.setTitle("Modularize: Preview Classes and Resources to Be Moved");
            this.init();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myPanel.getPanel();
        }

        @NotNull
        public UsageInfo[] getSelectedUsages() {
            UsageInfo[] usageInfoArray = this.myPanel.getSelectedUsages();
            if (usageInfoArray == null) {
                PreviewDialog.$$$reportNull$$$0(2);
            }
            return usageInfoArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "graph";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "infos";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/refactoring/modularize/AndroidModularizeProcessor$PreviewDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/refactoring/modularize/AndroidModularizeProcessor$PreviewDialog";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelectedUsages";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ResourceXmlUsageInfo
    extends UsageInfo {
        private final ResourceItem myResourceItem;

        public ResourceXmlUsageInfo(@NotNull PsiElement element2, @NotNull ResourceItem resourceItem) {
            if (element2 == null) {
                ResourceXmlUsageInfo.$$$reportNull$$$0(0);
            }
            if (resourceItem == null) {
                ResourceXmlUsageInfo.$$$reportNull$$$0(1);
            }
            super(element2);
            this.myResourceItem = resourceItem;
        }

        public ResourceXmlUsageInfo(@NotNull SmartPsiElementPointer<?> smartPointer, @Nullable SmartPsiFileRange psiFileRange, @NotNull ResourceItem resourceItem) {
            if (smartPointer == null) {
                ResourceXmlUsageInfo.$$$reportNull$$$0(2);
            }
            if (resourceItem == null) {
                ResourceXmlUsageInfo.$$$reportNull$$$0(3);
            }
            super(smartPointer, psiFileRange, false, false);
            this.myResourceItem = resourceItem;
        }

        @NotNull
        public ResourceItem getResourceItem() {
            ResourceItem resourceItem = this.myResourceItem;
            if (resourceItem == null) {
                ResourceXmlUsageInfo.$$$reportNull$$$0(4);
            }
            return resourceItem;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resourceItem";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "smartPointer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/refactoring/modularize/AndroidModularizeProcessor$ResourceXmlUsageInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/refactoring/modularize/AndroidModularizeProcessor$ResourceXmlUsageInfo";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResourceItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

