/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.refactoring.modularize;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AndroidCodeAndResourcesGraph
implements RefactoringUtil.Graph<PsiElement> {
    private static final PsiElement SENTINEL_ROOT = new FakePsiElement(){

        public PsiElement getParent() {
            return null;
        }
    };
    private final Set<PsiElement> myRoots;
    private final Map<PsiElement, Map<PsiElement, Integer>> myGraph;
    private final Map<PsiElement, Set<PsiElement>> myReverseGraph;
    private final Set<PsiElement> myReferencedExternally;
    private final Map<PsiElement, PsiElement> myImmediateDominator;

    public AndroidCodeAndResourcesGraph(Map<PsiElement, Map<PsiElement, Integer>> graph, Set<PsiElement> roots, Set<PsiElement> referencedExternally) {
        this.myGraph = graph;
        this.myRoots = roots;
        this.myReferencedExternally = referencedExternally;
        this.myReverseGraph = Maps.newHashMapWithExpectedSize((int)graph.size());
        for (PsiElement node2 : this.myGraph.keySet()) {
            for (PsiElement succ : this.myGraph.get(node2).keySet()) {
                Set<PsiElement> predecessors = this.myReverseGraph.get(succ);
                if (predecessors == null) {
                    predecessors = new HashSet<PsiElement>();
                }
                predecessors.add(node2);
                this.myReverseGraph.put(succ, predecessors);
            }
        }
        this.myImmediateDominator = Maps.newHashMapWithExpectedSize((int)this.myGraph.size());
        for (PsiElement node2 : roots) {
            this.myImmediateDominator.put(node2, SENTINEL_ROOT);
        }
    }

    public Set<PsiElement> getVertices() {
        return this.myGraph.keySet();
    }

    public Set<PsiElement> getTargets(PsiElement source) {
        Map<PsiElement, Integer> targets = this.myGraph.get(source);
        return targets == null ? Collections.emptySet() : targets.keySet();
    }

    public Set<PsiElement> getRoots() {
        return this.myRoots;
    }

    public Set<PsiElement> getReferencedOutsideScope() {
        Stack stack = new Stack();
        HashSet<PsiElement> visited = new HashSet<PsiElement>(this.myGraph.size());
        for (PsiElement root2 : this.myReferencedExternally) {
            stack.push((Object)root2);
        }
        while (!stack.isEmpty()) {
            PsiElement current = (PsiElement)stack.pop();
            if (!visited.add(current)) continue;
            for (PsiElement succ : this.getTargets(current)) {
                stack.push((Object)succ);
            }
        }
        return visited;
    }

    public int getFrequency(PsiElement source, PsiElement target) {
        Map<PsiElement, Integer> targets = this.myGraph.get(source);
        if (targets == null) {
            return 0;
        }
        return targets.getOrDefault(target, 0);
    }

    public Map<PsiElement, PsiElement> computeDominators() {
        List<PsiElement> sorted2 = this.computeTopologicalSort();
        boolean changed = true;
        while (changed) {
            changed = false;
            for (PsiElement node2 : sorted2) {
                if (this.myImmediateDominator.get(node2) == SENTINEL_ROOT) continue;
                PsiElement dominator = null;
                for (PsiElement predecessor : this.myReverseGraph.get(node2)) {
                    if (this.myImmediateDominator.get(predecessor) == null) continue;
                    if (dominator == null) {
                        dominator = predecessor;
                        continue;
                    }
                    PsiElement fingerA = dominator;
                    PsiElement fingerB = predecessor;
                    while (fingerA != fingerB) {
                        if (sorted2.indexOf(fingerA) < sorted2.indexOf(fingerB)) {
                            fingerB = this.myImmediateDominator.get(fingerB);
                            continue;
                        }
                        fingerA = this.myImmediateDominator.get(fingerA);
                    }
                    dominator = fingerA;
                }
                if (this.myImmediateDominator.get(node2) == dominator) continue;
                this.myImmediateDominator.put(node2, dominator);
                changed = true;
            }
        }
        return this.myImmediateDominator;
    }

    private List<PsiElement> computeTopologicalSort() {
        Stack stack = new Stack();
        Stack head2 = new Stack();
        HashSet<PsiElement> visited = new HashSet<PsiElement>();
        ArrayList<PsiElement> sorted2 = new ArrayList<PsiElement>(this.myGraph.size());
        for (PsiElement root2 : this.myRoots) {
            stack.push((Object)root2);
        }
        while (!stack.isEmpty()) {
            PsiElement current = (PsiElement)stack.peek();
            if (!head2.isEmpty() && current == head2.peek()) {
                stack.pop();
                head2.pop();
                sorted2.add(current);
                continue;
            }
            head2.push((Object)current);
            for (PsiElement succ : this.getTargets(current)) {
                if (!visited.add(succ)) continue;
                stack.push((Object)succ);
            }
        }
        return Lists.reverse(sorted2);
    }

    public static class Builder {
        private final Set<PsiElement> myRoots = new HashSet<PsiElement>();
        private final Map<PsiElement, Map<PsiElement, Integer>> myReferenceGraph = new HashMap<PsiElement, Map<PsiElement, Integer>>();
        private final Set<PsiElement> myReferencedExternally = new HashSet<PsiElement>();

        public void markReference(PsiElement source, PsiElement target) {
            Map references = this.myReferenceGraph.computeIfAbsent(source, k -> new HashMap());
            Integer count = references.getOrDefault(target, 0);
            references.put(target, count + 1);
        }

        public void markReferencedOutsideScope(PsiElement elm) {
            if (!this.myRoots.contains(elm)) {
                this.myReferencedExternally.add(elm);
            }
        }

        public void addRoot(PsiElement root2) {
            this.myRoots.add(root2);
        }

        public AndroidCodeAndResourcesGraph build() {
            return new AndroidCodeAndResourcesGraph(this.myReferenceGraph, this.myRoots, this.myReferencedExternally);
        }
    }
}

