/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.projectsystem.gradle.sync;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.ProjectStructure;
import com.android.tools.idea.gradle.project.SupportedModuleChecker;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.idea.SdkSyncUtil;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.gradle.project.sync.idea.data.service.ModuleModelDataService;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.android.tools.idea.gradle.project.sync.setup.post.ComposeInBetaChecker;
import com.android.tools.idea.gradle.project.sync.setup.post.MemorySettingsPostSyncChecker;
import com.android.tools.idea.gradle.project.sync.setup.post.ModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectSetup;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectStructureUsageTracker;
import com.android.tools.idea.gradle.project.sync.setup.post.TimeBasedReminder;
import com.android.tools.idea.gradle.project.sync.validation.android.AndroidModuleValidator;
import com.android.tools.idea.gradle.project.upgrade.GradlePluginUpgrade;
import com.android.tools.idea.gradle.variant.conflict.ConflictSet;
import com.android.tools.idea.projectsystem.gradle.sync.AndroidModuleDataServiceKt;
import com.android.tools.idea.run.RunConfigurationChecker;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.Computable;
import com.intellij.pom.java.LanguageLevel;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u000f\b\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bH\u0016J@\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00020\u0013H\u0016J6\u0010\u0015\u001a\u00020\n2\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\r0\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0019H\u0016J8\u0010\u001a\u001a\u00020\n2\u0014\u0010\u000b\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00020\r0\u001b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016JY\u0010\u001c\u001a\u00020\n2\u0014\u0010\u001d\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u001f0\f0\u001e2\u0012\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\r0\f2\u000b\u0010\u0017\u001a\u00070\u0018\u00a2\u0006\u0002\b!2\u000b\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b!2\u000b\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b!H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/projectsystem/gradle/sync/AndroidModuleDataService;", "Lcom/android/tools/idea/gradle/project/sync/idea/data/service/ModuleModelDataService;", "Lcom/android/tools/idea/gradle/project/model/AndroidModuleModel;", "()V", "myModuleValidatorFactory", "Lcom/android/tools/idea/gradle/project/sync/validation/android/AndroidModuleValidator$Factory;", "(Lcom/android/tools/idea/gradle/project/sync/validation/android/AndroidModuleValidator$Factory;)V", "getTargetDataKey", "Lcom/intellij/openapi/externalSystem/model/Key;", "importData", "", "toImport", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "project", "Lcom/intellij/openapi/project/Project;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "modelsByModuleName", "", "", "onSuccessImport", "imported", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "Lcom/intellij/openapi/externalSystem/service/project/IdeModelsProvider;", "postProcess", "", "removeData", "toRemoveComputable", "Lcom/intellij/openapi/util/Computable;", "Lcom/intellij/openapi/module/Module;", "toIgnore", "Lorg/jetbrains/annotations/NotNull;", "intellij.android.projectSystem.gradle.sync"})
public final class AndroidModuleDataService
extends ModuleModelDataService<AndroidModuleModel> {
    private final AndroidModuleValidator.Factory myModuleValidatorFactory;

    @NotNull
    public Key<AndroidModuleModel> getTargetDataKey() {
        Key<AndroidModuleModel> key = AndroidProjectKeys.ANDROID_MODEL;
        Intrinsics.checkNotNullExpressionValue(key, (String)"ANDROID_MODEL");
        return key;
    }

    @Override
    public void importData(@NotNull Collection<? extends DataNode<AndroidModuleModel>> toImport, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Map<String, ? extends AndroidModuleModel> modelsByModuleName) {
        int n;
        Intrinsics.checkNotNullParameter(toImport, (String)"toImport");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
        Intrinsics.checkNotNullParameter(modelsByModuleName, (String)"modelsByModuleName");
        AndroidModuleValidator androidModuleValidator = this.myModuleValidatorFactory.create(project);
        Intrinsics.checkNotNullExpressionValue((Object)androidModuleValidator, (String)"myModuleValidatorFactory.create(project)");
        AndroidModuleValidator moduleValidator = androidModuleValidator;
        Module[] moduleArray = modelsProvider.getModules();
        int n2 = moduleArray.length;
        for (n = 0; n < n2; ++n) {
            Module module2;
            Module module3 = module2 = moduleArray[n];
            Intrinsics.checkNotNullExpressionValue((Object)module3, (String)"module");
            AndroidModuleModel androidModel = modelsByModuleName.get(module3.getName());
            if (androidModel == null) continue;
            AndroidFacet androidFacet = (AndroidFacet)modelsProvider.getModifiableFacetModel(module2).getFacetByType(AndroidFacet.ID);
            if (androidFacet == null) {
                androidFacet = AndroidModuleDataServiceKt.access$createAndroidFacet(module2, modelsProvider);
            }
            Intrinsics.checkNotNullExpressionValue((Object)androidFacet, (String)"modelsProvider.getModifi\u2026t(module, modelsProvider)");
            AndroidFacet androidFacet2 = androidFacet;
            androidModel.setModule(module2);
            AndroidModuleDataServiceKt.access$configureFacet(androidFacet2, androidModel);
            LanguageLevel languageLevel = androidModel.getJavaLanguageLevel();
            if (languageLevel != null) {
                Object object = modelsProvider.getModifiableRootModel(module2).getModuleExtension(LanguageLevelModuleExtension.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"modelsProvider.getModifi\u2026uleExtension::class.java)");
                ((LanguageLevelModuleExtension)object).setLanguageLevel(languageLevel);
            }
            moduleValidator.validate(module2, androidModel);
        }
        Map<String, ? extends AndroidModuleModel> map2 = modelsByModuleName;
        n = 0;
        if (!map2.isEmpty()) {
            moduleValidator.fixAndReportFoundIssues();
        }
    }

    public void removeData(@NotNull Computable<? extends Collection<? extends Module>> toRemoveComputable, @NotNull Collection<? extends DataNode<AndroidModuleModel>> toIgnore, @NotNull ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Intrinsics.checkNotNullParameter(toRemoveComputable, (String)"toRemoveComputable");
        Intrinsics.checkNotNullParameter(toIgnore, (String)"toIgnore");
        Intrinsics.checkNotNullParameter((Object)projectData, (String)"projectData");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
        for (Module module2 : (Collection)toRemoveComputable.get()) {
            ModifiableFacetModel facetModel;
            Intrinsics.checkNotNullExpressionValue((Object)modelsProvider.getModifiableFacetModel(module2), (String)"modelsProvider.getModifiableFacetModel(module)");
            Facets.removeAllFacets(facetModel, AndroidFacet.ID);
        }
    }

    public void postProcess(@NotNull Collection<? extends DataNode<AndroidModuleModel>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Intrinsics.checkNotNullParameter(toImport, (String)"toImport");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
        super.postProcess(toImport, projectData, project, modelsProvider);
        for (DataNode<AndroidModuleModel> dataNode : toImport) {
            Module mainIdeModule;
            DataNode mainModuleDataNode;
            if (ExternalSystemApiUtil.findParent(dataNode, (Key)ProjectKeys.MODULE) == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)mainModuleDataNode, (String)"ExternalSystemApiUtil.fi\u2026ODULE\n      ) ?: continue");
            Object object = mainModuleDataNode.getData();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mainModuleDataNode.data");
            ModuleData mainModuleData = (ModuleData)object;
            if (modelsProvider.findIdeModule(mainModuleData) == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)mainIdeModule, (String)"modelsProvider.findIdeMo\u2026inModuleData) ?: continue");
            Object object2 = dataNode.getData();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"nodeToImport.data");
            AndroidModuleModel androidModel = (AndroidModuleModel)object2;
            AndroidSdks androidSdks = AndroidSdks.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)androidSdks, (String)"AndroidSdks.getInstance()");
            String string = androidModel.getAndroidProject().getName();
            String string2 = androidModel.getAndroidProject().getCompileTarget();
            Collection collection2 = androidModel.getAndroidProject().getBootClasspath();
            IdeSdks ideSdks = IdeSdks.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)ideSdks, (String)"IdeSdks.getInstance()");
            Sdk sdkToUse = SdkSyncUtil.computeSdkReloadingAsNeeded(androidSdks, project, string, string2, collection2, ideSdks);
            if (sdkToUse == null) continue;
            ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(mainIdeModule);
            Intrinsics.checkNotNullExpressionValue((Object)modifiableRootModel, (String)"modelsProvider.getModifi\u2026eRootModel(mainIdeModule)");
            modifiableRootModel.setSdk(sdkToUse);
        }
    }

    public void onSuccessImport(@NotNull Collection<? extends DataNode<AndroidModuleModel>> imported, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModelsProvider modelsProvider) {
        Intrinsics.checkNotNullParameter(imported, (String)"imported");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
        GradleProjectInfo gradleProjectInfo = GradleProjectInfo.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)gradleProjectInfo, (String)"GradleProjectInfo.getInstance(project)");
        gradleProjectInfo.setNewProject(false);
        GradleProjectInfo gradleProjectInfo2 = GradleProjectInfo.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)gradleProjectInfo2, (String)"GradleProjectInfo.getInstance(project)");
        gradleProjectInfo2.setImportedProject(false);
        if (imported.isEmpty()) {
            IdeInfo ideInfo = IdeInfo.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)ideInfo, (String)"IdeInfo.getInstance()");
            if (!ideInfo.isAndroidStudio()) {
                return;
            }
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(project){
            final /* synthetic */ Project $project;

            public final void run() {
                if (GradlePluginUpgrade.shouldRecommendPluginUpgrade$default(this.$project, null, null, 6, null)) {
                    GradlePluginUpgrade.recommendPluginUpgrade(this.$project);
                }
            }
            {
                this.$project = project;
            }
        });
        IdeInfo ideInfo = IdeInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)ideInfo, (String)"IdeInfo.getInstance()");
        if (ideInfo.isAndroidStudio()) {
            ComposeInBetaChecker.checkIfComposeProject(project);
            MemorySettingsPostSyncChecker.checkSettings(project, new TimeBasedReminder(project, "memory.settings.postsync", TimeUnit.DAYS.toMillis(1L)));
        }
        new ProjectStructureUsageTracker(project).trackProjectStructure();
        SupportedModuleChecker.getInstance().checkForSupportedModules(project);
        ConflictSet.findConflicts(project).showSelectionConflicts();
        new ProjectSetup(project).setUpProject(false);
        AndroidModuleDataServiceKt.access$modifyJUnitRunConfigurations(project);
        RunConfigurationChecker.getInstance(project).ensureRunConfigsInvokeBuild();
        ProjectStructure.getInstance(project).analyzeProjectStructure();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, project, "Setting up modules..."){
            final /* synthetic */ Project $project;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                ModuleSetup.setUpModules(this.$project);
            }
            {
                this.$project = $captured_local_variable$0;
                super($super_call_param$1, $super_call_param$2);
            }
        });
    }

    @VisibleForTesting
    public AndroidModuleDataService(@NotNull AndroidModuleValidator.Factory myModuleValidatorFactory) {
        Intrinsics.checkNotNullParameter((Object)myModuleValidatorFactory, (String)"myModuleValidatorFactory");
        this.myModuleValidatorFactory = myModuleValidatorFactory;
    }

    public AndroidModuleDataService() {
        this(new AndroidModuleValidator.Factory());
    }
}

