/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.projectsystem.gradle.actions;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenUrlHyperlink;
import com.android.tools.idea.gradle.run.MakeBeforeRunTaskProviderUtil;
import com.android.tools.idea.project.AndroidNotification;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.commands.ActionCommand;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FixAndroidRunConfigurationsAction
extends DumbAwareAction {
    public static final String ID = "Android.FixAndroidRunConfigurations";

    @NotNull
    private static Logger getLogger() {
        Logger logger2 = Logger.getInstance(FixAndroidRunConfigurationsAction.class);
        if (logger2 == null) {
            FixAndroidRunConfigurationsAction.$$$reportNull$$$0(0);
        }
        return logger2;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            FixAndroidRunConfigurationsAction.$$$reportNull$$$0(1);
        }
        super.update(e);
        e.getPresentation().setEnabled(((Boolean)StudioFlags.FIX_ANDROID_RUN_CONFIGURATIONS_ENABLED.get()).booleanValue());
        e.getPresentation().setVisible(false);
    }

    public static void perform(@Nullable Project project) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (project == null || project.isDisposed()) {
            return;
        }
        FixAndroidRunConfigurationsAction.executeAction(ID);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            FixAndroidRunConfigurationsAction.$$$reportNull$$$0(2);
        }
        if ((project = e.getProject()) == null || project.isDisposed()) {
            return;
        }
        if (!((Boolean)StudioFlags.FIX_ANDROID_RUN_CONFIGURATIONS_ENABLED.get()).booleanValue()) {
            return;
        }
        List<RunConfiguration> fixedConfigs = MakeBeforeRunTaskProviderUtil.fixConfigurationsMissingBeforeRunTask(project);
        if (fixedConfigs.isEmpty()) {
            return;
        }
        String configs = fixedConfigs.stream().map(x -> "\"" + x.getName() + "\"").collect(Collectors.joining(", "));
        String message2 = String.format("The IDE updated the following %s: %s.", StringUtil.pluralize((String)"run configuration", (int)fixedConfigs.size()), configs);
        FixAndroidRunConfigurationsAction.getLogger().warn(message2);
        AndroidNotification.getInstance(project).showBalloon("Android Run Configuration", message2, NotificationType.WARNING, AndroidNotification.BALLOON_GROUP, new OpenUrlHyperlink("https://d.android.com/r/studio-ui/gradle-aware-make-fix.html", "Learn more"));
    }

    private static void executeAction(@NotNull String actionId) {
        ActionManagerEx actionManager;
        AnAction action2;
        if (actionId == null) {
            FixAndroidRunConfigurationsAction.$$$reportNull$$$0(3);
        }
        if ((action2 = (actionManager = ActionManagerEx.getInstanceEx()).getAction(actionId)) == null) {
            return;
        }
        actionManager.tryToExecute(action2, ActionCommand.getInputEvent((String)actionId), null, "unknown", true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/projectsystem/gradle/actions/FixAndroidRunConfigurationsAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/projectsystem/gradle/actions/FixAndroidRunConfigurationsAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "executeAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

