/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.projectsystem;

import com.google.common.base.Strings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public class AndroidProjectRootUtil {
    private AndroidProjectRootUtil() {
    }

    @Nullable
    public static @SystemIndependent String getModuleDirPath(@NotNull Module module2) {
        String linkedProjectPath;
        if (module2 == null) {
            AndroidProjectRootUtil.$$$reportNull$$$0(0);
        }
        if (!Strings.isNullOrEmpty((String)(linkedProjectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module2)))) {
            return linkedProjectPath;
        }
        @SystemIndependent String moduleFilePath = module2.getModuleFilePath();
        return VfsUtil.getParentDir((String)moduleFilePath);
    }

    @Nullable
    public static VirtualFile getFileByRelativeModulePath(Module module2, String relativePath, boolean lookInContentRoot) {
        if (module2.isDisposed() || relativePath == null || relativePath.isEmpty()) {
            return null;
        }
        ProgressManager.checkCanceled();
        String moduleDirPath = AndroidProjectRootUtil.getModuleDirPath(module2);
        if (moduleDirPath != null) {
            String absPath = FileUtil.toSystemIndependentName((String)(moduleDirPath + relativePath));
            ProgressManager.checkCanceled();
            VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(absPath);
            if (file2 != null) {
                return file2;
            }
        }
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module2).getContentRoots();
        if (lookInContentRoot) {
            for (VirtualFile contentRoot : contentRoots) {
                String absPath = FileUtil.toSystemIndependentName((String)(contentRoot.getPath() + relativePath));
                ProgressManager.checkCanceled();
                VirtualFile file3 = LocalFileSystem.getInstance().findFileByPath(absPath);
                if (file3 == null) continue;
                return file3;
            }
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static @SystemIndependent String getAptGenSourceRootPath(@NotNull AndroidFacet facet2) {
        String path2;
        if (facet2 == null) {
            AndroidProjectRootUtil.$$$reportNull$$$0(1);
        }
        if ((path2 = facet2.getProperties().GEN_FOLDER_RELATIVE_PATH_APT).isEmpty()) {
            return null;
        }
        @SystemIndependent String moduleDirPath = AndroidProjectRootUtil.getModuleDirPath(facet2.getModule());
        return moduleDirPath != null ? moduleDirPath + path2 : null;
    }

    @Deprecated
    @Nullable
    public static @SystemIndependent String getAidlGenSourceRootPath(@NotNull AndroidFacet facet2) {
        String path2;
        if (facet2 == null) {
            AndroidProjectRootUtil.$$$reportNull$$$0(2);
        }
        if ((path2 = facet2.getProperties().GEN_FOLDER_RELATIVE_PATH_AIDL).isEmpty()) {
            return null;
        }
        @SystemIndependent String moduleDirPath = AndroidProjectRootUtil.getModuleDirPath(facet2.getModule());
        return moduleDirPath != null ? moduleDirPath + path2 : null;
    }

    @Deprecated
    @Nullable
    public static VirtualFile getAidlGenDir(@NotNull AndroidFacet facet2) {
        String genPath;
        if (facet2 == null) {
            AndroidProjectRootUtil.$$$reportNull$$$0(3);
        }
        return (genPath = AndroidProjectRootUtil.getAidlGenSourceRootPath(facet2)) != null ? LocalFileSystem.getInstance().findFileByPath(genPath) : null;
    }

    @Deprecated
    @Nullable
    public static String getRenderscriptGenSourceRootPath(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            AndroidProjectRootUtil.$$$reportNull$$$0(4);
        }
        return AndroidProjectRootUtil.getAidlGenSourceRootPath(facet2);
    }

    @Deprecated
    @Nullable
    public static VirtualFile getRenderscriptGenDir(@NotNull AndroidFacet facet2) {
        String path2;
        if (facet2 == null) {
            AndroidProjectRootUtil.$$$reportNull$$$0(5);
        }
        return (path2 = AndroidProjectRootUtil.getRenderscriptGenSourceRootPath(facet2)) != null ? LocalFileSystem.getInstance().findFileByPath(path2) : null;
    }

    @Deprecated
    @Nullable
    public static VirtualFile getAssetsDir(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            AndroidProjectRootUtil.$$$reportNull$$$0(6);
        }
        return AndroidProjectRootUtil.getFileByRelativeModulePath(facet2.getModule(), facet2.getProperties().ASSETS_FOLDER_RELATIVE_PATH, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/projectsystem/AndroidProjectRootUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getModuleDirPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getAptGenSourceRootPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getAidlGenSourceRootPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getAidlGenDir";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getRenderscriptGenSourceRootPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getRenderscriptGenDir";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getAssetsDir";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

