/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project.messages;

import com.android.tools.idea.gradle.project.build.events.AndroidSyncIssueEvent;
import com.android.tools.idea.gradle.project.build.events.AndroidSyncIssueEventResult;
import com.android.tools.idea.gradle.project.build.events.AndroidSyncIssueFileEvent;
import com.android.tools.idea.gradle.project.build.events.AndroidSyncIssueQuickFix;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.project.messages.SyncMessage;
import com.android.tools.idea.ui.QuickFixNotificationListener;
import com.android.tools.idea.util.PositionInFile;
import com.intellij.build.SyncViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.Failure;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSyncMessages
implements Disposable {
    private Project myProject;
    @NotNull
    private final Object myLock;
    @NotNull
    private final HashMap<Object, List<NotificationData>> myCurrentNotifications;
    @NotNull
    private final HashMap<Object, List<Failure>> myShownFailures;
    @NotNull
    private static final String PENDING_TASK_ID = "Pending taskId";

    protected AbstractSyncMessages(@NotNull Project project) {
        if (project == null) {
            AbstractSyncMessages.$$$reportNull$$$0(0);
        }
        this.myLock = new Object();
        this.myCurrentNotifications = new HashMap();
        this.myShownFailures = new HashMap();
        this.myProject = project;
    }

    public int getErrorCount() {
        return this.countNotifications(notification -> notification.getNotificationCategory() == NotificationCategory.ERROR);
    }

    public int getMessageCount(@NotNull String groupName) {
        if (groupName == null) {
            AbstractSyncMessages.$$$reportNull$$$0(1);
        }
        return this.countNotifications(notification -> notification.getTitle().equals(groupName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String getErrorDescription() {
        LinkedHashSet<String> errorGroups = new LinkedHashSet<String>();
        Object object = this.myLock;
        synchronized (object) {
            for (List<NotificationData> notificationDataList : this.myCurrentNotifications.values()) {
                for (NotificationData notificationData : notificationDataList) {
                    if (notificationData.getNotificationCategory() != NotificationCategory.ERROR) continue;
                    errorGroups.add(notificationData.getTitle());
                }
            }
        }
        String string = String.join((CharSequence)", ", errorGroups);
        if (string == null) {
            AbstractSyncMessages.$$$reportNull$$$0(2);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countNotifications(@NotNull Predicate<NotificationData> condition) {
        if (condition == null) {
            AbstractSyncMessages.$$$reportNull$$$0(3);
        }
        int total = 0;
        Object object = this.myLock;
        synchronized (object) {
            for (List<NotificationData> notificationDataList : this.myCurrentNotifications.values()) {
                for (NotificationData notificationData : notificationDataList) {
                    if (!condition.test(notificationData)) continue;
                    ++total;
                }
            }
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myCurrentNotifications.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllMessages() {
        Object object = this.myLock;
        synchronized (object) {
            this.myCurrentNotifications.clear();
        }
    }

    public void report(@NotNull SyncMessage message2) {
        if (message2 == null) {
            AbstractSyncMessages.$$$reportNull$$$0(4);
        }
        String title = message2.getGroup();
        String text2 = StringUtil.join((String[])message2.getText(), (String)"\n");
        NotificationCategory category = message2.getType().convertToCategory();
        PositionInFile position = message2.getPosition();
        NotificationData notification = this.createNotification(title, text2, category, position);
        Navigatable navigatable = message2.getNavigatable();
        notification.setNavigatable(navigatable);
        List<NotificationHyperlink> quickFixes = message2.getQuickFixes();
        if (!quickFixes.isEmpty()) {
            this.updateNotification(notification, text2, quickFixes);
        }
        this.report(notification, ContainerUtil.map(quickFixes, it -> new AndroidSyncIssueQuickFix((NotificationHyperlink)it)));
    }

    @NotNull
    public NotificationData createNotification(@NotNull String title, @NotNull String text2, @NotNull NotificationCategory category, @Nullable PositionInFile position) {
        if (title == null) {
            AbstractSyncMessages.$$$reportNull$$$0(5);
        }
        if (text2 == null) {
            AbstractSyncMessages.$$$reportNull$$$0(6);
        }
        if (category == null) {
            AbstractSyncMessages.$$$reportNull$$$0(7);
        }
        NotificationSource source = NotificationSource.PROJECT_SYNC;
        if (position != null) {
            String filePath = VfsUtilCore.virtualToIoFile((VirtualFile)position.file).getPath();
            return new NotificationData(title, text2, category, source, filePath, position.line, position.column, false);
        }
        return new NotificationData(title, text2, category, source);
    }

    public void updateNotification(@NotNull NotificationData notification, @NotNull String text2, @NotNull List<NotificationHyperlink> quickFixes) {
        if (notification == null) {
            AbstractSyncMessages.$$$reportNull$$$0(8);
        }
        if (text2 == null) {
            AbstractSyncMessages.$$$reportNull$$$0(9);
        }
        if (quickFixes == null) {
            AbstractSyncMessages.$$$reportNull$$$0(10);
        }
        Object message2 = text2;
        int hyperlinkCount = quickFixes.size();
        if (hyperlinkCount > 0) {
            StringBuilder b = new StringBuilder();
            for (int i2 = 0; i2 < hyperlinkCount; ++i2) {
                b.append(quickFixes.get(i2).toHtml());
                if (i2 >= hyperlinkCount - 1) continue;
                b.append("<br>");
            }
            message2 = (String)message2 + "\n" + b.toString();
        }
        notification.setMessage((String)message2);
        this.addNotificationListener(notification, quickFixes);
    }

    public void addNotificationListener(@NotNull NotificationData notification, @NotNull List<NotificationHyperlink> quickFixes) {
        if (notification == null) {
            AbstractSyncMessages.$$$reportNull$$$0(11);
        }
        if (quickFixes == null) {
            AbstractSyncMessages.$$$reportNull$$$0(12);
        }
        for (NotificationHyperlink quickFix : quickFixes) {
            notification.setListener(quickFix.getUrl(), (NotificationListener)new QuickFixNotificationListener(this.myProject, quickFix));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report(@NotNull NotificationData notification, @NotNull List<? extends BuildIssueQuickFix> quickFixes) {
        Object taskId;
        if (notification == null) {
            AbstractSyncMessages.$$$reportNull$$$0(13);
        }
        if (quickFixes == null) {
            AbstractSyncMessages.$$$reportNull$$$0(14);
        }
        if ((taskId = GradleSyncState.getInstance(this.myProject).getExternalSystemTaskId()) == null) {
            taskId = PENDING_TASK_ID;
        } else {
            this.showNotification(notification, taskId, quickFixes);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myCurrentNotifications.computeIfAbsent(taskId, key -> new ArrayList()).add(notification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showNotification(@NotNull NotificationData notification, @NotNull Object taskId, @NotNull List<? extends BuildIssueQuickFix> quickFixes) {
        AndroidSyncIssueEvent issueEvent;
        if (notification == null) {
            AbstractSyncMessages.$$$reportNull$$$0(15);
        }
        if (taskId == null) {
            AbstractSyncMessages.$$$reportNull$$$0(16);
        }
        if (quickFixes == null) {
            AbstractSyncMessages.$$$reportNull$$$0(17);
        }
        String title = notification.getTitle();
        String[] lines2 = notification.getMessage().split(System.lineSeparator());
        if (lines2.length > 0) {
            title = lines2[0];
        }
        if ((issueEvent = notification.getFilePath() != null ? new AndroidSyncIssueFileEvent(taskId, notification, title, quickFixes) : new AndroidSyncIssueEvent(taskId, notification, title, quickFixes)).getKind() == MessageEvent.Kind.ERROR) {
            Object object = this.myLock;
            synchronized (object) {
                this.myShownFailures.computeIfAbsent(taskId, key -> new ArrayList()).addAll(((AndroidSyncIssueEventResult)issueEvent.getResult()).getFailures());
            }
        } else {
            ((SyncViewManager)this.myProject.getService(SyncViewManager.class)).onEvent(taskId, (BuildEvent)issueEvent);
        }
    }

    @NotNull
    protected abstract ProjectSystemId getProjectSystemId();

    @NotNull
    protected Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            AbstractSyncMessages.$$$reportNull$$$0(18);
        }
        return project;
    }

    public void dispose() {
        this.myProject = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
            case 2: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/project/messages/AbstractSyncMessages";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixes";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/project/messages/AbstractSyncMessages";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorDescription";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getMessageCount";
                break;
            }
            case 2: 
            case 18: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "countNotifications";
                break;
            }
            case 4: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "report";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createNotification";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateNotification";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addNotificationListener";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "showNotification";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

