/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project;

import com.android.tools.idea.model.AndroidManifestIndex;
import com.android.tools.idea.model.AndroidManifestIndexQueryUtils;
import com.android.tools.idea.project.DefaultModuleSystemKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.text.StringKt;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.SourceProviderManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\f\u001a\u0012\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001aU\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u0002H\u00170\u0015\"\u0004\b\u0000\u0010\u0016\"\u0004\b\u0001\u0010\u00172.\u0010\u0018\u001a\u0018\u0012\u0014\b\u0001\u0012\u0010\u0012\u0004\u0012\u0002H\u0016\u0012\u0006\u0012\u0004\u0018\u0001H\u00170\u001a0\u0019\"\u0010\u0012\u0004\u0012\u0002H\u0016\u0012\u0006\u0012\u0004\u0018\u0001H\u00170\u001aH\u0002\u00a2\u0006\u0002\u0010\u001b\u001a\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a!\u0010\u001d\u001a\u0002H\u001e\"\u0004\b\u0000\u0010\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001e0 H\u0002\u00a2\u0006\u0002\u0010!\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"1\u0010\u0004\u001a%\u0012\u001c\u0012\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u0007 \b*\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "PACKAGE_NAME_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/util/CachedValue;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getPackageName", "module", "Lcom/intellij/openapi/module/Module;", "getPackageNameByParsingPrimaryManifest", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "getPackageNameFromIndex", "getText", "manifestFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "notNullMapOf", "", "K", "V", "pairs", "", "Lkotlin/Pair;", "([Lkotlin/Pair;)Ljava/util/Map;", "readPackageNameFromManifest", "runCancellableReadAction", "T", "computable", "Lcom/intellij/openapi/util/Computable;", "(Lcom/intellij/openapi/util/Computable;)Ljava/lang/Object;", "intellij.android.core"})
public final class DefaultModuleSystemKt {
    private static final Key<CachedValue<String>> PACKAGE_NAME_KEY;

    private static final Logger getLOG() {
        Logger logger2 = Logger.getInstance((String)"DefaultModuleSystem.kt");
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(\"DefaultModuleSystem.kt\")");
        return logger2;
    }

    private static final <K, V> Map<K, V> notNullMapOf(Pair<? extends K, ? extends V> ... pairs) {
        Map map2 = MapsKt.toMap((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])pairs), (Function1)notNullMapOf.1.INSTANCE));
        if (map2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
        }
        return map2;
    }

    @Nullable
    public static final String getPackageName(@NotNull Module module2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module2);
        if (androidFacet == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)androidFacet, (String)"AndroidFacet.getInstance(module) ?: return null");
        AndroidFacet facet2 = androidFacet;
        String rawPackageName = null;
        Boolean bl = AndroidManifestIndex.Companion.indexEnabled();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"AndroidManifestIndex.indexEnabled()");
        if (bl.booleanValue()) {
            rawPackageName = (String)DumbService.getInstance((Project)module2.getProject()).runReadActionInSmartMode(new Computable(facet2){
                final /* synthetic */ AndroidFacet $facet;

                @Nullable
                public final String compute() {
                    return DefaultModuleSystemKt.access$getPackageNameFromIndex(this.$facet);
                }
                {
                    this.$facet = androidFacet;
                }
            });
        }
        if ((string = rawPackageName) == null) {
            string = DefaultModuleSystemKt.getPackageNameByParsingPrimaryManifest(facet2);
        }
        return string;
    }

    private static final String getPackageNameFromIndex(AndroidFacet facet2) {
        String string;
        Module module2 = facet2.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"facet.module");
        if (DumbService.isDumb((Project)module2.getProject())) {
            return null;
        }
        try {
            string = AndroidManifestIndexQueryUtils.queryPackageNameFromManifestIndex(facet2);
        }
        catch (IndexNotReadyException e) {
            DefaultModuleSystemKt.getLOG().debug((Throwable)e);
            string = null;
        }
        return string;
    }

    private static final String getPackageNameByParsingPrimaryManifest(AndroidFacet facet2) {
        VirtualFile virtualFile = SourceProviderManager.Companion.getInstance(facet2).getMainManifestFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile manifestFile = virtualFile;
        Module module2 = facet2.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"facet.module");
        CachedValue cachedValue2 = CachedValuesManager.getManager((Project)module2.getProject()).createCachedValue(new CachedValueProvider(manifestFile){
            final /* synthetic */ VirtualFile $manifestFile;

            @Nullable
            public final CachedValueProvider.Result<String> compute() {
                String packageName = DefaultModuleSystemKt.access$readPackageNameFromManifest(this.$manifestFile);
                return CachedValueProvider.Result.create((Object)packageName, (Object[])new Object[]{this.$manifestFile});
            }
            {
                this.$manifestFile = virtualFile;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)cachedValue2, (String)"CachedValuesManager.getM\u2026geName, manifestFile)\n  }");
        CachedValue cachedValue3 = cachedValue2;
        Object object = facet2.putUserDataIfAbsent(PACKAGE_NAME_KEY, (Object)cachedValue3);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"facet.putUserDataIfAbsen\u2026GE_NAME_KEY, cachedValue)");
        return (String)((CachedValue)object).getValue();
    }

    private static final String readPackageNameFromManifest(VirtualFile manifestFile) {
        try {
            KXmlParser kXmlParser = new KXmlParser();
            boolean bl = false;
            boolean bl2 = false;
            KXmlParser $this$apply = kXmlParser;
            boolean bl3 = false;
            $this$apply.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            $this$apply.setInput((Reader)new StringReader((String)DefaultModuleSystemKt.runCancellableReadAction((Computable)new Computable(manifestFile){
                final /* synthetic */ VirtualFile $manifestFile$inlined;
                {
                    this.$manifestFile$inlined = virtualFile;
                }

                public final String compute() {
                    return DefaultModuleSystemKt.access$getText(this.$manifestFile$inlined);
                }
            })));
            KXmlParser parser = kXmlParser;
            if (parser.nextTag() == 2) {
                return StringKt.nullize((String)parser.getAttributeValue(null, "package"), (boolean)true);
            }
        }
        catch (Exception e) {
            DefaultModuleSystemKt.getLOG().warn((Throwable)e);
        }
        return null;
    }

    private static final String getText(VirtualFile manifestFile) {
        Document document = FileDocumentManager.getInstance().getCachedDocument(manifestFile);
        if (document == null) {
            return ((Object)LoadTextUtil.getTextByBinaryPresentation((byte[])manifestFile.contentsToByteArray(), (VirtualFile)manifestFile)).toString();
        }
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"FileDocumentManager.getI\u2026 manifestFile).toString()");
        Document document2 = document;
        String string = document2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"document.text");
        return string;
    }

    private static final <T> T runCancellableReadAction(Computable<T> computable) {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isReadAccessAllowed()) {
            return (T)computable.compute();
        }
        Function0 function0 = new Function0<T>(computable){

            public final T invoke() {
                return (T)((Computable)this.receiver).compute();
            }
        };
        return (T)ReadAction.nonBlocking((Callable)new Callable(function0){
            private final /* synthetic */ Function0 function;
            {
                this.function = function0;
            }

            public final /* synthetic */ Object call() {
                return this.function.invoke();
            }
        }).executeSynchronously();
    }

    static {
        Key key = Key.create((String)"main.manifest.package.name");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<CachedValue<S\u2026n.manifest.package.name\")");
        PACKAGE_NAME_KEY = key;
    }

    public static final /* synthetic */ Map access$notNullMapOf(Pair ... pairs) {
        return DefaultModuleSystemKt.notNullMapOf(pairs);
    }

    public static final /* synthetic */ String access$getPackageNameFromIndex(AndroidFacet facet2) {
        return DefaultModuleSystemKt.getPackageNameFromIndex(facet2);
    }

    public static final /* synthetic */ String access$readPackageNameFromManifest(VirtualFile manifestFile) {
        return DefaultModuleSystemKt.readPackageNameFromManifest(manifestFile);
    }

    public static final /* synthetic */ String access$getText(VirtualFile manifestFile) {
        return DefaultModuleSystemKt.getText(manifestFile);
    }
}

